/*
 * Decompiled with CFR 0.152.
 */
package kellinwood.logging;

import java.text.SimpleDateFormat;
import java.util.Date;
import kellinwood.logging.LoggerInterface;

public abstract class AbstractLogger
implements LoggerInterface {
    protected String category;
    SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss");

    public AbstractLogger(String category) {
        this.category = category;
    }

    protected String format(String level, String message) {
        return String.format("%s %s %s: %s\n", this.dateFormat.format(new Date()), level, this.category, message);
    }

    protected abstract void write(String var1, String var2, Throwable var3);

    protected void writeFixNullMessage(String level, String message, Throwable t) {
        if (message == null) {
            message = t != null ? t.getClass().getName() : "null";
        }
        this.write(level, message, t);
    }

    @Override
    public void debug(String message, Throwable t) {
        this.writeFixNullMessage("DEBUG", message, t);
    }

    @Override
    public void debug(String message) {
        this.writeFixNullMessage("DEBUG", message, null);
    }

    @Override
    public void error(String message, Throwable t) {
        this.writeFixNullMessage("ERROR", message, t);
    }

    @Override
    public void error(String message) {
        this.writeFixNullMessage("ERROR", message, null);
    }

    @Override
    public void info(String message, Throwable t) {
        this.writeFixNullMessage("INFO", message, t);
    }

    @Override
    public void info(String message) {
        this.writeFixNullMessage("INFO", message, null);
    }

    @Override
    public void warning(String message, Throwable t) {
        this.writeFixNullMessage("WARNING", message, t);
    }

    @Override
    public void warning(String message) {
        this.writeFixNullMessage("WARNING", message, null);
    }

    @Override
    public boolean isDebugEnabled() {
        return true;
    }

    @Override
    public boolean isErrorEnabled() {
        return true;
    }

    @Override
    public boolean isInfoEnabled() {
        return true;
    }

    @Override
    public boolean isWarningEnabled() {
        return true;
    }
}

