/*
 * Decompiled with CFR 0.152.
 */
package kellinwood.security.zipsigner.optional;

import java.security.cert.X509Certificate;
import java.util.ArrayList;
import kellinwood.security.zipsigner.KeySet;
import org.spongycastle.cert.jcajce.JcaCertStore;
import org.spongycastle.cms.CMSProcessableByteArray;
import org.spongycastle.cms.CMSSignedData;
import org.spongycastle.cms.CMSSignedDataGenerator;
import org.spongycastle.cms.CMSTypedData;
import org.spongycastle.cms.SignerInfoGenerator;
import org.spongycastle.cms.jcajce.JcaSignerInfoGeneratorBuilder;
import org.spongycastle.operator.ContentSigner;
import org.spongycastle.operator.DigestCalculatorProvider;
import org.spongycastle.operator.jcajce.JcaContentSignerBuilder;
import org.spongycastle.operator.jcajce.JcaDigestCalculatorProviderBuilder;
import org.spongycastle.util.Store;

public class SignatureBlockGenerator {
    public static byte[] generate(KeySet keySet, byte[] content) {
        try {
            ArrayList<X509Certificate> certList = new ArrayList<X509Certificate>();
            CMSProcessableByteArray msg = new CMSProcessableByteArray(content);
            certList.add(keySet.getPublicKey());
            JcaCertStore certs = new JcaCertStore(certList);
            CMSSignedDataGenerator gen = new CMSSignedDataGenerator();
            JcaContentSignerBuilder jcaContentSignerBuilder = new JcaContentSignerBuilder(keySet.getSignatureAlgorithm()).setProvider("SC");
            ContentSigner sha1Signer = jcaContentSignerBuilder.build(keySet.getPrivateKey());
            JcaDigestCalculatorProviderBuilder jcaDigestCalculatorProviderBuilder = new JcaDigestCalculatorProviderBuilder().setProvider("SC");
            DigestCalculatorProvider digestCalculatorProvider = jcaDigestCalculatorProviderBuilder.build();
            JcaSignerInfoGeneratorBuilder jcaSignerInfoGeneratorBuilder = new JcaSignerInfoGeneratorBuilder(digestCalculatorProvider);
            jcaSignerInfoGeneratorBuilder.setDirectSignature(true);
            SignerInfoGenerator signerInfoGenerator = jcaSignerInfoGeneratorBuilder.build(sha1Signer, keySet.getPublicKey());
            gen.addSignerInfoGenerator(signerInfoGenerator);
            gen.addCertificates((Store)certs);
            CMSSignedData sigData = gen.generate((CMSTypedData)msg, false);
            return sigData.toASN1Structure().getEncoded("DER");
        }
        catch (Exception x) {
            throw new RuntimeException(x.getMessage(), x);
        }
    }
}

