/*
 * Decompiled with CFR 0.152.
 */
package kellinwood.security.zipsigner.optional;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.security.Key;
import java.security.KeyStore;
import java.security.Provider;
import java.security.Security;
import java.security.cert.Certificate;
import kellinwood.logging.LoggerInterface;
import kellinwood.logging.LoggerManager;
import kellinwood.security.zipsigner.optional.JksKeyStore;
import kellinwood.security.zipsigner.optional.KeyNameConflictException;
import kellinwood.security.zipsigner.optional.LoadKeystoreException;
import kellinwood.security.zipsigner.optional.PasswordObfuscator;
import org.spongycastle.jce.provider.BouncyCastleProvider;

public class KeyStoreFileManager {
    static Provider provider = new BouncyCastleProvider();
    static LoggerInterface logger = LoggerManager.getLogger((String)KeyStoreFileManager.class.getName());

    public static Provider getProvider() {
        return provider;
    }

    public static void setProvider(Provider provider) {
        if (KeyStoreFileManager.provider != null) {
            Security.removeProvider(KeyStoreFileManager.provider.getName());
        }
        KeyStoreFileManager.provider = provider;
        Security.addProvider(provider);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static KeyStore loadKeyStore(String keystorePath, String encodedPassword) throws Exception {
        KeyStore keyStore;
        block4: {
            char[] password = null;
            try {
                if (encodedPassword != null) {
                    password = PasswordObfuscator.getInstance().decodeKeystorePassword(keystorePath, encodedPassword);
                }
                keyStore = KeyStoreFileManager.loadKeyStore(keystorePath, password);
                if (password == null) break block4;
            }
            catch (Throwable throwable) {
                if (password != null) {
                    PasswordObfuscator.flush(password);
                }
                throw throwable;
            }
            PasswordObfuscator.flush(password);
        }
        return keyStore;
    }

    public static KeyStore createKeyStore(String keystorePath, char[] password) throws Exception {
        KeyStore ks = null;
        ks = keystorePath.toLowerCase().endsWith(".bks") ? KeyStore.getInstance("bks", (Provider)new BouncyCastleProvider()) : new JksKeyStore();
        ks.load(null, password);
        return ks;
    }

    public static KeyStore loadKeyStore(String keystorePath, char[] password) throws Exception {
        KeyStore ks = null;
        try {
            ks = new JksKeyStore();
            FileInputStream fis = new FileInputStream(keystorePath);
            ks.load(fis, password);
            fis.close();
            return ks;
        }
        catch (LoadKeystoreException x) {
            throw x;
        }
        catch (Exception x) {
            try {
                ks = KeyStore.getInstance("bks", KeyStoreFileManager.getProvider());
                FileInputStream fis = new FileInputStream(keystorePath);
                ks.load(fis, password);
                fis.close();
                return ks;
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to load keystore: " + e.getMessage(), e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeKeyStore(KeyStore ks, String keystorePath, String encodedPassword) throws Exception {
        char[] password = null;
        try {
            password = PasswordObfuscator.getInstance().decodeKeystorePassword(keystorePath, encodedPassword);
            KeyStoreFileManager.writeKeyStore(ks, keystorePath, password);
        }
        finally {
            if (password != null) {
                PasswordObfuscator.flush(password);
            }
        }
    }

    public static void writeKeyStore(KeyStore ks, String keystorePath, char[] password) throws Exception {
        File keystoreFile = new File(keystorePath);
        try {
            if (keystoreFile.exists()) {
                File tmpFile = File.createTempFile(keystoreFile.getName(), null, keystoreFile.getParentFile());
                FileOutputStream fos = new FileOutputStream(tmpFile);
                ks.store(fos, password);
                fos.flush();
                fos.close();
                KeyStoreFileManager.renameTo(tmpFile, keystoreFile);
            } else {
                FileOutputStream fos = new FileOutputStream(keystorePath);
                ks.store(fos, password);
                fos.close();
            }
        }
        catch (Exception x) {
            try {
                File logfile = File.createTempFile("zipsigner-error", ".log", keystoreFile.getParentFile());
                PrintWriter pw = new PrintWriter(new FileWriter(logfile));
                x.printStackTrace(pw);
                pw.flush();
                pw.close();
            }
            catch (Exception y) {
                // empty catch block
            }
            throw x;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void copyFile(File srcFile, File destFile, boolean preserveFileDate) throws IOException {
        if (destFile.exists() && destFile.isDirectory()) {
            throw new IOException("Destination '" + destFile + "' exists but is a directory");
        }
        FileInputStream input = new FileInputStream(srcFile);
        try {
            FileOutputStream output = new FileOutputStream(destFile);
            try {
                byte[] buffer = new byte[4096];
                long count = 0L;
                int n = 0;
                while (-1 != (n = input.read(buffer))) {
                    output.write(buffer, 0, n);
                    count += (long)n;
                }
            }
            finally {
                try {
                    output.close();
                }
                catch (IOException x) {}
            }
        }
        finally {
            try {
                input.close();
            }
            catch (IOException x) {}
        }
        if (srcFile.length() != destFile.length()) {
            throw new IOException("Failed to copy full contents from '" + srcFile + "' to '" + destFile + "'");
        }
        if (preserveFileDate) {
            destFile.setLastModified(srcFile.lastModified());
        }
    }

    public static void renameTo(File fromFile, File toFile) throws IOException {
        KeyStoreFileManager.copyFile(fromFile, toFile, true);
        if (!fromFile.delete()) {
            throw new IOException("Failed to delete " + fromFile);
        }
    }

    public static void deleteKey(String storePath, String storePass, String keyName) throws Exception {
        KeyStore ks = KeyStoreFileManager.loadKeyStore(storePath, storePass);
        ks.deleteEntry(keyName);
        KeyStoreFileManager.writeKeyStore(ks, storePath, storePass);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String renameKey(String keystorePath, String storePass, String oldKeyName, String newKeyName, String keyPass) throws Exception {
        String string;
        char[] keyPw = null;
        try {
            KeyStore ks = KeyStoreFileManager.loadKeyStore(keystorePath, storePass);
            if (ks instanceof JksKeyStore) {
                newKeyName = newKeyName.toLowerCase();
            }
            if (ks.containsAlias(newKeyName)) {
                throw new KeyNameConflictException();
            }
            keyPw = PasswordObfuscator.getInstance().decodeAliasPassword(keystorePath, oldKeyName, keyPass);
            Key key = ks.getKey(oldKeyName, keyPw);
            Certificate cert = ks.getCertificate(oldKeyName);
            ks.setKeyEntry(newKeyName, key, keyPw, new Certificate[]{cert});
            ks.deleteEntry(oldKeyName);
            KeyStoreFileManager.writeKeyStore(ks, keystorePath, storePass);
            string = newKeyName;
        }
        catch (Throwable throwable) {
            PasswordObfuscator.flush(keyPw);
            throw throwable;
        }
        PasswordObfuscator.flush(keyPw);
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static KeyStore.Entry getKeyEntry(String keystorePath, String storePass, String keyName, String keyPass) throws Exception {
        KeyStore.Entry entry;
        KeyStore.PasswordProtection passwordProtection;
        block5: {
            char[] keyPw = null;
            passwordProtection = null;
            try {
                KeyStore ks = KeyStoreFileManager.loadKeyStore(keystorePath, storePass);
                keyPw = PasswordObfuscator.getInstance().decodeAliasPassword(keystorePath, keyName, keyPass);
                passwordProtection = new KeyStore.PasswordProtection(keyPw);
                entry = ks.getEntry(keyName, passwordProtection);
                if (keyPw == null) break block5;
            }
            catch (Throwable throwable) {
                if (keyPw != null) {
                    PasswordObfuscator.flush(keyPw);
                }
                if (passwordProtection != null) {
                    passwordProtection.destroy();
                }
                throw throwable;
            }
            PasswordObfuscator.flush(keyPw);
        }
        if (passwordProtection != null) {
            passwordProtection.destroy();
        }
        return entry;
    }

    public static boolean containsKey(String keystorePath, String storePass, String keyName) throws Exception {
        KeyStore ks = KeyStoreFileManager.loadKeyStore(keystorePath, storePass);
        return ks.containsAlias(keyName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void validateKeystorePassword(String keystorePath, String encodedPassword) throws Exception {
        char[] password = null;
        try {
            KeyStore keyStore = KeyStoreFileManager.loadKeyStore(keystorePath, encodedPassword);
        }
        finally {
            if (password != null) {
                PasswordObfuscator.flush(password);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void validateKeyPassword(String keystorePath, String keyName, String encodedPassword) throws Exception {
        char[] password = null;
        try {
            KeyStore ks = KeyStoreFileManager.loadKeyStore(keystorePath, (char[])null);
            password = PasswordObfuscator.getInstance().decodeAliasPassword(keystorePath, keyName, encodedPassword);
            ks.getKey(keyName, password);
            if (password == null) return;
        }
        catch (Throwable throwable) {
            if (password == null) throw throwable;
            PasswordObfuscator.flush(password);
            throw throwable;
        }
        PasswordObfuscator.flush(password);
    }

    static {
        Security.addProvider(KeyStoreFileManager.getProvider());
    }
}

