/*
 * Decompiled with CFR 0.152.
 */
package processing.mode.java.pdex;

import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.GridBagLayout;
import java.awt.Point;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowEvent;
import java.awt.event.WindowFocusListener;
import javax.swing.BoxLayout;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.SwingWorker;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import processing.app.SketchCode;
import processing.mode.java.JavaEditor;
import processing.mode.java.pdex.ErrorCheckerService;

public class TabOutline {
    protected JFrame frmOutlineView;
    protected JScrollPane jsp;
    protected DefaultMutableTreeNode tabNode;
    protected DefaultMutableTreeNode tempNode;
    protected JTree tabTree;
    protected JTextField searchField;
    protected JLabel lblCaption;
    protected JavaEditor editor;
    protected ErrorCheckerService errorCheckerService;
    protected boolean internalSelection = false;

    public TabOutline(ErrorCheckerService ecs) {
        this.errorCheckerService = ecs;
        this.editor = ecs.getEditor();
        this.createGUI();
    }

    private void createGUI() {
        this.frmOutlineView = new JFrame();
        this.frmOutlineView.setAlwaysOnTop(true);
        this.frmOutlineView.setUndecorated(true);
        Point tp = this.errorCheckerService.getEditor().getTextArea().getLocationOnScreen();
        this.lblCaption = new JLabel("Tabs List (type to filter)");
        int minWidth = this.estimateFrameWidth();
        int maxWidth = (int)((float)this.editor.getMinimumSize().width * 0.9f);
        this.frmOutlineView.setLayout(new BoxLayout(this.frmOutlineView.getContentPane(), 1));
        JPanel panelTop = new JPanel();
        JPanel panelMiddle = new JPanel();
        JPanel panelBottom = new JPanel();
        panelTop.setLayout(new GridBagLayout());
        panelMiddle.setLayout(new BoxLayout(panelMiddle, 1));
        panelBottom.setLayout(new BoxLayout(panelBottom, 1));
        this.lblCaption.setAlignmentX(0.0f);
        panelTop.add(this.lblCaption);
        this.searchField = new JTextField();
        this.searchField.setMinimumSize(new Dimension(minWidth, 25));
        panelMiddle.add(this.searchField);
        this.jsp = new JScrollPane();
        this.populateTabTree();
        this.jsp.setViewportView(this.tabTree);
        this.jsp.setVerticalScrollBarPolicy(20);
        this.jsp.setHorizontalScrollBarPolicy(30);
        this.jsp.setMinimumSize(new Dimension(minWidth, this.editor.getTextArea().getHeight() - 10));
        this.jsp.setMaximumSize(new Dimension(maxWidth, this.editor.getTextArea().getHeight() - 10));
        panelBottom.add(this.jsp);
        this.frmOutlineView.add(panelTop);
        this.frmOutlineView.add(panelMiddle);
        this.frmOutlineView.add(panelBottom);
        this.frmOutlineView.setDefaultCloseOperation(2);
        this.frmOutlineView.pack();
        this.frmOutlineView.setBounds(tp.x + this.errorCheckerService.getEditor().getTextArea().getWidth() - minWidth, tp.y, minWidth, this.estimateFrameHeight());
        this.frmOutlineView.setMinimumSize(new Dimension(minWidth, Math.min(this.errorCheckerService.getEditor().getTextArea().getHeight(), this.frmOutlineView.getHeight())));
        this.frmOutlineView.setLocation(tp.x + this.errorCheckerService.getEditor().getTextArea().getWidth() / 2 - this.frmOutlineView.getWidth() / 2, this.frmOutlineView.getY() + (this.editor.getTextArea().getHeight() - this.frmOutlineView.getHeight()) / 2);
        DefaultTreeCellRenderer renderer = (DefaultTreeCellRenderer)this.tabTree.getCellRenderer();
        renderer.setLeafIcon(null);
        renderer.setClosedIcon(null);
        renderer.setOpenIcon(null);
        this.addListeners();
    }

    private void addListeners() {
        this.searchField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                if (TabOutline.this.tabTree.getRowCount() == 0) {
                    return;
                }
                TabOutline.this.internalSelection = true;
                if (evt.getKeyCode() == 27) {
                    TabOutline.this.close();
                } else if (evt.getKeyCode() == 10) {
                    if (TabOutline.this.tabTree.getLastSelectedPathComponent() != null) {
                        DefaultMutableTreeNode tnode = (DefaultMutableTreeNode)TabOutline.this.tabTree.getLastSelectedPathComponent();
                        TabOutline.this.switchToTab(tnode.toString());
                        TabOutline.this.close();
                    }
                } else if (evt.getKeyCode() == 38) {
                    if (TabOutline.this.tabTree.getLastSelectedPathComponent() == null) {
                        TabOutline.this.tabTree.setSelectionRow(0);
                        return;
                    }
                    int x = TabOutline.this.tabTree.getLeadSelectionRow() - 1;
                    int step = TabOutline.this.jsp.getVerticalScrollBar().getMaximum() / TabOutline.this.tabTree.getRowCount();
                    if (x == -1) {
                        x = TabOutline.this.tabTree.getRowCount() - 1;
                        TabOutline.this.jsp.getVerticalScrollBar().setValue(TabOutline.this.jsp.getVerticalScrollBar().getMaximum());
                    } else {
                        TabOutline.this.jsp.getVerticalScrollBar().setValue(TabOutline.this.jsp.getVerticalScrollBar().getValue() - step);
                    }
                    TabOutline.this.tabTree.setSelectionRow(x);
                } else if (evt.getKeyCode() == 40) {
                    if (TabOutline.this.tabTree.getLastSelectedPathComponent() == null) {
                        TabOutline.this.tabTree.setSelectionRow(0);
                        return;
                    }
                    int x = TabOutline.this.tabTree.getLeadSelectionRow() + 1;
                    int step = TabOutline.this.jsp.getVerticalScrollBar().getMaximum() / TabOutline.this.tabTree.getRowCount();
                    if (x == TabOutline.this.tabTree.getRowCount()) {
                        x = 0;
                        TabOutline.this.jsp.getVerticalScrollBar().setValue(TabOutline.this.jsp.getVerticalScrollBar().getMinimum());
                    } else {
                        TabOutline.this.jsp.getVerticalScrollBar().setValue(TabOutline.this.jsp.getVerticalScrollBar().getValue() + step);
                    }
                    TabOutline.this.tabTree.setSelectionRow(x);
                }
            }
        });
        this.searchField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.updateSelection();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.updateSelection();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                this.updateSelection();
            }

            private void updateSelection() {
                SwingWorker<Object, Object> worker = new SwingWorker<Object, Object>(){

                    @Override
                    protected Object doInBackground() throws Exception {
                        String text = (this).TabOutline.this.searchField.getText().toLowerCase();
                        (this).TabOutline.this.tempNode = new DefaultMutableTreeNode();
                        TabOutline.this.filterTree(text, (this).TabOutline.this.tempNode, (this).TabOutline.this.tabNode);
                        return null;
                    }

                    @Override
                    protected void done() {
                        (this).TabOutline.this.tabTree.setModel(new DefaultTreeModel((this).TabOutline.this.tempNode));
                        ((DefaultTreeModel)(this).TabOutline.this.tabTree.getModel()).reload();
                        (this).TabOutline.this.internalSelection = true;
                        (this).TabOutline.this.tabTree.setSelectionRow(0);
                    }
                };
                worker.execute();
            }
        });
        this.tabTree.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                if (TabOutline.this.internalSelection) {
                    TabOutline.this.internalSelection = false;
                    return;
                }
                SwingWorker<Object, Object> worker = new SwingWorker<Object, Object>(){

                    @Override
                    protected Object doInBackground() throws Exception {
                        return null;
                    }

                    @Override
                    protected void done() {
                        if ((this).TabOutline.this.tabTree.getLastSelectedPathComponent() == null) {
                            return;
                        }
                        DefaultMutableTreeNode tnode = (DefaultMutableTreeNode)(this).TabOutline.this.tabTree.getLastSelectedPathComponent();
                        TabOutline.this.switchToTab(tnode.toString());
                        TabOutline.this.close();
                    }
                };
                worker.execute();
            }
        });
        this.tabTree.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent me) {
                if (TabOutline.this.tabTree.getLastSelectedPathComponent() == null) {
                    return;
                }
                DefaultMutableTreeNode tnode = (DefaultMutableTreeNode)TabOutline.this.tabTree.getLastSelectedPathComponent();
                TabOutline.this.switchToTab(tnode.toString());
                TabOutline.this.close();
            }
        });
        this.frmOutlineView.addWindowFocusListener(new WindowFocusListener(){

            @Override
            public void windowLostFocus(WindowEvent e) {
                TabOutline.this.close();
            }

            @Override
            public void windowGainedFocus(WindowEvent e) {
            }
        });
    }

    private void switchToTab(String tabName) {
        SketchCode[] sketchCodeArray = this.editor.getSketch().getCode();
        int n = sketchCodeArray.length;
        int n2 = 0;
        while (n2 < n) {
            SketchCode sc = sketchCodeArray[n2];
            if (sc.getPrettyName().equals(tabName)) {
                this.editor.getSketch().setCurrentCode(this.editor.getSketch().getCodeIndex(sc));
            }
            ++n2;
        }
    }

    private void populateTabTree() {
        this.tabNode = new DefaultMutableTreeNode("Tabs");
        SketchCode[] sketchCodeArray = this.editor.getSketch().getCode();
        int n = sketchCodeArray.length;
        int n2 = 0;
        while (n2 < n) {
            SketchCode sc = sketchCodeArray[n2];
            DefaultMutableTreeNode tab = new DefaultMutableTreeNode(sc.getPrettyName());
            this.tabNode.add(tab);
            ++n2;
        }
        this.tempNode = this.tabNode;
        this.tabTree = new JTree(this.tabNode);
        this.tabTree.getSelectionModel().setSelectionMode(1);
        this.tabTree.setRootVisible(false);
        this.tabTree.setSelectionRow(this.editor.getSketch().getCurrentCodeIndex());
    }

    protected boolean filterTree(String prefix, DefaultMutableTreeNode tree, DefaultMutableTreeNode mainTree) {
        if (mainTree.isLeaf()) {
            return mainTree.getUserObject().toString().toLowerCase().startsWith(prefix);
        }
        boolean found = false;
        int i = 0;
        while (i < mainTree.getChildCount()) {
            DefaultMutableTreeNode tNode = new DefaultMutableTreeNode(((DefaultMutableTreeNode)mainTree.getChildAt(i)).getUserObject());
            if (this.filterTree(prefix, tNode, (DefaultMutableTreeNode)mainTree.getChildAt(i))) {
                found = true;
                tree.add(tNode);
            }
            ++i;
        }
        return found;
    }

    private int estimateFrameWidth() {
        FontMetrics fm = this.editor.getTextArea().getGraphics().getFontMetrics();
        int w = fm.stringWidth(this.lblCaption.getText()) + 10;
        int i = 0;
        while (i < this.editor.getSketch().getCodeCount()) {
            w = Math.max(w, fm.stringWidth(this.editor.getSketch().getCode(i).getPrettyName()) + 10);
            ++i;
        }
        return w;
    }

    private int estimateFrameHeight() {
        int textHeight = this.jsp.getGraphics().getFontMetrics().getHeight() + 2;
        int t = Math.max(4, this.editor.getSketch().getCodeCount() + 3);
        return Math.min(textHeight * t, this.frmOutlineView.getHeight());
    }

    public void show() {
        this.frmOutlineView.setVisible(true);
    }

    public void close() {
        this.frmOutlineView.setVisible(false);
        this.frmOutlineView.dispose();
    }

    public boolean isVisible() {
        return this.frmOutlineView.isVisible();
    }
}

