/*
 * Decompiled with CFR 0.152.
 */
package processing.mode.java.pdex;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowEvent;
import java.awt.event.WindowFocusListener;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.SwingWorker;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import processing.app.Mode;
import processing.mode.java.JavaEditor;
import processing.mode.java.pdex.ASTNodeWrapper;
import processing.mode.java.pdex.CompletionCandidate;
import processing.mode.java.pdex.ErrorCheckerService;

public class SketchOutline {
    protected JFrame frmOutlineView;
    protected ErrorCheckerService errorCheckerService;
    protected JScrollPane jsp;
    protected DefaultMutableTreeNode soNode;
    protected DefaultMutableTreeNode tempNode;
    protected final JTree soTree;
    protected JTextField searchField;
    protected JavaEditor editor;
    protected boolean internalSelection = false;
    ImageIcon classIcon;
    ImageIcon fieldIcon;
    ImageIcon methodIcon;

    public SketchOutline(DefaultMutableTreeNode codeTree, ErrorCheckerService ecs) {
        this.errorCheckerService = ecs;
        this.editor = ecs.getEditor();
        this.soNode = new DefaultMutableTreeNode();
        this.generateSketchOutlineTree(this.soNode, codeTree);
        this.tempNode = this.soNode = (DefaultMutableTreeNode)this.soNode.getChildAt(0);
        this.soTree = new JTree(this.soNode);
        Mode mode = this.editor.getMode();
        this.classIcon = mode.loadIcon("theme/icon_class_obj.png");
        this.methodIcon = mode.loadIcon("theme/icon_methpub_obj.png");
        this.fieldIcon = mode.loadIcon("theme/icon_field_protected_obj.png");
        this.createGUI();
    }

    private void createGUI() {
        this.frmOutlineView = new JFrame();
        this.frmOutlineView.setAlwaysOnTop(true);
        this.frmOutlineView.setUndecorated(true);
        Point tp = this.errorCheckerService.getEditor().getTextArea().getLocationOnScreen();
        int minWidth = (int)((float)this.editor.getMinimumSize().width * 0.7f);
        int maxWidth = (int)((float)this.editor.getMinimumSize().width * 0.9f);
        this.frmOutlineView.setLayout(new BoxLayout(this.frmOutlineView.getContentPane(), 1));
        JPanel panelTop = new JPanel();
        JPanel panelBottom = new JPanel();
        panelTop.setLayout(new BoxLayout(panelTop, 1));
        panelBottom.setLayout(new BoxLayout(panelBottom, 1));
        this.searchField = new JTextField();
        this.searchField.setMinimumSize(new Dimension(minWidth, 25));
        panelTop.add(this.searchField);
        this.jsp = new JScrollPane();
        this.soTree.getSelectionModel().setSelectionMode(1);
        this.soTree.setRootVisible(false);
        this.soTree.setCellRenderer(new CustomCellRenderer());
        int i = 0;
        while (i < this.soTree.getRowCount()) {
            this.soTree.expandRow(i);
            ++i;
        }
        this.soTree.setSelectionRow(0);
        this.jsp.setViewportView(this.soTree);
        this.jsp.setVerticalScrollBarPolicy(20);
        this.jsp.setHorizontalScrollBarPolicy(30);
        this.jsp.setMinimumSize(new Dimension(minWidth, this.editor.getTextArea().getHeight() - 10));
        this.jsp.setMaximumSize(new Dimension(maxWidth, this.editor.getTextArea().getHeight() - 10));
        panelBottom.add(this.jsp);
        this.frmOutlineView.add(panelTop);
        this.frmOutlineView.add(panelBottom);
        this.frmOutlineView.setDefaultCloseOperation(2);
        this.frmOutlineView.pack();
        this.frmOutlineView.setBounds(tp.x + this.errorCheckerService.getEditor().getTextArea().getWidth() - minWidth, tp.y, minWidth, Math.min(this.editor.getTextArea().getHeight(), this.frmOutlineView.getHeight()));
        this.frmOutlineView.setMinimumSize(new Dimension(minWidth, Math.min(this.errorCheckerService.getEditor().getTextArea().getHeight(), this.frmOutlineView.getHeight())));
        this.frmOutlineView.setLocation(tp.x + this.errorCheckerService.getEditor().getTextArea().getWidth() / 2 - this.frmOutlineView.getWidth() / 2, this.frmOutlineView.getY() + (this.editor.getTextArea().getHeight() - this.frmOutlineView.getHeight()) / 2);
        this.addListeners();
    }

    protected void addListeners() {
        this.searchField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                if (SketchOutline.this.soTree.getRowCount() == 0) {
                    return;
                }
                SketchOutline.this.internalSelection = true;
                if (evt.getKeyCode() == 27) {
                    SketchOutline.this.close();
                } else if (evt.getKeyCode() == 10) {
                    DefaultMutableTreeNode tnode;
                    if (SketchOutline.this.soTree.getLastSelectedPathComponent() != null && (tnode = (DefaultMutableTreeNode)SketchOutline.this.soTree.getLastSelectedPathComponent()).getUserObject() instanceof ASTNodeWrapper) {
                        ASTNodeWrapper awrap = (ASTNodeWrapper)tnode.getUserObject();
                        awrap.highlightNode(SketchOutline.this.editor);
                        SketchOutline.this.close();
                    }
                } else if (evt.getKeyCode() == 38) {
                    if (SketchOutline.this.soTree.getLastSelectedPathComponent() == null) {
                        SketchOutline.this.soTree.setSelectionRow(0);
                        return;
                    }
                    int x = SketchOutline.this.soTree.getLeadSelectionRow() - 1;
                    int step = SketchOutline.this.jsp.getVerticalScrollBar().getMaximum() / SketchOutline.this.soTree.getRowCount();
                    if (x == -1) {
                        x = SketchOutline.this.soTree.getRowCount() - 1;
                        SketchOutline.this.jsp.getVerticalScrollBar().setValue(SketchOutline.this.jsp.getVerticalScrollBar().getMaximum());
                    } else {
                        SketchOutline.this.jsp.getVerticalScrollBar().setValue(SketchOutline.this.jsp.getVerticalScrollBar().getValue() - step);
                    }
                    SketchOutline.this.soTree.setSelectionRow(x);
                } else if (evt.getKeyCode() == 40) {
                    if (SketchOutline.this.soTree.getLastSelectedPathComponent() == null) {
                        SketchOutline.this.soTree.setSelectionRow(0);
                        return;
                    }
                    int x = SketchOutline.this.soTree.getLeadSelectionRow() + 1;
                    int step = SketchOutline.this.jsp.getVerticalScrollBar().getMaximum() / SketchOutline.this.soTree.getRowCount();
                    if (x == SketchOutline.this.soTree.getRowCount()) {
                        x = 0;
                        SketchOutline.this.jsp.getVerticalScrollBar().setValue(SketchOutline.this.jsp.getVerticalScrollBar().getMinimum());
                    } else {
                        SketchOutline.this.jsp.getVerticalScrollBar().setValue(SketchOutline.this.jsp.getVerticalScrollBar().getValue() + step);
                    }
                    SketchOutline.this.soTree.setSelectionRow(x);
                }
            }
        });
        this.searchField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.updateSelection();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.updateSelection();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                this.updateSelection();
            }

            private void updateSelection() {
                SwingWorker<Object, Object> worker = new SwingWorker<Object, Object>(){

                    @Override
                    protected Object doInBackground() throws Exception {
                        String text = (this).SketchOutline.this.searchField.getText().toLowerCase();
                        (this).SketchOutline.this.tempNode = new DefaultMutableTreeNode();
                        SketchOutline.this.filterTree(text, (this).SketchOutline.this.tempNode, (this).SketchOutline.this.soNode);
                        return null;
                    }

                    @Override
                    protected void done() {
                        (this).SketchOutline.this.soTree.setModel(new DefaultTreeModel((this).SketchOutline.this.tempNode));
                        ((DefaultTreeModel)(this).SketchOutline.this.soTree.getModel()).reload();
                        int i = 0;
                        while (i < (this).SketchOutline.this.soTree.getRowCount()) {
                            (this).SketchOutline.this.soTree.expandRow(i);
                            ++i;
                        }
                        (this).SketchOutline.this.internalSelection = true;
                        (this).SketchOutline.this.soTree.setSelectionRow(0);
                    }
                };
                worker.execute();
            }
        });
        this.frmOutlineView.addWindowFocusListener(new WindowFocusListener(){

            @Override
            public void windowLostFocus(WindowEvent e) {
                SketchOutline.this.close();
            }

            @Override
            public void windowGainedFocus(WindowEvent e) {
            }
        });
        this.soTree.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                if (SketchOutline.this.internalSelection) {
                    SketchOutline.this.internalSelection = false;
                    return;
                }
                SketchOutline.this.scrollToNode();
            }
        });
        this.soTree.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent me) {
                SketchOutline.this.scrollToNode();
            }
        });
    }

    private void scrollToNode() {
        SwingWorker<Object, Object> worker = new SwingWorker<Object, Object>(){

            @Override
            protected Object doInBackground() throws Exception {
                return null;
            }

            @Override
            protected void done() {
                if (SketchOutline.this.soTree.getLastSelectedPathComponent() == null) {
                    return;
                }
                DefaultMutableTreeNode tnode = (DefaultMutableTreeNode)SketchOutline.this.soTree.getLastSelectedPathComponent();
                if (tnode.getUserObject() instanceof ASTNodeWrapper) {
                    ASTNodeWrapper awrap = (ASTNodeWrapper)tnode.getUserObject();
                    awrap.highlightNode(SketchOutline.this.editor);
                    SketchOutline.this.close();
                }
            }
        };
        worker.execute();
    }

    protected boolean filterTree(String prefix, DefaultMutableTreeNode tree, DefaultMutableTreeNode mainTree) {
        if (mainTree.isLeaf()) {
            return mainTree.getUserObject().toString().toLowerCase().startsWith(prefix);
        }
        boolean found = false;
        int i = 0;
        while (i < mainTree.getChildCount()) {
            DefaultMutableTreeNode tNode = new DefaultMutableTreeNode(((DefaultMutableTreeNode)mainTree.getChildAt(i)).getUserObject());
            if (this.filterTree(prefix, tNode, (DefaultMutableTreeNode)mainTree.getChildAt(i))) {
                found = true;
                tree.add(tNode);
            }
            ++i;
        }
        return found;
    }

    protected void generateSketchOutlineTree(DefaultMutableTreeNode node, DefaultMutableTreeNode codetree) {
        if (codetree == null) {
            return;
        }
        if (!(codetree.getUserObject() instanceof ASTNodeWrapper)) {
            return;
        }
        ASTNodeWrapper awnode = (ASTNodeWrapper)codetree.getUserObject();
        ASTNodeWrapper aw2 = null;
        if (awnode.getNode() instanceof TypeDeclaration) {
            aw2 = new ASTNodeWrapper((ASTNode)((TypeDeclaration)awnode.getNode()).getName(), ((TypeDeclaration)awnode.getNode()).getName().toString());
        } else if (awnode.getNode() instanceof MethodDeclaration) {
            aw2 = new ASTNodeWrapper((ASTNode)((MethodDeclaration)awnode.getNode()).getName(), new CompletionCandidate((MethodDeclaration)awnode.getNode()).toString());
        } else if (awnode.getNode() instanceof FieldDeclaration) {
            FieldDeclaration fd = (FieldDeclaration)awnode.getNode();
            for (VariableDeclarationFragment vdf : fd.fragments()) {
                String text = new CompletionCandidate(vdf).toString();
                DefaultMutableTreeNode newNode = new DefaultMutableTreeNode(new ASTNodeWrapper((ASTNode)vdf.getName(), text));
                node.add(newNode);
            }
            return;
        }
        if (aw2 == null) {
            return;
        }
        DefaultMutableTreeNode newNode = new DefaultMutableTreeNode(aw2);
        node.add(newNode);
        int i = 0;
        while (i < codetree.getChildCount()) {
            this.generateSketchOutlineTree(newNode, (DefaultMutableTreeNode)codetree.getChildAt(i));
            ++i;
        }
    }

    public void show() {
        this.frmOutlineView.setVisible(true);
    }

    public void close() {
        this.frmOutlineView.setVisible(false);
        this.frmOutlineView.dispose();
    }

    public boolean isVisible() {
        return this.frmOutlineView.isVisible();
    }

    protected class CustomCellRenderer
    extends DefaultTreeCellRenderer {
        protected CustomCellRenderer() {
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
            if (value instanceof DefaultMutableTreeNode) {
                this.setIcon(this.getTreeIcon(value));
            }
            return this;
        }

        public Icon getTreeIcon(Object o) {
            if (((DefaultMutableTreeNode)o).getUserObject() instanceof ASTNodeWrapper) {
                ASTNodeWrapper awrap = (ASTNodeWrapper)((DefaultMutableTreeNode)o).getUserObject();
                int type = awrap.getNode().getParent().getNodeType();
                if (type == 31) {
                    return SketchOutline.this.methodIcon;
                }
                if (type == 55) {
                    return SketchOutline.this.classIcon;
                }
                if (type == 59) {
                    return SketchOutline.this.fieldIcon;
                }
            }
            return null;
        }
    }
}

