/*
 * Decompiled with CFR 0.152.
 */
package processing.mode.java.pdex;

import java.util.ArrayList;

public class OffsetMatcher {
    public ArrayList<OffsetPair> offsetMatch;
    String pdeCodeLine;
    String javaCodeLine;
    boolean matchingNeeded = false;

    public OffsetMatcher(String pdeCode, String javaCode) {
        this.pdeCodeLine = pdeCode;
        this.javaCodeLine = javaCode;
        if (this.pdeCodeLine.trim().equals(this.javaCodeLine.trim())) {
            this.matchingNeeded = false;
            this.offsetMatch = new ArrayList();
        } else {
            this.matchingNeeded = true;
            this.minDistance();
        }
    }

    public int getPdeOffForJavaOff(int start, int length) {
        if (!this.matchingNeeded) {
            return start;
        }
        int ans = this.getPdeOffForJavaOff(start);
        int end = this.getPdeOffForJavaOff(start + length - 1);
        if (ans != -1) {
            // empty if block
        }
        return ans;
    }

    public int getJavaOffForPdeOff(int start, int length) {
        if (!this.matchingNeeded) {
            return start;
        }
        int ans = this.getJavaOffForPdeOff(start);
        return ans;
    }

    public int getPdeOffForJavaOff(int javaOff) {
        if (!this.matchingNeeded) {
            return javaOff;
        }
        int i = this.offsetMatch.size() - 1;
        while (i >= 0) {
            if (this.offsetMatch.get((int)i).javaOffset >= javaOff && this.offsetMatch.get((int)i).javaOffset == javaOff) {
                int j;
                while (i > 0 && this.offsetMatch.get((int)(--i)).javaOffset == javaOff) {
                }
                if (i + 1 < this.offsetMatch.size()) {
                    int pdeOff = this.offsetMatch.get((int)(++i)).pdeOffset;
                    while (i > 0 && this.offsetMatch.get((int)(--i)).pdeOffset == pdeOff) {
                    }
                }
                if ((j = i + 1) > -1 && j < this.offsetMatch.size()) {
                    return this.offsetMatch.get((int)j).pdeOffset;
                }
            }
            --i;
        }
        return -1;
    }

    public int getJavaOffForPdeOff(int pdeOff) {
        if (!this.matchingNeeded) {
            return pdeOff;
        }
        int i = this.offsetMatch.size() - 1;
        while (i >= 0) {
            if (this.offsetMatch.get((int)i).pdeOffset >= pdeOff && this.offsetMatch.get((int)i).pdeOffset == pdeOff) {
                int j;
                while (i > 0 && this.offsetMatch.get((int)(--i)).pdeOffset == pdeOff) {
                }
                if (i + 1 < this.offsetMatch.size()) {
                    int javaOff = this.offsetMatch.get((int)(++i)).javaOffset;
                    while (i > 0 && this.offsetMatch.get((int)(--i)).javaOffset == javaOff) {
                    }
                }
                if ((j = i + 1) > -1 && j < this.offsetMatch.size()) {
                    return this.offsetMatch.get((int)j).javaOffset;
                }
            }
            --i;
        }
        return -1;
    }

    private int minDistance() {
        int len1 = this.pdeCodeLine.length();
        int len2 = this.javaCodeLine.length();
        int[][] dp = new int[len1 + 1][len2 + 1];
        int i = 0;
        while (i <= len1) {
            dp[i][0] = i;
            ++i;
        }
        int j = 0;
        while (j <= len2) {
            dp[0][j] = j;
            ++j;
        }
        i = 0;
        while (i < len1) {
            char c1 = this.pdeCodeLine.charAt(i);
            int j2 = 0;
            while (j2 < len2) {
                char c2 = this.javaCodeLine.charAt(j2);
                if (c1 == c2) {
                    dp[i + 1][j2 + 1] = dp[i][j2];
                } else {
                    int replace = dp[i][j2] + 1;
                    int insert = dp[i][j2 + 1] + 1;
                    int delete = dp[i + 1][j2] + 1;
                    int min = replace > insert ? insert : replace;
                    dp[i + 1][j2 + 1] = min = delete > min ? min : delete;
                }
                ++j2;
            }
            ++i;
        }
        ArrayList<OffsetPair> alist = new ArrayList<OffsetPair>();
        this.offsetMatch = alist;
        this.minDistInGrid(dp, len1, len2, 0, 0, this.pdeCodeLine.toCharArray(), this.javaCodeLine.toCharArray(), alist);
        return dp[len1][len2];
    }

    private void minDistInGrid(int[][] g, int i, int j, int fi, int fj, char[] s1, char[] s2, ArrayList<OffsetPair> set) {
        if (i < s1.length && j < s2.length) {
            set.add(new OffsetPair(i, j));
        }
        if (i != fi || j != fj) {
            int mini;
            int a;
            int b = a = Integer.MAX_VALUE;
            int c = a;
            if (i > 0) {
                a = g[i - 1][j];
            }
            if (j > 0) {
                b = g[i][j - 1];
            }
            if (i > 0 && j > 0) {
                c = g[i - 1][j - 1];
            }
            if ((mini = Math.min(a, Math.min(b, c))) == a) {
                this.minDistInGrid(g, i - 1, j, fi, fj, s1, s2, set);
            } else if (mini == b) {
                this.minDistInGrid(g, i, j - 1, fi, fj, s1, s2, set);
            } else if (mini == c) {
                this.minDistInGrid(g, i - 1, j - 1, fi, fj, s1, s2, set);
            }
        }
    }

    private class OffsetPair {
        public final int pdeOffset;
        public final int javaOffset;

        public OffsetPair(int pde, int java) {
            this.pdeOffset = pde;
            this.javaOffset = java;
        }
    }
}

