/*
 * Decompiled with CFR 0.152.
 */
package processing.mode.java.pdex;

import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Image;
import java.awt.Point;
import java.awt.event.ComponentListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.BitSet;
import java.util.Collections;
import java.util.EventListener;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import javax.swing.DefaultListModel;
import javax.swing.SwingWorker;
import processing.app.Messages;
import processing.app.Mode;
import processing.app.Platform;
import processing.app.syntax.InputHandler;
import processing.app.syntax.JEditTextArea;
import processing.app.syntax.PdeTextAreaDefaults;
import processing.app.syntax.TextAreaDefaults;
import processing.mode.java.JavaEditor;
import processing.mode.java.JavaInputHandler;
import processing.mode.java.JavaMode;
import processing.mode.java.pdex.ASTGenerator;
import processing.mode.java.pdex.CompletionCandidate;
import processing.mode.java.pdex.CompletionPanel;
import processing.mode.java.pdex.JavaTextAreaPainter;
import processing.mode.java.tweak.ColorControlBox;
import processing.mode.java.tweak.Handle;

public class JavaTextArea
extends JEditTextArea {
    protected PdeTextAreaDefaults defaults;
    protected JavaEditor editor;
    protected MouseListener[] mouseListeners;
    protected Map<Integer, Color> lineColors = new HashMap<Integer, Color>();
    protected int gutterPadding;
    protected Image gutterGradient;
    protected Color gutterLineColor;
    public static final String BREAK_MARKER = "<>";
    public static final String STEP_MARKER = "->";
    protected Map<Integer, String> gutterText = new HashMap<Integer, String>();
    protected Map<Integer, Color> gutterTextColors = new HashMap<Integer, Color>();
    private CompletionPanel suggestion;
    SwingWorker<Void, Void> suggestionWorker = null;
    int lastCaretPosition = 0;
    String lastPhrase = "";
    volatile boolean suggestionRunning = false;
    volatile boolean suggestionRequested = false;
    ComponentListener[] prevCompListeners;
    MouseListener[] prevMouseListeners;
    MouseMotionListener[] prevMMotionListeners;
    KeyListener[] prevKeyListeners;
    boolean tweakMode;

    public JavaTextArea(TextAreaDefaults defaults, JavaEditor editor) {
        super(defaults, (InputHandler)new JavaInputHandler(editor));
        this.editor = editor;
        this.mouseListeners = this.painter.getMouseListeners();
        MouseHandler mouseHandler = new MouseHandler();
        this.painter.addMouseListener((MouseListener)mouseHandler);
        this.painter.addMouseMotionListener((MouseMotionListener)mouseHandler);
        this.add(CENTER, (Component)this.painter);
        Mode mode = editor.getMode();
        this.gutterGradient = mode.makeGradient("editor", 44, 500);
        this.gutterLineColor = mode.getColor("editor.gutter.linecolor");
        this.gutterPadding = mode.getInteger("editor.gutter.padding");
        this.prevCompListeners = this.painter.getComponentListeners();
        this.prevMouseListeners = this.painter.getMouseListeners();
        this.prevMMotionListeners = this.painter.getMouseMotionListeners();
        this.prevKeyListeners = editor.getKeyListeners();
        this.tweakMode = false;
        this.addPrevListeners();
    }

    protected JavaTextAreaPainter createPainter(TextAreaDefaults defaults) {
        return new JavaTextAreaPainter(this, defaults);
    }

    protected JavaTextAreaPainter getCustomPainter() {
        return (JavaTextAreaPainter)this.painter;
    }

    public void setMode(JavaMode mode) {
        this.getCustomPainter().setMode(mode);
    }

    public void processKeyEvent(KeyEvent evt) {
        if (evt.getKeyCode() == 27) {
            if (this.suggestion != null && this.suggestion.isVisible()) {
                Messages.log((String)"esc key");
                this.hideSuggestion();
                evt.consume();
                return;
            }
        } else if (evt.getKeyCode() == 10 && evt.getID() == 401 && this.suggestion != null && this.suggestion.isVisible() && this.suggestion.insertSelection(20)) {
            evt.consume();
            if (this.suggestion.isVisible()) {
                this.prepareSuggestions(evt);
            }
            return;
        }
        if (evt.getID() == 401) {
            switch (evt.getKeyCode()) {
                case 40: {
                    if (this.suggestion == null || !this.suggestion.isVisible()) break;
                    this.suggestion.moveDown();
                    return;
                }
                case 38: {
                    if (this.suggestion == null || !this.suggestion.isVisible()) break;
                    this.suggestion.moveUp();
                    return;
                }
                case 8: {
                    Messages.log((String)"BK Key");
                    break;
                }
                case 32: {
                    if (this.suggestion == null || !this.suggestion.isVisible()) break;
                    Messages.log((String)"Space bar, hide completion list");
                    this.suggestion.setInvisible();
                }
            }
        }
        super.processKeyEvent(evt);
        if (!this.editor.hasJavaTabs()) {
            if (evt.getID() == 400) {
                this.processCompletionKeys(evt);
            } else if (!Platform.isMacOS() && evt.getID() == 402) {
                this.processCompletionKeys(evt);
            } else if (Platform.isMacOS() && evt.getID() == 402) {
                this.processControlSpace(evt);
            }
        }
    }

    private void processControlSpace(KeyEvent event) {
        if (event.getKeyCode() == 32 && event.isControlDown() && JavaMode.codeCompletionsEnabled) {
            Messages.log((String)("[KeyEvent]" + KeyEvent.getKeyText(event.getKeyCode()) + "  |Prediction started"));
            this.fetchPhrase();
        }
    }

    private void processCompletionKeys(KeyEvent event) {
        char keyChar = event.getKeyChar();
        int keyCode = event.getKeyCode();
        if (keyChar != '\n' && keyChar != '\u001b' && keyChar != '\t' && (event.getID() != 402 || keyCode == 37 || keyCode == 39)) {
            if (keyChar == ')') {
                this.hideSuggestion();
            } else if (keyChar == '.') {
                if (JavaMode.codeCompletionsEnabled) {
                    Messages.log((String)("[KeyEvent]" + KeyEvent.getKeyText(event.getKeyCode()) + "  |Prediction started"));
                    this.fetchPhrase();
                }
            } else if (keyChar == ' ') {
                if (!Platform.isMacOS() && JavaMode.codeCompletionsEnabled && (event.isControlDown() || event.isMetaDown())) {
                    if (JavaMode.codeCompletionsEnabled) {
                        Messages.log((String)("[KeyEvent]" + event.getKeyChar() + "  |Prediction started"));
                        this.fetchPhrase();
                    }
                } else {
                    this.hideSuggestion();
                }
            } else if (JavaMode.codeCompletionsEnabled) {
                this.prepareSuggestions(event);
            }
        }
    }

    private void prepareSuggestions(KeyEvent evt) {
        if (JavaMode.codeCompletionsEnabled && (JavaMode.ccTriggerEnabled || this.suggestion != null && this.suggestion.isVisible())) {
            Messages.log((String)("[KeyEvent]" + evt.getKeyChar() + "  |Prediction started"));
            this.fetchPhrase();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String fetchPhrase(MouseEvent evt) {
        ASTGenerator astGenerator;
        Messages.log((String)"--handle Mouse Right Click--");
        int off = this.xyToOffset(evt.getX(), evt.getY());
        if (off < 0) {
            return null;
        }
        int line = this.getLineOfOffset(off);
        if (line < 0) {
            return null;
        }
        String s = this.getLineText(line);
        if (s == null) {
            return null;
        }
        if (s.length() == 0) {
            return null;
        }
        int x = this.xToOffset(line, evt.getX());
        int x2 = x + 1;
        int x1 = x - 1;
        int xLS = off - this.getLineStartNonWhiteSpaceOffset(line);
        Messages.log((String)("x=" + x));
        if (x < 0 || x >= s.length()) {
            return null;
        }
        String word = String.valueOf(s.charAt(x));
        if (s.charAt(x) == ' ') {
            return null;
        }
        if (!Character.isLetterOrDigit(s.charAt(x)) && s.charAt(x) != '_' && s.charAt(x) != '$') {
            return null;
        }
        int i = 0;
        do {
            ++i;
            if (x1 >= 0 && x1 < s.length()) {
                if (Character.isLetter(s.charAt(x1)) || s.charAt(x1) == '_') {
                    word = String.valueOf(s.charAt(x1--)) + word;
                    --xLS;
                } else {
                    x1 = -1;
                }
            } else {
                x1 = -1;
            }
            if (x2 >= 0 && x2 < s.length()) {
                if (Character.isLetterOrDigit(s.charAt(x2)) || s.charAt(x2) == '_' || s.charAt(x2) == '$') {
                    word = String.valueOf(word) + s.charAt(x2++);
                    continue;
                }
                x2 = -1;
                continue;
            }
            x2 = -1;
        } while ((x1 >= 0 || x2 >= 0) && i <= 200);
        if (Character.isDigit(word.charAt(0))) {
            return null;
        }
        Messages.log((String)("Mouse click, word: " + word.trim()));
        ASTGenerator aSTGenerator = astGenerator = this.editor.getErrorChecker().getASTGenerator();
        synchronized (aSTGenerator) {
            astGenerator.setLastClickedWord(line, word, xLS);
        }
        return word.trim();
    }

    protected void fetchPhrase() {
        if (this.suggestionRunning) {
            this.suggestionRequested = true;
            return;
        }
        this.suggestionRunning = true;
        this.suggestionRequested = false;
        int caretPosition = this.getCaretPosition();
        if (caretPosition < 0) {
            this.suggestionRunning = false;
            return;
        }
        final int caretLineIndex = this.getCaretLine();
        if (caretLineIndex < 0) {
            this.suggestionRunning = false;
            return;
        }
        String lineText = this.getLineText(caretLineIndex);
        if (lineText == null) {
            this.suggestionRunning = false;
            return;
        }
        int caretLinePosition = this.getCaretPosition() - this.getLineStartOffset(caretLineIndex);
        if (caretLinePosition <= 0) {
            this.suggestionRunning = false;
            return;
        }
        if (caretLinePosition > lineText.length()) {
            this.suggestionRunning = false;
            return;
        }
        final String text = lineText.substring(0, caretLinePosition);
        this.suggestionWorker = new SwingWorker<Void, Void>(){
            String phrase = null;
            DefaultListModel<CompletionCandidate> defListModel = null;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected Void doInBackground() throws Exception {
                ASTGenerator astGenerator;
                Messages.log((String)"phrase parse start");
                this.phrase = JavaTextArea.parsePhrase(text);
                Messages.log((String)("phrase: " + this.phrase));
                if (this.phrase == null) {
                    return null;
                }
                List<CompletionCandidate> candidates = null;
                ASTGenerator aSTGenerator = astGenerator = JavaTextArea.this.editor.getErrorChecker().getASTGenerator();
                synchronized (aSTGenerator) {
                    int lineOffset = caretLineIndex + JavaTextArea.this.editor.getErrorChecker().mainClassOffset;
                    candidates = astGenerator.preparePredictions(this.phrase, lineOffset);
                }
                if (JavaTextArea.this.suggestionRequested) {
                    return null;
                }
                if (this.phrase != null && candidates != null && !candidates.isEmpty()) {
                    Collections.sort(candidates);
                    this.defListModel = ASTGenerator.filterPredictions(candidates);
                    Messages.log((String)("Got: " + candidates.size() + " candidates, " + this.defListModel.size() + " filtered"));
                }
                return null;
            }

            @Override
            protected void done() {
                try {
                    this.get();
                }
                catch (ExecutionException e) {
                    Messages.loge((String)"error while preparing suggestions", (Throwable)e.getCause());
                }
                catch (InterruptedException interruptedException) {}
                JavaTextArea.this.suggestionRunning = false;
                if (JavaTextArea.this.suggestionRequested) {
                    Messages.log((String)"completion invalidated");
                    JavaTextArea.this.hideSuggestion();
                    JavaTextArea.this.fetchPhrase();
                    return;
                }
                Messages.log((String)"completion finishing");
                if (this.defListModel != null) {
                    JavaTextArea.this.showSuggestion(this.defListModel, this.phrase);
                } else {
                    JavaTextArea.this.hideSuggestion();
                }
            }
        };
        this.suggestionWorker.execute();
    }

    /*
     * Enabled aggressive block sorting
     */
    protected static String parsePhrase(String lineText) {
        boolean overloading;
        block48: {
            char lastChar;
            block47: {
                overloading = false;
                String trimmedLineText = lineText.trim();
                if (trimmedLineText.length() == 0) {
                    return null;
                }
                lastChar = trimmedLineText.charAt(trimmedLineText.length() - 1);
                if (lastChar != '.') break block47;
                if ((trimmedLineText = trimmedLineText.substring(0, trimmedLineText.length() - 1).trim()).length() == 0) {
                    return null;
                }
                lastChar = trimmedLineText.charAt(trimmedLineText.length() - 1);
                switch (lastChar) {
                    case '\"': 
                    case ')': 
                    case ']': {
                        break block48;
                    }
                    default: {
                        if (!Character.isJavaIdentifierPart(lastChar)) {
                            return null;
                        }
                        break block48;
                    }
                }
            }
            if (lastChar == '(') {
                overloading = true;
            } else if (!Character.isJavaIdentifierPart(lastChar)) {
                return null;
            }
        }
        int currentCharIndex = lineText.length() - 1;
        int commentStart = lineText.indexOf("//", 0);
        if (commentStart >= 0 && currentCharIndex > commentStart) {
            return null;
        }
        BitSet isInLiteral = new BitSet(lineText.length());
        BitSet isInBrackets = new BitSet(lineText.length());
        boolean inString = false;
        boolean inChar = false;
        boolean inEscaped = false;
        int i = 0;
        while (i < lineText.length()) {
            block50: {
                block49: {
                    if (inEscaped) break block49;
                    switch (lineText.charAt(i)) {
                        case '\"': {
                            if (!inChar) {
                                inString = !inString;
                                break;
                            }
                            break block50;
                        }
                        case '\'': {
                            if (!inString) {
                                inChar = !inChar;
                                break;
                            }
                            break block50;
                        }
                        case '\\': {
                            if (!inString && !inChar) break block50;
                            inEscaped = true;
                        }
                        default: {
                            break;
                        }
                        {
                        }
                    }
                    break block50;
                }
                inEscaped = false;
            }
            isInLiteral.set(i, inString || inChar);
            ++i;
        }
        if (isInLiteral.get(currentCharIndex)) {
            return null;
        }
        int depth = overloading ? 1 : 0;
        int bracketStart = overloading ? lineText.length() : 0;
        int squareDepth = 0;
        int squareBracketStart = 0;
        int i2 = lineText.length() - 1;
        block23: while (i2 >= 0) {
            if (!isInLiteral.get(i2)) {
                switch (lineText.charAt(i2)) {
                    case ')': {
                        if (depth == 0) {
                            bracketStart = i2;
                        }
                        ++depth;
                        break;
                    }
                    case '(': {
                        if (--depth == 0) {
                            isInBrackets.set(i2, bracketStart);
                            break;
                        }
                        if (depth >= 0) break;
                        break block23;
                    }
                    case ']': {
                        if (squareDepth == 0) {
                            squareBracketStart = i2;
                        }
                        ++squareDepth;
                        break;
                    }
                    case '[': {
                        if (--squareDepth == 0) {
                            isInBrackets.set(i2, squareBracketStart);
                            break;
                        }
                        if (squareDepth < 0) break block23;
                    }
                }
            }
            --i2;
        }
        if (depth > 0) {
            isInBrackets.set(0, bracketStart);
        }
        if (squareDepth > 0) {
            isInBrackets.set(0, squareBracketStart);
        }
        int position = currentCharIndex;
        block24: while (position >= 0) {
            char currChar = lineText.charAt(position);
            switch (currChar) {
                case '.': {
                    --position;
                    break;
                }
                case '[': {
                    break block24;
                }
                case ']': {
                    position = isInBrackets.previousClearBit(position - 1);
                    break;
                }
                case '(': {
                    if (!isInBrackets.get(position)) break block24;
                    --position;
                    break;
                }
                case ')': {
                    position = isInBrackets.previousClearBit(position - 1);
                    break;
                }
                case '\"': {
                    position = isInLiteral.previousClearBit(position - 1);
                    break block24;
                }
                default: {
                    if (Character.isJavaIdentifierPart((int)currChar)) {
                        --position;
                        break;
                    }
                    if (!Character.isWhitespace((int)currChar)) break block24;
                    --position;
                }
            }
        }
        String phrase = lineText.substring(++position, lineText.length()).trim();
        Messages.log((String)phrase);
        if (phrase.length() != 0 && !Character.isDigit(phrase.charAt(0))) {
            return phrase;
        }
        return null;
    }

    public Image getGutterGradient() {
        return this.gutterGradient;
    }

    public void setGutterText(int lineIdx, String text) {
        this.gutterText.put(lineIdx, text);
        this.painter.invalidateLine(lineIdx);
    }

    public void setGutterText(int lineIdx, String text, Color textColor) {
        this.gutterTextColors.put(lineIdx, textColor);
        this.setGutterText(lineIdx, text);
    }

    public void clearGutterText(int lineIdx) {
        this.gutterText.remove(lineIdx);
        this.painter.invalidateLine(lineIdx);
    }

    public void clearGutterText() {
        for (int lineIdx : this.gutterText.keySet()) {
            this.painter.invalidateLine(lineIdx);
        }
        this.gutterText.clear();
    }

    public String getGutterText(int lineIdx) {
        return this.gutterText.get(lineIdx);
    }

    public Color getGutterTextColor(int lineIdx) {
        return this.gutterTextColors.get(lineIdx);
    }

    public void setLineBgColor(int lineIdx, Color col) {
        this.lineColors.put(lineIdx, col);
        this.painter.invalidateLine(lineIdx);
    }

    public void clearLineBgColor(int lineIdx) {
        this.lineColors.remove(lineIdx);
        this.painter.invalidateLine(lineIdx);
    }

    public void clearLineBgColors() {
        for (int lineIdx : this.lineColors.keySet()) {
            this.painter.invalidateLine(lineIdx);
        }
        this.lineColors.clear();
    }

    public Color getLineBgColor(int lineIdx) {
        return this.lineColors.get(lineIdx);
    }

    public int _offsetToX(int line, int offset) {
        return super._offsetToX(line, offset) + 44;
    }

    public int xToOffset(int line, int x) {
        return super.xToOffset(line, x - 44);
    }

    protected void showSuggestion(DefaultListModel<CompletionCandidate> listModel, String subWord) {
        this.hideSuggestion();
        if (listModel.size() == 0) {
            Messages.log((String)"TextArea: No suggestions to show.");
        } else {
            int position = this.getCaretPosition();
            Point location = new Point();
            try {
                location.x = this.offsetToX(this.getCaretLine(), position - this.getLineStartOffset(this.getCaretLine()));
                location.y = this.lineToY(this.getCaretLine()) + this.getPainter().getFontMetrics().getHeight() + this.getPainter().getFontMetrics().getDescent();
            }
            catch (Exception e2) {
                e2.printStackTrace();
                return;
            }
            this.suggestion = new CompletionPanel(this, position, subWord, listModel, location, this.editor);
            this.requestFocusInWindow();
        }
    }

    public void hideSuggestion() {
        if (this.suggestion != null) {
            this.suggestion.setInvisible();
            this.suggestion = null;
        }
    }

    public void removeAllListeners() {
        ComponentListener[] componentListeners = this.painter.getComponentListeners();
        MouseListener[] mouseListeners = this.painter.getMouseListeners();
        MouseMotionListener[] mouseMotionListeners = this.painter.getMouseMotionListeners();
        KeyListener[] keyListeners = this.editor.getKeyListeners();
        EventListener[] eventListenerArray = componentListeners;
        int n = componentListeners.length;
        int n2 = 0;
        while (n2 < n) {
            ComponentListener cl = eventListenerArray[n2];
            this.painter.removeComponentListener(cl);
            ++n2;
        }
        eventListenerArray = mouseListeners;
        n = mouseListeners.length;
        n2 = 0;
        while (n2 < n) {
            EventListener ml = eventListenerArray[n2];
            this.painter.removeMouseListener((MouseListener)ml);
            ++n2;
        }
        eventListenerArray = mouseMotionListeners;
        n = mouseMotionListeners.length;
        n2 = 0;
        while (n2 < n) {
            EventListener mml = eventListenerArray[n2];
            this.painter.removeMouseMotionListener((MouseMotionListener)mml);
            ++n2;
        }
        eventListenerArray = keyListeners;
        n = keyListeners.length;
        n2 = 0;
        while (n2 < n) {
            EventListener kl = eventListenerArray[n2];
            this.editor.removeKeyListener((KeyListener)kl);
            ++n2;
        }
    }

    public void startTweakMode() {
        if (!this.tweakMode) {
            this.removeAllListeners();
            this.getCustomPainter().startTweakMode();
            this.editable = false;
            this.caretBlinks = false;
            this.setCaretVisible(false);
            this.tweakMode = true;
        }
    }

    public void stopTweakMode() {
        if (this.tweakMode) {
            this.removeAllListeners();
            this.addPrevListeners();
            this.getCustomPainter().stopTweakMode();
            this.editable = true;
            this.caretBlinks = true;
            this.setCaretVisible(true);
            this.tweakMode = false;
        }
    }

    public int getHorizontalScroll() {
        return this.horizontal.getValue();
    }

    private void addPrevListeners() {
        EventListener[] eventListenerArray = this.prevCompListeners;
        int n = this.prevCompListeners.length;
        int n2 = 0;
        while (n2 < n) {
            ComponentListener cl = eventListenerArray[n2];
            this.painter.addComponentListener(cl);
            ++n2;
        }
        eventListenerArray = this.prevMouseListeners;
        n = this.prevMouseListeners.length;
        n2 = 0;
        while (n2 < n) {
            EventListener ml = eventListenerArray[n2];
            this.painter.addMouseListener((MouseListener)ml);
            ++n2;
        }
        eventListenerArray = this.prevMMotionListeners;
        n = this.prevMMotionListeners.length;
        n2 = 0;
        while (n2 < n) {
            EventListener mml = eventListenerArray[n2];
            this.painter.addMouseMotionListener((MouseMotionListener)mml);
            ++n2;
        }
        eventListenerArray = this.prevKeyListeners;
        n = this.prevKeyListeners.length;
        n2 = 0;
        while (n2 < n) {
            EventListener kl = eventListenerArray[n2];
            this.editor.addKeyListener((KeyListener)kl);
            ++n2;
        }
    }

    public void updateInterface(List<List<Handle>> handles, List<List<ColorControlBox>> colorBoxes) {
        this.getCustomPainter().updateInterface(handles, colorBoxes);
    }

    protected class MouseHandler
    implements MouseListener,
    MouseMotionListener {
        protected int lastX;

        protected MouseHandler() {
        }

        @Override
        public void mouseClicked(MouseEvent me) {
            MouseListener[] mouseListenerArray = JavaTextArea.this.mouseListeners;
            int n = JavaTextArea.this.mouseListeners.length;
            int n2 = 0;
            while (n2 < n) {
                MouseListener ml = mouseListenerArray[n2];
                ml.mouseClicked(me);
                ++n2;
            }
        }

        @Override
        public void mousePressed(MouseEvent me) {
            if (me.getButton() == 3 && !JavaTextArea.this.editor.hasJavaTabs()) {
                JavaTextArea.this.fetchPhrase(me);
            }
            MouseListener[] mouseListenerArray = JavaTextArea.this.mouseListeners;
            int n = JavaTextArea.this.mouseListeners.length;
            int n2 = 0;
            while (n2 < n) {
                MouseListener ml = mouseListenerArray[n2];
                ml.mousePressed(me);
                ++n2;
            }
        }

        @Override
        public void mouseReleased(MouseEvent me) {
            MouseListener[] mouseListenerArray = JavaTextArea.this.mouseListeners;
            int n = JavaTextArea.this.mouseListeners.length;
            int n2 = 0;
            while (n2 < n) {
                MouseListener ml = mouseListenerArray[n2];
                ml.mouseReleased(me);
                ++n2;
            }
        }

        @Override
        public void mouseEntered(MouseEvent me) {
            MouseListener[] mouseListenerArray = JavaTextArea.this.mouseListeners;
            int n = JavaTextArea.this.mouseListeners.length;
            int n2 = 0;
            while (n2 < n) {
                MouseListener ml = mouseListenerArray[n2];
                ml.mouseEntered(me);
                ++n2;
            }
        }

        @Override
        public void mouseExited(MouseEvent me) {
            MouseListener[] mouseListenerArray = JavaTextArea.this.mouseListeners;
            int n = JavaTextArea.this.mouseListeners.length;
            int n2 = 0;
            while (n2 < n) {
                MouseListener ml = mouseListenerArray[n2];
                ml.mouseExited(me);
                ++n2;
            }
        }

        @Override
        public void mouseDragged(MouseEvent me) {
        }

        @Override
        public void mouseMoved(MouseEvent me) {
            if (me.getX() < 44) {
                if (this.lastX >= 44) {
                    JavaTextArea.this.painter.setCursor(new Cursor(0));
                }
            } else if (this.lastX < 44) {
                JavaTextArea.this.painter.setCursor(new Cursor(2));
            }
            this.lastX = me.getX();
        }
    }
}

