/*
 * Decompiled with CFR 0.152.
 */
package processing.mode.java.pdex;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.TreeMap;
import org.eclipse.jdt.core.compiler.IProblem;
import org.eclipse.jdt.internal.compiler.problem.DefaultProblem;
import processing.app.Language;
import processing.core.PApplet;
import processing.data.StringList;
import processing.mode.java.pdex.Problem;

public class ErrorMessageSimplifier {
    private static TreeMap<Integer, String> constantsMap;

    public ErrorMessageSimplifier() {
        new Thread(){

            @Override
            public void run() {
                ErrorMessageSimplifier.prepareConstantsList();
            }
        }.start();
    }

    private static void prepareConstantsList() {
        Field[] f;
        constantsMap = new TreeMap();
        Class<DefaultProblem> probClass = DefaultProblem.class;
        Field[] fieldArray = f = probClass.getFields();
        int n = f.length;
        int n2 = 0;
        while (n2 < n) {
            block4: {
                Field field = fieldArray[n2];
                if (Modifier.isStatic(field.getModifiers())) {
                    try {
                        Object val = field.get(null);
                        if (!(val instanceof Integer)) break block4;
                        constantsMap.put((Integer)val, field.getName());
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        break;
                    }
                }
            }
            ++n2;
        }
    }

    public static String getIDName(int id) {
        if (constantsMap == null) {
            ErrorMessageSimplifier.prepareConstantsList();
        }
        return constantsMap.get(id);
    }

    public static String getSimplifiedErrorMessage(Problem problem) {
        if (problem == null) {
            return null;
        }
        IProblem iprob = problem.getIProblem();
        String[] args = iprob.getArguments();
        String result = null;
        switch (iprob.getID()) {
            case 0x600000CC: {
                if (args.length <= 0) break;
                result = Language.interpolate((String)"editor.status.error_on", (Object[])new Object[]{args[0]});
                break;
            }
            case 1610612968: {
                if (args.length <= 0) break;
                result = Language.interpolate((String)"editor.status.error_on", (Object[])new Object[]{args[0]});
                break;
            }
            case 0x600000F0: {
                if (args.length <= 0) break;
                if (args[0].length() == 1) {
                    result = ErrorMessageSimplifier.getErrorMessageForBracket(args[0].charAt(0));
                    break;
                }
                if (args[0].equals("AssignmentOperator Expression")) {
                    result = Language.interpolate((String)"editor.status.missing.add", (Object[])new Object[]{"="});
                    break;
                }
                if (args[0].equalsIgnoreCase(") Statement")) {
                    result = ErrorMessageSimplifier.getErrorMessageForBracket(args[0].charAt(0));
                    break;
                }
                result = Language.interpolate((String)"editor.status.error_on", (Object[])new Object[]{args[0]});
                break;
            }
            case 1610612971: {
                if (args.length <= 0) break;
                if (args[1].equals("VariableDeclaratorId")) {
                    if (args[0].equals("int")) {
                        result = Language.text((String)"editor.status.reserved_words");
                        break;
                    }
                    result = Language.interpolate((String)"editor.status.error_on", (Object[])new Object[]{args[0]});
                    break;
                }
                result = Language.interpolate((String)"editor.status.error_on", (Object[])new Object[]{args[0]});
                break;
            }
            case 1610612967: {
                if (args.length <= 0) break;
                if (args[1].length() == 1) {
                    result = ErrorMessageSimplifier.getErrorMessageForBracket(args[1].charAt(0));
                    break;
                }
                if (args[1].equalsIgnoreCase("Statement")) {
                    result = Language.interpolate((String)"editor.status.error_on", (Object[])new Object[]{args[0]});
                    break;
                }
                result = String.valueOf(Language.interpolate((String)"editor.status.error_on", (Object[])new Object[]{args[0]})) + " " + Language.interpolate((String)"editor.status.missing.add", (Object[])new Object[]{args[1]});
                break;
            }
            case 0x8000082: {
                if (args.length != 2) break;
                String constructorName = args[0];
                if (constructorName.contains(".")) {
                    constructorName = constructorName.substring(constructorName.indexOf(46) + 1);
                    constructorName = constructorName.substring(constructorName.indexOf(46) + 1);
                }
                String constructorArgs = ErrorMessageSimplifier.removePackagePrefixes(args[args.length - 1]);
                result = Language.interpolate((String)"editor.status.undefined_constructor", (Object[])new Object[]{constructorName, constructorArgs});
                break;
            }
            case 0x4000064: {
                if (args.length <= 2) break;
                String methodName = args[args.length - 2];
                String methodArgs = ErrorMessageSimplifier.removePackagePrefixes(args[args.length - 1]);
                result = Language.interpolate((String)"editor.status.undefined_method", (Object[])new Object[]{methodName, methodArgs});
                break;
            }
            case 67108979: {
                if (args.length <= 3) break;
                if (args[2].trim().length() == 0) {
                    result = Language.interpolate((String)"editor.status.empty_param", (Object[])new Object[]{args[1]});
                    break;
                }
                result = Language.interpolate((String)"editor.status.wrong_param", (Object[])new Object[]{args[1], args[1], ErrorMessageSimplifier.removePackagePrefixes(args[2])});
                break;
            }
            case 33554502: {
                if (args.length <= 0) break;
                result = Language.interpolate((String)"editor.status.undef_global_var", (Object[])new Object[]{args[0]});
                break;
            }
            case 0x1000002: {
                if (args.length <= 0) break;
                result = Language.interpolate((String)"editor.status.undef_class", (Object[])new Object[]{args[0]});
                break;
            }
            case 33554515: {
                if (args.length <= 0) break;
                result = Language.interpolate((String)"editor.status.undef_var", (Object[])new Object[]{args[0]});
                break;
            }
            case 0x22000032: {
                if (args.length <= 0) break;
                result = Language.interpolate((String)"editor.status.undef_name", (Object[])new Object[]{args[0]});
                break;
            }
            case 0x1000011: {
                if (args.length <= 1) break;
                result = Language.interpolate((String)"editor.status.type_mismatch", (Object[])new Object[]{args[0], args[1]});
                break;
            }
            case 536870973: {
                if (args.length <= 0) break;
                result = Language.interpolate((String)"editor.status.unused_variable", (Object[])new Object[]{args[0]});
                break;
            }
            case 0x20000033: {
                if (args.length <= 0) break;
                result = Language.interpolate((String)"editor.status.uninitialized_variable", (Object[])new Object[]{args[0]});
                break;
            }
            case 0x200000B2: {
                if (args.length <= 0) break;
                result = Language.interpolate((String)"editor.status.no_effect_assignment", (Object[])new Object[]{args[0]});
            }
        }
        return result == null ? problem.getMessage() : result;
    }

    private static String removePackagePrefixes(String input) {
        if (!input.contains(".")) {
            return input;
        }
        String[] names = PApplet.split((String)input, (char)',');
        StringList result = new StringList();
        String[] stringArray = names;
        int n = names.length;
        int n2 = 0;
        while (n2 < n) {
            String name = stringArray[n2];
            int dot = name.lastIndexOf(46);
            if (dot >= 0) {
                name = name.substring(dot + 1, name.length());
            }
            result.append(name);
            ++n2;
        }
        return result.join(", ");
    }

    private static String getErrorMessageForBracket(char c) {
        switch (c) {
            case ';': {
                return Language.text((String)"editor.status.missing.semicolon");
            }
            case '[': {
                return Language.text((String)"editor.status.missing.left_sq_bracket");
            }
            case ']': {
                return Language.text((String)"editor.status.missing.right_sq_bracket");
            }
            case '(': {
                return Language.text((String)"editor.status.missing.left_paren");
            }
            case ')': {
                return Language.text((String)"editor.status.missing.right_paren");
            }
            case '{': {
                return Language.text((String)"editor.status.missing.left_curly_bracket");
            }
            case '}': {
                return Language.text((String)"editor.status.missing.right_curly_bracket");
            }
        }
        return Language.interpolate((String)"editor.status.missing.default", (Object[])new Object[]{Character.valueOf(c)});
    }
}

