/*
 * Decompiled with CFR 0.152.
 */
package processing.mode.java.pdex;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.List;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.StructuralPropertyDescriptor;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import processing.mode.java.pdex.ASTGenerator;

public class CompletionCandidate
implements Comparable<CompletionCandidate> {
    private final String elementName;
    private final String label;
    private final String completionString;
    private final Object wrappedObject;
    private final int type;
    static final int PREDEF_CLASS = 0;
    static final int PREDEF_FIELD = 1;
    static final int PREDEF_METHOD = 2;
    static final int LOCAL_CLASS = 3;
    static final int LOCAL_METHOD = 4;
    static final int LOCAL_FIELD = 5;
    static final int LOCAL_VAR = 6;

    public CompletionCandidate(Method method) {
        method.getDeclaringClass().getName();
        this.elementName = method.getName();
        StringBuilder label = new StringBuilder("<html>" + method.getName() + "(");
        StringBuilder cstr = new StringBuilder(String.valueOf(method.getName()) + "(");
        int i = 0;
        while (i < method.getParameterTypes().length) {
            label.append(method.getParameterTypes()[i].getSimpleName());
            if (i < method.getParameterTypes().length - 1) {
                label.append(",");
                cstr.append(",");
            }
            ++i;
        }
        if (method.getParameterTypes().length == 1) {
            cstr.append(' ');
        }
        label.append(")");
        if (method.getReturnType() != null) {
            label.append(" : " + method.getReturnType().getSimpleName());
        }
        label.append(" - <font color=#777777>" + method.getDeclaringClass().getSimpleName() + "</font></html>");
        cstr.append(")");
        this.label = label.toString();
        this.completionString = cstr.toString();
        this.type = 2;
        this.wrappedObject = method;
    }

    public Object getWrappedObject() {
        return this.wrappedObject;
    }

    public CompletionCandidate(SingleVariableDeclaration svd) {
        this.completionString = svd.getName().toString();
        this.elementName = svd.getName().toString();
        this.type = svd.getParent() instanceof FieldDeclaration ? 5 : 6;
        this.label = svd.getName() + " : " + svd.getType();
        this.wrappedObject = svd;
    }

    public CompletionCandidate(VariableDeclarationFragment vdf) {
        this.completionString = vdf.getName().toString();
        this.elementName = vdf.getName().toString();
        this.type = vdf.getParent() instanceof FieldDeclaration ? 5 : 6;
        this.label = vdf.getName() + " : " + ASTGenerator.extracTypeInfo2((ASTNode)vdf);
        this.wrappedObject = vdf;
    }

    public CompletionCandidate(MethodDeclaration method) {
        this.elementName = method.getName().toString();
        this.type = 4;
        List params = (List)method.getStructuralProperty((StructuralPropertyDescriptor)MethodDeclaration.PARAMETERS_PROPERTY);
        StringBuilder label = new StringBuilder(String.valueOf(this.elementName) + "(");
        StringBuilder cstr = new StringBuilder(method.getName() + "(");
        int i = 0;
        while (i < params.size()) {
            label.append(((ASTNode)params.get(i)).toString());
            if (i < params.size() - 1) {
                label.append(",");
                cstr.append(",");
            }
            ++i;
        }
        if (params.size() == 1) {
            cstr.append(' ');
        }
        label.append(")");
        if (method.getReturnType2() != null) {
            label.append(" : " + method.getReturnType2());
        }
        cstr.append(")");
        this.label = label.toString();
        this.completionString = cstr.toString();
        this.wrappedObject = method;
    }

    public CompletionCandidate(TypeDeclaration td) {
        this.type = 3;
        this.label = this.elementName = td.getName().toString();
        this.completionString = this.elementName;
        this.wrappedObject = td;
    }

    public CompletionCandidate(Field f) {
        f.getDeclaringClass().getName();
        this.elementName = f.getName();
        this.type = 1;
        this.label = "<html>" + f.getName() + " : " + f.getType().getSimpleName() + " - <font color=#777777>" + f.getDeclaringClass().getSimpleName() + "</font></html>";
        this.completionString = this.elementName;
        this.wrappedObject = f;
    }

    public CompletionCandidate(String name, String labelStr, String completionStr, int type) {
        this.elementName = name;
        this.label = labelStr;
        this.completionString = completionStr;
        this.type = type;
        this.wrappedObject = null;
    }

    public CompletionCandidate(String name, int type) {
        this.elementName = name;
        this.label = name;
        this.completionString = name;
        this.type = type;
        this.wrappedObject = null;
    }

    private CompletionCandidate(String elementName, String label, String completionString, int type, Object wrappedObject) {
        this.elementName = elementName;
        this.label = label;
        this.completionString = completionString;
        this.type = type;
        this.wrappedObject = wrappedObject;
    }

    public String getElementName() {
        return this.elementName;
    }

    public String getCompletionString() {
        return this.completionString;
    }

    public String toString() {
        return this.label;
    }

    public int getType() {
        return this.type;
    }

    public String getLabel() {
        return this.label;
    }

    public String getNoHtmlLabel() {
        if (!this.label.contains("<html>")) {
            return this.label;
        }
        StringBuilder ans = new StringBuilder(this.label);
        while (ans.indexOf("<") > -1) {
            int b;
            int a = ans.indexOf("<");
            if (a > (b = ans.indexOf(">"))) break;
            ans.replace(a, b + 1, "");
        }
        return ans.toString();
    }

    public CompletionCandidate withLabelAndCompString(String label, String completionString) {
        return new CompletionCandidate(this.elementName, label, completionString, this.type, this.wrappedObject);
    }

    @Override
    public int compareTo(CompletionCandidate cc) {
        if (this.type != cc.getType()) {
            return cc.getType() - this.type;
        }
        return this.elementName.compareTo(cc.getElementName());
    }

    public CompletionCandidate withRegeneratedCompString() {
        if (this.wrappedObject instanceof MethodDeclaration) {
            MethodDeclaration method = (MethodDeclaration)this.wrappedObject;
            List params = (List)method.getStructuralProperty((StructuralPropertyDescriptor)MethodDeclaration.PARAMETERS_PROPERTY);
            StringBuilder label = new StringBuilder(String.valueOf(this.elementName) + "(");
            StringBuilder cstr = new StringBuilder(method.getName() + "(");
            int i = 0;
            while (i < params.size()) {
                label.append(((ASTNode)params.get(i)).toString());
                if (i < params.size() - 1) {
                    label.append(",");
                    cstr.append(",");
                }
                ++i;
            }
            if (params.size() == 1) {
                cstr.append(' ');
            }
            label.append(")");
            if (method.getReturnType2() != null) {
                label.append(" : " + method.getReturnType2());
            }
            cstr.append(")");
            return this.withLabelAndCompString(label.toString(), cstr.toString());
        }
        if (this.wrappedObject instanceof Method) {
            Method method = (Method)this.wrappedObject;
            StringBuilder label = new StringBuilder("<html>" + method.getName() + "(");
            StringBuilder cstr = new StringBuilder(String.valueOf(method.getName()) + "(");
            int i = 0;
            while (i < method.getParameterTypes().length) {
                label.append(method.getParameterTypes()[i].getSimpleName());
                if (i < method.getParameterTypes().length - 1) {
                    label.append(",");
                    cstr.append(",");
                }
                ++i;
            }
            if (method.getParameterTypes().length == 1) {
                cstr.append(' ');
            }
            label.append(")");
            if (method.getReturnType() != null) {
                label.append(" : " + method.getReturnType().getSimpleName());
            }
            label.append(" - <font color=#777777>" + method.getDeclaringClass().getSimpleName() + "</font></html>");
            cstr.append(")");
            return this.withLabelAndCompString(label.toString(), cstr.toString());
        }
        return this;
    }
}

