/*
 * Decompiled with CFR 0.152.
 */
package processing.mode.java.pdex;

import com.google.classpath.ClassPath;
import com.google.classpath.ClassPathFactory;
import com.google.classpath.RegExpResourceFilter;
import com.google.classpath.ResourceFilter;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.regex.Pattern;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.SwingWorker;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Element;
import javax.swing.text.PlainDocument;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.ArrayAccess;
import org.eclipse.jdt.core.dom.ArrayType;
import org.eclipse.jdt.core.dom.Block;
import org.eclipse.jdt.core.dom.Comment;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.ExpressionStatement;
import org.eclipse.jdt.core.dom.FieldAccess;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.Modifier;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.ParameterizedType;
import org.eclipse.jdt.core.dom.PrimitiveType;
import org.eclipse.jdt.core.dom.QualifiedName;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SimpleType;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.StructuralPropertyDescriptor;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.dom.VariableDeclarationExpression;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jdt.core.dom.VariableDeclarationStatement;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.select.Elements;
import processing.app.Library;
import processing.app.Messages;
import processing.app.SketchCode;
import processing.app.Util;
import processing.app.syntax.JEditTextArea;
import processing.app.ui.Toolkit;
import processing.mode.java.JavaEditor;
import processing.mode.java.pdex.ASTNodeWrapper;
import processing.mode.java.pdex.CompletionCandidate;
import processing.mode.java.pdex.ErrorCheckerService;
import processing.mode.java.pdex.ImportStatement;
import processing.mode.java.pdex.JavaTextArea;
import processing.mode.java.pdex.OffsetMatcher;
import processing.mode.java.pdex.TabOutline;
import processing.mode.java.preproc.PdePreprocessor;

public class ASTGenerator {
    protected final ErrorCheckerService errorCheckerService;
    protected JavaEditor editor;
    public DefaultMutableTreeNode codeTree = new DefaultMutableTreeNode();
    protected JFrame frmASTView;
    protected JTree jtree;
    protected JTree refactorTree;
    protected CompilationUnit compilationUnit;
    protected JFrame frmRename;
    protected JButton btnRename;
    protected JButton btnListOccurrence;
    protected JTextField txtRenameField;
    protected JFrame frmOccurenceList;
    protected JLabel lblRefactorOldName;
    public static final boolean SHOW_AST = false;
    protected final ClassPathFactory factory = new ClassPathFactory();
    protected ClassPath classPath;
    protected TreeMap<String, String> jdocMap;
    protected List<CompletionCandidate> candidates;
    protected String lastPredictedPhrase = " ";
    protected String lastClickedWord = null;
    protected ASTNodeWrapper lastClickedWordNode = null;
    protected JFrame frmImportSuggest;
    private TreeSet<String> ignoredImportSuggestions;

    public ASTGenerator(ErrorCheckerService ecs) {
        this.errorCheckerService = ecs;
        this.editor = ecs.getEditor();
        this.setupGUI();
        this.addListeners();
    }

    protected void setupGUI() {
        this.frmASTView = new JFrame();
        this.jtree = new JTree();
        this.frmASTView.setDefaultCloseOperation(1);
        this.frmASTView.setBounds(new Rectangle(680, 100, 460, 620));
        this.frmASTView.setTitle("AST View - " + this.editor.getSketch().getName());
        JScrollPane sp = new JScrollPane();
        sp.setViewportView(this.jtree);
        this.frmASTView.add(sp);
        this.btnRename = new JButton("Rename");
        this.btnListOccurrence = new JButton("Show Usage");
        this.frmRename = new JFrame();
        this.frmRename.setDefaultCloseOperation(1);
        this.frmRename.setSize(250, 130);
        this.frmRename.setLayout(new BoxLayout(this.frmRename.getContentPane(), 1));
        Toolkit.setIcon((Frame)this.frmRename);
        JPanel panelTop = new JPanel();
        JPanel panelBottom = new JPanel();
        panelTop.setLayout(new BoxLayout(panelTop, 1));
        panelTop.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        panelBottom.setLayout(new BoxLayout(panelBottom, 0));
        panelBottom.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        panelBottom.add(Box.createHorizontalGlue());
        panelBottom.add(this.btnListOccurrence);
        panelBottom.add(Box.createRigidArea(new Dimension(15, 0)));
        panelBottom.add(this.btnRename);
        this.frmRename.setTitle("Enter new name:");
        this.txtRenameField = new JTextField();
        this.txtRenameField.setPreferredSize(new Dimension(150, 60));
        panelTop.add(this.txtRenameField);
        this.lblRefactorOldName = new JLabel();
        this.lblRefactorOldName.setText("Old Name: ");
        panelTop.add(Box.createRigidArea(new Dimension(0, 10)));
        panelTop.add(this.lblRefactorOldName);
        this.frmRename.add(panelTop);
        this.frmRename.add(panelBottom);
        this.frmRename.setMinimumSize(this.frmRename.getSize());
        this.frmRename.setLocation(this.editor.getX() + (this.editor.getWidth() - this.frmRename.getWidth()) / 2, this.editor.getY() + (this.editor.getHeight() - this.frmRename.getHeight()) / 2);
        this.frmOccurenceList = new JFrame();
        this.frmOccurenceList.setDefaultCloseOperation(1);
        this.frmOccurenceList.setSize(300, 400);
        Toolkit.setIcon((Frame)this.frmOccurenceList);
        JScrollPane sp2 = new JScrollPane();
        this.refactorTree = new JTree();
        sp2.setViewportView(this.refactorTree);
        this.frmOccurenceList.add(sp2);
    }

    protected DefaultMutableTreeNode buildAST(String source, CompilationUnit cu) {
        if (cu == null) {
            ASTParser parser = ASTParser.newParser((int)8);
            parser.setSource(source.toCharArray());
            parser.setKind(8);
            Hashtable options = JavaCore.getOptions();
            JavaCore.setComplianceOptions((String)"1.7", (Map)options);
            parser.setCompilerOptions((Map)options);
            this.compilationUnit = (CompilationUnit)parser.createAST(null);
        } else {
            this.compilationUnit = cu;
        }
        this.getCodeComments();
        this.codeTree = new DefaultMutableTreeNode(new ASTNodeWrapper((ASTNode)this.compilationUnit.types().get(0)));
        if (this.compilationUnit.types() == null || this.compilationUnit.types().isEmpty()) {
            Messages.loge((String)"No CU found!");
        }
        ASTGenerator.visitRecur((ASTNode)this.compilationUnit.types().get(0), this.codeTree);
        SwingWorker<Object, Object> worker = new SwingWorker<Object, Object>(){

            @Override
            protected Object doInBackground() throws Exception {
                return null;
            }

            @Override
            protected void done() {
                if (ASTGenerator.this.codeTree != null) {
                    // empty if block
                }
            }
        };
        worker.execute();
        return this.codeTree;
    }

    protected void loadJavaDoc() {
        this.jdocMap = new TreeMap();
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    ASTGenerator.loadJavaDoc(ASTGenerator.this.jdocMap, ASTGenerator.this.editor.getMode().getReferenceFolder());
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }).start();
    }

    static void loadJavaDoc(TreeMap<String, String> jdocMap, File referenceFolder) throws IOException {
        FileFilter fileFilter = new FileFilter(){

            @Override
            public boolean accept(File file) {
                if (!file.getName().endsWith("_.html")) {
                    return false;
                }
                int k = 0;
                int i = 0;
                while (i < file.getName().length()) {
                    if (file.getName().charAt(i) == '_') {
                        ++k;
                    }
                    if (k > 1) {
                        return false;
                    }
                    ++i;
                }
                return true;
            }
        };
        File[] fileArray = referenceFolder.listFiles(fileFilter);
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File docFile = fileArray[n2];
            Document doc = Jsoup.parse((File)docFile, null);
            Elements elm = doc.getElementsByClass("ref-item");
            String msg = "";
            String methodName = docFile.getName().substring(0, docFile.getName().indexOf(95));
            for (org.jsoup.nodes.Element ele : elm) {
                msg = "<html><body> <strong><div style=\"width: 300px; text-justification: justify;\"></strong><table cellpadding=\"0\" cellspacing=\"0\" border=\"0\" class=\"ref-item\">" + ele.html() + "</table></div></html></body></html>";
                msg = msg.replaceAll("img src=\"", "img src=\"" + referenceFolder.toURI().toURL().toString() + "/");
            }
            jdocMap.put(methodName, msg);
            ++n2;
        }
    }

    public static CompletionCandidate[] checkForTypes(ASTNode node) {
        List vdfs = null;
        switch (node.getNodeType()) {
            case 55: {
                return new CompletionCandidate[]{new CompletionCandidate((TypeDeclaration)node)};
            }
            case 31: {
                MethodDeclaration md = (MethodDeclaration)node;
                ASTGenerator.log(ASTGenerator.getNodeAsString((ASTNode)md));
                List params = (List)md.getStructuralProperty((StructuralPropertyDescriptor)MethodDeclaration.PARAMETERS_PROPERTY);
                CompletionCandidate[] cand = new CompletionCandidate[params.size() + 1];
                cand[0] = new CompletionCandidate(md);
                int i = 0;
                while (i < params.size()) {
                    cand[i + 1] = new CompletionCandidate((SingleVariableDeclaration)params.get(i));
                    ++i;
                }
                return cand;
            }
            case 44: {
                return new CompletionCandidate[]{new CompletionCandidate((SingleVariableDeclaration)node)};
            }
            case 23: {
                vdfs = ((FieldDeclaration)node).fragments();
                break;
            }
            case 60: {
                vdfs = ((VariableDeclarationStatement)node).fragments();
                break;
            }
            case 58: {
                vdfs = ((VariableDeclarationExpression)node).fragments();
                break;
            }
        }
        if (vdfs != null) {
            CompletionCandidate[] ret = new CompletionCandidate[vdfs.size()];
            int i = 0;
            for (VariableDeclarationFragment vdf : vdfs) {
                ret[i++] = new CompletionCandidate(vdf);
            }
            return ret;
        }
        return null;
    }

    public static ASTNode resolveExpression(ASTNode nearestNode, ASTNode expression, boolean noCompare) {
        ASTGenerator.log("Resolving " + ASTGenerator.getNodeAsString(expression) + " noComp " + noCompare);
        if (expression instanceof SimpleName) {
            return ASTGenerator.findDeclaration2((Name)((SimpleName)expression), nearestNode);
        }
        if (expression instanceof MethodInvocation) {
            ASTGenerator.log("3. Method Invo " + ((MethodInvocation)expression).getName());
            return ASTGenerator.findDeclaration2((Name)((MethodInvocation)expression).getName(), nearestNode);
        }
        if (expression instanceof FieldAccess) {
            ASTGenerator.log("2. Field access " + ASTGenerator.getNodeAsString((ASTNode)((FieldAccess)expression).getExpression()) + "|||" + ASTGenerator.getNodeAsString((ASTNode)((FieldAccess)expression).getName()));
            if (noCompare) {
                return ASTGenerator.findDeclaration2((Name)((FieldAccess)expression).getName(), nearestNode);
            }
            return ASTGenerator.resolveExpression(nearestNode, (ASTNode)((FieldAccess)expression).getExpression(), true);
        }
        if (expression instanceof QualifiedName) {
            ASTGenerator.log("1. Resolving " + ((QualifiedName)expression).getQualifier() + " ||| " + ((QualifiedName)expression).getName());
            if (noCompare) {
                return ASTGenerator.findDeclaration2((Name)((QualifiedName)expression).getName(), nearestNode);
            }
            return ASTGenerator.findDeclaration2(((QualifiedName)expression).getQualifier(), nearestNode);
        }
        return null;
    }

    public ClassMember resolveExpression3rdParty(ASTNode nearestNode, ASTNode astNode, boolean noCompare) {
        Class<?> tehClass;
        ASTGenerator.log("Resolve 3rdParty expr-- " + ASTGenerator.getNodeAsString(astNode) + " nearest node " + ASTGenerator.getNodeAsString(nearestNode));
        if (astNode == null) {
            return null;
        }
        if (astNode instanceof SimpleName) {
            ASTNode decl = ASTGenerator.findDeclaration2((Name)((SimpleName)astNode), nearestNode);
            if (decl != null) {
                ASTGenerator.log(String.valueOf(ASTGenerator.getNodeAsString(astNode)) + " found decl -> " + ASTGenerator.getNodeAsString(decl));
                if (decl.getNodeType() == 55) {
                    TypeDeclaration td = (TypeDeclaration)decl;
                    return new ClassMember((ASTNode)td);
                }
                Type type = ASTGenerator.extracTypeInfo2(decl);
                if (type != null && type.isArrayType() && astNode.getParent().getNodeType() != 2) {
                    Class<?> arrayClass;
                    Type elementType = ((ArrayType)type).getElementType();
                    String name = "";
                    if (elementType.isSimpleType()) {
                        Class<?> c = this.findClassIfExists(elementType.toString());
                        if (c != null) {
                            name = c.getName();
                        }
                    } else if (elementType.isPrimitiveType()) {
                        name = ((PrimitiveType)elementType).getPrimitiveTypeCode().toString();
                    }
                    return (arrayClass = this.getArrayClass(name)) == null ? null : new ClassMember(arrayClass);
                }
                return new ClassMember((ASTNode)ASTGenerator.extracTypeInfo(decl));
            }
            tehClass = this.findClassIfExists(astNode.toString());
            if (tehClass != null) {
                return new ClassMember(tehClass);
            }
            astNode = astNode.getParent();
        }
        switch (astNode.getNodeType()) {
            case 22: {
                ClassMember scopeParent;
                FieldAccess fa = (FieldAccess)astNode;
                if (fa.getExpression() == null) {
                    ASTGenerator.log("FA,Not implemented.");
                    return null;
                }
                if (fa.getExpression() instanceof SimpleName) {
                    SimpleType stp = ASTGenerator.extracTypeInfo(ASTGenerator.findDeclaration2((Name)((SimpleName)fa.getExpression()), nearestNode));
                    if (stp == null) {
                        tehClass = this.findClassIfExists(fa.getExpression().toString());
                        if (tehClass != null) {
                            return this.definedIn3rdPartyClass(new ClassMember(tehClass), fa.getName().toString());
                        }
                        ASTGenerator.log("FA resolve 3rd par, Can't resolve " + fa.getExpression());
                        return null;
                    }
                    ASTGenerator.log("FA, SN Type " + ASTGenerator.getNodeAsString((ASTNode)stp));
                    scopeParent = this.definedIn3rdPartyClass(stp.getName().toString(), "THIS");
                } else {
                    scopeParent = this.resolveExpression3rdParty(nearestNode, (ASTNode)fa.getExpression(), noCompare);
                }
                ASTGenerator.log("FA, ScopeParent " + scopeParent);
                return this.definedIn3rdPartyClass(scopeParent, fa.getName().toString());
            }
            case 32: {
                MethodInvocation mi = (MethodInvocation)astNode;
                ASTNode temp = ASTGenerator.findDeclaration2((Name)mi.getName(), nearestNode);
                if (temp instanceof MethodDeclaration) {
                    ASTGenerator.log(mi.getName() + " was found locally," + ASTGenerator.getNodeAsString((ASTNode)ASTGenerator.extracTypeInfo(temp)));
                    Type type = ASTGenerator.extracTypeInfo2(temp);
                    if (type != null && type.isArrayType() && astNode.getParent().getNodeType() != 2) {
                        Class<?> arrayClass;
                        Type elementType = ((ArrayType)type).getElementType();
                        String name = "";
                        if (elementType.isSimpleType()) {
                            Class<?> c = this.findClassIfExists(elementType.toString());
                            if (c != null) {
                                name = c.getName();
                            }
                        } else if (elementType.isPrimitiveType()) {
                            name = ((PrimitiveType)elementType).getPrimitiveTypeCode().toString();
                        }
                        return (arrayClass = this.getArrayClass(name)) == null ? null : new ClassMember(arrayClass);
                    }
                    return new ClassMember((ASTNode)ASTGenerator.extracTypeInfo(temp));
                }
                if (mi.getExpression() == null) {
                    ASTGenerator.log("MI,Not implemented.");
                    return null;
                }
                if (mi.getExpression() instanceof SimpleName) {
                    ASTNode decl = ASTGenerator.findDeclaration2((Name)((SimpleName)mi.getExpression()), nearestNode);
                    if (decl != null) {
                        if (decl.getNodeType() == 55) {
                            TypeDeclaration td = (TypeDeclaration)decl;
                            return new ClassMember((ASTNode)td);
                        }
                        SimpleType stp = ASTGenerator.extracTypeInfo(decl);
                        if (stp == null) {
                            Class<?> tehClass2 = this.findClassIfExists(mi.getExpression().toString());
                            if (tehClass2 != null) {
                                return this.definedIn3rdPartyClass(new ClassMember(tehClass2), mi.getName().toString());
                            }
                            ASTGenerator.log("MI resolve 3rd par, Can't resolve " + mi.getExpression());
                            return null;
                        }
                        ASTGenerator.log("MI, SN Type " + ASTGenerator.getNodeAsString((ASTNode)stp));
                        ASTNode typeDec = ASTGenerator.findDeclaration2(stp.getName(), nearestNode);
                        if (typeDec == null) {
                            ASTGenerator.log(stp.getName() + " couldn't be found locally..");
                            Class<?> tehClass3 = this.findClassIfExists(stp.getName().toString());
                            if (tehClass3 != null) {
                                return this.definedIn3rdPartyClass(new ClassMember(tehClass3), mi.getName().toString());
                            }
                        }
                        return this.definedIn3rdPartyClass(new ClassMember(typeDec), mi.getName().toString());
                    }
                } else {
                    ASTGenerator.log("MI EXP.." + ASTGenerator.getNodeAsString((ASTNode)mi.getExpression()));
                    ClassMember scopeParent = this.resolveExpression3rdParty(nearestNode, (ASTNode)mi.getExpression(), noCompare);
                    ASTGenerator.log("MI, ScopeParent " + scopeParent);
                    return this.definedIn3rdPartyClass(scopeParent, mi.getName().toString());
                }
            }
            case 40: {
                QualifiedName qn = (QualifiedName)astNode;
                ASTNode temp2 = ASTGenerator.findDeclaration2((Name)qn.getName(), nearestNode);
                if (temp2 instanceof FieldDeclaration) {
                    ASTGenerator.log(qn.getName() + " was found locally," + ASTGenerator.getNodeAsString((ASTNode)ASTGenerator.extracTypeInfo(temp2)));
                    return new ClassMember((ASTNode)ASTGenerator.extracTypeInfo(temp2));
                }
                if (qn.getQualifier() == null) {
                    ASTGenerator.log("QN,Not implemented.");
                    return null;
                }
                if (qn.getQualifier() instanceof SimpleName) {
                    SimpleType stp = ASTGenerator.extracTypeInfo(ASTGenerator.findDeclaration2(qn.getQualifier(), nearestNode));
                    if (stp == null) {
                        Class<?> tehClass4 = this.findClassIfExists(qn.getQualifier().toString());
                        if (tehClass4 != null) {
                            return this.definedIn3rdPartyClass(new ClassMember(tehClass4), qn.getName().toString());
                        }
                        ASTGenerator.log("QN resolve 3rd par, Can't resolve " + qn.getQualifier());
                        return null;
                    }
                    ASTGenerator.log("QN, SN Local Type " + ASTGenerator.getNodeAsString((ASTNode)stp));
                    ASTNode typeDec = ASTGenerator.findDeclaration2(stp.getName(), nearestNode);
                    if (typeDec == null) {
                        ASTGenerator.log(stp.getName() + " couldn't be found locally..");
                        Class<?> tehClass5 = this.findClassIfExists(stp.getName().toString());
                        if (tehClass5 != null) {
                            return this.definedIn3rdPartyClass(new ClassMember(tehClass5), qn.getName().toString());
                        }
                        ASTGenerator.log("QN resolve 3rd par, Can't resolve " + qn.getQualifier());
                        return null;
                    }
                    return this.definedIn3rdPartyClass(new ClassMember(typeDec), qn.getName().toString());
                }
                ClassMember scopeParent = this.resolveExpression3rdParty(nearestNode, (ASTNode)qn.getQualifier(), noCompare);
                ASTGenerator.log("QN, ScopeParent " + scopeParent);
                return this.definedIn3rdPartyClass(scopeParent, qn.getName().toString());
            }
            case 2: {
                ArrayAccess arac = (ArrayAccess)astNode;
                return this.resolveExpression3rdParty(nearestNode, (ASTNode)arac.getArray(), noCompare);
            }
        }
        ASTGenerator.log("Unaccounted type " + ASTGenerator.getNodeAsString(astNode));
        return null;
    }

    public Class<?> getArrayClass(String elementClass) {
        String name = elementClass.startsWith("[") ? "[" + elementClass : (elementClass.equals("boolean") ? "[Z" : (elementClass.equals("byte") ? "[B" : (elementClass.equals("char") ? "[C" : (elementClass.equals("double") ? "[D" : (elementClass.equals("float") ? "[F" : (elementClass.equals("int") ? "[I" : (elementClass.equals("long") ? "[J" : (elementClass.equals("short") ? "[S" : "[L" + elementClass + ";"))))))));
        return this.loadClass(name);
    }

    public static ASTNode getChildExpression(ASTNode expression) {
        if (expression instanceof SimpleName) {
            return expression;
        }
        if (expression instanceof FieldAccess) {
            return ((FieldAccess)expression).getName();
        }
        if (expression instanceof QualifiedName) {
            return ((QualifiedName)expression).getName();
        }
        if (expression instanceof MethodInvocation) {
            return ((MethodInvocation)expression).getName();
        }
        if (expression instanceof ArrayAccess) {
            return ((ArrayAccess)expression).getArray();
        }
        ASTGenerator.log(" getChildExpression returning NULL for " + ASTGenerator.getNodeAsString(expression));
        return null;
    }

    public static ASTNode getParentExpression(ASTNode expression) {
        if (expression instanceof SimpleName) {
            return expression;
        }
        if (expression instanceof FieldAccess) {
            return ((FieldAccess)expression).getExpression();
        }
        if (expression instanceof QualifiedName) {
            return ((QualifiedName)expression).getQualifier();
        }
        if (expression instanceof MethodInvocation) {
            return ((MethodInvocation)expression).getExpression();
        }
        if (expression instanceof ArrayAccess) {
            return ((ArrayAccess)expression).getArray();
        }
        ASTGenerator.log("getParentExpression returning NULL for " + ASTGenerator.getNodeAsString(expression));
        return null;
    }

    protected static List<CompletionCandidate> trimCandidates(String newWord, List<CompletionCandidate> candidates) {
        ArrayList<CompletionCandidate> newCandidate = new ArrayList<CompletionCandidate>();
        newWord = newWord.toLowerCase();
        for (CompletionCandidate comp : candidates) {
            if (!comp.getNoHtmlLabel().toLowerCase().startsWith(newWord)) continue;
            newCandidate.add(comp);
        }
        return newCandidate;
    }

    public List<CompletionCandidate> preparePredictions(String pdePhrase, int line) {
        ASTNode nearestNode;
        boolean incremental;
        ErrorCheckerService errorCheckerService = this.editor.getErrorChecker();
        ASTNode astRootNode = (ASTNode)errorCheckerService.getLatestCU().types().get(0);
        String phrase = ASTNodeWrapper.getJavaCode(pdePhrase);
        boolean noCompare = phrase.endsWith(".");
        if (noCompare) {
            phrase = phrase.substring(0, phrase.length() - 1);
        }
        boolean bl = incremental = !noCompare && phrase.length() > this.lastPredictedPhrase.length() && phrase.startsWith(this.lastPredictedPhrase);
        if (incremental) {
            ASTGenerator.log(String.valueOf(pdePhrase) + " starts with " + this.lastPredictedPhrase);
            ASTGenerator.log("Don't recalc");
            if (phrase.contains(".")) {
                int x = phrase.lastIndexOf(46);
                this.candidates = ASTGenerator.trimCandidates(phrase.substring(x + 1), this.candidates);
            } else {
                this.candidates = ASTGenerator.trimCandidates(phrase, this.candidates);
            }
            this.lastPredictedPhrase = phrase;
            return this.candidates;
        }
        int lineNumber = line;
        int codeIndex = this.editor.getSketch().getCodeIndex(this.editor.getCurrentTab());
        if (codeIndex > 0) {
            int i = 0;
            while (i < codeIndex) {
                SketchCode sc = this.editor.getSketch().getCode(i);
                int len = Util.countLines((String)sc.getProgram()) + 1;
                lineNumber += len;
                ++i;
            }
        }
        ASTParser parser = ASTParser.newParser((int)8);
        parser.setKind(1);
        parser.setSource(phrase.toCharArray());
        ASTNode testnode = parser.createAST(null);
        Messages.loge((String)("Typed: " + phrase + "|" + " temp Node type: " + testnode.getClass().getSimpleName()));
        if (testnode instanceof MethodInvocation) {
            MethodInvocation mi = (MethodInvocation)testnode;
            ASTGenerator.log(mi.getName() + "," + mi.getExpression() + "," + mi.typeArguments().size());
        }
        if ((nearestNode = ASTGenerator.findClosestNode(lineNumber, astRootNode)) == null) {
            nearestNode = astRootNode;
        }
        Messages.loge((String)(String.valueOf(lineNumber) + " Nearest ASTNode to PRED " + ASTGenerator.getNodeAsString(nearestNode)));
        this.candidates = new ArrayList<CompletionCandidate>();
        this.lastPredictedPhrase = phrase;
        if (testnode instanceof SimpleName && !noCompare) {
            Messages.loge((String)("One word expression " + ASTGenerator.getNodeAsString(testnode)));
            while (nearestNode != null) {
                TypeDeclaration td;
                if (nearestNode instanceof TypeDeclaration && (td = (TypeDeclaration)nearestNode).getStructuralProperty((StructuralPropertyDescriptor)TypeDeclaration.SUPERCLASS_TYPE_PROPERTY) != null) {
                    SimpleType st = (SimpleType)td.getStructuralProperty((StructuralPropertyDescriptor)TypeDeclaration.SUPERCLASS_TYPE_PROPERTY);
                    ASTGenerator.log("Superclass " + st.getName());
                    ArrayList<CompletionCandidate> tempCandidates = this.getMembersForType(st.getName().toString(), phrase, false, false);
                    Iterator iterator = tempCandidates.iterator();
                    while (iterator.hasNext()) {
                        CompletionCandidate can = (CompletionCandidate)iterator.next();
                        this.candidates.add(can);
                    }
                }
                List sprops = nearestNode.structuralPropertiesForType();
                for (StructuralPropertyDescriptor sprop : sprops) {
                    if (!sprop.isChildListProperty()) {
                        ASTNode cnode;
                        CompletionCandidate[] types;
                        if (!(nearestNode.getStructuralProperty(sprop) instanceof ASTNode) || (types = ASTGenerator.checkForTypes(cnode = (ASTNode)nearestNode.getStructuralProperty(sprop))) == null) continue;
                        CompletionCandidate[] completionCandidateArray = types;
                        int n = types.length;
                        int n2 = 0;
                        while (n2 < n) {
                            CompletionCandidate type = completionCandidateArray[n2];
                            if (type.getElementName().toLowerCase().startsWith(phrase.toLowerCase())) {
                                this.candidates.add(type);
                            }
                            ++n2;
                        }
                        continue;
                    }
                    List nodelist = (List)nearestNode.getStructuralProperty(sprop);
                    for (ASTNode clnode : nodelist) {
                        CompletionCandidate[] types = ASTGenerator.checkForTypes(clnode);
                        if (types == null) continue;
                        CompletionCandidate[] completionCandidateArray = types;
                        int n = types.length;
                        int n3 = 0;
                        while (n3 < n) {
                            CompletionCandidate type = completionCandidateArray[n3];
                            if (type.getElementName().toLowerCase().startsWith(phrase.toLowerCase())) {
                                this.candidates.add(type);
                            }
                            ++n3;
                        }
                    }
                }
                nearestNode = nearestNode.getParent();
            }
            ASTGenerator.log("Empty can. " + phrase);
            if (this.classPath != null) {
                ASTNode resources;
                ASTNode clnode;
                RegExpResourceFilter regExpResourceFilter = new RegExpResourceFilter(Pattern.compile(".*"), Pattern.compile(String.valueOf(phrase) + "[a-zA-Z_0-9]*.class", 2));
                clnode = resources = this.classPath.findResources("", (ResourceFilter)regExpResourceFilter);
                int nodelist = ((ASTNode)clnode).length;
                int cnode = 0;
                while (cnode < nodelist) {
                    Object matchedClass2 = clnode[cnode];
                    matchedClass2 = ((String)matchedClass2).replace('/', '.');
                    String matchedClass = ((String)matchedClass2).substring(0, ((String)matchedClass2).length() - 6);
                    int d = matchedClass.lastIndexOf(46);
                    if (!errorCheckerService.ignorableSuggestionImport(matchedClass)) {
                        matchedClass = matchedClass.substring(d + 1);
                        String html = "<html>" + matchedClass + " : <font color=#777777>" + ((String)matchedClass2).substring(0, d) + "</font></html>";
                        this.candidates.add(new CompletionCandidate(matchedClass, html, matchedClass, 0));
                    }
                    ++cnode;
                }
            }
        } else {
            ClassMember expr;
            Messages.loge((String)("Complex expression " + ASTGenerator.getNodeAsString(testnode)));
            ASTGenerator.log("candidates empty");
            ASTNode childExpr = ASTGenerator.getChildExpression(testnode);
            ASTGenerator.log("Parent expression : " + ASTGenerator.getParentExpression(testnode));
            ASTGenerator.log("Child expression : " + childExpr);
            if (!noCompare) {
                ASTGenerator.log("Original testnode " + ASTGenerator.getNodeAsString(testnode));
                testnode = ASTGenerator.getParentExpression(testnode);
                ASTGenerator.log("Corrected testnode " + ASTGenerator.getNodeAsString(testnode));
            }
            if ((expr = this.resolveExpression3rdParty(nearestNode, testnode, noCompare)) == null) {
                ASTGenerator.log("Expr is null");
            } else {
                boolean isArray = expr.thisclass != null && expr.thisclass.isArray();
                boolean isSimpleType = expr.astNode != null && expr.astNode.getNodeType() == 43;
                boolean isMethod = expr.method != null;
                boolean staticOnly = !isMethod && !isArray && !isSimpleType;
                ASTGenerator.log("Expr is " + expr.toString());
                String lookFor = noCompare || childExpr == null ? "" : childExpr.toString();
                this.candidates = this.getMembersForType(expr, lookFor, noCompare, staticOnly);
            }
        }
        return this.candidates;
    }

    protected static DefaultListModel<CompletionCandidate> filterPredictions(List<CompletionCandidate> candidates) {
        DefaultListModel<CompletionCandidate> defListModel = new DefaultListModel<CompletionCandidate>();
        if (candidates.isEmpty()) {
            return defListModel;
        }
        if (candidates.get(0).getElementName().equals(candidates.get(candidates.size() - 1).getElementName())) {
            ASTGenerator.log("All CC are methods only: " + candidates.get(0).getElementName());
            int i = 0;
            while (i < candidates.size()) {
                CompletionCandidate cc = candidates.get(i).withRegeneratedCompString();
                candidates.set(i, cc);
                defListModel.addElement(cc);
                ++i;
            }
        } else {
            boolean ignoredSome = false;
            int i = 0;
            while (i < candidates.size()) {
                if (i > 0 && candidates.get(i).getElementName().equals(candidates.get(i - 1).getElementName()) && (candidates.get(i).getType() == 4 || candidates.get(i).getType() == 2)) {
                    CompletionCandidate cc = candidates.get(i - 1);
                    String label = cc.getLabel();
                    int x = label.lastIndexOf(41);
                    String newLabel = candidates.get(i).getType() == 2 ? String.valueOf(cc.getLabel().contains("<html>") ? "<html>" : "") + cc.getElementName() + "(...)" + label.substring(x + 1) : String.valueOf(cc.getElementName()) + "(...)" + label.substring(x + 1);
                    String newCompString = String.valueOf(cc.getElementName()) + "(";
                    candidates.set(i - 1, cc.withLabelAndCompString(newLabel, newCompString));
                    ignoredSome = true;
                } else {
                    defListModel.addElement(candidates.get(i));
                }
                ++i;
            }
            if (ignoredSome) {
                ASTGenerator.log("Some suggestions hidden");
            }
        }
        return defListModel;
    }

    public ArrayList<CompletionCandidate> getMembersForType(String typeName, String child, boolean noCompare, boolean staticOnly) {
        ArrayList<CompletionCandidate> candidates = new ArrayList<CompletionCandidate>();
        ASTGenerator.log("In GMFT(), Looking for match " + child + " in class " + typeName + " noCompare " + noCompare + " staticOnly " + staticOnly);
        Class<?> probableClass = this.findClassIfExists(typeName);
        if (probableClass == null) {
            ASTGenerator.log("In GMFT(), class not found.");
            return candidates;
        }
        return this.getMembersForType(new ClassMember(probableClass), child, noCompare, staticOnly);
    }

    public ArrayList<CompletionCandidate> getMembersForType(ClassMember tehClass, String childToLookFor, boolean noCompare, boolean staticOnly) {
        Class<?> probableClass;
        String child = childToLookFor.toLowerCase();
        ArrayList<CompletionCandidate> candidates = new ArrayList<CompletionCandidate>();
        ASTGenerator.log("getMemFoType-> Looking for match " + child + " inside " + tehClass + " noCompare " + noCompare + " staticOnly " + staticOnly);
        if (tehClass == null) {
            return candidates;
        }
        if (tehClass.getDeclaringNode() instanceof TypeDeclaration) {
            ArrayList<CompletionCandidate> superClassCandidates;
            FieldDeclaration[] fields;
            TypeDeclaration td = (TypeDeclaration)tehClass.getDeclaringNode();
            FieldDeclaration[] fieldDeclarationArray = fields = td.getFields();
            int n = fields.length;
            int n2 = 0;
            while (n2 < n) {
                FieldDeclaration field = fieldDeclarationArray[n2];
                if (!staticOnly || ASTGenerator.isStatic(field.modifiers())) {
                    List vdfs = field.fragments();
                    for (VariableDeclarationFragment vdf : vdfs) {
                        if (noCompare) {
                            candidates.add(new CompletionCandidate(vdf));
                            continue;
                        }
                        if (!vdf.getName().toString().toLowerCase().startsWith(child)) continue;
                        candidates.add(new CompletionCandidate(vdf));
                    }
                }
                ++n2;
            }
            MethodDeclaration[] methods = td.getMethods();
            fieldDeclarationArray = methods;
            n = methods.length;
            n2 = 0;
            while (n2 < n) {
                FieldDeclaration method = fieldDeclarationArray[n2];
                if (!staticOnly || ASTGenerator.isStatic(method.modifiers())) {
                    if (noCompare) {
                        candidates.add(new CompletionCandidate((MethodDeclaration)method));
                    } else if (method.getName().toString().toLowerCase().startsWith(child)) {
                        candidates.add(new CompletionCandidate((MethodDeclaration)method));
                    }
                }
                ++n2;
            }
            if (td.getSuperclassType() != null) {
                ASTGenerator.log(String.valueOf(ASTGenerator.getNodeAsString((ASTNode)td.getSuperclassType())) + " <-Looking into superclass of " + tehClass);
                superClassCandidates = this.getMembersForType(new ClassMember((ASTNode)td.getSuperclassType()), childToLookFor, noCompare, staticOnly);
            } else {
                superClassCandidates = this.getMembersForType(new ClassMember(Object.class), childToLookFor, noCompare, staticOnly);
            }
            for (CompletionCandidate cc : superClassCandidates) {
                candidates.add(cc);
            }
            return candidates;
        }
        if (tehClass.getClass_() != null) {
            probableClass = tehClass.getClass_();
        } else {
            probableClass = this.findClassIfExists(tehClass.getTypeAsString());
            if (probableClass == null) {
                ASTGenerator.log("Couldn't find class " + tehClass.getTypeAsString());
                return candidates;
            }
            ASTGenerator.log("Loaded " + probableClass.toString());
        }
        AccessibleObject[] accessibleObjectArray = probableClass.getMethods();
        int n = accessibleObjectArray.length;
        int cc = 0;
        while (cc < n) {
            Method method = accessibleObjectArray[cc];
            if (java.lang.reflect.Modifier.isStatic(method.getModifiers()) || !staticOnly) {
                StringBuilder label = new StringBuilder(String.valueOf(method.getName()) + "(");
                int i = 0;
                while (i < method.getParameterTypes().length) {
                    label.append(method.getParameterTypes()[i].getSimpleName());
                    if (i < method.getParameterTypes().length - 1) {
                        label.append(",");
                    }
                    ++i;
                }
                label.append(")");
                if (noCompare) {
                    candidates.add(new CompletionCandidate(method));
                } else if (label.toString().toLowerCase().startsWith(child)) {
                    candidates.add(new CompletionCandidate(method));
                }
            }
            ++cc;
        }
        accessibleObjectArray = probableClass.getFields();
        n = accessibleObjectArray.length;
        cc = 0;
        while (cc < n) {
            AccessibleObject field = accessibleObjectArray[cc];
            if (java.lang.reflect.Modifier.isStatic(((Field)field).getModifiers()) || !staticOnly) {
                if (noCompare) {
                    candidates.add(new CompletionCandidate((Field)field));
                } else if (((Field)field).getName().toLowerCase().startsWith(child)) {
                    candidates.add(new CompletionCandidate((Field)field));
                }
            }
            ++cc;
        }
        if (probableClass.isArray() && !staticOnly) {
            String className = probableClass.getSimpleName();
            if (noCompare || "clone()".startsWith(child)) {
                String methodLabel = "<html>clone() : " + className + " - <font color=#777777>" + className + "</font></html>";
                candidates.add(new CompletionCandidate("clone()", methodLabel, "clone()", 2));
            }
            if ("length".startsWith(child)) {
                String fieldLabel = "<html>length : int - <font color=#777777>" + className + "</font></html>";
                candidates.add(new CompletionCandidate("length", fieldLabel, "length", 1));
            }
        }
        return candidates;
    }

    private static boolean isStatic(List<Modifier> modifiers) {
        for (Modifier m : modifiers) {
            if (!m.isStatic()) continue;
            return true;
        }
        return false;
    }

    public String getPDESourceCodeLine(int javaLineNumber) {
        int[] res = this.errorCheckerService.calculateTabIndexAndLineNumber(javaLineNumber);
        if (res != null) {
            return this.errorCheckerService.getPdeCodeAtLine(res[0], res[1]);
        }
        return null;
    }

    public String getJavaSourceCodeLine(int javaLineNumber) {
        Element lineElement;
        PlainDocument javaSource;
        block3: {
            try {
                javaSource = new PlainDocument();
                javaSource.insertString(0, this.errorCheckerService.lastCodeCheckResult.sourceCode, null);
                lineElement = javaSource.getDefaultRootElement().getElement(javaLineNumber - 1);
                if (lineElement != null) break block3;
                ASTGenerator.log("Couldn't fetch jlinenum " + javaLineNumber);
                return null;
            }
            catch (BadLocationException e) {
                Messages.loge((String)(e + " in getJavaSourceCodeline() for jinenum: " + javaLineNumber));
                return null;
            }
        }
        String javaLine = javaSource.getText(lineElement.getStartOffset(), lineElement.getEndOffset() - lineElement.getStartOffset());
        return javaLine;
    }

    public Element getJavaSourceCodeElement(int javaLineNumber) {
        Element lineElement;
        block3: {
            try {
                PlainDocument javaSource = new PlainDocument();
                javaSource.insertString(0, this.errorCheckerService.lastCodeCheckResult.sourceCode, null);
                lineElement = javaSource.getDefaultRootElement().getElement(javaLineNumber - 1);
                if (lineElement != null) break block3;
                ASTGenerator.log("Couldn't fetch jlinenum " + javaLineNumber);
                return null;
            }
            catch (BadLocationException e) {
                Messages.loge((String)(e + " in getJavaSourceCodeline() for jinenum: " + javaLineNumber));
                return null;
            }
        }
        return lineElement;
    }

    protected Class<?> findClassIfExists(String className) {
        String impS;
        String temp;
        if (className == null) {
            return null;
        }
        Class<?> tehClass = this.loadClass(className);
        if (tehClass != null) {
            return tehClass;
        }
        ASTGenerator.log("Looking in the classloader for " + className);
        ArrayList<ImportStatement> imports = this.errorCheckerService.getProgramImports();
        for (ImportStatement impS2 : imports) {
            temp = impS2.getPackageName();
            if (impS2.isStarredImport() && className.indexOf(46) == -1) {
                temp = String.valueOf(impS2.getPackageName()) + "." + className;
            }
            if ((tehClass = this.loadClass(temp)) == null) continue;
            ASTGenerator.log(String.valueOf(tehClass.getName()) + " located.");
            return tehClass;
        }
        for (ImportStatement impS2 : this.errorCheckerService.codeFolderImports) {
            temp = impS2.getPackageName();
            if (impS2.isStarredImport() && className.indexOf(46) == -1) {
                temp = String.valueOf(impS2.getPackageName()) + "." + className;
            }
            if ((tehClass = this.loadClass(temp)) == null) continue;
            ASTGenerator.log(String.valueOf(tehClass.getName()) + " located.");
            return tehClass;
        }
        PdePreprocessor p = new PdePreprocessor(null);
        String[] stringArray = p.getCoreImports();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            impS = stringArray[n2];
            tehClass = this.loadClass(String.valueOf(impS.substring(0, impS.length() - 1)) + className);
            if (tehClass != null) {
                ASTGenerator.log(String.valueOf(tehClass.getName()) + " located.");
                return tehClass;
            }
            ++n2;
        }
        stringArray = p.getDefaultImports();
        n = stringArray.length;
        n2 = 0;
        while (n2 < n) {
            impS = stringArray[n2];
            if ((className.equals(impS) || impS.endsWith(className)) && (tehClass = this.loadClass(impS)) != null) {
                ASTGenerator.log(String.valueOf(tehClass.getName()) + " located.");
                return tehClass;
            }
            ++n2;
        }
        String daddy = "java.lang." + className;
        tehClass = this.loadClass(daddy);
        if (tehClass != null) {
            ASTGenerator.log(String.valueOf(tehClass.getName()) + " located.");
            return tehClass;
        }
        return null;
    }

    protected Class<?> loadClass(String className) {
        Class<?> tehClass = null;
        if (className != null) {
            try {
                tehClass = Class.forName(className, false, this.errorCheckerService.getSketchClassLoader());
            }
            catch (ClassNotFoundException classNotFoundException) {}
        }
        return tehClass;
    }

    public ClassMember definedIn3rdPartyClass(String className, String memberName) {
        Class<?> probableClass = this.findClassIfExists(className);
        if (probableClass == null) {
            ASTGenerator.log("Couldn't load " + className);
            return null;
        }
        if (memberName.equals("THIS")) {
            return new ClassMember(probableClass);
        }
        return this.definedIn3rdPartyClass(new ClassMember(probableClass), memberName);
    }

    public ClassMember definedIn3rdPartyClass(ClassMember tehClass, String memberName) {
        Class<?> probableClass;
        if (tehClass == null) {
            return null;
        }
        ASTGenerator.log("definedIn3rdPartyClass-> Looking for " + memberName + " in " + tehClass);
        String memberNameL = memberName.toLowerCase();
        if (tehClass.getDeclaringNode() instanceof TypeDeclaration) {
            TypeDeclaration td = (TypeDeclaration)tehClass.getDeclaringNode();
            int i = 0;
            while (i < td.getFields().length) {
                List vdfs = td.getFields()[i].fragments();
                for (VariableDeclarationFragment vdf : vdfs) {
                    if (!vdf.getName().toString().toLowerCase().startsWith(memberNameL)) continue;
                    return new ClassMember((ASTNode)vdf);
                }
                ++i;
            }
            i = 0;
            while (i < td.getMethods().length) {
                if (td.getMethods()[i].getName().toString().toLowerCase().startsWith(memberNameL)) {
                    return new ClassMember((ASTNode)td.getMethods()[i]);
                }
                ++i;
            }
            if (td.getSuperclassType() != null) {
                ASTGenerator.log(String.valueOf(ASTGenerator.getNodeAsString((ASTNode)td.getSuperclassType())) + " <-Looking into superclass of " + tehClass);
                return this.definedIn3rdPartyClass(new ClassMember((ASTNode)td.getSuperclassType()), memberName);
            }
            return this.definedIn3rdPartyClass(new ClassMember(Object.class), memberName);
        }
        if (tehClass.getClass_() != null) {
            probableClass = tehClass.getClass_();
        } else {
            probableClass = this.findClassIfExists(tehClass.getTypeAsString());
            ASTGenerator.log("Loaded " + probableClass.toString());
        }
        AccessibleObject[] accessibleObjectArray = probableClass.getMethods();
        int n = accessibleObjectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Method method = accessibleObjectArray[n2];
            if (method.getName().equalsIgnoreCase(memberName)) {
                return new ClassMember(method);
            }
            ++n2;
        }
        accessibleObjectArray = probableClass.getFields();
        n = accessibleObjectArray.length;
        n2 = 0;
        while (n2 < n) {
            AccessibleObject field = accessibleObjectArray[n2];
            if (((Field)field).getName().equalsIgnoreCase(memberName)) {
                return new ClassMember((Field)field);
            }
            ++n2;
        }
        return null;
    }

    public void updateJavaDoc(CompletionCandidate candidate) {
    }

    protected static ASTNode findClosestParentNode(int lineNumber, ASTNode node) {
        for (StructuralPropertyDescriptor prop : node.structuralPropertiesForType()) {
            if (prop.isChildProperty() || prop.isSimpleProperty()) {
                if (node.getStructuralProperty(prop) == null || !(node.getStructuralProperty(prop) instanceof ASTNode)) continue;
                ASTNode cnode = (ASTNode)node.getStructuralProperty(prop);
                int cLineNum = ((CompilationUnit)cnode.getRoot()).getLineNumber(cnode.getStartPosition() + cnode.getLength());
                if (ASTGenerator.getLineNumber(cnode) > lineNumber || lineNumber > cLineNum) continue;
                return ASTGenerator.findClosestParentNode(lineNumber, cnode);
            }
            if (!prop.isChildListProperty()) continue;
            List nodelist = (List)node.getStructuralProperty(prop);
            for (ASTNode cnode : nodelist) {
                int cLineNum = ((CompilationUnit)cnode.getRoot()).getLineNumber(cnode.getStartPosition() + cnode.getLength());
                if (ASTGenerator.getLineNumber(cnode) > lineNumber || lineNumber > cLineNum) continue;
                return ASTGenerator.findClosestParentNode(lineNumber, cnode);
            }
        }
        return node;
    }

    protected static ASTNode findClosestNode(int lineNumber, ASTNode node) {
        List nodes;
        ASTGenerator.log("findClosestNode to line " + lineNumber);
        ASTNode parent = ASTGenerator.findClosestParentNode(lineNumber, node);
        ASTGenerator.log("findClosestParentNode returned " + ASTGenerator.getNodeAsString(parent));
        if (parent == null) {
            return null;
        }
        if (ASTGenerator.getLineNumber(parent) == lineNumber) {
            ASTGenerator.log(parent + "|PNode " + ASTGenerator.getLineNumber(parent) + ", lfor " + lineNumber);
            return parent;
        }
        if (parent instanceof TypeDeclaration) {
            nodes = ((TypeDeclaration)parent).bodyDeclarations();
        } else if (parent instanceof Block) {
            nodes = ((Block)parent).statements();
        } else {
            ASTGenerator.log("findClosestNode() found " + ASTGenerator.getNodeAsString(parent));
            return null;
        }
        if (nodes.size() > 0) {
            ASTNode retNode = parent;
            for (ASTNode cNode : nodes) {
                ASTGenerator.log(cNode + "|cNode " + ASTGenerator.getLineNumber(cNode) + ", lfor " + lineNumber);
                if (ASTGenerator.getLineNumber(cNode) > lineNumber) continue;
                retNode = cNode;
            }
            return retNode;
        }
        return parent;
    }

    public DefaultMutableTreeNode getAST() {
        return this.codeTree;
    }

    public String getLabelForASTNode(int lineNumber, String name, int offset) {
        return this.getASTNodeAt(lineNumber, name, offset, false).getLabel();
    }

    protected String getLabelIfType(ASTNodeWrapper node, SimpleName sn) {
        ASTNode current = node.getNode().getParent();
        String type = "";
        StringBuilder fullName = new StringBuilder();
        Stack<String> parents = new Stack<String>();
        String simpleName = sn == null ? node.getNode().toString() : sn.toString();
        switch (node.getNodeType()) {
            case 23: 
            case 31: 
            case 55: {
                while (current != null) {
                    if (current instanceof TypeDeclaration) {
                        parents.push(((TypeDeclaration)current).getName().toString());
                    }
                    current = current.getParent();
                }
                while (parents.size() > 0) {
                    fullName.append((String)parents.pop()).append(".");
                }
                fullName.append(simpleName);
                if (node.getNode() instanceof MethodDeclaration) {
                    MethodDeclaration md = (MethodDeclaration)node.getNode();
                    if (!md.isConstructor()) {
                        type = md.getReturnType2().toString();
                    }
                    fullName.append('(');
                    if (!md.parameters().isEmpty()) {
                        List params = md.parameters();
                        for (ASTNode par : params) {
                            if (!(par instanceof SingleVariableDeclaration)) continue;
                            SingleVariableDeclaration svd = (SingleVariableDeclaration)par;
                            fullName.append(svd.getType()).append(" ").append(svd.getName()).append(",");
                        }
                    }
                    if (fullName.charAt(fullName.length() - 1) == ',') {
                        fullName.deleteCharAt(fullName.length() - 1);
                    }
                    fullName.append(')');
                } else if (node.getNode() instanceof FieldDeclaration) {
                    type = ((FieldDeclaration)node.getNode()).getType().toString();
                }
                int x = fullName.indexOf(".");
                fullName.delete(0, x + 1);
                return String.valueOf(type) + " " + fullName;
            }
            case 44: {
                SingleVariableDeclaration svd = (SingleVariableDeclaration)node.getNode();
                return svd.getType() + " " + svd.getName();
            }
            case 60: {
                return ((VariableDeclarationStatement)node.getNode()).getType() + " " + simpleName;
            }
            case 58: {
                return ((VariableDeclarationExpression)node.getNode()).getType() + " " + simpleName;
            }
        }
        return "";
    }

    public void scrollToDeclaration(int lineNumber, String name, int offset) {
        this.getASTNodeAt(lineNumber, name, offset, true);
    }

    public ASTNodeWrapper getASTNodeAt(int lineNumber, String name, int offset, boolean scrollOnly) {
        ASTNode simpName2;
        ASTNodeWrapper declWrap;
        int pdeLineNumber = lineNumber + this.errorCheckerService.mainClassOffset;
        this.editor = this.errorCheckerService.getEditor();
        int codeIndex = this.editor.getSketch().getCodeIndex(this.editor.getCurrentTab());
        if (codeIndex > 0) {
            int i = 0;
            while (i < codeIndex) {
                SketchCode sc = this.editor.getSketch().getCode(i);
                int len = Util.countLines((String)sc.getProgram()) + 1;
                pdeLineNumber += len;
                ++i;
            }
        }
        ASTNode lineNode = ASTGenerator.findLineOfNode((ASTNode)this.compilationUnit, pdeLineNumber, offset, name);
        ASTNode decl = null;
        String nodeLabel = null;
        String nameOfNode = null;
        if (lineNode != null) {
            String pdeCodeLine = this.errorCheckerService.getPdeCodeAtLine(this.editor.getSketch().getCurrentCodeIndex(), lineNumber);
            String javaCodeLine = this.getJavaSourceCodeLine(pdeLineNumber);
            OffsetMatcher ofm = new OffsetMatcher(pdeCodeLine, javaCodeLine);
            int javaOffset = ofm.getJavaOffForPdeOff(offset, name.length()) + lineNode.getStartPosition();
            ASTNode simpName = this.dfsLookForASTNode((ASTNode)this.errorCheckerService.getLatestCU(), name, javaOffset, javaOffset + name.length());
            if (simpName == null && lineNode instanceof SimpleName) {
                switch (lineNode.getParent().getNodeType()) {
                    case 23: 
                    case 31: 
                    case 55: 
                    case 59: {
                        decl = lineNode.getParent();
                        return new ASTNodeWrapper(decl, "");
                    }
                }
            }
            if (simpName instanceof SimpleName) {
                nameOfNode = simpName.toString();
                decl = ASTGenerator.findDeclaration((Name)((SimpleName)simpName));
                if (decl != null) {
                    nodeLabel = this.getLabelIfType(new ASTNodeWrapper(decl), (SimpleName)simpName);
                } else if (scrollOnly) {
                    this.editor.statusMessage(simpName + " is not defined in this sketch", 1);
                }
            }
        }
        if (decl != null && scrollOnly && !(declWrap = new ASTNodeWrapper(simpName2 = ASTGenerator.getNodeName(decl, nameOfNode), nodeLabel)).highlightNode(this.editor)) {
            Messages.loge((String)"Highlighting failed.");
        }
        return new ASTNodeWrapper(decl, nodeLabel);
    }

    protected static ASTNode getNodeName(ASTNode node, String name) {
        List vdfs = null;
        switch (node.getNodeType()) {
            case 55: {
                return ((TypeDeclaration)node).getName();
            }
            case 31: {
                return ((MethodDeclaration)node).getName();
            }
            case 44: {
                return ((SingleVariableDeclaration)node).getName();
            }
            case 23: {
                vdfs = ((FieldDeclaration)node).fragments();
                break;
            }
            case 60: {
                vdfs = ((VariableDeclarationStatement)node).fragments();
                break;
            }
            case 58: {
                vdfs = ((VariableDeclarationExpression)node).fragments();
                break;
            }
        }
        if (vdfs != null) {
            for (VariableDeclarationFragment vdf : vdfs) {
                if (!vdf.getName().toString().equals(name)) continue;
                return vdf.getName();
            }
        }
        return null;
    }

    public static int getLineNumber(ASTNode node) {
        return ((CompilationUnit)node.getRoot()).getLineNumber(node.getStartPosition());
    }

    public static int getLineNumber(ASTNode node, int pos) {
        return ((CompilationUnit)node.getRoot()).getLineNumber(pos);
    }

    protected void addListeners() {
        this.jtree.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                Messages.log((String)e.toString());
                SwingWorker<Object, Object> worker = new SwingWorker<Object, Object>(){

                    @Override
                    protected Object doInBackground() throws Exception {
                        return null;
                    }

                    @Override
                    protected void done() {
                        if ((this).ASTGenerator.this.jtree.getLastSelectedPathComponent() == null) {
                            return;
                        }
                        DefaultMutableTreeNode tnode = (DefaultMutableTreeNode)(this).ASTGenerator.this.jtree.getLastSelectedPathComponent();
                        if (tnode.getUserObject() instanceof ASTNodeWrapper) {
                            ASTNodeWrapper awrap = (ASTNodeWrapper)tnode.getUserObject();
                            awrap.highlightNode((this).ASTGenerator.this.editor);
                            try {
                                int javaLineNumber = ASTGenerator.getLineNumber(awrap.getNode());
                                int[] pdeOffs = (this).ASTGenerator.this.errorCheckerService.calculateTabIndexAndLineNumber(javaLineNumber);
                                PlainDocument javaSource = new PlainDocument();
                                javaSource.insertString(0, (this).ASTGenerator.this.errorCheckerService.lastCodeCheckResult.sourceCode, null);
                                Element lineElement = javaSource.getDefaultRootElement().getElement(javaLineNumber - 1);
                                if (lineElement == null) {
                                    return;
                                }
                                String javaLine = javaSource.getText(lineElement.getStartOffset(), lineElement.getEndOffset() - lineElement.getStartOffset());
                                (this).ASTGenerator.this.editor.getSketch().setCurrentCode(pdeOffs[0]);
                                String pdeLine = (this).ASTGenerator.this.editor.getLineText(pdeOffs[1]);
                                ASTGenerator.log("JL " + javaLine + " LSO " + lineElement.getStartOffset() + "," + lineElement.getEndOffset());
                                ASTGenerator.log("PL " + pdeLine);
                            }
                            catch (BadLocationException e) {
                                e.printStackTrace();
                            }
                        }
                    }
                };
                worker.execute();
            }
        });
        this.btnRename.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (ASTGenerator.this.txtRenameField.getText().length() == 0) {
                    return;
                }
                SwingWorker<Object, Object> worker = new SwingWorker<Object, Object>(){

                    @Override
                    protected Object doInBackground() throws Exception {
                        return null;
                    }

                    @Override
                    protected void done() {
                        ASTGenerator.this.refactorIt();
                    }
                };
                worker.execute();
            }
        });
        this.btnListOccurrence.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SwingWorker<Object, Object> worker = new SwingWorker<Object, Object>(){

                    @Override
                    protected Object doInBackground() throws Exception {
                        return null;
                    }

                    @Override
                    protected void done() {
                        ASTGenerator.this.handleShowUsage();
                    }
                };
                worker.execute();
            }
        });
        this.refactorTree.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                ASTGenerator.log(e);
                SwingWorker<Object, Object> worker = new SwingWorker<Object, Object>(){

                    @Override
                    protected Object doInBackground() throws Exception {
                        return null;
                    }

                    @Override
                    protected void done() {
                        if ((this).ASTGenerator.this.refactorTree.getLastSelectedPathComponent() == null) {
                            return;
                        }
                        DefaultMutableTreeNode tnode = (DefaultMutableTreeNode)(this).ASTGenerator.this.refactorTree.getLastSelectedPathComponent();
                        if (tnode.getUserObject() instanceof ASTNodeWrapper) {
                            ASTNodeWrapper awrap = (ASTNodeWrapper)tnode.getUserObject();
                            awrap.highlightNode((this).ASTGenerator.this.editor);
                        }
                    }
                };
                worker.execute();
            }
        });
    }

    protected void refactorIt() {
        ASTNodeWrapper awrap;
        String newName = this.txtRenameField.getText().trim();
        String selText = this.lastClickedWord == null ? this.getSelectedText() : this.lastClickedWord;
        DefaultMutableTreeNode defCU = this.findAllOccurrences();
        if (defCU == null) {
            this.editor.statusMessage("Can't locate definition of " + selText, 1);
            return;
        }
        if (!newName.matches("([a-zA-Z][a-zA-Z0-9_]*)|([_][a-zA-Z0-9_]+)")) {
            JOptionPane.showConfirmDialog(new JFrame(), String.valueOf(newName) + " isn't a valid name.", "Uh oh..", -1);
            return;
        }
        this.errorCheckerService.cancel();
        if (this.refactorTree.isVisible()) {
            this.refactorTree.setModel(new DefaultTreeModel(defCU));
            ((DefaultTreeModel)this.refactorTree.getModel()).reload();
        }
        int lineOffsetDisplacementConst = newName.length() - selText.length();
        HashMap<Integer, Integer> lineOffsetDisplacement = new HashMap<Integer, Integer>();
        int[][] pdeOffsets = new int[defCU.getChildCount()][3];
        int i = 0;
        while (i < defCU.getChildCount()) {
            awrap = (ASTNodeWrapper)((DefaultMutableTreeNode)defCU.getChildAt(i)).getUserObject();
            int[] ans = this.errorCheckerService.calculateTabIndexAndLineNumber(awrap.getLineNumber());
            pdeOffsets[i][0] = ans[0];
            pdeOffsets[i][1] = ans[1];
            pdeOffsets[i][2] = awrap.getPDECodeOffsetForSN(this);
            ++i;
        }
        this.editor.startCompoundEdit();
        i = 0;
        while (i < defCU.getChildCount()) {
            awrap = (ASTNodeWrapper)((DefaultMutableTreeNode)defCU.getChildAt(i)).getUserObject();
            int off = 0;
            if (lineOffsetDisplacement.get(awrap.getLineNumber()) != null) {
                off = (Integer)lineOffsetDisplacement.get(awrap.getLineNumber());
                lineOffsetDisplacement.put(awrap.getLineNumber(), lineOffsetDisplacementConst + off);
            } else {
                lineOffsetDisplacement.put(awrap.getLineNumber(), lineOffsetDisplacementConst);
            }
            this.highlightPDECode(pdeOffsets[i][0], pdeOffsets[i][1], pdeOffsets[i][2] + off, awrap.getNode().toString().length());
            this.editor.getTextArea().setSelectedText(newName);
            ++i;
        }
        this.editor.stopCompoundEdit();
        this.errorCheckerService.request();
        this.editor.getSketch().setModified(true);
        this.errorCheckerService.request();
        this.frmRename.setVisible(false);
        this.lastClickedWord = null;
        this.lastClickedWordNode = null;
    }

    public void highlightPDECode(int tab, int lineNumber, int lineStartWSOffset, int length) {
        this.editor.toFront();
        this.editor.getSketch().setCurrentCode(tab);
        this.editor.getTextArea().select(lineStartWSOffset += this.editor.getTextArea().getLineStartOffset(lineNumber), lineStartWSOffset + length);
    }

    public void handleShowUsage() {
        String selText;
        if (this.editor.hasJavaTabs()) {
            return;
        }
        ASTGenerator.log("Last clicked word:" + this.lastClickedWord);
        if (this.lastClickedWord == null && this.getSelectedText() == null) {
            this.editor.statusMessage("Highlight the class/function/variable name first", 0);
            return;
        }
        if (this.errorCheckerService.hasSyntaxErrors()) {
            this.editor.statusMessage("Can't perform action until errors are fixed", 3);
            return;
        }
        DefaultMutableTreeNode defCU = this.findAllOccurrences();
        String string = selText = this.lastClickedWord == null ? this.getSelectedText() : this.lastClickedWord;
        if (defCU == null) {
            this.editor.statusMessage("Can't locate definition of " + selText, 1);
            return;
        }
        if (defCU.getChildCount() == 0) {
            return;
        }
        this.refactorTree.setModel(new DefaultTreeModel(defCU));
        ((DefaultTreeModel)this.refactorTree.getModel()).reload();
        this.refactorTree.setRootVisible(false);
        this.frmOccurenceList.setTitle("Usage of \"" + selText + "\" : " + defCU.getChildCount() + " time(s)");
        this.frmOccurenceList.setLocation(this.editor.getX() + this.editor.getWidth(), this.editor.getY());
        this.frmOccurenceList.setVisible(true);
        this.lastClickedWord = null;
        this.lastClickedWordNode = null;
    }

    public String getLastClickedWord() {
        return this.lastClickedWord;
    }

    public void setLastClickedWord(int lineNumber, String lastClickedWord, int offset) {
        this.lastClickedWord = lastClickedWord;
        this.lastClickedWordNode = this.getASTNodeAt(lineNumber, lastClickedWord, offset, false);
        ASTGenerator.log("Last clicked node: " + this.lastClickedWordNode);
    }

    protected DefaultMutableTreeNode findAllOccurrences() {
        JEditTextArea ta = this.editor.getTextArea();
        ASTGenerator.log("Last clicked word:" + this.lastClickedWord);
        String selText = this.lastClickedWord == null ? ta.getSelectedText() : this.lastClickedWord;
        int line = ta.getSelectionStartLine();
        ASTGenerator.log(String.valueOf(selText) + "<- offsets " + line + ", " + (ta.getSelectionStart() - ta.getLineStartOffset(line)) + ", " + (ta.getSelectionStop() - ta.getLineStartOffset(line)));
        int offwhitespace = ta.getLineStartNonWhiteSpaceOffset(line);
        ASTNodeWrapper wnode = this.lastClickedWord == null || this.lastClickedWordNode.getNode() == null ? this.getASTNodeAt(line + this.errorCheckerService.mainClassOffset, selText, ta.getSelectionStart() - offwhitespace, false) : this.lastClickedWordNode;
        if (wnode.getNode() == null) {
            return null;
        }
        Messages.loge((String)("Gonna find all occurrences of " + ASTGenerator.getNodeAsString(wnode.getNode())));
        if (wnode.getNodeType() == 31) {
            TypeDeclaration td;
            MethodDeclaration md = (MethodDeclaration)wnode.getNode();
            ASTNode node = md.getParent();
            while (node != null) {
                if (node instanceof TypeDeclaration) break;
                node = node.getParent();
            }
            if (node != null && node instanceof TypeDeclaration && (td = (TypeDeclaration)node).getName().toString().equals(md.getName().toString())) {
                Messages.loge((String)("Renaming constructor of " + ASTGenerator.getNodeAsString((ASTNode)td)));
                wnode = new ASTNodeWrapper((ASTNode)td);
            }
        }
        DefaultMutableTreeNode defCU = new DefaultMutableTreeNode(new ASTNodeWrapper(wnode.getNode(), selText));
        this.dfsNameOnly(defCU, wnode.getNode(), selText);
        Stack<TreeNode> tempS = new Stack<TreeNode>();
        int i = 0;
        while (i < defCU.getChildCount()) {
            tempS.push(defCU.getChildAt(i));
            ++i;
        }
        defCU.removeAllChildren();
        while (!tempS.isEmpty()) {
            defCU.add((MutableTreeNode)tempS.pop());
        }
        ASTGenerator.log(wnode);
        return defCU;
    }

    public static void visitRecur(ASTNode node, DefaultMutableTreeNode tnode) {
        for (StructuralPropertyDescriptor prop : node.structuralPropertiesForType()) {
            DefaultMutableTreeNode ctnode;
            if (prop.isChildProperty() || prop.isSimpleProperty()) {
                if (node.getStructuralProperty(prop) == null) continue;
                if (node.getStructuralProperty(prop) instanceof ASTNode) {
                    ASTNode cnode = (ASTNode)node.getStructuralProperty(prop);
                    if (!ASTGenerator.isAddableASTNode(cnode)) continue;
                    ctnode = new DefaultMutableTreeNode(new ASTNodeWrapper((ASTNode)node.getStructuralProperty(prop)));
                    tnode.add(ctnode);
                    ASTGenerator.visitRecur(cnode, ctnode);
                    continue;
                }
                tnode.add(new DefaultMutableTreeNode(node.getStructuralProperty(prop)));
                continue;
            }
            if (!prop.isChildListProperty()) continue;
            List nodelist = (List)node.getStructuralProperty(prop);
            for (ASTNode cnode : nodelist) {
                if (ASTGenerator.isAddableASTNode(cnode)) {
                    ctnode = new DefaultMutableTreeNode(new ASTNodeWrapper(cnode));
                    tnode.add(ctnode);
                    ASTGenerator.visitRecur(cnode, ctnode);
                    continue;
                }
                ASTGenerator.visitRecur(cnode, tnode);
            }
        }
    }

    public void dfsNameOnly(DefaultMutableTreeNode tnode, ASTNode decl, String name) {
        Stack<DefaultMutableTreeNode> temp = new Stack<DefaultMutableTreeNode>();
        temp.push(this.codeTree);
        while (!temp.isEmpty()) {
            ASTNodeWrapper awnode;
            DefaultMutableTreeNode cnode = (DefaultMutableTreeNode)temp.pop();
            int i = 0;
            while (i < cnode.getChildCount()) {
                temp.push((DefaultMutableTreeNode)cnode.getChildAt(i));
                ++i;
            }
            if (!(cnode.getUserObject() instanceof ASTNodeWrapper) || !this.isInstanceOfType((awnode = (ASTNodeWrapper)cnode.getUserObject()).getNode(), decl, name)) continue;
            int[] val = this.errorCheckerService.JavaToPdeOffsets(awnode.getLineNumber(), 0);
            tnode.add(new DefaultMutableTreeNode(new ASTNodeWrapper(awnode.getNode(), "Line " + (val[1] + 1) + " | Tab: " + this.editor.getSketch().getCode(val[0]).getPrettyName())));
        }
    }

    public ASTNode dfsLookForASTNode(ASTNode root, String name, int startOffset, int endOffset) {
        Stack<ASTNode> stack = new Stack<ASTNode>();
        stack.push(root);
        while (!stack.isEmpty()) {
            ASTNode node = (ASTNode)stack.pop();
            for (StructuralPropertyDescriptor prop : node.structuralPropertiesForType()) {
                if (prop.isChildProperty() || prop.isSimpleProperty()) {
                    ASTNode temp;
                    if (!(node.getStructuralProperty(prop) instanceof ASTNode) || (temp = (ASTNode)node.getStructuralProperty(prop)).getStartPosition() > startOffset || temp.getStartPosition() + temp.getLength() < endOffset) continue;
                    if (temp instanceof SimpleName) {
                        if (!name.equals(temp.toString())) continue;
                        return temp;
                    }
                    stack.push(temp);
                    continue;
                }
                if (!prop.isChildListProperty()) continue;
                List nodelist = (List)node.getStructuralProperty(prop);
                for (ASTNode temp : nodelist) {
                    if (temp.getStartPosition() > startOffset || temp.getStartPosition() + temp.getLength() < endOffset) continue;
                    stack.push(temp);
                    if (temp instanceof SimpleName) {
                        if (!name.equals(temp.toString())) continue;
                        return temp;
                    }
                    stack.push(temp);
                }
            }
        }
        return null;
    }

    public void showTabOutline() {
        new TabOutline(this.errorCheckerService).show();
    }

    public int javaCodeOffsetToLineStartOffset(int line, int jOffset) {
        line = this.pdeLineNumToJavaLineNum(line);
        ASTGenerator.log("Looking for line: " + line + ", jOff " + jOffset);
        Stack<DefaultMutableTreeNode> temp = new Stack<DefaultMutableTreeNode>();
        temp.push(this.codeTree);
        while (!temp.isEmpty()) {
            ASTNodeWrapper awnode;
            DefaultMutableTreeNode cnode = (DefaultMutableTreeNode)temp.pop();
            int i = 0;
            while (i < cnode.getChildCount()) {
                temp.push((DefaultMutableTreeNode)cnode.getChildAt(i));
                ++i;
            }
            if (!(cnode.getUserObject() instanceof ASTNodeWrapper) || (awnode = (ASTNodeWrapper)cnode.getUserObject()).getLineNumber() != line) continue;
            ASTGenerator.log("First element with this line no is: " + awnode + "LSO: " + (jOffset - awnode.getNode().getStartPosition()));
            return jOffset - awnode.getNode().getStartPosition();
        }
        return -1;
    }

    protected int pdeLineNumToJavaLineNum(int pdeLineNum) {
        int javaLineNumber = pdeLineNum + this.errorCheckerService.getPdeImportsCount();
        int codeIndex = this.editor.getSketch().getCodeIndex(this.editor.getCurrentTab());
        if (codeIndex > 0) {
            int i = 0;
            while (i < codeIndex) {
                SketchCode sc = this.editor.getSketch().getCode(i);
                int len = Util.countLines((String)sc.getProgram()) + 1;
                javaLineNumber += len;
                ++i;
            }
        }
        return javaLineNumber;
    }

    protected boolean isInstanceOfType(ASTNode node, ASTNode decl, String name) {
        SimpleName sn;
        if (node instanceof SimpleName && (sn = (SimpleName)node).toString().equals(name)) {
            ArrayList<Object> nodesToBeMatched = new ArrayList<Object>();
            nodesToBeMatched.add(decl);
            if (decl instanceof TypeDeclaration) {
                MethodDeclaration[] methodDeclarationArray;
                ASTGenerator.log("decl is a TD");
                TypeDeclaration td = (TypeDeclaration)decl;
                MethodDeclaration[] methodDeclarationArray2 = methodDeclarationArray = td.getMethods();
                int n = methodDeclarationArray.length;
                int n2 = 0;
                while (n2 < n) {
                    MethodDeclaration md = methodDeclarationArray2[n2];
                    if (md.getName().toString().equals(name)) {
                        nodesToBeMatched.add(md);
                    }
                    ++n2;
                }
            }
            ASTGenerator.log("Visiting: " + ASTGenerator.getNodeAsString(node));
            ASTNode decl2 = ASTGenerator.findDeclaration((Name)sn);
            Messages.loge((String)("It's decl: " + ASTGenerator.getNodeAsString(decl2)));
            ASTGenerator.log("But we need: " + ASTGenerator.getNodeAsString(decl));
            for (ASTNode aSTNode : nodesToBeMatched) {
                if (!aSTNode.equals((Object)decl2)) continue;
                return true;
            }
        }
        return false;
    }

    public void handleRefactor() {
        String selText;
        if (this.editor.hasJavaTabs()) {
            return;
        }
        ASTGenerator.log("Last clicked word:" + this.lastClickedWord);
        if (this.lastClickedWord == null && this.getSelectedText() == null) {
            this.editor.statusMessage("Highlight the class/function/variable name first", 0);
            return;
        }
        if (this.errorCheckerService.hasSyntaxErrors()) {
            this.editor.statusMessage("Can't perform action until syntax errors are fixed :(", 3);
            return;
        }
        DefaultMutableTreeNode defCU = this.findAllOccurrences();
        String string = selText = this.lastClickedWord == null ? this.getSelectedText() : this.lastClickedWord;
        if (defCU == null) {
            this.editor.statusMessage(String.valueOf(selText) + " isn't defined in this sketch, " + "so it cannot be renamed", 1);
            return;
        }
        if (!this.frmRename.isVisible()) {
            this.frmRename.setLocation(this.editor.getX() + (this.editor.getWidth() - this.frmRename.getWidth()) / 2, this.editor.getY() + (this.editor.getHeight() - this.frmRename.getHeight()) / 2);
            this.frmRename.setVisible(true);
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    String selText = ASTGenerator.this.lastClickedWord == null ? ASTGenerator.this.getSelectedText() : ASTGenerator.this.lastClickedWord;
                    ASTGenerator.this.frmOccurenceList.setTitle("All occurrences of " + selText);
                    ASTGenerator.this.lblRefactorOldName.setText("Current name: " + selText);
                    ASTGenerator.this.txtRenameField.setText("");
                    ASTGenerator.this.txtRenameField.requestFocus();
                }
            });
        }
        this.frmRename.toFront();
    }

    public static void printRecur(ASTNode node) {
        for (StructuralPropertyDescriptor prop : node.structuralPropertiesForType()) {
            if (prop.isChildProperty() || prop.isSimpleProperty()) {
                if (node.getStructuralProperty(prop) == null || !(node.getStructuralProperty(prop) instanceof ASTNode)) continue;
                ASTNode cnode = (ASTNode)node.getStructuralProperty(prop);
                ASTGenerator.log(ASTGenerator.getNodeAsString(cnode));
                ASTGenerator.printRecur(cnode);
                continue;
            }
            if (!prop.isChildListProperty()) continue;
            List nodelist = (List)node.getStructuralProperty(prop);
            for (ASTNode cnode : nodelist) {
                ASTGenerator.log(ASTGenerator.getNodeAsString(cnode));
                ASTGenerator.printRecur(cnode);
            }
        }
    }

    protected static ASTNode findLineOfNode(ASTNode node, int lineNumber, int offset, String name) {
        if (node == null) {
            return null;
        }
        CompilationUnit root = (CompilationUnit)node.getRoot();
        if (root.getLineNumber(node.getStartPosition()) == lineNumber) {
            return node;
        }
        for (Object oprop : node.structuralPropertiesForType()) {
            StructuralPropertyDescriptor prop = (StructuralPropertyDescriptor)oprop;
            if (prop.isChildProperty() || prop.isSimpleProperty()) {
                ASTNode retNode;
                if (node.getStructuralProperty(prop) == null || !(node.getStructuralProperty(prop) instanceof ASTNode) || (retNode = ASTGenerator.findLineOfNode((ASTNode)node.getStructuralProperty(prop), lineNumber, offset, name)) == null) continue;
                return retNode;
            }
            if (!prop.isChildListProperty()) continue;
            List nodelist = (List)node.getStructuralProperty(prop);
            for (ASTNode retNode : nodelist) {
                ASTNode rr = ASTGenerator.findLineOfNode(retNode, lineNumber, offset, name);
                if (rr == null) continue;
                return rr;
            }
        }
        return null;
    }

    public static ASTNode pinpointOnLine(ASTNode node, int offset, int lineStartOffset, String name) {
        if (node instanceof SimpleName) {
            SimpleName sn = (SimpleName)node;
            if (lineStartOffset + offset >= sn.getStartPosition() && lineStartOffset + offset <= sn.getStartPosition() + sn.getLength()) {
                if (sn.toString().equals(name)) {
                    return sn;
                }
                return null;
            }
            return null;
        }
        for (Object oprop : node.structuralPropertiesForType()) {
            StructuralPropertyDescriptor prop = (StructuralPropertyDescriptor)oprop;
            if (prop.isChildProperty() || prop.isSimpleProperty()) {
                ASTNode retNode;
                if (node.getStructuralProperty(prop) == null || !(node.getStructuralProperty(prop) instanceof ASTNode) || (retNode = ASTGenerator.pinpointOnLine((ASTNode)node.getStructuralProperty(prop), offset, lineStartOffset, name)) == null) continue;
                return retNode;
            }
            if (!prop.isChildListProperty()) continue;
            List nodelist = (List)node.getStructuralProperty(prop);
            for (ASTNode retNode : nodelist) {
                ASTNode rr = ASTGenerator.pinpointOnLine(retNode, offset, lineStartOffset, name);
                if (rr == null) continue;
                return rr;
            }
        }
        return null;
    }

    protected static ASTNode findDeclaration(Name findMe) {
        ASTNode parent = findMe.getParent();
        ArrayList<Integer> constrains = new ArrayList<Integer>();
        if (parent.getNodeType() == 32) {
            Expression exp = (Expression)parent.getStructuralProperty((StructuralPropertyDescriptor)MethodInvocation.EXPRESSION_PROPERTY);
            if (((MethodInvocation)parent).getName().toString().equals(findMe.toString())) {
                constrains.add(31);
                if (exp != null) {
                    constrains.add(55);
                    if (exp instanceof MethodInvocation) {
                        SimpleType stp = ASTGenerator.extracTypeInfo(ASTGenerator.findDeclaration((Name)((MethodInvocation)exp).getName()));
                        if (stp == null) {
                            return null;
                        }
                        ASTNode declaringClass = ASTGenerator.findDeclaration(stp.getName());
                        return ASTGenerator.definedIn(declaringClass, ((MethodInvocation)parent).getName().toString(), constrains);
                    }
                    if (exp instanceof FieldAccess) {
                        SimpleType stp = ASTGenerator.extracTypeInfo(ASTGenerator.findDeclaration((Name)((FieldAccess)exp).getName()));
                        if (stp == null) {
                            return null;
                        }
                        ASTNode declaringClass = ASTGenerator.findDeclaration(stp.getName());
                        return ASTGenerator.definedIn(declaringClass, ((MethodInvocation)parent).getName().toString(), constrains);
                    }
                    if (exp instanceof SimpleName) {
                        SimpleType stp = ASTGenerator.extracTypeInfo(ASTGenerator.findDeclaration((Name)((SimpleName)exp)));
                        if (stp == null) {
                            return null;
                        }
                        ASTNode declaringClass = ASTGenerator.findDeclaration(stp.getName());
                        constrains.add(31);
                        return ASTGenerator.definedIn(declaringClass, ((MethodInvocation)parent).getName().toString(), constrains);
                    }
                }
            } else {
                parent = parent.getParent();
            }
        } else if (parent.getNodeType() == 22) {
            FieldAccess fa = (FieldAccess)parent;
            Expression exp = fa.getExpression();
            if (fa.getName().toString().equals(findMe.toString())) {
                constrains.add(23);
                if (exp != null) {
                    constrains.add(55);
                    if (exp instanceof MethodInvocation) {
                        SimpleType stp = ASTGenerator.extracTypeInfo(ASTGenerator.findDeclaration((Name)((MethodInvocation)exp).getName()));
                        if (stp == null) {
                            return null;
                        }
                        ASTNode declaringClass = ASTGenerator.findDeclaration(stp.getName());
                        return ASTGenerator.definedIn(declaringClass, fa.getName().toString(), constrains);
                    }
                    if (exp instanceof FieldAccess) {
                        SimpleType stp = ASTGenerator.extracTypeInfo(ASTGenerator.findDeclaration((Name)((FieldAccess)exp).getName()));
                        if (stp == null) {
                            return null;
                        }
                        ASTNode declaringClass = ASTGenerator.findDeclaration(stp.getName());
                        constrains.add(55);
                        return ASTGenerator.definedIn(declaringClass, fa.getName().toString(), constrains);
                    }
                    if (exp instanceof SimpleName) {
                        SimpleType stp = ASTGenerator.extracTypeInfo(ASTGenerator.findDeclaration((Name)((SimpleName)exp)));
                        if (stp == null) {
                            return null;
                        }
                        ASTNode declaringClass = ASTGenerator.findDeclaration(stp.getName());
                        constrains.add(31);
                        return ASTGenerator.definedIn(declaringClass, fa.getName().toString(), constrains);
                    }
                }
            } else {
                parent = parent.getParent();
            }
        } else if (parent.getNodeType() == 40) {
            QualifiedName qn = (QualifiedName)parent;
            if (!findMe.toString().equals(qn.getQualifier().toString())) {
                SimpleType stp = ASTGenerator.extracTypeInfo(ASTGenerator.findDeclaration(qn.getQualifier()));
                if (stp == null) {
                    return null;
                }
                ASTNode declaringClass = ASTGenerator.findDeclaration(stp.getName());
                constrains.clear();
                constrains.add(55);
                constrains.add(23);
                return ASTGenerator.definedIn(declaringClass, qn.getName().toString(), constrains);
            }
            if (findMe instanceof QualifiedName) {
                QualifiedName qnn = (QualifiedName)findMe;
                SimpleType stp = ASTGenerator.extracTypeInfo(ASTGenerator.findDeclaration(qnn.getQualifier()));
                if (stp == null) {
                    return null;
                }
                ASTNode declaringClass = ASTGenerator.findDeclaration(stp.getName());
                constrains.clear();
                constrains.add(55);
                constrains.add(23);
                return ASTGenerator.definedIn(declaringClass, qnn.getName().toString(), constrains);
            }
        } else if (parent.getNodeType() == 43) {
            constrains.add(55);
            if (parent.getParent().getNodeType() == 14) {
                constrains.add(14);
            }
        } else if (parent.getNodeType() == 55) {
            TypeDeclaration td = (TypeDeclaration)parent;
            if (findMe.equals((Object)td.getName())) {
                return parent;
            }
        } else {
            boolean cfr_ignored_0 = parent instanceof Expression;
        }
        while (parent != null) {
            for (Object oprop : parent.structuralPropertiesForType()) {
                ASTNode ret;
                StructuralPropertyDescriptor prop = (StructuralPropertyDescriptor)oprop;
                if (prop.isChildProperty() || prop.isSimpleProperty()) {
                    if (!(parent.getStructuralProperty(prop) instanceof ASTNode) || (ret = ASTGenerator.definedIn((ASTNode)parent.getStructuralProperty(prop), findMe.toString(), constrains)) == null) continue;
                    return ret;
                }
                if (!prop.isChildListProperty()) continue;
                List nodelist = (List)parent.getStructuralProperty(prop);
                for (ASTNode retNode : nodelist) {
                    ret = ASTGenerator.definedIn(retNode, findMe.toString(), constrains);
                    if (ret == null) continue;
                    return ret;
                }
            }
            parent = parent.getParent();
        }
        return null;
    }

    protected static ASTNode findDeclaration2(Name findMe, ASTNode alternateParent) {
        ASTNode parent = findMe.getParent();
        ArrayList<Integer> constrains = new ArrayList<Integer>();
        if (parent.getNodeType() == 32) {
            Expression exp = (Expression)parent.getStructuralProperty((StructuralPropertyDescriptor)MethodInvocation.EXPRESSION_PROPERTY);
            if (((MethodInvocation)parent).getName().toString().equals(findMe.toString())) {
                constrains.add(31);
                if (exp != null) {
                    constrains.add(55);
                    if (exp instanceof MethodInvocation) {
                        SimpleType stp = ASTGenerator.extracTypeInfo(ASTGenerator.findDeclaration2((Name)((MethodInvocation)exp).getName(), alternateParent));
                        if (stp == null) {
                            return null;
                        }
                        ASTNode declaringClass = ASTGenerator.findDeclaration2(stp.getName(), alternateParent);
                        return ASTGenerator.definedIn(declaringClass, ((MethodInvocation)parent).getName().toString(), constrains);
                    }
                    if (exp instanceof FieldAccess) {
                        SimpleType stp = ASTGenerator.extracTypeInfo(ASTGenerator.findDeclaration2((Name)((FieldAccess)exp).getName(), alternateParent));
                        if (stp == null) {
                            return null;
                        }
                        ASTNode declaringClass = ASTGenerator.findDeclaration2(stp.getName(), alternateParent);
                        return ASTGenerator.definedIn(declaringClass, ((MethodInvocation)parent).getName().toString(), constrains);
                    }
                    if (exp instanceof SimpleName) {
                        SimpleType stp = ASTGenerator.extracTypeInfo(ASTGenerator.findDeclaration2((Name)((SimpleName)exp), alternateParent));
                        if (stp == null) {
                            return null;
                        }
                        ASTNode declaringClass = ASTGenerator.findDeclaration2(stp.getName(), alternateParent);
                        constrains.add(31);
                        return ASTGenerator.definedIn(declaringClass, ((MethodInvocation)parent).getName().toString(), constrains);
                    }
                }
            } else {
                parent = parent.getParent();
                alternateParent = alternateParent.getParent();
            }
        } else if (parent.getNodeType() == 22) {
            FieldAccess fa = (FieldAccess)parent;
            Expression exp = fa.getExpression();
            if (fa.getName().toString().equals(findMe.toString())) {
                constrains.add(23);
                if (exp != null) {
                    constrains.add(55);
                    if (exp instanceof MethodInvocation) {
                        SimpleType stp = ASTGenerator.extracTypeInfo(ASTGenerator.findDeclaration2((Name)((MethodInvocation)exp).getName(), alternateParent));
                        if (stp == null) {
                            return null;
                        }
                        ASTNode declaringClass = ASTGenerator.findDeclaration2(stp.getName(), alternateParent);
                        return ASTGenerator.definedIn(declaringClass, fa.getName().toString(), constrains);
                    }
                    if (exp instanceof FieldAccess) {
                        SimpleType stp = ASTGenerator.extracTypeInfo(ASTGenerator.findDeclaration2((Name)((FieldAccess)exp).getName(), alternateParent));
                        if (stp == null) {
                            return null;
                        }
                        ASTNode declaringClass = ASTGenerator.findDeclaration2(stp.getName(), alternateParent);
                        constrains.add(55);
                        return ASTGenerator.definedIn(declaringClass, fa.getName().toString(), constrains);
                    }
                    if (exp instanceof SimpleName) {
                        SimpleType stp = ASTGenerator.extracTypeInfo(ASTGenerator.findDeclaration2((Name)((SimpleName)exp), alternateParent));
                        if (stp == null) {
                            return null;
                        }
                        ASTNode declaringClass = ASTGenerator.findDeclaration2(stp.getName(), alternateParent);
                        constrains.add(31);
                        return ASTGenerator.definedIn(declaringClass, fa.getName().toString(), constrains);
                    }
                }
            } else {
                parent = parent.getParent();
                alternateParent = alternateParent.getParent();
            }
        } else if (parent.getNodeType() == 40) {
            QualifiedName qn = (QualifiedName)parent;
            if (!findMe.toString().equals(qn.getQualifier().toString())) {
                SimpleType stp = ASTGenerator.extracTypeInfo(ASTGenerator.findDeclaration2(qn.getQualifier(), alternateParent));
                if (stp == null) {
                    return null;
                }
                ASTNode declaringClass = ASTGenerator.findDeclaration2(stp.getName(), alternateParent);
                constrains.clear();
                constrains.add(55);
                constrains.add(23);
                return ASTGenerator.definedIn(declaringClass, qn.getName().toString(), constrains);
            }
            if (findMe instanceof QualifiedName) {
                QualifiedName qnn = (QualifiedName)findMe;
                SimpleType stp = ASTGenerator.extracTypeInfo(ASTGenerator.findDeclaration2(qnn.getQualifier(), alternateParent));
                if (stp == null) {
                    return null;
                }
                ASTNode declaringClass = ASTGenerator.findDeclaration2(stp.getName(), alternateParent);
                constrains.clear();
                constrains.add(55);
                constrains.add(23);
                return ASTGenerator.definedIn(declaringClass, qnn.getName().toString(), constrains);
            }
        } else if (parent.getNodeType() == 43) {
            constrains.add(55);
            if (parent.getParent().getNodeType() == 14) {
                constrains.add(14);
            }
        } else {
            boolean cfr_ignored_0 = parent instanceof Expression;
        }
        while (alternateParent != null) {
            for (Object oprop : alternateParent.structuralPropertiesForType()) {
                ASTNode ret;
                StructuralPropertyDescriptor prop = (StructuralPropertyDescriptor)oprop;
                if (prop.isChildProperty() || prop.isSimpleProperty()) {
                    if (!(alternateParent.getStructuralProperty(prop) instanceof ASTNode) || (ret = ASTGenerator.definedIn((ASTNode)alternateParent.getStructuralProperty(prop), findMe.toString(), constrains)) == null) continue;
                    return ret;
                }
                if (!prop.isChildListProperty()) continue;
                List nodelist = (List)alternateParent.getStructuralProperty(prop);
                for (ASTNode retNode : nodelist) {
                    ret = ASTGenerator.definedIn(retNode, findMe.toString(), constrains);
                    if (ret == null) continue;
                    return ret;
                }
            }
            alternateParent = alternateParent.getParent();
        }
        return null;
    }

    protected List<Comment> getCodeComments() {
        List commentList = this.compilationUnit.getCommentList();
        return commentList;
    }

    public static SimpleType extracTypeInfo(ASTNode node) {
        if (node == null) {
            return null;
        }
        Type t = ASTGenerator.extracTypeInfo2(node);
        if (t instanceof PrimitiveType) {
            return null;
        }
        if (t instanceof ArrayType) {
            ArrayType at = (ArrayType)t;
            ASTGenerator.log("ele type " + at.getElementType() + ", " + at.getElementType().getClass().getName());
            if (at.getElementType() instanceof PrimitiveType) {
                return null;
            }
            if (at.getElementType() instanceof SimpleType) {
                return (SimpleType)at.getElementType();
            }
            return null;
        }
        if (t instanceof ParameterizedType) {
            ParameterizedType pmt = (ParameterizedType)t;
            ASTGenerator.log(pmt.getType() + ", " + pmt.getType().getClass());
            if (pmt.getType() instanceof SimpleType) {
                return (SimpleType)pmt.getType();
            }
            return null;
        }
        return (SimpleType)t;
    }

    public static Type extracTypeInfo2(ASTNode node) {
        if (node == null) {
            return null;
        }
        switch (node.getNodeType()) {
            case 31: {
                return ((MethodDeclaration)node).getReturnType2();
            }
            case 23: {
                return ((FieldDeclaration)node).getType();
            }
            case 58: {
                return ((VariableDeclarationExpression)node).getType();
            }
            case 60: {
                return ((VariableDeclarationStatement)node).getType();
            }
            case 44: {
                return ((SingleVariableDeclaration)node).getType();
            }
            case 59: {
                return ASTGenerator.extracTypeInfo2(node.getParent());
            }
        }
        ASTGenerator.log("Unknown type info request " + ASTGenerator.getNodeAsString(node));
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected static ASTNode definedIn(ASTNode node, String name, ArrayList<Integer> constrains) {
        if (node == null) {
            return null;
        }
        if (constrains != null && !constrains.contains(node.getNodeType()) && constrains.size() > 0) {
            return null;
        }
        List vdfList = null;
        switch (node.getNodeType()) {
            case 55: {
                MethodDeclaration md;
                int n;
                int n2;
                MethodDeclaration[] methodDeclarationArray;
                MethodDeclaration[] methods;
                TypeDeclaration td = (TypeDeclaration)node;
                if (td.getName().toString().equals(name)) {
                    if (!constrains.contains(14)) return node;
                    methodDeclarationArray = methods = td.getMethods();
                    n2 = methods.length;
                    n = 0;
                    while (n < n2) {
                        md = methodDeclarationArray[n];
                        if (md.getName().toString().equalsIgnoreCase(name)) {
                            ASTGenerator.log("Found a constructor.");
                            return md;
                        }
                        ++n;
                    }
                } else if (constrains.contains(23)) {
                    FieldDeclaration[] fields = td.getFields();
                    methodDeclarationArray = fields;
                    n2 = fields.length;
                    n = 0;
                    while (n < n2) {
                        MethodDeclaration fd = methodDeclarationArray[n];
                        List fragments = fd.fragments();
                        for (VariableDeclarationFragment vdf : fragments) {
                            if (!vdf.getName().toString().equalsIgnoreCase(name)) continue;
                            return fd;
                        }
                        ++n;
                    }
                } else {
                    if (!constrains.contains(31)) break;
                    methodDeclarationArray = methods = td.getMethods();
                    n2 = methods.length;
                    n = 0;
                    while (n < n2) {
                        md = methodDeclarationArray[n];
                        if (md.getName().toString().equalsIgnoreCase(name)) {
                            return md;
                        }
                        ++n;
                    }
                }
                break;
            }
            case 31: {
                if (!((MethodDeclaration)node).getName().toString().equalsIgnoreCase(name)) break;
                return node;
            }
            case 44: {
                if (!((SingleVariableDeclaration)node).getName().toString().equalsIgnoreCase(name)) break;
                return node;
            }
            case 23: {
                vdfList = ((FieldDeclaration)node).fragments();
                break;
            }
            case 58: {
                vdfList = ((VariableDeclarationExpression)node).fragments();
                break;
            }
            case 60: {
                vdfList = ((VariableDeclarationStatement)node).fragments();
            }
        }
        if (vdfList == null) return null;
        for (VariableDeclarationFragment vdf : vdfList) {
            if (!vdf.getName().toString().equalsIgnoreCase(name)) continue;
            return node;
        }
        return null;
    }

    public String[] getSuggestImports(String className) {
        int n;
        if (this.classPath == null) {
            return null;
        }
        if (this.ignoredImportSuggestions == null) {
            this.ignoredImportSuggestions = new TreeSet();
        } else if (this.ignoredImportSuggestions.contains(className)) {
            ASTGenerator.log("Ignoring import suggestions for " + className);
            return null;
        }
        ASTGenerator.log("Looking for class " + className);
        RegExpResourceFilter regf = new RegExpResourceFilter(Pattern.compile(".*"), Pattern.compile(String.valueOf(className) + ".class", 2));
        String[] resources = this.classPath.findResources("", (ResourceFilter)regf);
        ArrayList<String> candidates = new ArrayList<String>();
        Collections.addAll(candidates, resources);
        for (Library lib : this.editor.getMode().contribLibraries) {
            ClassPath cp = this.factory.createFromPath(lib.getClassPath());
            String[] stringArray = resources = cp.findResources("", (ResourceFilter)regf);
            int n2 = resources.length;
            n = 0;
            while (n < n2) {
                String res = stringArray[n];
                candidates.add(res);
                ASTGenerator.log("Res: " + res);
                ++n;
            }
        }
        if (this.editor.getSketch().hasCodeFolder()) {
            File codeFolder = this.editor.getSketch().getCodeFolder();
            ClassPath cp = this.factory.createFromPath(Util.contentsToClassPath((File)codeFolder));
            String[] stringArray = resources = cp.findResources("", (ResourceFilter)regf);
            n = resources.length;
            int n3 = 0;
            while (n3 < n) {
                String res = stringArray[n3];
                candidates.add(res);
                ASTGenerator.log("Res: " + res);
                ++n3;
            }
        }
        resources = new String[candidates.size()];
        int i = 0;
        while (i < resources.length) {
            resources[i] = ((String)candidates.get(i)).replace('/', '.').substring(0, ((String)candidates.get(i)).length() - 6);
            ++i;
        }
        return resources;
    }

    public void suggestImports(final String className) {
        int n;
        if (this.ignoredImportSuggestions == null) {
            this.ignoredImportSuggestions = new TreeSet();
        } else if (this.ignoredImportSuggestions.contains(className)) {
            ASTGenerator.log("Ignoring import suggestions for " + className);
            return;
        }
        if (this.frmImportSuggest != null && this.frmImportSuggest.isVisible()) {
            return;
        }
        ASTGenerator.log("Looking for class " + className);
        RegExpResourceFilter regf = new RegExpResourceFilter(Pattern.compile(".*"), Pattern.compile(String.valueOf(className) + ".class", 2));
        String[] resources = this.classPath.findResources("", (ResourceFilter)regf);
        ArrayList<String> candidates = new ArrayList<String>();
        Collections.addAll(candidates, resources);
        for (Library lib : this.editor.getMode().contribLibraries) {
            ClassPath cp = this.factory.createFromPath(lib.getClassPath());
            String[] stringArray = resources = cp.findResources("", (ResourceFilter)regf);
            int n2 = resources.length;
            n = 0;
            while (n < n2) {
                String res = stringArray[n];
                candidates.add(res);
                ASTGenerator.log("Res: " + res);
                ++n;
            }
        }
        if (this.editor.getSketch().hasCodeFolder()) {
            File codeFolder = this.editor.getSketch().getCodeFolder();
            ClassPath cp = this.factory.createFromPath(Util.contentsToClassPath((File)codeFolder));
            String[] stringArray = resources = cp.findResources("", (ResourceFilter)regf);
            n = resources.length;
            int res = 0;
            while (res < n) {
                String res2 = stringArray[res];
                candidates.add(res2);
                ASTGenerator.log("Res: " + res2);
                ++res;
            }
        }
        resources = new String[candidates.size()];
        int i = 0;
        while (i < resources.length) {
            resources[i] = ((String)candidates.get(i)).replace('/', '.').substring(0, ((String)candidates.get(i)).length() - 6);
            ++i;
        }
        if (resources.length >= 1) {
            final JList<String> classList = new JList<String>(resources);
            classList.setSelectionMode(0);
            this.frmImportSuggest = new JFrame();
            this.frmImportSuggest.setSize(350, 200);
            Toolkit.setIcon((Frame)this.frmImportSuggest);
            this.frmImportSuggest.setLayout(new BoxLayout(this.frmImportSuggest.getContentPane(), 1));
            ((JComponent)this.frmImportSuggest.getContentPane()).setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            JLabel lbl = new JLabel("<html>The class \"" + className + "\" couldn't be determined. You are probably missing one of the following imports:</html>");
            JScrollPane jsp = new JScrollPane();
            jsp.setViewportView(classList);
            JButton btnInsertImport = new JButton("Insert import");
            btnInsertImport.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    if (classList.getSelectedValue() != null) {
                        try {
                            String impString = "import " + (String)classList.getSelectedValue() + ";\n";
                            int ct = ASTGenerator.this.editor.getSketch().getCurrentCodeIndex();
                            ASTGenerator.this.editor.getSketch().setCurrentCode(0);
                            ASTGenerator.this.editor.getTextArea().getDocument().insertString(0, impString, null);
                            ASTGenerator.this.editor.getSketch().setCurrentCode(ct);
                            ASTGenerator.this.errorCheckerService.request();
                            ASTGenerator.this.frmImportSuggest.setVisible(false);
                            ASTGenerator.this.frmImportSuggest = null;
                        }
                        catch (BadLocationException e) {
                            ASTGenerator.log("Failed to insert import for " + className);
                            e.printStackTrace();
                        }
                    }
                }
            });
            JButton btnCancel = new JButton("Cancel");
            btnCancel.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ASTGenerator.this.frmImportSuggest.setVisible(false);
                }
            });
            JPanel panelTop = new JPanel();
            JPanel panelBottom = new JPanel();
            JPanel panelLabel = new JPanel();
            panelTop.setLayout(new BoxLayout(panelTop, 1));
            panelTop.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            panelLabel.setLayout(new BorderLayout());
            panelLabel.add((Component)lbl, "Center");
            panelTop.add(panelLabel);
            panelTop.add(Box.createRigidArea(new Dimension(1, 5)));
            panelTop.add(jsp);
            panelBottom.setLayout(new BoxLayout(panelBottom, 0));
            panelBottom.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            panelBottom.setLayout(new BoxLayout(panelBottom, 0));
            panelBottom.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            panelBottom.add(Box.createHorizontalGlue());
            panelBottom.add(btnInsertImport);
            panelBottom.add(Box.createRigidArea(new Dimension(15, 0)));
            panelBottom.add(btnCancel);
            JButton btnIgnore = new JButton("Ignore \"" + className + "\"");
            btnIgnore.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ASTGenerator.this.ignoredImportSuggestions.add(className);
                    ASTGenerator.this.frmImportSuggest.setVisible(false);
                }
            });
            panelBottom.add(Box.createRigidArea(new Dimension(15, 0)));
            panelBottom.add(btnIgnore);
            this.frmImportSuggest.add(panelTop);
            this.frmImportSuggest.add(panelBottom);
            this.frmImportSuggest.setDefaultCloseOperation(1);
            this.frmImportSuggest.setTitle("Import Suggestion");
            this.frmImportSuggest.setLocation(this.editor.getX() + (this.editor.getWidth() - this.frmImportSuggest.getWidth()) / 2, this.editor.getY() + (this.editor.getHeight() - this.frmImportSuggest.getHeight()) / 2);
            this.hideSuggestion();
            classList.setSelectedIndex(0);
            this.frmImportSuggest.setVisible(true);
        }
    }

    public void disposeAllWindows() {
        ASTGenerator.disposeWindow(this.frmASTView, this.frmImportSuggest, this.frmOccurenceList, this.frmRename);
    }

    public static void disposeWindow(JFrame ... f) {
        JFrame[] jFrameArray = f;
        int n = f.length;
        int n2 = 0;
        while (n2 < n) {
            JFrame jFrame = jFrameArray[n2];
            if (jFrame != null) {
                jFrame.dispose();
            }
            ++n2;
        }
    }

    public static boolean isAddableASTNode(ASTNode node) {
        node.getNodeType();
        return true;
    }

    public int getASTNodeLineStartOffset(ASTNode node) {
        int nodeLineNo = ASTGenerator.getLineNumber(node);
        while (node.getParent() != null) {
            if (ASTGenerator.getLineNumber(node.getParent()) != nodeLineNo) break;
            node = node.getParent();
        }
        return node.getStartPosition();
    }

    public int[] getASTNodeAllOffsets(ASTNode node) {
        int nodeLineNo = ASTGenerator.getLineNumber(node);
        int nodeOffset = node.getStartPosition();
        int nodeLength = node.getLength();
        while (node.getParent() != null) {
            if (ASTGenerator.getLineNumber(node.getParent()) != nodeLineNo) break;
            node = node.getParent();
        }
        return new int[]{nodeLineNo, node.getStartPosition(), nodeOffset, nodeLength};
    }

    protected static String getNodeAsString(ASTNode node) {
        if (node == null) {
            return "NULL";
        }
        String className = node.getClass().getName();
        int index = className.lastIndexOf(".");
        if (index > 0) {
            className = className.substring(index + 1);
        }
        String value = className;
        if (node instanceof TypeDeclaration) {
            value = String.valueOf(((TypeDeclaration)node).getName().toString()) + " | " + className;
        } else if (node instanceof MethodDeclaration) {
            value = String.valueOf(((MethodDeclaration)node).getName().toString()) + " | " + className;
        } else if (node instanceof MethodInvocation) {
            value = String.valueOf(((MethodInvocation)node).getName().toString()) + " | " + className;
        } else if (node instanceof FieldDeclaration) {
            value = String.valueOf(node.toString()) + " FldDecl| ";
        } else if (node instanceof SingleVariableDeclaration) {
            value = ((SingleVariableDeclaration)node).getName() + " - " + ((SingleVariableDeclaration)node).getType() + " | SVD ";
        } else if (node instanceof ExpressionStatement) {
            value = String.valueOf(node.toString()) + className;
        } else if (node instanceof SimpleName) {
            value = String.valueOf(((SimpleName)node).getFullyQualifiedName()) + " | " + className;
        } else if (node instanceof QualifiedName) {
            value = String.valueOf(node.toString()) + " | " + className;
        } else if (node instanceof FieldAccess) {
            value = String.valueOf(node.toString()) + " | ";
        } else if (className.startsWith("Variable")) {
            value = String.valueOf(node.toString()) + " | " + className;
        } else if (className.endsWith("Type")) {
            value = String.valueOf(node.toString()) + " |" + className;
        }
        value = String.valueOf(value) + " [" + node.getStartPosition() + "," + (node.getStartPosition() + node.getLength()) + "]";
        value = String.valueOf(value) + " Line: " + ((CompilationUnit)node.getRoot()).getLineNumber(node.getStartPosition());
        return value;
    }

    protected static String getNodeAsString2(ASTNode node) {
        if (node == null) {
            return "NULL";
        }
        String className = node.getClass().getName();
        int index = className.lastIndexOf(".");
        if (index > 0) {
            className = className.substring(index + 1);
        }
        String value = className;
        if (node instanceof TypeDeclaration) {
            value = ((TypeDeclaration)node).getName().toString();
        } else if (node instanceof MethodDeclaration) {
            value = ((MethodDeclaration)node).getName().toString();
        } else if (node instanceof MethodInvocation) {
            value = String.valueOf(((MethodInvocation)node).getName().toString()) + " | " + className;
        } else if (node instanceof FieldDeclaration) {
            value = node.toString();
        } else if (node instanceof SingleVariableDeclaration) {
            value = ((SingleVariableDeclaration)node).getName().toString();
        } else if (node instanceof ExpressionStatement) {
            value = String.valueOf(node.toString()) + className;
        } else if (node instanceof SimpleName) {
            value = String.valueOf(((SimpleName)node).getFullyQualifiedName()) + " | " + className;
        } else if (node instanceof QualifiedName) {
            value = node.toString();
        } else if (node instanceof VariableDeclarationFragment) {
            value = ((VariableDeclarationFragment)node).getName().toString();
        } else if (className.startsWith("Variable")) {
            value = node.toString();
        } else if (node instanceof VariableDeclarationStatement) {
            value = node.toString();
        } else if (className.endsWith("Type")) {
            value = node.toString();
        }
        return value;
    }

    private static void log(Object object) {
        Messages.log((String)(object == null ? "null" : object.toString()));
    }

    private String getSelectedText() {
        return this.editor.getTextArea().getSelectedText();
    }

    private void hideSuggestion() {
        ((JavaTextArea)this.editor.getTextArea()).hideSuggestion();
    }

    public class ClassMember {
        private Field field;
        private Method method;
        private Constructor<?> cons;
        private Class<?> thisclass;
        private String stringVal;
        private String classType;
        private ASTNode astNode;
        private ASTNode declaringNode;

        public ClassMember(Class<?> m) {
            this.thisclass = m;
            this.stringVal = "Predefined Class " + m.getName();
            this.classType = m.getName();
        }

        public ClassMember(Method m) {
            this.method = m;
            this.stringVal = "Method " + m.getReturnType().getName() + " | " + m.getName() + " defined in " + m.getDeclaringClass().getName();
            this.classType = m.getReturnType().getName();
        }

        public ClassMember(Field m) {
            this.field = m;
            this.stringVal = "Field " + m.getType().getName() + " | " + m.getName() + " defined in " + m.getDeclaringClass().getName();
            this.classType = m.getType().getName();
        }

        public ClassMember(Constructor<?> m) {
            this.cons = m;
            this.stringVal = "Cons  " + m.getName() + " defined in " + m.getDeclaringClass().getName();
        }

        public ClassMember(ASTNode node) {
            SimpleType stp;
            this.astNode = node;
            this.stringVal = ASTGenerator.getNodeAsString(node);
            if (node instanceof TypeDeclaration) {
                this.declaringNode = node;
            }
            if (node instanceof SimpleType) {
                this.classType = ((SimpleType)node).getName().toString();
            }
            SimpleType simpleType = stp = node instanceof SimpleType ? (SimpleType)node : ASTGenerator.extracTypeInfo(node);
            if (stp != null) {
                ASTNode decl = ASTGenerator.findDeclaration(stp.getName());
                if (decl == null) {
                    this.classType = stp.getName().toString();
                    this.thisclass = ASTGenerator.this.findClassIfExists(this.classType);
                } else {
                    this.declaringNode = decl;
                }
            }
        }

        public Class<?> getClass_() {
            return this.thisclass;
        }

        public ASTNode getDeclaringNode() {
            return this.declaringNode;
        }

        public Field getField() {
            return this.field;
        }

        public Method getMethod() {
            return this.method;
        }

        public Constructor<?> getCons() {
            return this.cons;
        }

        public ASTNode getASTNode() {
            return this.astNode;
        }

        public String toString() {
            return this.stringVal;
        }

        public String getTypeAsString() {
            return this.classType;
        }
    }
}

