/*
 * Decompiled with CFR 0.152.
 */
package processing.mode.java.debug;

import java.awt.Color;
import java.util.HashSet;
import java.util.Set;
import processing.mode.java.JavaEditor;
import processing.mode.java.debug.LineID;

public class LineHighlight {
    protected JavaEditor editor;
    protected Color bgColor;
    protected LineID lineID;
    protected String marker;
    protected Color markerColor;
    protected int priority = 0;
    protected static Set<LineHighlight> allHighlights = new HashSet<LineHighlight>();

    public LineHighlight(LineID lineID, Color bgColor, JavaEditor editor) {
        this.lineID = lineID;
        this.bgColor = bgColor;
        this.editor = editor;
        lineID.addListener(this);
        lineID.startTracking(editor.getTab(lineID.fileName()).getDocument());
        this.paint();
        allHighlights.add(this);
    }

    protected static boolean isHighestPriority(LineHighlight hl) {
        for (LineHighlight check : allHighlights) {
            if (!check.getLineID().equals(hl.getLineID()) || check.priority() <= hl.priority()) continue;
            return false;
        }
        return true;
    }

    public void setPriority(int p) {
        this.priority = p;
    }

    public int priority() {
        return this.priority;
    }

    public LineHighlight(int lineIdx, Color bgColor, JavaEditor editor) {
        this(editor.getLineIDInCurrentTab(lineIdx), bgColor, editor);
    }

    public void setMarker(String marker) {
        this.marker = marker;
        this.paint();
    }

    public void setMarker(String marker, Color markerColor) {
        this.markerColor = markerColor;
        this.setMarker(marker);
    }

    public LineID getLineID() {
        return this.lineID;
    }

    public Color getColor() {
        return this.bgColor;
    }

    public boolean isOnLine(LineID testLine) {
        return this.lineID.equals(testLine);
    }

    public void lineChanged(LineID line, int oldLineIdx, int newLineIdx) {
        if (this.editor.isInCurrentTab(new LineID(line.fileName(), oldLineIdx))) {
            this.editor.getJavaTextArea().clearLineBgColor(oldLineIdx);
            this.editor.getJavaTextArea().clearGutterText(oldLineIdx);
        }
        if (LineHighlight.isHighestPriority(this)) {
            this.paint();
        }
    }

    public void dispose() {
        this.lineID.removeListener(this);
        this.lineID.stopTracking();
        allHighlights.remove(this);
    }

    public void paint() {
        if (this.editor.isInCurrentTab(this.lineID)) {
            this.editor.getJavaTextArea().setLineBgColor(this.lineID.lineIdx(), this.bgColor);
            if (this.marker != null) {
                if (this.markerColor != null) {
                    this.editor.getJavaTextArea().setGutterText(this.lineID.lineIdx(), this.marker, this.markerColor);
                } else {
                    this.editor.getJavaTextArea().setGutterText(this.lineID.lineIdx(), this.marker);
                }
            }
        }
    }

    public void clear() {
        if (this.editor.isInCurrentTab(this.lineID)) {
            this.editor.getJavaTextArea().clearLineBgColor(this.lineID.lineIdx());
            this.editor.getJavaTextArea().clearGutterText(this.lineID.lineIdx());
        }
    }
}

