/*
 * Decompiled with CFR 0.152.
 */
package processing.mode.java;

import java.awt.Toolkit;
import java.awt.event.KeyEvent;
import java.util.Arrays;
import processing.app.Preferences;
import processing.app.Sketch;
import processing.app.syntax.JEditTextArea;
import processing.app.syntax.PdeInputHandler;
import processing.app.ui.Editor;

public class JavaInputHandler
extends PdeInputHandler {
    private Editor editor;
    static final int CTRL_ALT = 8 | Toolkit.getDefaultToolkit().getMenuShortcutKeyMask();

    public JavaInputHandler(Editor editor) {
        this.editor = editor;
    }

    public boolean handlePressed(KeyEvent event) {
        char c = event.getKeyChar();
        int code = event.getKeyCode();
        Sketch sketch = this.editor.getSketch();
        JEditTextArea textarea = this.editor.getTextArea();
        if ((event.getModifiers() & 4) != 0) {
            return false;
        }
        if (code == 8 || code == 9 || code == 10 || c >= ' ' && c < '\u0080') {
            sketch.setModified(true);
        }
        if (code == 38 && (event.getModifiers() & 2) != 0) {
            char[] contents = textarea.getText().toCharArray();
            int caretIndex = textarea.getCaretPosition();
            int index = this.calcLineStart(caretIndex - 1, contents);
            index -= 2;
            boolean onlySpaces = true;
            while (index > 0) {
                if (contents[index] == '\n') {
                    if (onlySpaces) {
                        ++index;
                        break;
                    }
                    onlySpaces = true;
                } else if (contents[index] != ' ') {
                    onlySpaces = false;
                }
                --index;
            }
            if (index < 0) {
                index = 0;
            }
            if ((event.getModifiers() & 1) != 0) {
                textarea.setSelectionStart(caretIndex);
                textarea.setSelectionEnd(index);
            } else {
                textarea.setCaretPosition(index);
            }
            event.consume();
        } else if (code == 40 && (event.getModifiers() & 2) != 0) {
            int caretIndex;
            char[] contents = textarea.getText().toCharArray();
            int index = caretIndex = textarea.getCaretPosition();
            int lineStart = 0;
            boolean onlySpaces = false;
            while (index < contents.length) {
                if (contents[index] == '\n') {
                    if (onlySpaces) {
                        index = lineStart;
                        break;
                    }
                    lineStart = index + 1;
                    onlySpaces = true;
                } else if (contents[index] != ' ') {
                    onlySpaces = false;
                }
                ++index;
            }
            if ((event.getModifiers() & 1) != 0) {
                textarea.setSelectionStart(caretIndex);
                textarea.setSelectionEnd(index);
            } else {
                textarea.setCaretPosition(index);
            }
            event.consume();
        } else if (c == '\t') {
            if ((event.getModifiers() & 1) != 0) {
                this.editor.handleOutdent();
            } else if (textarea.isSelectionActive()) {
                this.editor.handleIndent();
            } else if (Preferences.getBoolean((String)"editor.tabs.expand")) {
                int tabSize = Preferences.getInteger((String)"editor.tabs.size");
                textarea.setSelectedText(JavaInputHandler.spaces(tabSize));
                event.consume();
            } else if (!Preferences.getBoolean((String)"editor.tabs.expand")) {
                textarea.setSelectedText("\t");
                event.consume();
            }
        } else if (c == '\n' || c == '\r') {
            if (Preferences.getBoolean((String)"editor.indent")) {
                int sel;
                char[] contents = textarea.getText().toCharArray();
                int tabSize = Preferences.getInteger((String)"editor.tabs.size");
                int origIndex = textarea.getCaretPosition() - 1;
                int spaceCount = this.calcSpaceCount(origIndex, contents);
                int index2 = origIndex;
                while (index2 >= 0 && Character.isWhitespace(contents[index2])) {
                    --index2;
                }
                if (index2 != -1 && contents[index2] == '{') {
                    spaceCount = this.calcSpaceCount(index2, contents);
                    spaceCount += tabSize;
                }
                int index = origIndex + 1;
                int extraCount = 0;
                while (index < contents.length && contents[index] == ' ') {
                    ++extraCount;
                    ++index;
                }
                int braceCount = 0;
                while (index < contents.length && contents[index] != '\n') {
                    if (contents[index] == '}') {
                        ++braceCount;
                    }
                    ++index;
                }
                if ((spaceCount -= extraCount) < 0) {
                    textarea.setSelectionEnd(textarea.getSelectionStop() - spaceCount);
                    textarea.setSelectedText("\n");
                    textarea.setCaretPosition(textarea.getCaretPosition() + extraCount + spaceCount);
                } else {
                    String insertion = "\n" + JavaInputHandler.spaces(spaceCount);
                    textarea.setSelectedText(insertion);
                    textarea.setCaretPosition(textarea.getCaretPosition() + extraCount);
                }
                if (braceCount > 0 && (sel = textarea.getSelectionStart()) - tabSize >= 0) {
                    textarea.select(sel - tabSize, sel);
                    String s = JavaInputHandler.spaces(tabSize);
                    if (textarea.getSelectedText().equals(s)) {
                        textarea.setSelectedText("");
                    } else {
                        textarea.select(sel, sel);
                    }
                }
            } else {
                textarea.setSelectedText(String.valueOf(c));
            }
            event.consume();
        } else if (c == '}' && Preferences.getBoolean((String)"editor.indent")) {
            int prevCharIndex;
            if (textarea.getSelectionStart() != textarea.getSelectionStop()) {
                textarea.setSelectedText("");
            }
            char[] contents = textarea.getText().toCharArray();
            int index = prevCharIndex = textarea.getCaretPosition() - 1;
            boolean finished = false;
            while (index != -1 && !finished) {
                if (contents[index] == '\n') {
                    finished = true;
                    ++index;
                    continue;
                }
                if (contents[index] != ' ') {
                    return false;
                }
                --index;
            }
            if (!finished) {
                return false;
            }
            int lineStartIndex = index;
            int pairedSpaceCount = this.calcBraceIndent(prevCharIndex, contents);
            if (pairedSpaceCount == -1) {
                return false;
            }
            textarea.setSelectionStart(lineStartIndex);
            textarea.setSelectedText(JavaInputHandler.spaces(pairedSpaceCount));
            event.consume();
            return true;
        }
        return false;
    }

    public boolean handleTyped(KeyEvent event) {
        char c = event.getKeyChar();
        if ((event.getModifiers() & 2) != 0) {
            if (c == ',') {
                event.consume();
                return true;
            }
            if (c == ' ') {
                event.consume();
                return true;
            }
        }
        return false;
    }

    protected int calcLineStart(int index, char[] contents) {
        boolean finished = false;
        while (index != -1 && !finished) {
            if (contents[index] == '\n' || contents[index] == '\r') {
                finished = true;
                continue;
            }
            --index;
        }
        return index + 1;
    }

    protected int calcSpaceCount(int index, char[] contents) {
        index = this.calcLineStart(index, contents);
        int spaceCount = 0;
        while (index < contents.length && index >= 0 && contents[index++] == ' ') {
            ++spaceCount;
        }
        return spaceCount;
    }

    protected int calcBraceIndent(int index, char[] contents) {
        int braceDepth = 1;
        boolean finished = false;
        while (index != -1 && !finished) {
            if (contents[index] == '}') {
                ++braceDepth;
                --index;
                continue;
            }
            if (contents[index] == '{') {
                if (--braceDepth == 0) {
                    finished = true;
                }
                --index;
                continue;
            }
            --index;
        }
        if (!finished) {
            return -1;
        }
        return this.calcSpaceCount(index, contents);
    }

    private static String spaces(int count) {
        char[] c = new char[count];
        Arrays.fill(c, ' ');
        return new String(c);
    }
}

