/*
 * Decompiled with CFR 0.152.
 */
package com.android.sdklib.io;

import com.android.annotations.NonNull;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

public class NonClosingInputStream
extends FilterInputStream {
    private final InputStream mInputStream;
    private CloseBehavior mCloseBehavior = CloseBehavior.CLOSE;

    public NonClosingInputStream(@NonNull InputStream inputStream) {
        super(inputStream);
        this.mInputStream = inputStream;
    }

    @NonNull
    public CloseBehavior getCloseBehavior() {
        return this.mCloseBehavior;
    }

    public NonClosingInputStream setCloseBehavior(@NonNull CloseBehavior closeBehavior) {
        this.mCloseBehavior = closeBehavior;
        return this;
    }

    public void close() throws IOException {
        switch (this.mCloseBehavior) {
            case IGNORE: {
                break;
            }
            case RESET: {
                this.mInputStream.reset();
                break;
            }
            case CLOSE: {
                this.mInputStream.close();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum CloseBehavior {
        CLOSE,
        IGNORE,
        RESET;

    }
}

