/*
 * Decompiled with CFR 0.152.
 */
package com.android.sdklib.internal.repository.packages;

import com.android.sdklib.internal.repository.archives.Archive;
import com.android.sdklib.internal.repository.packages.FullRevision;
import com.android.sdklib.internal.repository.packages.IFullRevisionProvider;
import com.android.sdklib.internal.repository.packages.Package;
import com.android.sdklib.internal.repository.packages.PackageParserUtils;
import com.android.sdklib.internal.repository.sources.SdkSource;
import java.util.Map;
import java.util.Properties;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class FullRevisionPackage
extends Package
implements IFullRevisionProvider {
    private final FullRevision mPreviewVersion;

    FullRevisionPackage(SdkSource sdkSource, Node node, String string, Map<String, String> map) {
        super(sdkSource, node, string, map);
        this.mPreviewVersion = PackageParserUtils.parseFullRevisionElement(PackageParserUtils.findChildElement(node, "revision"));
    }

    public FullRevisionPackage(SdkSource sdkSource, Properties properties, int n, String string, String string2, String string3, Archive.Os os, Archive.Arch arch, String string4) {
        super(sdkSource, properties, n, string, string2, string3, os, arch, string4);
        String string5 = FullRevisionPackage.getProperty(properties, "Pkg.Revision", null);
        FullRevision fullRevision = null;
        if (string5 != null) {
            try {
                fullRevision = FullRevision.parseRevision(string5);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (fullRevision == null) {
            fullRevision = new FullRevision(n);
        }
        this.mPreviewVersion = fullRevision;
    }

    @Override
    public FullRevision getRevision() {
        return this.mPreviewVersion;
    }

    @Override
    public void saveProperties(Properties properties) {
        super.saveProperties(properties);
        properties.setProperty("Pkg.Revision", this.mPreviewVersion.toShortString());
    }

    @Override
    public int hashCode() {
        int n = super.hashCode();
        n = 31 * n + (this.mPreviewVersion == null ? 0 : this.mPreviewVersion.hashCode());
        return n;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        if (!(object instanceof FullRevisionPackage)) {
            return false;
        }
        FullRevisionPackage fullRevisionPackage = (FullRevisionPackage)object;
        return !(this.mPreviewVersion == null ? fullRevisionPackage.mPreviewVersion != null : !this.mPreviewVersion.equals(fullRevisionPackage.mPreviewVersion));
    }

    @Override
    public Package.UpdateInfo canBeUpdatedBy(Package package_) {
        if (package_ == null) {
            return Package.UpdateInfo.INCOMPATIBLE;
        }
        if (!this.sameItemAs(package_, true)) {
            return Package.UpdateInfo.INCOMPATIBLE;
        }
        if (!this.getRevision().isPreview() && package_.getRevision().isPreview()) {
            return Package.UpdateInfo.INCOMPATIBLE;
        }
        if (package_.getRevision().compareTo(this.getRevision()) > 0) {
            return Package.UpdateInfo.UPDATE;
        }
        return Package.UpdateInfo.NOT_UPDATE;
    }
}

