/*
 * Decompiled with CFR 0.152.
 */
package com.android.sdklib.internal.build;

import com.google.common.base.Charsets;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SymbolLoader {
    private final File mSymbolFile;
    private Table<String, String, SymbolEntry> mSymbols;

    public SymbolLoader(File file) {
        this.mSymbolFile = file;
    }

    public void load() throws IOException {
        List list = Files.readLines((File)this.mSymbolFile, (Charset)Charsets.UTF_8);
        this.mSymbols = HashBasedTable.create();
        String string = "";
        try {
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                String string2;
                string = string2 = (String)iterator.next();
                int n = string2.indexOf(32);
                String string3 = string2.substring(0, n);
                int n2 = string2.indexOf(32, n + 1);
                String string4 = string2.substring(n + 1, n2);
                int n3 = string2.indexOf(32, n2 + 1);
                String string5 = string2.substring(n2 + 1, n3);
                String string6 = string2.substring(n3 + 1);
                this.mSymbols.put((Object)string4, (Object)string5, (Object)new SymbolEntry(string5, string3, string6));
            }
        }
        catch (Exception exception) {
            throw new IOException("File format error reading " + this.mSymbolFile.getAbsolutePath() + ": " + string, exception);
        }
    }

    Table<String, String, SymbolEntry> getSymbols() {
        return this.mSymbols;
    }

    public static class SymbolEntry {
        private final String mName;
        private final String mType;
        private final String mValue;

        public SymbolEntry(String string, String string2, String string3) {
            this.mName = string;
            this.mType = string2;
            this.mValue = string3;
        }

        public String getValue() {
            return this.mValue;
        }

        public String getName() {
            return this.mName;
        }

        public String getType() {
            return this.mType;
        }
    }
}

