/*
 * Decompiled with CFR 0.152.
 */
package com.android.sdklib.internal.avd;

import com.android.utils.ILogger;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Map;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HardwareProperties {
    public static final String HW_MAINKEYS = "hw.mainKeys";
    public static final String HW_TRACKBALL = "hw.trackBall";
    public static final String HW_KEYBOARD = "hw.keyboard";
    public static final String HW_DPAD = "hw.dPad";
    public static final String HW_GPS = "hw.gps";
    public static final String HW_BATTERY = "hw.battery";
    public static final String HW_ACCELEROMETER = "hw.accelerometer";
    public static final String HW_ORIENTATION_SENSOR = "hw.sensors.orientation";
    public static final String HW_AUDIO_INPUT = "hw.audioInput";
    public static final String HW_SDCARD = "hw.sdCard";
    public static final String HW_LCD_DENSITY = "hw.lcd.density";
    public static final String HW_PROXIMITY_SENSOR = "hw.sensors.proximity";
    private static final Pattern PATTERN_PROP = Pattern.compile("^([a-zA-Z0-9._-]+)\\s*=\\s*(.*)\\s*$");
    private static final String HW_PROP_NAME = "name";
    private static final String HW_PROP_TYPE = "type";
    private static final String HW_PROP_DEFAULT = "default";
    private static final String HW_PROP_ABSTRACT = "abstract";
    private static final String HW_PROP_DESC = "description";
    private static final String HW_PROP_ENUM = "enum";
    public static final String BOOLEAN_YES = "yes";
    public static final String BOOLEAN_NO = "no";
    public static final String[] BOOLEAN_VALUES = new String[]{"yes", "no"};
    public static final Pattern DISKSIZE_PATTERN = Pattern.compile("\\d+[MK]B");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Map<String, HardwareProperty> parseHardwareDefinitions(File file, ILogger iLogger) {
        Object object;
        BufferedReader bufferedReader = null;
        try {
            FileInputStream fileInputStream = new FileInputStream(file);
            bufferedReader = new BufferedReader(new InputStreamReader(fileInputStream));
            TreeMap<String, HardwareProperty> treeMap = new TreeMap<String, HardwareProperty>();
            String string = null;
            HardwareProperty hardwareProperty = null;
            while ((string = bufferedReader.readLine()) != null) {
                String string2;
                if (string.length() <= 0 || string.charAt(0) == '#') continue;
                object = PATTERN_PROP.matcher(string);
                if (((Matcher)object).matches()) {
                    String string3;
                    int n;
                    String[] stringArray;
                    string2 = ((Matcher)object).group(1);
                    String string4 = ((Matcher)object).group(2);
                    if (HW_PROP_NAME.equals(string2)) {
                        hardwareProperty = new HardwareProperty();
                        hardwareProperty.mName = string4;
                        treeMap.put(hardwareProperty.mName, hardwareProperty);
                    }
                    if (hardwareProperty == null) {
                        iLogger.warning("Error parsing '%1$s': missing '%2$s'", new Object[]{file.getAbsolutePath(), HW_PROP_NAME});
                        stringArray = null;
                        return stringArray;
                    }
                    if (HW_PROP_TYPE.equals(string2)) {
                        hardwareProperty.mType = HardwarePropertyType.getEnum(string4, false);
                        if ($assertionsDisabled || hardwareProperty.mType != null) continue;
                        throw new AssertionError();
                    }
                    if (HW_PROP_DEFAULT.equals(string2)) {
                        hardwareProperty.mDefault = string4;
                        continue;
                    }
                    if (HW_PROP_ABSTRACT.equals(string2)) {
                        hardwareProperty.mAbstract = string4;
                        continue;
                    }
                    if (HW_PROP_DESC.equals(string2)) {
                        hardwareProperty.mDescription = string4;
                        continue;
                    }
                    if (!HW_PROP_ENUM.equals(string2)) continue;
                    if (!hardwareProperty.mType.isEnum()) {
                        hardwareProperty.mType = HardwarePropertyType.getEnum(hardwareProperty.mType.getName(), true);
                        assert (hardwareProperty.mType != null);
                    }
                    stringArray = string4.split(",");
                    int n2 = 0;
                    for (n = 0; n < stringArray.length; ++n) {
                        stringArray[n] = stringArray[n].trim();
                        string3 = stringArray[n];
                        if (string3.length() <= 0) continue;
                        ++n2;
                    }
                    HardwareProperty.access$502(hardwareProperty, new String[n2]);
                    n2 = 0;
                    for (n = 0; n < stringArray.length; ++n) {
                        string3 = stringArray[n];
                        if (string3.length() <= 0) continue;
                        ((HardwareProperty)hardwareProperty).mEnum[n2++] = string3;
                    }
                    continue;
                }
                iLogger.warning("Error parsing '%1$s': \"%2$s\" is not a valid syntax", new Object[]{file.getAbsolutePath(), string});
                string2 = null;
                return string2;
            }
            object = treeMap;
        }
        catch (FileNotFoundException fileNotFoundException) {
            return null;
        }
        catch (IOException iOException) {
            iLogger.warning("Error parsing '%1$s': %2$s.", new Object[]{file.getAbsolutePath(), iOException.getMessage()});
            return null;
        }
        finally {
            if (bufferedReader != null) {
                try {
                    bufferedReader.close();
                }
                catch (IOException iOException) {}
            }
        }
        return object;
    }

    public static int getBooleanValueIndex(String string) {
        if (BOOLEAN_YES.equals(string)) {
            return 0;
        }
        if (BOOLEAN_NO.equals(string)) {
            return 1;
        }
        return -1;
    }

    public static final class HardwareProperty {
        private String mName = "";
        private HardwarePropertyType mType;
        private String mDefault = "";
        private String[] mEnum;
        private String mAbstract = "";
        private String mDescription = "";

        public String getName() {
            return this.mName;
        }

        public HardwarePropertyType getType() {
            return this.mType;
        }

        public String getDefault() {
            return this.mDefault;
        }

        public String getAbstract() {
            return this.mAbstract;
        }

        public String getDescription() {
            return this.mDescription;
        }

        public String[] getEnum() {
            return this.mEnum;
        }

        public boolean isValidForUi() {
            return this.mType != HardwarePropertyType.STRING || this.mType.isEnum();
        }

        static /* synthetic */ String[] access$502(HardwareProperty hardwareProperty, String[] stringArray) {
            hardwareProperty.mEnum = stringArray;
            return stringArray;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum HardwarePropertyType {
        INTEGER("integer", false),
        BOOLEAN("boolean", false),
        DISKSIZE("diskSize", false),
        STRING("string", false),
        INTEGER_ENUM("integer", true),
        STRING_ENUM("string", true);

        private String mName;
        private boolean mIsEnum;

        private HardwarePropertyType(String string2, boolean bl) {
            this.mName = string2;
            this.mIsEnum = bl;
        }

        public String getName() {
            return this.mName;
        }

        public boolean isEnum() {
            return this.mIsEnum;
        }

        public static HardwarePropertyType getEnum(String string, boolean bl) {
            for (HardwarePropertyType hardwarePropertyType : HardwarePropertyType.values()) {
                if (!hardwarePropertyType.mName.equals(string) || hardwarePropertyType.mIsEnum != bl) continue;
                return hardwarePropertyType;
            }
            return null;
        }
    }
}

