/*
 * Decompiled with CFR 0.152.
 */
package com.android.sdklib;

import com.android.SdkConstants;
import com.android.sdklib.AndroidVersion;
import com.android.sdklib.IAndroidTarget;
import com.android.sdklib.ISystemImage;
import com.android.sdklib.SdkManager;
import com.android.sdklib.io.FileOp;
import java.io.File;
import java.util.Locale;

public class SystemImage
implements ISystemImage {
    public static final String ANDROID_PREFIX = "android-";
    private final ISystemImage.LocationType mLocationtype;
    private final String mAbiType;
    private final File mLocation;

    public SystemImage(File file, ISystemImage.LocationType locationType, String string) {
        this.mLocation = file;
        this.mLocationtype = locationType;
        this.mAbiType = string;
    }

    public SystemImage(SdkManager sdkManager, IAndroidTarget iAndroidTarget, ISystemImage.LocationType locationType, String string) {
        this.mLocationtype = locationType;
        this.mAbiType = string;
        File file = null;
        switch (locationType) {
            case IN_PLATFORM_LEGACY: {
                file = new File(iAndroidTarget.getLocation(), SdkConstants.OS_IMAGES_FOLDER);
                break;
            }
            case IN_PLATFORM_SUBFOLDER: {
                file = FileOp.append(iAndroidTarget.getLocation(), SdkConstants.OS_IMAGES_FOLDER, string);
                break;
            }
            case IN_SYSTEM_IMAGE: {
                if (!iAndroidTarget.isPlatform()) {
                    throw new IllegalArgumentException("Add-ons do not support the system-image location type");
                }
                file = SystemImage.getCanonicalFolder(sdkManager.getLocation(), iAndroidTarget.getVersion(), string);
                break;
            }
            default: {
                assert (false) : "SystemImage used with an incorrect locationType";
                break;
            }
        }
        this.mLocation = file;
    }

    public static File getCanonicalFolder(String string, AndroidVersion androidVersion, String string2) {
        File file = FileOp.append(string, "system-images", ANDROID_PREFIX + androidVersion.getApiString());
        if (string2 == null) {
            return file;
        }
        return FileOp.append(file, string2);
    }

    public File getLocation() {
        return this.mLocation;
    }

    public ISystemImage.LocationType getLocationType() {
        return this.mLocationtype;
    }

    public String getAbiType() {
        return this.mAbiType;
    }

    public int compareTo(ISystemImage iSystemImage) {
        return this.getAbiType().compareToIgnoreCase(iSystemImage.getAbiType());
    }

    public String toString() {
        return String.format("SystemImage ABI=%s, location %s='%s'", this.mAbiType, this.mLocationtype.toString().replace('_', ' ').toLowerCase(Locale.US), this.mLocation);
    }
}

