/*
 * Decompiled with CFR 0.152.
 */
package processing.core;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.content.res.AssetManager;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Rect;
import android.graphics.Typeface;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.support.annotation.LayoutRes;
import android.view.ContextMenu;
import android.view.LayoutInflater;
import android.view.Menu;
import android.view.MenuInflater;
import android.view.MenuItem;
import android.view.MotionEvent;
import android.view.SurfaceHolder;
import android.view.View;
import android.view.ViewGroup;
import android.view.inputmethod.InputMethodManager;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import processing.a2d.PGraphicsAndroid2D;
import processing.android.ActivityAPI;
import processing.android.AppComponent;
import processing.android.CompatUtils;
import processing.core.PConstants;
import processing.core.PFont;
import processing.core.PGraphics;
import processing.core.PImage;
import processing.core.PMatrix;
import processing.core.PMatrix2D;
import processing.core.PMatrix3D;
import processing.core.PShape;
import processing.core.PStyle;
import processing.core.PSurface;
import processing.data.JSONArray;
import processing.data.JSONObject;
import processing.data.StringList;
import processing.data.Table;
import processing.data.XML;
import processing.event.Event;
import processing.event.KeyEvent;
import processing.event.MouseEvent;
import processing.event.TouchEvent;
import processing.opengl.PGL;
import processing.opengl.PGraphics2D;
import processing.opengl.PGraphics3D;
import processing.opengl.PGraphicsOpenGL;
import processing.opengl.PShader;

public class PApplet
implements ActivityAPI,
PConstants {
    public static final boolean DEBUG = false;
    public static final int SDK = Build.VERSION.SDK_INT;
    protected PSurface surface;
    @LayoutRes
    public int parentLayout = -1;
    public PGraphics g;
    public int displayWidth;
    public int displayHeight;
    public String sketchPath;
    public static final int DEFAULT_WIDTH = -1;
    public static final int DEFAULT_HEIGHT = -1;
    protected boolean surfaceChanged;
    public int[] pixels;
    public int width = -1;
    public int height = -1;
    public float displayDensity = 1.0f;
    public int pixelDensity = 1;
    public int pixelWidth;
    public int pixelHeight;
    public int mouseX;
    public int mouseY;
    public int pmouseX;
    public int pmouseY;
    public boolean mousePressed;
    public boolean touchIsStarted;
    public TouchEvent.Pointer[] touches = new TouchEvent.Pointer[0];
    protected int dmouseX;
    protected int dmouseY;
    protected int emouseX;
    protected int emouseY;
    protected int mousePointerId;
    protected int touchPointerId;
    public char key;
    public int keyCode;
    public boolean keyPressed;
    public boolean focused = false;
    protected boolean keyRepeatEnabled = false;
    boolean keyboardIsOpen = false;
    public boolean handledBackPressed = true;
    protected HashMap<String, String> permissionMethods = new HashMap();
    protected ArrayList<String> reqPermissions = new ArrayList();
    long millisOffset = System.currentTimeMillis();
    protected boolean insideDraw;
    protected long frameRateLastNanos = 0L;
    public float frameRate = 10.0f;
    protected boolean looping;
    protected boolean redraw;
    public int frameCount;
    public boolean finished;
    protected boolean exitCalled;
    boolean insideSettings;
    String renderer = "processing.core.PGraphicsAndroid2D";
    int smooth = 1;
    boolean fullScreen = false;
    int display = -1;
    int windowColor = -2236963;
    static final String ERROR_MIN_MAX = "Cannot use min() or max() on an empty array.";
    public static final String ARGS_EDITOR_LOCATION = "--editor-location";
    public static final String ARGS_EXTERNAL = "--external";
    public static final String ARGS_LOCATION = "--location";
    public static final String ARGS_DISPLAY = "--display";
    public static final String ARGS_BGCOLOR = "--bgcolor";
    public static final String ARGS_PRESENT = "--present";
    public static final String ARGS_EXCLUSIVE = "--exclusive";
    public static final String ARGS_STOP_COLOR = "--stop-color";
    public static final String ARGS_HIDE_STOP = "--hide-stop";
    public static final String ARGS_SKETCH_FOLDER = "--sketch-path";
    public static final String EXTERNAL_STOP = "__STOP__";
    public static final String EXTERNAL_MOVE = "__MOVE__";
    boolean external = false;
    HashMap<String, RegisteredMethods> registerMap = new HashMap();
    private boolean requestedNoLoop = false;
    InternalEventQueue eventQueue = new InternalEventQueue();
    Random internalRandom;
    static final int PERLIN_YWRAPB = 4;
    static final int PERLIN_YWRAP = 16;
    static final int PERLIN_ZWRAPB = 8;
    static final int PERLIN_ZWRAP = 256;
    static final int PERLIN_SIZE = 4095;
    int perlin_octaves = 4;
    float perlin_amp_falloff = 0.5f;
    int perlin_TWOPI;
    int perlin_PI;
    float[] perlin_cosTable;
    float[] perlin;
    Random perlinRandom;
    public int requestImageMax = 4;
    volatile int requestImageCount;
    protected static HashMap<String, Pattern> matchPatterns;
    private static NumberFormat int_nf;
    private static int int_nf_digits;
    private static boolean int_nf_commas;
    private static NumberFormat float_nf;
    private static int float_nf_left;
    private static int float_nf_right;
    private static boolean float_nf_commas;
    public static final byte[] ICON_IMAGE;

    public PSurface getSurface() {
        return this.surface;
    }

    public Context getContext() {
        return this.surface.getContext();
    }

    public Activity getActivity() {
        return this.surface.getActivity();
    }

    public void initSurface(AppComponent component, SurfaceHolder holder) {
        this.parentLayout = -1;
        this.initSurface(null, null, null, component, holder);
    }

    public void initSurface(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState, AppComponent component, SurfaceHolder holder) {
        component.initDimensions();
        this.displayWidth = component.getDisplayWidth();
        this.displayHeight = component.getDisplayHeight();
        this.displayDensity = component.getDisplayDensity();
        this.handleSettings();
        boolean parentSize = false;
        if (this.parentLayout == -1) {
            if (this.fullScreen || this.width == -1 || this.height == -1) {
                this.width = this.displayWidth;
                this.height = this.displayHeight;
            }
        } else if (this.fullScreen || this.width == -1 || this.height == -1) {
            this.width = 100;
            this.height = 100;
            parentSize = true;
        }
        this.pixelWidth = this.width * this.pixelDensity;
        this.pixelHeight = this.height * this.pixelDensity;
        String rendererName = this.sketchRenderer();
        this.g = this.makeGraphics(this.width, this.height, rendererName, true);
        this.surface = this.g.createSurface(component, holder, false);
        if (this.parentLayout == -1) {
            this.setFullScreenVisibility();
            this.surface.initView(this.width, this.height);
        } else {
            this.surface.initView(this.width, this.height, parentSize, inflater, container, savedInstanceState);
        }
        this.finished = false;
        this.looping = true;
        this.redraw = true;
        this.sketchPath = this.surface.getFilesDir().getAbsolutePath();
        this.surface.startThread();
    }

    private void setFullScreenVisibility() {
        if (this.fullScreen) {
            this.runOnUiThread(new Runnable(){

                @Override
                public void run() {
                    int visibility = SDK < 19 ? 2 : 5894;
                    PApplet.this.surface.setSystemUiVisibility(visibility);
                }
            });
        }
    }

    @Override
    public void onResume() {
        if (this.parentLayout == -1) {
            this.setFullScreenVisibility();
        }
        if (this.g != null) {
            this.g.restoreState();
        }
        this.handleMethods("resume");
        if (0 < this.frameCount) {
            this.resume();
        }
        this.handledBackPressed = true;
        this.surface.resumeThread();
    }

    @Override
    public void onPause() {
        this.surface.pauseThread();
        this.closeKeyboard();
        if (this.g != null) {
            this.g.saveState();
        }
        this.handleMethods("pause");
        this.pause();
    }

    @Override
    public void onStart() {
        this.start();
    }

    @Override
    public void onStop() {
        this.stop();
    }

    @Override
    public void onCreate(Bundle savedInstanceState) {
        this.create();
    }

    @Override
    public void onDestroy() {
        this.handleMethods("onDestroy");
        this.dispose();
    }

    @Override
    public void onActivityResult(int requestCode, int resultCode, Intent data) {
        this.handleMethods("onActivityResult", new Object[]{requestCode, resultCode, data});
    }

    @Override
    public void onNewIntent(Intent intent) {
        this.handleMethods("onNewIntent", new Object[]{intent});
    }

    @Override
    public void onCreateOptionsMenu(Menu menu, MenuInflater inflater) {
    }

    @Override
    public boolean onOptionsItemSelected(MenuItem item) {
        return false;
    }

    @Override
    public void onCreateContextMenu(ContextMenu menu, View v, ContextMenu.ContextMenuInfo menuInfo) {
    }

    @Override
    public boolean onContextItemSelected(MenuItem item) {
        return false;
    }

    @Override
    public void setHasOptionsMenu(boolean hasMenu) {
        this.surface.setHasOptionsMenu(hasMenu);
    }

    @Override
    public void onBackPressed() {
        this.handledBackPressed = false;
    }

    public void startActivity(Intent intent) {
        this.surface.startActivity(intent);
    }

    public void runOnUiThread(Runnable action) {
        this.surface.runOnUiThread(action);
    }

    public boolean hasPermission(String permission) {
        return this.surface.hasPermission(permission);
    }

    public void requestPermission(String permission) {
        if (!this.hasPermission(permission)) {
            this.reqPermissions.add(permission);
        }
    }

    public void requestPermission(String permission, String callback) {
        this.requestPermission(permission, callback, this);
    }

    public void requestPermission(String permission, String callback, Object target) {
        this.registerWithArgs(callback, target, new Class[]{Boolean.TYPE});
        if (this.hasPermission(permission)) {
            this.handleMethods(callback, new Object[]{true});
        } else {
            this.permissionMethods.put(permission, callback);
            this.reqPermissions.add(permission);
        }
    }

    public void onRequestPermissionsResult(int requestCode, String[] permissions, int[] grantResults) {
        if (requestCode == 1) {
            for (int i = 0; i < grantResults.length; ++i) {
                boolean granted = grantResults[i] == 0;
                this.handlePermissionsResult(permissions[i], granted);
            }
        }
    }

    private void handlePermissionsResult(String permission, final boolean granted) {
        String methodName = this.permissionMethods.get(permission);
        final RegisteredMethods meth = this.registerMap.get(methodName);
        if (meth != null) {
            Handler handler = new Handler(Looper.getMainLooper());
            handler.post(new Runnable(){

                @Override
                public void run() {
                    meth.handle(new Object[]{granted});
                }
            });
        }
    }

    private void handlePermissions() {
        if (0 < this.reqPermissions.size()) {
            String[] req = this.reqPermissions.toArray(new String[this.reqPermissions.size()]);
            this.surface.requestPermissions(req);
            this.reqPermissions.clear();
        }
    }

    boolean insideSettings(String method, Object ... args) {
        if (this.insideSettings) {
            return true;
        }
        String url = "https://processing.org/reference/" + method + "_.html";
        if (!this.external) {
            StringList argList = new StringList(args);
            System.err.println("When not using the PDE, " + method + "() can only be used inside settings().");
            System.err.println("Remove the " + method + "() method from setup(), and add the following:");
            System.err.println("public void settings() {");
            System.err.println("  " + method + "(" + argList.join(", ") + ");");
            System.err.println("}");
        }
        throw new IllegalStateException(method + "() cannot be used here, see " + url);
    }

    void handleSettings() {
        this.insideSettings = true;
        this.settings();
        this.insideSettings = false;
    }

    public void settings() {
    }

    public final int sketchWidth() {
        return this.width;
    }

    public final int sketchHeight() {
        return this.height;
    }

    public final String sketchRenderer() {
        return this.renderer;
    }

    public int sketchSmooth() {
        return this.smooth;
    }

    public final boolean sketchFullScreen() {
        return this.fullScreen;
    }

    public final int sketchDisplay() {
        return this.display;
    }

    public final String sketchOutputPath() {
        return null;
    }

    public final OutputStream sketchOutputStream() {
        return null;
    }

    public final int sketchWindowColor() {
        return this.windowColor;
    }

    public final int sketchPixelDensity() {
        return this.pixelDensity;
    }

    public void surfaceChanged() {
        this.surfaceChanged = true;
    }

    public void surfaceWindowFocusChanged(boolean hasFocus) {
        this.focused = hasFocus;
        if (this.focused) {
            this.focusGained();
        } else {
            this.focusLost();
        }
    }

    public boolean surfaceTouchEvent(MotionEvent event) {
        this.nativeMotionEvent(event);
        return true;
    }

    public void surfaceKeyDown(int code, android.view.KeyEvent event) {
        this.nativeKeyEvent(event);
    }

    public void surfaceKeyUp(int code, android.view.KeyEvent event) {
        this.nativeKeyEvent(event);
    }

    public void start() {
    }

    public void stop() {
    }

    public void pause() {
    }

    public void resume() {
    }

    public void registerMethod(String methodName, Object target) {
        if (methodName.equals("mouseEvent")) {
            this.registerWithArgs("mouseEvent", target, new Class[]{MouseEvent.class});
        } else if (methodName.equals("keyEvent")) {
            this.registerWithArgs("keyEvent", target, new Class[]{KeyEvent.class});
        } else if (methodName.equals("touchEvent")) {
            this.registerWithArgs("touchEvent", target, new Class[]{TouchEvent.class});
        } else if (methodName.equals("onDestroy")) {
            this.registerNoArgs(methodName, target);
        } else if (methodName.equals("onActivityResult")) {
            this.registerWithArgs("onActivityResult", target, new Class[]{Integer.TYPE, Integer.TYPE, Intent.class});
        } else if (methodName.equals("onNewIntent")) {
            this.registerWithArgs("onNewIntent", target, new Class[]{Intent.class});
        } else {
            this.registerNoArgs(methodName, target);
        }
    }

    private void registerNoArgs(String name, Object o) {
        RegisteredMethods meth = this.registerMap.get(name);
        if (meth == null) {
            meth = new RegisteredMethods();
            this.registerMap.put(name, meth);
        }
        Class<?> c = o.getClass();
        try {
            Method method = c.getMethod(name, new Class[0]);
            meth.add(o, method);
        }
        catch (NoSuchMethodException nsme) {
            this.die("There is no public " + name + "() method in the class " + o.getClass().getName());
        }
        catch (Exception e) {
            this.die("Could not register " + name + " + () for " + o, e);
        }
    }

    private void registerWithArgs(String name, Object o, Class<?>[] cargs) {
        RegisteredMethods meth = this.registerMap.get(name);
        if (meth == null) {
            meth = new RegisteredMethods();
            this.registerMap.put(name, meth);
        }
        Class<?> c = o.getClass();
        try {
            Method method = c.getMethod(name, cargs);
            meth.add(o, method);
        }
        catch (NoSuchMethodException nsme) {
            this.die("There is no public " + name + "() method in the class " + o.getClass().getName());
        }
        catch (Exception e) {
            this.die("Could not register " + name + " + () for " + o, e);
        }
    }

    public void unregisterMethod(String name, Object target) {
        RegisteredMethods meth = this.registerMap.get(name);
        if (meth == null) {
            this.die("No registered methods with the name " + name + "() were found.");
        }
        try {
            meth.remove(target);
        }
        catch (Exception e) {
            this.die("Could not unregister " + name + "() for " + target, e);
        }
    }

    protected void handleMethods(String methodName) {
        RegisteredMethods meth = this.registerMap.get(methodName);
        if (meth != null) {
            meth.handle();
        }
    }

    protected void handleMethods(String methodName, final Object[] args) {
        final RegisteredMethods meth = this.registerMap.get(methodName);
        if (meth != null) {
            Handler handler = new Handler(Looper.getMainLooper());
            handler.post(new Runnable(){

                @Override
                public void run() {
                    meth.handle(args);
                }
            });
        }
    }

    @Deprecated
    public void registerSize(Object o) {
        System.err.println("The registerSize() command is no longer supported.");
    }

    @Deprecated
    public void registerPre(Object o) {
        this.registerNoArgs("pre", o);
    }

    @Deprecated
    public void registerDraw(Object o) {
        this.registerNoArgs("draw", o);
    }

    @Deprecated
    public void registerPost(Object o) {
        this.registerNoArgs("post", o);
    }

    @Deprecated
    public void registerDispose(Object o) {
        this.registerNoArgs("dispose", o);
    }

    @Deprecated
    public void unregisterSize(Object o) {
        System.err.println("The unregisterSize() command is no longer supported.");
    }

    @Deprecated
    public void unregisterPre(Object o) {
        this.unregisterMethod("pre", o);
    }

    @Deprecated
    public void unregisterDraw(Object o) {
        this.unregisterMethod("draw", o);
    }

    @Deprecated
    public void unregisterPost(Object o) {
        this.unregisterMethod("post", o);
    }

    @Deprecated
    public void unregisterDispose(Object o) {
        this.unregisterMethod("dispose", o);
    }

    public void setup() {
    }

    public void calculate() {
    }

    public void draw() {
        this.finished = true;
    }

    public void fullScreen() {
        if (!this.fullScreen && this.insideSettings("fullScreen", new Object[0])) {
            this.fullScreen = true;
        }
    }

    public void fullScreen(int display) {
        if (!this.fullScreen && this.insideSettings("fullScreen", display)) {
            this.fullScreen = true;
        }
    }

    public void fullScreen(String renderer) {
        if (!(this.fullScreen && renderer.equals(this.renderer) || !this.insideSettings("fullScreen", renderer))) {
            this.fullScreen = true;
            this.renderer = renderer;
        }
    }

    public void fullScreen(String renderer, int display) {
        if (!(this.fullScreen && renderer.equals(this.renderer) || !this.insideSettings("fullScreen", renderer, display))) {
            this.fullScreen = true;
            this.renderer = renderer;
        }
    }

    public void size(int iwidth, int iheight) {
        if ((iwidth != this.width || iheight != this.height) && this.insideSettings("size", iwidth, iheight)) {
            this.width = iwidth;
            this.height = iheight;
        }
    }

    public void size(int iwidth, int iheight, String irenderer) {
        if ((iwidth != this.width || iheight != this.height || !this.renderer.equals(irenderer)) && this.insideSettings("size", iwidth, iheight, irenderer)) {
            this.width = iwidth;
            this.height = iheight;
            this.renderer = irenderer;
        }
    }

    public void setSize(int width, int height) {
        if (this.fullScreen) {
            this.displayWidth = width;
            this.displayHeight = height;
        }
        this.width = width;
        this.height = height;
        this.pixelWidth = width * this.pixelDensity;
        this.pixelHeight = height * this.pixelDensity;
    }

    public void setExternal(boolean external) {
        this.external = external;
    }

    public void smooth() {
        this.smooth(1);
    }

    public void smooth(int level) {
        if (this.insideSettings) {
            this.smooth = level;
        } else if (this.smooth != level) {
            this.smoothWarning("smooth");
        }
    }

    public void noSmooth() {
        if (this.insideSettings) {
            this.smooth = 0;
        } else if (this.smooth != 0) {
            this.smoothWarning("noSmooth");
        }
    }

    private void smoothWarning(String method) {
        String where = this.external ? "setup" : "settings";
        PGraphics.showWarning("%s() can only be used inside %s()", method, where);
    }

    public PGraphics getGraphics() {
        return this.g;
    }

    public void orientation(int which) {
        this.surface.setOrientation(which);
    }

    public void size(int iwidth, int iheight, String irenderer, String ipath) {
        if ((iwidth != this.width || iheight != this.height || !this.renderer.equals(irenderer)) && this.insideSettings("size", iwidth, iheight, irenderer, ipath)) {
            this.width = iwidth;
            this.height = iheight;
            this.renderer = irenderer;
        }
    }

    public PGraphics createGraphics(int iwidth, int iheight) {
        return this.createGraphics(iwidth, iheight, "processing.core.PGraphicsAndroid2D");
    }

    public PGraphics createGraphics(int iwidth, int iheight, String irenderer) {
        return this.makeGraphics(iwidth, iheight, irenderer, false);
    }

    protected PGraphics makeGraphics(int w, int h, String renderer, boolean primary) {
        PGraphics pg = null;
        if (renderer.equals("processing.core.PGraphicsAndroid2D")) {
            pg = new PGraphicsAndroid2D();
        } else if (renderer.equals("processing.opengl.PGraphics2D")) {
            if (!primary && !this.g.isGL()) {
                throw new RuntimeException("createGraphics() with P2D requires size() to use P2D or P3D");
            }
            pg = new PGraphics2D();
        } else if (renderer.equals("processing.opengl.PGraphics3D")) {
            if (!primary && !this.g.isGL()) {
                throw new RuntimeException("createGraphics() with P3D or OPENGL requires size() to use P2D or P3D");
            }
            pg = new PGraphics3D();
        } else {
            Class<?> rendererClass = null;
            Constructor<?> constructor = null;
            try {
                rendererClass = Thread.currentThread().getContextClassLoader().loadClass(renderer);
            }
            catch (ClassNotFoundException cnfe) {
                throw new RuntimeException("Missing renderer class");
            }
            if (rendererClass != null) {
                try {
                    constructor = rendererClass.getConstructor(new Class[0]);
                }
                catch (NoSuchMethodException nsme) {
                    throw new RuntimeException("Missing renderer constructor");
                }
                if (constructor != null) {
                    try {
                        pg = (PGraphics)constructor.newInstance(new Object[0]);
                    }
                    catch (InvocationTargetException e) {
                        this.printStackTrace(e);
                        throw new RuntimeException(e.getMessage());
                    }
                    catch (IllegalAccessException e) {
                        this.printStackTrace(e);
                        throw new RuntimeException(e.getMessage());
                    }
                    catch (InstantiationException e) {
                        this.printStackTrace(e);
                        throw new RuntimeException(e.getMessage());
                    }
                    catch (IllegalArgumentException e) {
                        this.printStackTrace(e);
                    }
                }
            }
        }
        pg.setParent(this);
        pg.setPrimary(primary);
        ((PGraphics)pg).setSize(w, h);
        return pg;
    }

    public PImage createImage(int wide, int high, int format) {
        PImage image = new PImage(wide, high, format);
        image.parent = this;
        return image;
    }

    public void handleDraw() {
        if (this.g == null) {
            return;
        }
        if (!this.surfaceChanged && this.parentLayout != -1) {
            return;
        }
        if (!this.looping && !this.redraw) {
            return;
        }
        if (this.insideDraw) {
            System.err.println("handleDraw() called before finishing");
            System.exit(1);
        }
        this.insideDraw = true;
        this.g.beginDraw();
        if (this.requestedNoLoop) {
            this.looping = false;
            this.requestedNoLoop = false;
            this.g.endDraw();
            this.insideDraw = false;
            return;
        }
        long now = System.nanoTime();
        if (this.frameCount == 0) {
            this.setup();
        } else {
            double rate = 1000000.0 / ((double)(now - this.frameRateLastNanos) / 1000000.0);
            float instantaneousRate = (float)(rate / 1000.0);
            this.frameRate = this.frameRate * 0.9f + instantaneousRate * 0.1f;
            if (this.frameCount != 0) {
                this.handleMethods("pre");
            }
            this.pmouseX = this.dmouseX;
            this.pmouseY = this.dmouseY;
            this.draw();
            this.dmouseX = this.mouseX;
            this.dmouseY = this.mouseY;
            this.dequeueEvents();
            this.handleMethods("draw");
            this.handlePermissions();
            this.redraw = false;
        }
        this.g.endDraw();
        this.insideDraw = false;
        if (this.frameCount != 0) {
            this.handleMethods("post");
        }
        this.frameRateLastNanos = now;
        ++this.frameCount;
    }

    public synchronized void redraw() {
        if (!this.looping) {
            this.redraw = true;
        }
    }

    public synchronized void loop() {
        if (!this.looping) {
            this.looping = true;
        }
    }

    public synchronized void noLoop() {
        if (this.looping) {
            if (this.g instanceof PGraphicsOpenGL) {
                this.requestedNoLoop = true;
            } else {
                this.looping = false;
            }
        }
    }

    public boolean isLooping() {
        return this.looping;
    }

    public void postEvent(Event pe) {
        this.eventQueue.add(pe);
        if (!this.looping) {
            this.dequeueEvents();
        }
    }

    protected void dequeueEvents() {
        while (this.eventQueue.available()) {
            Event e = this.eventQueue.remove();
            switch (e.getFlavor()) {
                case 3: {
                    this.handleTouchEvent((TouchEvent)e);
                    break;
                }
                case 2: {
                    this.handleMouseEvent((MouseEvent)e);
                    break;
                }
                case 1: {
                    this.handleKeyEvent((KeyEvent)e);
                }
            }
        }
    }

    protected void handleMouseEvent(MouseEvent event) {
        if (event.getAction() == 4 || event.getAction() == 5) {
            this.pmouseX = this.emouseX;
            this.pmouseY = this.emouseY;
            this.mouseX = event.getX();
            this.mouseY = event.getY();
        }
        if (event.getAction() == 1) {
            this.mouseX = event.getX();
            this.mouseY = event.getY();
            this.pmouseX = this.mouseX;
            this.pmouseY = this.mouseY;
            this.dmouseX = this.mouseX;
            this.dmouseY = this.mouseY;
        }
        switch (event.getAction()) {
            case 1: {
                this.mousePressed = true;
                break;
            }
            case 2: {
                this.mousePressed = false;
            }
        }
        this.handleMethods("mouseEvent", new Object[]{event});
        switch (event.getAction()) {
            case 1: {
                this.mousePressed(event);
                break;
            }
            case 2: {
                this.mouseReleased(event);
                break;
            }
            case 3: {
                this.mouseClicked(event);
                break;
            }
            case 4: {
                this.mouseDragged(event);
                break;
            }
            case 5: {
                this.mouseMoved(event);
                break;
            }
            case 6: {
                this.mouseEntered(event);
                break;
            }
            case 7: {
                this.mouseExited(event);
            }
        }
        if (event.getAction() == 4 || event.getAction() == 5) {
            this.emouseX = this.mouseX;
            this.emouseY = this.mouseY;
        }
        if (event.getAction() == 1) {
            this.emouseX = this.mouseX;
            this.emouseY = this.mouseY;
        }
    }

    protected void handleTouchEvent(TouchEvent event) {
        this.touches = event.getTouches(this.touches);
        switch (event.getAction()) {
            case 1: {
                this.touchIsStarted = true;
                break;
            }
            case 2: {
                this.touchIsStarted = false;
            }
        }
        this.handleMethods("touchEvent", new Object[]{event});
        switch (event.getAction()) {
            case 1: {
                this.touchStarted(event);
                break;
            }
            case 2: {
                this.touchEnded(event);
                break;
            }
            case 4: {
                this.touchMoved(event);
                break;
            }
            case 3: {
                this.touchCancelled(event);
            }
        }
    }

    protected void nativeMotionEvent(MotionEvent motionEvent) {
        int button;
        int metaState = motionEvent.getMetaState();
        int modifiers = 0;
        if ((metaState & 1) != 0) {
            modifiers |= 1;
        }
        if ((metaState & 0x1000) != 0) {
            modifiers |= 2;
        }
        if ((metaState & 0x10000) != 0) {
            modifiers |= 4;
        }
        if ((metaState & 2) != 0) {
            modifiers |= 8;
        }
        int state = motionEvent.getButtonState();
        switch (state) {
            case 1: {
                button = 21;
                break;
            }
            case 2: {
                button = 22;
                break;
            }
            case 4: {
                button = 3;
                break;
            }
            default: {
                button = state;
            }
        }
        this.enqueueMouseEvents(motionEvent, button, modifiers);
        this.enqueueTouchEvents(motionEvent, button, modifiers);
    }

    protected void enqueueTouchEvents(MotionEvent event, int button, int modifiers) {
        int action = event.getAction();
        int actionMasked = action & 0xFF;
        int paction = 0;
        switch (actionMasked) {
            case 0: {
                paction = 1;
                break;
            }
            case 5: {
                paction = 1;
                break;
            }
            case 2: {
                paction = 4;
                break;
            }
            case 1: {
                paction = 2;
                break;
            }
            case 6: {
                paction = 2;
                break;
            }
            default: {
                paction = 3;
            }
        }
        if (paction == 1 || paction == 2) {
            this.touchPointerId = event.getPointerId(0);
        }
        int pointerCount = event.getPointerCount();
        if (actionMasked == 2) {
            int historySize = event.getHistorySize();
            for (int h = 0; h < historySize; ++h) {
                TouchEvent touchEvent = new TouchEvent(event, event.getHistoricalEventTime(h), paction, modifiers, button);
                touchEvent.setNumPointers(pointerCount);
                for (int p = 0; p < pointerCount; ++p) {
                    touchEvent.setPointer(p, event.getPointerId(p), event.getHistoricalX(p, h), event.getHistoricalY(p, h), event.getHistoricalSize(p, h), event.getHistoricalPressure(p, h));
                }
                this.postEvent(touchEvent);
            }
        }
        TouchEvent touchEvent = new TouchEvent(event, event.getEventTime(), paction, modifiers, button);
        if (actionMasked == 1) {
            touchEvent.setNumPointers(0);
        } else {
            touchEvent.setNumPointers(pointerCount);
            for (int p = 0; p < event.getPointerCount(); ++p) {
                touchEvent.setPointer(p, event.getPointerId(p), event.getX(p), event.getY(p), event.getSize(p), event.getPressure(p));
            }
        }
        this.postEvent(touchEvent);
    }

    protected void enqueueMouseEvents(MotionEvent event, int button, int modifiers) {
        int action = event.getAction();
        int clickCount = 1;
        switch (action & 0xFF) {
            case 0: {
                this.mousePointerId = event.getPointerId(0);
                this.postEvent(new MouseEvent(event, event.getEventTime(), 1, modifiers, (int)event.getX(), (int)event.getY(), button, clickCount));
                break;
            }
            case 2: {
                int index = event.findPointerIndex(this.mousePointerId);
                if (index == -1) break;
                this.postEvent(new MouseEvent(event, event.getEventTime(), 4, modifiers, (int)event.getX(index), (int)event.getY(index), button, clickCount));
                break;
            }
            case 1: {
                int index = event.findPointerIndex(this.mousePointerId);
                if (index == -1) break;
                this.postEvent(new MouseEvent(event, event.getEventTime(), 2, modifiers, (int)event.getX(index), (int)event.getY(index), button, clickCount));
            }
        }
    }

    public void mousePressed() {
    }

    public void mousePressed(MouseEvent event) {
        this.mousePressed();
    }

    public void mouseReleased() {
    }

    public void mouseReleased(MouseEvent event) {
        this.mouseReleased();
    }

    public void mouseClicked() {
    }

    public void mouseClicked(MouseEvent event) {
        this.mouseClicked();
    }

    public void mouseDragged() {
    }

    public void mouseDragged(MouseEvent event) {
        this.mouseDragged();
    }

    public void mouseMoved() {
    }

    public void mouseMoved(MouseEvent event) {
        this.mouseMoved();
    }

    public void mouseEntered() {
    }

    public void mouseEntered(MouseEvent event) {
        this.mouseEntered();
    }

    public void mouseExited() {
    }

    public void mouseExited(MouseEvent event) {
        this.mouseExited();
    }

    public void touchStarted() {
    }

    public void touchStarted(TouchEvent event) {
        this.touchStarted();
    }

    public void touchMoved() {
    }

    public void touchMoved(TouchEvent event) {
        this.touchMoved();
    }

    public void touchEnded() {
    }

    public void touchEnded(TouchEvent event) {
        this.touchEnded();
    }

    public void touchCancelled() {
    }

    public void touchCancelled(TouchEvent event) {
        this.touchCancelled();
    }

    public boolean wallpaperPreview() {
        return this.surface.getEngine().isPreview();
    }

    public float wallpaperOffset() {
        return this.surface.getEngine().getXOffset();
    }

    public int wallpaperHomeCount() {
        float step = this.surface.getEngine().getXOffsetStep();
        if (0.0f < step) {
            return (int)(1.0f + 1.0f / step);
        }
        return 1;
    }

    public boolean wearAmbient() {
        return this.surface.getEngine().isInAmbientMode();
    }

    public boolean wearInteractive() {
        return !this.surface.getEngine().isInAmbientMode();
    }

    public boolean wearRound() {
        return this.surface.getEngine().isRound();
    }

    public boolean wearSquare() {
        return !this.surface.getEngine().isRound();
    }

    public Rect wearInsets() {
        return this.surface.getEngine().getInsets();
    }

    public boolean wearLowBit() {
        return this.surface.getEngine().useLowBitAmbient();
    }

    public boolean wearBurnIn() {
        return this.surface.getEngine().requireBurnInProtection();
    }

    protected void handleKeyEvent(KeyEvent event) {
        if (!this.keyRepeatEnabled && event.isAutoRepeat()) {
            return;
        }
        this.key = event.getKey();
        this.keyCode = event.getKeyCode();
        switch (event.getAction()) {
            case 1: {
                this.keyPressed = true;
                this.keyPressed(event);
                break;
            }
            case 2: {
                this.keyPressed = false;
                this.keyReleased(event);
            }
        }
        this.handleMethods("keyEvent", new Object[]{event});
    }

    protected void nativeKeyEvent(android.view.KeyEvent event) {
        char key = (char)event.getUnicodeChar();
        if (key == '\u0000' || key == '\uffff') {
            key = '\uffff';
        }
        int keyCode = event.getKeyCode();
        int keAction = 0;
        int action = event.getAction();
        if (action == 0) {
            keAction = 1;
        } else if (action == 1) {
            keAction = 2;
        }
        int keModifiers = 0;
        KeyEvent ke = new KeyEvent(event, event.getEventTime(), keAction, keModifiers, key, keyCode, 0 < event.getRepeatCount());
        this.postEvent(ke);
    }

    public void openKeyboard() {
        Context context = this.surface.getContext();
        InputMethodManager imm = (InputMethodManager)context.getSystemService("input_method");
        imm.toggleSoftInput(2, 0);
        this.keyboardIsOpen = true;
    }

    public void closeKeyboard() {
        if (this.keyboardIsOpen) {
            Context context = this.surface.getContext();
            InputMethodManager imm = (InputMethodManager)context.getSystemService("input_method");
            imm.toggleSoftInput(1, 0);
            this.keyboardIsOpen = false;
            if (this.parentLayout == -1) {
                this.setFullScreenVisibility();
            }
        }
    }

    public void keyPressed() {
    }

    public void keyPressed(KeyEvent event) {
        this.keyPressed();
    }

    public void keyReleased() {
    }

    public void keyReleased(KeyEvent event) {
        this.keyReleased();
    }

    public void keyTyped() {
    }

    public void keyTyped(KeyEvent event) {
        this.keyTyped();
    }

    public void focusGained() {
    }

    public void focusLost() {
    }

    public int millis() {
        return (int)(System.currentTimeMillis() - this.millisOffset);
    }

    public static int second() {
        return Calendar.getInstance().get(13);
    }

    public static int minute() {
        return Calendar.getInstance().get(12);
    }

    public static int hour() {
        return Calendar.getInstance().get(11);
    }

    public static int day() {
        return Calendar.getInstance().get(5);
    }

    public static int month() {
        return Calendar.getInstance().get(2) + 1;
    }

    public static int year() {
        return Calendar.getInstance().get(1);
    }

    public void delay(int napTime) {
        try {
            Thread.sleep(napTime);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void frameRate(float fps) {
        this.surface.setFrameRate(fps);
    }

    public void link(String here) {
        this.link(here, null);
    }

    public void link(String url, String frameTitle) {
        Intent viewIntent = new Intent("android.intent.action.VIEW", Uri.parse((String)url));
        this.surface.startActivity(viewIntent);
    }

    public static void open(String filename) {
        PApplet.open(new String[]{filename});
    }

    public static Process open(String[] argv) {
        return PApplet.exec(argv);
    }

    public static Process exec(String[] argv) {
        try {
            return Runtime.getRuntime().exec(argv);
        }
        catch (Exception e) {
            throw new RuntimeException("Could not open " + PApplet.join(argv, ' '));
        }
    }

    protected void printStackTrace(Throwable t) {
        t.printStackTrace();
    }

    public void die(String what) {
        this.stop();
        throw new RuntimeException(what);
    }

    public void die(String what, Exception e) {
        if (e != null) {
            e.printStackTrace();
        }
        this.die(what);
    }

    public void create() {
    }

    public final void dispose() {
        this.finished = true;
        if (this.surface != null) {
            this.surface.stopThread();
            this.surface.dispose();
        }
        if (this.g != null) {
            this.g.dispose();
        }
        this.handleMethods("dispose");
    }

    public void method(String name) {
        try {
            Method method = this.getClass().getMethod(name, new Class[0]);
            method.invoke((Object)this, new Object[0]);
        }
        catch (IllegalArgumentException e) {
            this.printStackTrace(e);
        }
        catch (IllegalAccessException e) {
            this.printStackTrace(e);
        }
        catch (InvocationTargetException e) {
            e.getTargetException().printStackTrace();
        }
        catch (NoSuchMethodException nsme) {
            System.err.println("There is no public " + name + "() method in the class " + this.getClass().getName());
        }
        catch (Exception e) {
            this.printStackTrace(e);
        }
    }

    public void thread(final String name) {
        Thread later = new Thread(){

            @Override
            public void run() {
                PApplet.this.method(name);
            }
        };
        later.start();
    }

    public void save(String filename) {
        this.g.save(this.savePath(filename));
    }

    public void saveFrame() {
        try {
            this.g.save(this.savePath("screen-" + PApplet.nf(this.frameCount, 4) + ".tif"));
        }
        catch (SecurityException se) {
            System.err.println("Can't use saveFrame() when running in a browser, unless using a signed applet.");
        }
    }

    public void saveFrame(String what) {
        try {
            this.g.save(this.savePath(this.insertFrame(what)));
        }
        catch (SecurityException se) {
            System.err.println("Can't use saveFrame() when running in a browser, unless using a signed applet.");
        }
    }

    protected String insertFrame(String what) {
        int first = what.indexOf(35);
        int last = what.lastIndexOf(35);
        if (first != -1 && last - first > 0) {
            String prefix = what.substring(0, first);
            int count = last - first + 1;
            String suffix = what.substring(last + 1);
            return prefix + PApplet.nf(this.frameCount, count) + suffix;
        }
        return what;
    }

    public static void print(byte what) {
        System.out.print(what);
        System.out.flush();
    }

    public static void print(boolean what) {
        System.out.print(what);
        System.out.flush();
    }

    public static void print(char what) {
        System.out.print(what);
        System.out.flush();
    }

    public static void print(int what) {
        System.out.print(what);
        System.out.flush();
    }

    public static void print(float what) {
        System.out.print(what);
        System.out.flush();
    }

    public static void print(String what) {
        System.out.print(what);
        System.out.flush();
    }

    public static void print(Object ... variables) {
        StringBuilder sb = new StringBuilder();
        for (Object o : variables) {
            if (sb.length() != 0) {
                sb.append(" ");
            }
            if (o == null) {
                sb.append("null");
                continue;
            }
            sb.append(o.toString());
        }
        System.out.print(sb.toString());
    }

    public static void println() {
        System.out.println();
    }

    public static void println(byte what) {
        PApplet.print(what);
        System.out.println();
    }

    public static void println(boolean what) {
        PApplet.print(what);
        System.out.println();
    }

    public static void println(char what) {
        PApplet.print(what);
        System.out.println();
    }

    public static void println(int what) {
        PApplet.print(what);
        System.out.println();
    }

    public static void println(float what) {
        PApplet.print(what);
        System.out.println();
    }

    public static void println(String what) {
        PApplet.print(what);
        System.out.println();
    }

    public static void println(Object ... variables) {
        PApplet.print(variables);
        PApplet.println();
    }

    public static void println(Object what) {
        block17: {
            block18: {
                block16: {
                    if (what != null) break block16;
                    System.out.println("null");
                    break block17;
                }
                String name = what.getClass().getName();
                if (name.charAt(0) != '[') break block18;
                switch (name.charAt(1)) {
                    case '[': {
                        System.out.println(what);
                        break;
                    }
                    case 'L': {
                        Object[] poo = (Object[])what;
                        for (int i = 0; i < poo.length; ++i) {
                            if (poo[i] instanceof String) {
                                System.out.println("[" + i + "] \"" + poo[i] + "\"");
                                continue;
                            }
                            System.out.println("[" + i + "] " + poo[i]);
                        }
                        break block17;
                    }
                    case 'Z': {
                        boolean[] zz = (boolean[])what;
                        for (int i = 0; i < zz.length; ++i) {
                            System.out.println("[" + i + "] " + zz[i]);
                        }
                        break block17;
                    }
                    case 'B': {
                        byte[] bb = (byte[])what;
                        for (int i = 0; i < bb.length; ++i) {
                            System.out.println("[" + i + "] " + bb[i]);
                        }
                        break block17;
                    }
                    case 'C': {
                        char[] cc = (char[])what;
                        for (int i = 0; i < cc.length; ++i) {
                            System.out.println("[" + i + "] '" + cc[i] + "'");
                        }
                        break block17;
                    }
                    case 'I': {
                        int[] ii = (int[])what;
                        for (int i = 0; i < ii.length; ++i) {
                            System.out.println("[" + i + "] " + ii[i]);
                        }
                        break block17;
                    }
                    case 'F': {
                        float[] ff = (float[])what;
                        for (int i = 0; i < ff.length; ++i) {
                            System.out.println("[" + i + "] " + ff[i]);
                        }
                        break block17;
                    }
                    default: {
                        System.out.println(what);
                        break;
                    }
                }
                break block17;
            }
            System.out.println(what);
        }
    }

    public static void printArray(Object what) {
        block21: {
            block22: {
                block20: {
                    if (what != null) break block20;
                    System.out.println("null");
                    break block21;
                }
                String name = what.getClass().getName();
                if (name.charAt(0) != '[') break block22;
                switch (name.charAt(1)) {
                    case '[': {
                        System.out.println(what);
                        break;
                    }
                    case 'L': {
                        Object[] poo = (Object[])what;
                        for (int i = 0; i < poo.length; ++i) {
                            if (poo[i] instanceof String) {
                                System.out.println("[" + i + "] \"" + poo[i] + "\"");
                                continue;
                            }
                            System.out.println("[" + i + "] " + poo[i]);
                        }
                        break block21;
                    }
                    case 'Z': {
                        boolean[] zz = (boolean[])what;
                        for (int i = 0; i < zz.length; ++i) {
                            System.out.println("[" + i + "] " + zz[i]);
                        }
                        break block21;
                    }
                    case 'B': {
                        byte[] bb = (byte[])what;
                        for (int i = 0; i < bb.length; ++i) {
                            System.out.println("[" + i + "] " + bb[i]);
                        }
                        break block21;
                    }
                    case 'C': {
                        char[] cc = (char[])what;
                        for (int i = 0; i < cc.length; ++i) {
                            System.out.println("[" + i + "] '" + cc[i] + "'");
                        }
                        break block21;
                    }
                    case 'I': {
                        int[] ii = (int[])what;
                        for (int i = 0; i < ii.length; ++i) {
                            System.out.println("[" + i + "] " + ii[i]);
                        }
                        break block21;
                    }
                    case 'J': {
                        long[] jj = (long[])what;
                        for (int i = 0; i < jj.length; ++i) {
                            System.out.println("[" + i + "] " + jj[i]);
                        }
                        break block21;
                    }
                    case 'F': {
                        float[] ff = (float[])what;
                        for (int i = 0; i < ff.length; ++i) {
                            System.out.println("[" + i + "] " + ff[i]);
                        }
                        break block21;
                    }
                    case 'D': {
                        double[] dd = (double[])what;
                        for (int i = 0; i < dd.length; ++i) {
                            System.out.println("[" + i + "] " + dd[i]);
                        }
                        break block21;
                    }
                    default: {
                        System.out.println(what);
                        break;
                    }
                }
                break block21;
            }
            System.out.println(what);
        }
        System.out.flush();
    }

    public static final float abs(float n) {
        return n < 0.0f ? -n : n;
    }

    public static final int abs(int n) {
        return n < 0 ? -n : n;
    }

    public static final float sq(float a) {
        return a * a;
    }

    public static final float sqrt(float a) {
        return (float)Math.sqrt(a);
    }

    public static final float log(float a) {
        return (float)Math.log(a);
    }

    public static final float exp(float a) {
        return (float)Math.exp(a);
    }

    public static final float pow(float a, float b) {
        return (float)Math.pow(a, b);
    }

    public static final int max(int a, int b) {
        return a > b ? a : b;
    }

    public static final float max(float a, float b) {
        return a > b ? a : b;
    }

    public static final int max(int a, int b, int c) {
        return a > b ? (a > c ? a : c) : (b > c ? b : c);
    }

    public static final float max(float a, float b, float c) {
        return a > b ? (a > c ? a : c) : (b > c ? b : c);
    }

    public static final int max(int[] list) {
        if (list.length == 0) {
            throw new ArrayIndexOutOfBoundsException(ERROR_MIN_MAX);
        }
        int max = list[0];
        for (int i = 1; i < list.length; ++i) {
            if (list[i] <= max) continue;
            max = list[i];
        }
        return max;
    }

    public static final float max(float[] list) {
        if (list.length == 0) {
            throw new ArrayIndexOutOfBoundsException(ERROR_MIN_MAX);
        }
        float max = list[0];
        for (int i = 1; i < list.length; ++i) {
            if (!(list[i] > max)) continue;
            max = list[i];
        }
        return max;
    }

    public static final int min(int a, int b) {
        return a < b ? a : b;
    }

    public static final float min(float a, float b) {
        return a < b ? a : b;
    }

    public static final int min(int a, int b, int c) {
        return a < b ? (a < c ? a : c) : (b < c ? b : c);
    }

    public static final float min(float a, float b, float c) {
        return a < b ? (a < c ? a : c) : (b < c ? b : c);
    }

    public static final int min(int[] list) {
        if (list.length == 0) {
            throw new ArrayIndexOutOfBoundsException(ERROR_MIN_MAX);
        }
        int min = list[0];
        for (int i = 1; i < list.length; ++i) {
            if (list[i] >= min) continue;
            min = list[i];
        }
        return min;
    }

    public static final float min(float[] list) {
        if (list.length == 0) {
            throw new ArrayIndexOutOfBoundsException(ERROR_MIN_MAX);
        }
        float min = list[0];
        for (int i = 1; i < list.length; ++i) {
            if (!(list[i] < min)) continue;
            min = list[i];
        }
        return min;
    }

    public static final int constrain(int amt, int low, int high) {
        return amt < low ? low : (amt > high ? high : amt);
    }

    public static final float constrain(float amt, float low, float high) {
        return amt < low ? low : (amt > high ? high : amt);
    }

    public static final float sin(float angle) {
        return (float)Math.sin(angle);
    }

    public static final float cos(float angle) {
        return (float)Math.cos(angle);
    }

    public static final float tan(float angle) {
        return (float)Math.tan(angle);
    }

    public static final float asin(float value) {
        return (float)Math.asin(value);
    }

    public static final float acos(float value) {
        return (float)Math.acos(value);
    }

    public static final float atan(float value) {
        return (float)Math.atan(value);
    }

    public static final float atan2(float a, float b) {
        return (float)Math.atan2(a, b);
    }

    public static final float degrees(float radians) {
        return radians * 57.295776f;
    }

    public static final float radians(float degrees) {
        return degrees * ((float)Math.PI / 180);
    }

    public static final int ceil(float what) {
        return (int)Math.ceil(what);
    }

    public static final int floor(float what) {
        return (int)Math.floor(what);
    }

    public static final int round(float what) {
        return Math.round(what);
    }

    public static final float mag(float a, float b) {
        return (float)Math.sqrt(a * a + b * b);
    }

    public static final float mag(float a, float b, float c) {
        return (float)Math.sqrt(a * a + b * b + c * c);
    }

    public static final float dist(float x1, float y1, float x2, float y2) {
        return PApplet.sqrt(PApplet.sq(x2 - x1) + PApplet.sq(y2 - y1));
    }

    public static final float dist(float x1, float y1, float z1, float x2, float y2, float z2) {
        return PApplet.sqrt(PApplet.sq(x2 - x1) + PApplet.sq(y2 - y1) + PApplet.sq(z2 - z1));
    }

    public static final float lerp(float start, float stop, float amt) {
        return start + (stop - start) * amt;
    }

    public static final float norm(float value, float start, float stop) {
        return (value - start) / (stop - start);
    }

    public static final float map(float value, float istart, float istop, float ostart, float ostop) {
        return ostart + (ostop - ostart) * ((value - istart) / (istop - istart));
    }

    public final float random(float high) {
        if (high == 0.0f || high != high) {
            return 0.0f;
        }
        if (this.internalRandom == null) {
            this.internalRandom = new Random();
        }
        float value = 0.0f;
        while ((value = this.internalRandom.nextFloat() * high) == high) {
        }
        return value;
    }

    public final float randomGaussian() {
        if (this.internalRandom == null) {
            this.internalRandom = new Random();
        }
        return (float)this.internalRandom.nextGaussian();
    }

    public final float random(float low, float high) {
        if (low >= high) {
            return low;
        }
        float diff = high - low;
        float value = 0.0f;
        while ((value = this.random(diff) + low) == high) {
        }
        return value;
    }

    public final void randomSeed(long seed) {
        if (this.internalRandom == null) {
            this.internalRandom = new Random();
        }
        this.internalRandom.setSeed(seed);
    }

    public float noise(float x) {
        return this.noise(x, 0.0f, 0.0f);
    }

    public float noise(float x, float y) {
        return this.noise(x, y, 0.0f);
    }

    public float noise(float x, float y, float z) {
        if (this.perlin == null) {
            if (this.perlinRandom == null) {
                this.perlinRandom = new Random();
            }
            this.perlin = new float[4096];
            for (int i = 0; i < 4096; ++i) {
                this.perlin[i] = this.perlinRandom.nextFloat();
            }
            this.perlin_cosTable = PGraphics.cosLUT;
            this.perlin_PI = 720;
            this.perlin_TWOPI = 720;
            this.perlin_PI >>= 1;
        }
        if (x < 0.0f) {
            x = -x;
        }
        if (y < 0.0f) {
            y = -y;
        }
        if (z < 0.0f) {
            z = -z;
        }
        int xi = (int)x;
        int yi = (int)y;
        int zi = (int)z;
        float xf = x - (float)xi;
        float yf = y - (float)yi;
        float zf = z - (float)zi;
        float r = 0.0f;
        float ampl = 0.5f;
        for (int i = 0; i < this.perlin_octaves; ++i) {
            int of = xi + (yi << 4) + (zi << 8);
            float rxf = this.noise_fsc(xf);
            float ryf = this.noise_fsc(yf);
            float n1 = this.perlin[of & 0xFFF];
            n1 += rxf * (this.perlin[of + 1 & 0xFFF] - n1);
            float n2 = this.perlin[of + 16 & 0xFFF];
            n2 += rxf * (this.perlin[of + 16 + 1 & 0xFFF] - n2);
            n1 += ryf * (n2 - n1);
            n2 = this.perlin[(of += 256) & 0xFFF];
            n2 += rxf * (this.perlin[of + 1 & 0xFFF] - n2);
            float n3 = this.perlin[of + 16 & 0xFFF];
            n3 += rxf * (this.perlin[of + 16 + 1 & 0xFFF] - n3);
            n2 += ryf * (n3 - n2);
            n1 += this.noise_fsc(zf) * (n2 - n1);
            r += n1 * ampl;
            ampl *= this.perlin_amp_falloff;
            xi <<= 1;
            xf *= 2.0f;
            yi <<= 1;
            yf *= 2.0f;
            zi <<= 1;
            zf *= 2.0f;
            if (xf >= 1.0f) {
                ++xi;
                xf -= 1.0f;
            }
            if (yf >= 1.0f) {
                ++yi;
                yf -= 1.0f;
            }
            if (!(zf >= 1.0f)) continue;
            ++zi;
            zf -= 1.0f;
        }
        return r;
    }

    private float noise_fsc(float i) {
        return 0.5f * (1.0f - this.perlin_cosTable[(int)(i * (float)this.perlin_PI) % this.perlin_TWOPI]);
    }

    public void noiseDetail(int lod) {
        if (lod > 0) {
            this.perlin_octaves = lod;
        }
    }

    public void noiseDetail(int lod, float falloff) {
        if (lod > 0) {
            this.perlin_octaves = lod;
        }
        if (falloff > 0.0f) {
            this.perlin_amp_falloff = falloff;
        }
    }

    public void noiseSeed(long seed) {
        if (this.perlinRandom == null) {
            this.perlinRandom = new Random();
        }
        this.perlinRandom.setSeed(seed);
        this.perlin = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PImage loadImage(String filename) {
        InputStream stream = this.createInput(filename);
        if (stream == null) {
            System.err.println("Could not find the image " + filename + ".");
            return null;
        }
        Bitmap bitmap = null;
        try {
            bitmap = BitmapFactory.decodeStream((InputStream)stream);
        }
        finally {
            try {
                stream.close();
                stream = null;
            }
            catch (IOException iOException) {}
        }
        if (bitmap == null) {
            System.err.println("Could not load the image because the bitmap was empty.");
            return null;
        }
        PImage image = new PImage(bitmap);
        image.parent = this;
        return image;
    }

    public PImage requestImage(String filename) {
        PImage vessel = this.createImage(0, 0, 2);
        AsyncImageLoader ail = new AsyncImageLoader(filename, vessel);
        ail.start();
        return vessel;
    }

    public XML createXML(String name) {
        try {
            return new XML(name);
        }
        catch (Exception e) {
            this.printStackTrace(e);
            return null;
        }
    }

    public XML loadXML(String filename) {
        return this.loadXML(filename, null);
    }

    public XML loadXML(String filename, String options) {
        try {
            return new XML(this.createInput(filename), options);
        }
        catch (Exception e) {
            this.printStackTrace(e);
            return null;
        }
    }

    public XML parseXML(String xmlString) {
        return this.parseXML(xmlString, null);
    }

    public XML parseXML(String xmlString, String options) {
        try {
            return XML.parse(xmlString, options);
        }
        catch (Exception e) {
            this.printStackTrace(e);
            return null;
        }
    }

    public boolean saveXML(XML xml, String filename) {
        return this.saveXML(xml, filename, null);
    }

    public boolean saveXML(XML xml, String filename, String options) {
        return xml.save(this.saveFile(filename), options);
    }

    public JSONObject parseJSONObject(String input) {
        return new JSONObject(new StringReader(input));
    }

    public JSONObject loadJSONObject(String filename) {
        return new JSONObject(this.createReader(filename));
    }

    public static JSONObject loadJSONObject(File file) {
        return new JSONObject(PApplet.createReader(file));
    }

    public boolean saveJSONObject(JSONObject json, String filename) {
        return this.saveJSONObject(json, filename, null);
    }

    public boolean saveJSONObject(JSONObject json, String filename, String options) {
        return json.save(this.saveFile(filename), options);
    }

    public JSONArray parseJSONArray(String input) {
        return new JSONArray(new StringReader(input));
    }

    public JSONArray loadJSONArray(String filename) {
        return new JSONArray(this.createReader(filename));
    }

    public static JSONArray loadJSONArray(File file) {
        return new JSONArray(PApplet.createReader(file));
    }

    public boolean saveJSONArray(JSONArray json, String filename) {
        return this.saveJSONArray(json, filename, null);
    }

    public boolean saveJSONArray(JSONArray json, String filename, String options) {
        return json.save(this.saveFile(filename), options);
    }

    public Table createTable() {
        return new Table();
    }

    public Table loadTable(String filename) {
        return this.loadTable(filename, null);
    }

    public Table loadTable(String filename, String options) {
        try {
            String ext = PApplet.checkExtension(filename);
            if (ext != null && (ext.equals("csv") || ext.equals("tsv"))) {
                options = options == null ? ext : ext + "," + options;
            }
            return new Table(this.createInput(filename), options);
        }
        catch (IOException e) {
            this.printStackTrace(e);
            return null;
        }
    }

    public boolean saveTable(Table table, String filename) {
        return this.saveTable(table, filename, null);
    }

    public boolean saveTable(Table table, String filename, String options) {
        try {
            table.save(this.saveFile(filename), options);
            return true;
        }
        catch (IOException e) {
            this.printStackTrace(e);
            return false;
        }
    }

    public PFont loadFont(String filename) {
        try {
            InputStream input = this.createInput(filename);
            return new PFont(input);
        }
        catch (Exception e) {
            this.die("Could not load font " + filename + ". Make sure that the font has been copied to the data folder of your sketch.", e);
            return null;
        }
    }

    protected PFont createDefaultFont(float size) {
        return this.createFont("SansSerif", size, true, null);
    }

    public PFont createFont(String name, float size) {
        return this.createFont(name, size, true, null);
    }

    public PFont createFont(String name, float size, boolean smooth) {
        return this.createFont(name, size, smooth, null);
    }

    public PFont createFont(String name, float size, boolean smooth, char[] charset) {
        String lowerName = name.toLowerCase();
        Typeface baseFont = null;
        if (lowerName.endsWith(".otf") || lowerName.endsWith(".ttf")) {
            AssetManager assets = this.surface.getAssets();
            baseFont = Typeface.createFromAsset((AssetManager)assets, (String)name);
        } else {
            baseFont = (Typeface)PFont.findNative(name);
        }
        return new PFont(baseFont, PApplet.round(size), smooth, charset);
    }

    public String[] listPaths(String path, String ... options) {
        File[] list = this.listFiles(path, options);
        int offset = 0;
        for (String opt : options) {
            if (!opt.equals("relative")) continue;
            if (!path.endsWith(File.pathSeparator)) {
                path = path + File.pathSeparator;
            }
            offset = path.length();
            break;
        }
        String[] outgoing = new String[list.length];
        for (int i = 0; i < list.length; ++i) {
            outgoing[i] = list[i].getAbsolutePath().substring(offset);
        }
        return outgoing;
    }

    public File[] listFiles(String path, String ... options) {
        File file = new File(path);
        if (!file.isAbsolute()) {
            file = this.sketchFile(path);
        }
        return PApplet.listFiles(file, options);
    }

    public static File[] listFiles(File base, String ... options) {
        boolean recursive = false;
        String[] extensions = null;
        boolean directories = true;
        boolean files = true;
        boolean hidden = false;
        for (String opt : options) {
            if (opt.equals("recursive")) {
                recursive = true;
                continue;
            }
            if (opt.startsWith("extension=")) {
                extensions = new String[]{opt.substring(10)};
                continue;
            }
            if (opt.startsWith("extensions=")) {
                extensions = PApplet.split(opt.substring(10), ',');
                continue;
            }
            if (opt.equals("files")) {
                directories = false;
                continue;
            }
            if (opt.equals("directories")) {
                files = false;
                continue;
            }
            if (opt.equals("hidden")) {
                hidden = true;
                continue;
            }
            if (opt.equals("relative")) continue;
            throw new RuntimeException(opt + " is not a listFiles() option");
        }
        if (extensions != null) {
            for (int i = 0; i < extensions.length; ++i) {
                extensions[i] = "." + (String)extensions[i];
            }
        }
        if (!files && !directories) {
            files = true;
            directories = true;
        }
        if (!base.canRead()) {
            return null;
        }
        ArrayList<File> outgoing = new ArrayList<File>();
        PApplet.listFilesImpl(base, recursive, extensions, hidden, directories, files, outgoing);
        return outgoing.toArray(new File[0]);
    }

    static void listFilesImpl(File folder, boolean recursive, String[] extensions, boolean hidden, boolean directories, boolean files, List<File> list) {
        File[] items = folder.listFiles();
        if (items != null) {
            for (File item : items) {
                String name = item.getName();
                if (!hidden && name.charAt(0) == '.') continue;
                if (item.isDirectory()) {
                    if (recursive) {
                        PApplet.listFilesImpl(item, recursive, extensions, hidden, directories, files, list);
                    }
                    if (!directories) continue;
                    list.add(item);
                    continue;
                }
                if (!files) continue;
                if (extensions == null) {
                    list.add(item);
                    continue;
                }
                for (String ext : extensions) {
                    if (!item.getName().toLowerCase().endsWith(ext)) continue;
                    list.add(item);
                }
            }
        }
    }

    public static String checkExtension(String filename) {
        int dotIndex;
        if (filename.toLowerCase().endsWith(".gz")) {
            filename = filename.substring(0, filename.length() - 3);
        }
        if ((dotIndex = filename.lastIndexOf(46)) != -1) {
            return filename.substring(dotIndex + 1).toLowerCase();
        }
        return null;
    }

    public BufferedReader createReader(String filename) {
        try {
            InputStream is = this.createInput(filename);
            if (is == null) {
                System.err.println(filename + " does not exist or could not be read");
                return null;
            }
            return PApplet.createReader(is);
        }
        catch (Exception e) {
            if (filename == null) {
                System.err.println("Filename passed to reader() was null");
            } else {
                System.err.println("Couldn't create a reader for " + filename);
            }
            return null;
        }
    }

    public static BufferedReader createReader(File file) {
        try {
            InputStream is = new FileInputStream(file);
            if (file.getName().toLowerCase().endsWith(".gz")) {
                is = new GZIPInputStream(is);
            }
            return PApplet.createReader(is);
        }
        catch (Exception e) {
            if (file == null) {
                throw new RuntimeException("File passed to createReader() was null");
            }
            e.printStackTrace();
            throw new RuntimeException("Couldn't create a reader for " + file.getAbsolutePath());
        }
    }

    public static BufferedReader createReader(InputStream input) {
        InputStreamReader isr = new InputStreamReader(input, CompatUtils.getCharsetUTF8());
        BufferedReader reader = new BufferedReader(isr);
        try {
            reader.mark(1);
            int c = reader.read();
            if (c != 65279) {
                reader.reset();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return reader;
    }

    public PrintWriter createWriter(String filename) {
        return PApplet.createWriter(this.saveFile(filename));
    }

    public static PrintWriter createWriter(File file) {
        try {
            OutputStream output = new FileOutputStream(file);
            if (file.getName().toLowerCase().endsWith(".gz")) {
                output = new GZIPOutputStream(output);
            }
            return PApplet.createWriter(output);
        }
        catch (Exception e) {
            if (file == null) {
                throw new RuntimeException("File passed to createWriter() was null");
            }
            e.printStackTrace();
            throw new RuntimeException("Couldn't create a writer for " + file.getAbsolutePath());
        }
    }

    public static PrintWriter createWriter(OutputStream output) {
        BufferedOutputStream bos = new BufferedOutputStream(output, 8192);
        OutputStreamWriter osw = new OutputStreamWriter((OutputStream)bos, CompatUtils.getCharsetUTF8());
        return new PrintWriter(osw);
    }

    public InputStream createInput(String filename) {
        InputStream input = this.createInputRaw(filename);
        String lower = filename.toLowerCase();
        if (input != null && (lower.endsWith(".gz") || lower.endsWith(".svgz"))) {
            try {
                return new BufferedInputStream(new GZIPInputStream(input));
            }
            catch (IOException e) {
                this.printStackTrace(e);
                return null;
            }
        }
        return new BufferedInputStream(input);
    }

    public InputStream createInputRaw(String filename) {
        File sketchFile;
        InputStream stream = null;
        if (filename == null) {
            return null;
        }
        if (filename.length() == 0) {
            return null;
        }
        if (filename.indexOf(":") != -1) {
            try {
                URL url = new URL(filename);
                HttpURLConnection con = (HttpURLConnection)url.openConnection();
                con.setRequestMethod("GET");
                con.setDoInput(true);
                con.connect();
                return con.getInputStream();
            }
            catch (MalformedURLException url) {
            }
            catch (FileNotFoundException url) {
            }
            catch (IOException e) {
                this.printStackTrace(e);
                return null;
            }
        }
        AssetManager assets = this.surface.getAssets();
        try {
            stream = assets.open(filename);
            if (stream != null) {
                return stream;
            }
        }
        catch (IOException con) {
            // empty catch block
        }
        File absFile = new File(filename);
        if (absFile.exists()) {
            try {
                stream = new FileInputStream(absFile);
                if (stream != null) {
                    return stream;
                }
            }
            catch (FileNotFoundException fileNotFoundException) {
                // empty catch block
            }
        }
        if ((sketchFile = new File(this.sketchPath(filename))).exists()) {
            try {
                stream = new FileInputStream(sketchFile);
                if (stream != null) {
                    return stream;
                }
            }
            catch (FileNotFoundException fileNotFoundException) {
                // empty catch block
            }
        }
        return this.surface.openFileInput(filename);
    }

    public static InputStream createInput(File file) {
        if (file == null) {
            throw new IllegalArgumentException("File passed to createInput() was null");
        }
        try {
            FileInputStream input = new FileInputStream(file);
            if (file.getName().toLowerCase().endsWith(".gz")) {
                return new BufferedInputStream(new GZIPInputStream(input));
            }
            return new BufferedInputStream(input);
        }
        catch (IOException e) {
            System.err.println("Could not createInput() for " + file);
            e.printStackTrace();
            return null;
        }
    }

    public byte[] loadBytes(String filename) {
        InputStream is = this.createInput(filename);
        if (is != null) {
            return PApplet.loadBytes(is);
        }
        System.err.println("The file \"" + filename + "\" is missing or inaccessible, make sure the URL is valid or that the file has been added to your sketch and is readable.");
        return null;
    }

    public static byte[] loadBytes(InputStream input) {
        try {
            BufferedInputStream bis = new BufferedInputStream(input);
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            int c = bis.read();
            while (c != -1) {
                out.write(c);
                c = bis.read();
            }
            return out.toByteArray();
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static byte[] loadBytes(File file) {
        InputStream is = PApplet.createInput(file);
        return PApplet.loadBytes(is);
    }

    public static String[] loadStrings(File file) {
        InputStream is = PApplet.createInput(file);
        if (is != null) {
            return PApplet.loadStrings(is);
        }
        return null;
    }

    public static String[] loadStrings(BufferedReader reader) {
        try {
            String[] lines = new String[100];
            int lineCount = 0;
            String line = null;
            while ((line = reader.readLine()) != null) {
                if (lineCount == lines.length) {
                    String[] temp = new String[lineCount << 1];
                    System.arraycopy(lines, 0, temp, 0, lineCount);
                    lines = temp;
                }
                lines[lineCount++] = line;
            }
            reader.close();
            if (lineCount == lines.length) {
                return lines;
            }
            String[] output = new String[lineCount];
            System.arraycopy(lines, 0, output, 0, lineCount);
            return output;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public String[] loadStrings(String filename) {
        InputStream is = this.createInput(filename);
        if (is != null) {
            return PApplet.loadStrings(is);
        }
        System.err.println("The file \"" + filename + "\" is missing or inaccessible, make sure the URL is valid or that the file has been added to your sketch and is readable.");
        return null;
    }

    public static String[] loadStrings(InputStream input) {
        try {
            BufferedReader reader = new BufferedReader(new InputStreamReader(input, "UTF-8"));
            String[] lines = new String[100];
            int lineCount = 0;
            String line = null;
            while ((line = reader.readLine()) != null) {
                if (lineCount == lines.length) {
                    String[] temp = new String[lineCount << 1];
                    System.arraycopy(lines, 0, temp, 0, lineCount);
                    lines = temp;
                }
                lines[lineCount++] = line;
            }
            reader.close();
            if (lineCount == lines.length) {
                return lines;
            }
            String[] output = new String[lineCount];
            System.arraycopy(lines, 0, output, 0, lineCount);
            return output;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public OutputStream createOutput(String filename) {
        try {
            File file = new File(filename);
            if (!file.isAbsolute()) {
                file = new File(this.sketchPath(filename));
            }
            FileOutputStream fos = new FileOutputStream(file);
            if (file.getName().toLowerCase().endsWith(".gz")) {
                return new GZIPOutputStream(fos);
            }
            return fos;
        }
        catch (IOException e) {
            this.printStackTrace(e);
            return null;
        }
    }

    public static OutputStream createOutput(File file) {
        try {
            PApplet.createPath(file);
            FileOutputStream output = new FileOutputStream(file);
            if (file.getName().toLowerCase().endsWith(".gz")) {
                return new BufferedOutputStream(new GZIPOutputStream(output));
            }
            return new BufferedOutputStream(output);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public boolean saveStream(String targetFilename, String sourceLocation) {
        return this.saveStream(this.saveFile(targetFilename), sourceLocation);
    }

    public boolean saveStream(File targetFile, String sourceLocation) {
        return PApplet.saveStream(targetFile, this.createInputRaw(sourceLocation));
    }

    public boolean saveStream(String targetFilename, InputStream sourceStream) {
        return PApplet.saveStream(this.saveFile(targetFilename), sourceStream);
    }

    public static boolean saveStream(File target, InputStream source) {
        File tempFile = null;
        try {
            PApplet.createPath(target);
            tempFile = PApplet.createTempFile(target);
            FileOutputStream targetStream = new FileOutputStream(tempFile);
            PApplet.saveStream(targetStream, source);
            targetStream.close();
            targetStream = null;
            if (target.exists() && !target.delete()) {
                System.err.println("Could not replace " + target.getAbsolutePath() + ".");
            }
            if (!tempFile.renameTo(target)) {
                System.err.println("Could not rename temporary file " + tempFile.getAbsolutePath());
                return false;
            }
            return true;
        }
        catch (IOException e) {
            if (tempFile != null) {
                tempFile.delete();
            }
            e.printStackTrace();
            return false;
        }
    }

    public static void saveStream(OutputStream target, InputStream source) throws IOException {
        int bytesRead;
        BufferedInputStream bis = new BufferedInputStream(source, 16384);
        BufferedOutputStream bos = new BufferedOutputStream(target);
        byte[] buffer = new byte[8192];
        while ((bytesRead = bis.read(buffer)) != -1) {
            bos.write(buffer, 0, bytesRead);
        }
        bos.flush();
    }

    public void saveBytes(String filename, byte[] data) {
        PApplet.saveBytes(this.saveFile(filename), data);
    }

    private static File createTempFile(File file) throws IOException {
        String prefix;
        File parentDir = file.getParentFile();
        String name = file.getName();
        String suffix = null;
        int dot = name.lastIndexOf(46);
        if (dot == -1) {
            prefix = name;
        } else {
            prefix = name.substring(0, dot);
            suffix = name.substring(dot);
        }
        if (prefix.length() < 3) {
            prefix = prefix + "processing";
        }
        return File.createTempFile(prefix, suffix, parentDir);
    }

    public static void saveBytes(File file, byte[] data) {
        File tempFile = null;
        try {
            tempFile = PApplet.createTempFile(file);
            OutputStream output = PApplet.createOutput(tempFile);
            PApplet.saveBytes(output, data);
            output.close();
            output = null;
            if (file.exists() && !file.delete()) {
                System.err.println("Could not replace " + file.getAbsolutePath());
            }
            if (!tempFile.renameTo(file)) {
                System.err.println("Could not rename temporary file " + tempFile.getAbsolutePath());
            }
        }
        catch (IOException e) {
            System.err.println("error saving bytes to " + file);
            if (tempFile != null) {
                tempFile.delete();
            }
            e.printStackTrace();
        }
    }

    public static void saveBytes(OutputStream output, byte[] data) {
        try {
            output.write(data);
            output.flush();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void saveStrings(String filename, String[] strings) {
        PApplet.saveStrings(this.saveFile(filename), strings);
    }

    public static void saveStrings(File file, String[] strings) {
        try {
            String location = file.getAbsolutePath();
            PApplet.createPath(location);
            OutputStream output = new FileOutputStream(location);
            if (file.getName().toLowerCase().endsWith(".gz")) {
                output = new GZIPOutputStream(output);
            }
            PApplet.saveStrings(output, strings);
            ((OutputStream)output).close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void saveStrings(OutputStream output, String[] strings) {
        try {
            OutputStreamWriter osw = new OutputStreamWriter(output, "UTF-8");
            PrintWriter writer = new PrintWriter(osw);
            for (int i = 0; i < strings.length; ++i) {
                writer.println(strings[i]);
            }
            writer.flush();
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
    }

    public String sketchPath(String where) {
        if (this.sketchPath == null) {
            return where;
        }
        try {
            if (new File(where).isAbsolute()) {
                return where;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.surface.getFileStreamPath(where).getAbsolutePath();
    }

    public File sketchFile(String where) {
        return new File(this.sketchPath(where));
    }

    public String savePath(String where) {
        if (where == null) {
            return null;
        }
        String filename = this.sketchPath(where);
        PApplet.createPath(filename);
        return filename;
    }

    public File saveFile(String where) {
        return new File(this.savePath(where));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String dataPath(String where) {
        boolean isAsset = false;
        AssetManager assets = this.surface.getAssets();
        InputStream is = null;
        try {
            is = assets.open(where);
            isAsset = true;
        }
        catch (IOException iOException) {
        }
        finally {
            try {
                is.close();
            }
            catch (Exception exception) {}
        }
        if (isAsset) {
            return where;
        }
        return this.sketchPath(where);
    }

    public File dataFile(String where) {
        return new File(this.dataPath(where));
    }

    public static void createPath(String path) {
        PApplet.createPath(new File(path));
    }

    public static void createPath(File file) {
        try {
            File unit;
            String parent = file.getParent();
            if (parent != null && !(unit = new File(parent)).exists()) {
                unit.mkdirs();
            }
        }
        catch (SecurityException se) {
            System.err.println("You don't have permissions to create " + file.getAbsolutePath());
        }
    }

    public static String getExtension(String filename) {
        String extension;
        int question;
        String lower = filename.toLowerCase();
        int dot = filename.lastIndexOf(46);
        if (dot == -1) {
            String string = "unknown";
        }
        if ((question = (extension = lower.substring(dot + 1)).indexOf(63)) != -1) {
            extension = extension.substring(0, question);
        }
        return extension;
    }

    public static String urlEncode(String what) {
        try {
            return URLEncoder.encode(what, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            return null;
        }
    }

    public static String urlDecode(String what) {
        try {
            return URLDecoder.decode(what, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            return null;
        }
    }

    public static byte[] sort(byte[] what) {
        return PApplet.sort(what, what.length);
    }

    public static byte[] sort(byte[] what, int count) {
        byte[] outgoing = new byte[what.length];
        System.arraycopy(what, 0, outgoing, 0, what.length);
        Arrays.sort(outgoing, 0, count);
        return outgoing;
    }

    public static char[] sort(char[] what) {
        return PApplet.sort(what, what.length);
    }

    public static char[] sort(char[] what, int count) {
        char[] outgoing = new char[what.length];
        System.arraycopy(what, 0, outgoing, 0, what.length);
        Arrays.sort(outgoing, 0, count);
        return outgoing;
    }

    public static int[] sort(int[] what) {
        return PApplet.sort(what, what.length);
    }

    public static int[] sort(int[] what, int count) {
        int[] outgoing = new int[what.length];
        System.arraycopy(what, 0, outgoing, 0, what.length);
        Arrays.sort(outgoing, 0, count);
        return outgoing;
    }

    public static float[] sort(float[] what) {
        return PApplet.sort(what, what.length);
    }

    public static float[] sort(float[] what, int count) {
        float[] outgoing = new float[what.length];
        System.arraycopy(what, 0, outgoing, 0, what.length);
        Arrays.sort(outgoing, 0, count);
        return outgoing;
    }

    public static String[] sort(String[] what) {
        return PApplet.sort(what, what.length);
    }

    public static String[] sort(String[] what, int count) {
        Object[] outgoing = new String[what.length];
        System.arraycopy(what, 0, outgoing, 0, what.length);
        Arrays.sort(outgoing, 0, count);
        return outgoing;
    }

    public static void arrayCopy(Object src, int srcPosition, Object dst, int dstPosition, int length) {
        System.arraycopy(src, srcPosition, dst, dstPosition, length);
    }

    public static void arrayCopy(Object src, Object dst, int length) {
        System.arraycopy(src, 0, dst, 0, length);
    }

    public static void arrayCopy(Object src, Object dst) {
        System.arraycopy(src, 0, dst, 0, Array.getLength(src));
    }

    public static boolean[] expand(boolean[] list) {
        return PApplet.expand(list, list.length << 1);
    }

    public static boolean[] expand(boolean[] list, int newSize) {
        boolean[] temp = new boolean[newSize];
        System.arraycopy(list, 0, temp, 0, Math.min(newSize, list.length));
        return temp;
    }

    public static byte[] expand(byte[] list) {
        return PApplet.expand(list, list.length << 1);
    }

    public static byte[] expand(byte[] list, int newSize) {
        byte[] temp = new byte[newSize];
        System.arraycopy(list, 0, temp, 0, Math.min(newSize, list.length));
        return temp;
    }

    public static char[] expand(char[] list) {
        return PApplet.expand(list, list.length << 1);
    }

    public static char[] expand(char[] list, int newSize) {
        char[] temp = new char[newSize];
        System.arraycopy(list, 0, temp, 0, Math.min(newSize, list.length));
        return temp;
    }

    public static int[] expand(int[] list) {
        return PApplet.expand(list, list.length << 1);
    }

    public static int[] expand(int[] list, int newSize) {
        int[] temp = new int[newSize];
        System.arraycopy(list, 0, temp, 0, Math.min(newSize, list.length));
        return temp;
    }

    public static PImage[] expand(PImage[] list) {
        return PApplet.expand(list, list.length << 1);
    }

    public static PImage[] expand(PImage[] list, int newSize) {
        PImage[] temp = new PImage[newSize];
        System.arraycopy(list, 0, temp, 0, Math.min(newSize, list.length));
        return temp;
    }

    public static float[] expand(float[] list) {
        return PApplet.expand(list, list.length << 1);
    }

    public static float[] expand(float[] list, int newSize) {
        float[] temp = new float[newSize];
        System.arraycopy(list, 0, temp, 0, Math.min(newSize, list.length));
        return temp;
    }

    public static String[] expand(String[] list) {
        return PApplet.expand(list, list.length << 1);
    }

    public static String[] expand(String[] list, int newSize) {
        String[] temp = new String[newSize];
        System.arraycopy(list, 0, temp, 0, Math.min(newSize, list.length));
        return temp;
    }

    public static Object expand(Object array) {
        return PApplet.expand(array, Array.getLength(array) << 1);
    }

    public static Object expand(Object list, int newSize) {
        Class<?> type = list.getClass().getComponentType();
        Object temp = Array.newInstance(type, newSize);
        System.arraycopy(list, 0, temp, 0, Math.min(Array.getLength(list), newSize));
        return temp;
    }

    public static byte[] append(byte[] b, byte value) {
        b = PApplet.expand(b, b.length + 1);
        b[b.length - 1] = value;
        return b;
    }

    public static char[] append(char[] b, char value) {
        b = PApplet.expand(b, b.length + 1);
        b[b.length - 1] = value;
        return b;
    }

    public static int[] append(int[] b, int value) {
        b = PApplet.expand(b, b.length + 1);
        b[b.length - 1] = value;
        return b;
    }

    public static float[] append(float[] b, float value) {
        b = PApplet.expand(b, b.length + 1);
        b[b.length - 1] = value;
        return b;
    }

    public static String[] append(String[] b, String value) {
        b = PApplet.expand(b, b.length + 1);
        b[b.length - 1] = value;
        return b;
    }

    public static Object append(Object b, Object value) {
        int length = Array.getLength(b);
        b = PApplet.expand(b, length + 1);
        Array.set(b, length, value);
        return b;
    }

    public static boolean[] shorten(boolean[] list) {
        return PApplet.subset(list, 0, list.length - 1);
    }

    public static byte[] shorten(byte[] list) {
        return PApplet.subset(list, 0, list.length - 1);
    }

    public static char[] shorten(char[] list) {
        return PApplet.subset(list, 0, list.length - 1);
    }

    public static int[] shorten(int[] list) {
        return PApplet.subset(list, 0, list.length - 1);
    }

    public static float[] shorten(float[] list) {
        return PApplet.subset(list, 0, list.length - 1);
    }

    public static String[] shorten(String[] list) {
        return PApplet.subset(list, 0, list.length - 1);
    }

    public static Object shorten(Object list) {
        int length = Array.getLength(list);
        return PApplet.subset(list, 0, length - 1);
    }

    public static final boolean[] splice(boolean[] list, boolean v, int index) {
        boolean[] outgoing = new boolean[list.length + 1];
        System.arraycopy(list, 0, outgoing, 0, index);
        outgoing[index] = v;
        System.arraycopy(list, index, outgoing, index + 1, list.length - index);
        return outgoing;
    }

    public static final boolean[] splice(boolean[] list, boolean[] v, int index) {
        boolean[] outgoing = new boolean[list.length + v.length];
        System.arraycopy(list, 0, outgoing, 0, index);
        System.arraycopy(v, 0, outgoing, index, v.length);
        System.arraycopy(list, index, outgoing, index + v.length, list.length - index);
        return outgoing;
    }

    public static final byte[] splice(byte[] list, byte v, int index) {
        byte[] outgoing = new byte[list.length + 1];
        System.arraycopy(list, 0, outgoing, 0, index);
        outgoing[index] = v;
        System.arraycopy(list, index, outgoing, index + 1, list.length - index);
        return outgoing;
    }

    public static final byte[] splice(byte[] list, byte[] v, int index) {
        byte[] outgoing = new byte[list.length + v.length];
        System.arraycopy(list, 0, outgoing, 0, index);
        System.arraycopy(v, 0, outgoing, index, v.length);
        System.arraycopy(list, index, outgoing, index + v.length, list.length - index);
        return outgoing;
    }

    public static final char[] splice(char[] list, char v, int index) {
        char[] outgoing = new char[list.length + 1];
        System.arraycopy(list, 0, outgoing, 0, index);
        outgoing[index] = v;
        System.arraycopy(list, index, outgoing, index + 1, list.length - index);
        return outgoing;
    }

    public static final char[] splice(char[] list, char[] v, int index) {
        char[] outgoing = new char[list.length + v.length];
        System.arraycopy(list, 0, outgoing, 0, index);
        System.arraycopy(v, 0, outgoing, index, v.length);
        System.arraycopy(list, index, outgoing, index + v.length, list.length - index);
        return outgoing;
    }

    public static final int[] splice(int[] list, int v, int index) {
        int[] outgoing = new int[list.length + 1];
        System.arraycopy(list, 0, outgoing, 0, index);
        outgoing[index] = v;
        System.arraycopy(list, index, outgoing, index + 1, list.length - index);
        return outgoing;
    }

    public static final int[] splice(int[] list, int[] v, int index) {
        int[] outgoing = new int[list.length + v.length];
        System.arraycopy(list, 0, outgoing, 0, index);
        System.arraycopy(v, 0, outgoing, index, v.length);
        System.arraycopy(list, index, outgoing, index + v.length, list.length - index);
        return outgoing;
    }

    public static final float[] splice(float[] list, float v, int index) {
        float[] outgoing = new float[list.length + 1];
        System.arraycopy(list, 0, outgoing, 0, index);
        outgoing[index] = v;
        System.arraycopy(list, index, outgoing, index + 1, list.length - index);
        return outgoing;
    }

    public static final float[] splice(float[] list, float[] v, int index) {
        float[] outgoing = new float[list.length + v.length];
        System.arraycopy(list, 0, outgoing, 0, index);
        System.arraycopy(v, 0, outgoing, index, v.length);
        System.arraycopy(list, index, outgoing, index + v.length, list.length - index);
        return outgoing;
    }

    public static final String[] splice(String[] list, String v, int index) {
        String[] outgoing = new String[list.length + 1];
        System.arraycopy(list, 0, outgoing, 0, index);
        outgoing[index] = v;
        System.arraycopy(list, index, outgoing, index + 1, list.length - index);
        return outgoing;
    }

    public static final String[] splice(String[] list, String[] v, int index) {
        String[] outgoing = new String[list.length + v.length];
        System.arraycopy(list, 0, outgoing, 0, index);
        System.arraycopy(v, 0, outgoing, index, v.length);
        System.arraycopy(list, index, outgoing, index + v.length, list.length - index);
        return outgoing;
    }

    public static final Object splice(Object list, Object v, int index) {
        Object[] outgoing = null;
        int length = Array.getLength(list);
        if (v.getClass().getName().charAt(0) == '[') {
            int vlength = Array.getLength(v);
            outgoing = new Object[length + vlength];
            System.arraycopy(list, 0, outgoing, 0, index);
            System.arraycopy(v, 0, outgoing, index, vlength);
            System.arraycopy(list, index, outgoing, index + vlength, length - index);
        } else {
            outgoing = new Object[length + 1];
            System.arraycopy(list, 0, outgoing, 0, index);
            Array.set(outgoing, index, v);
            System.arraycopy(list, index, outgoing, index + 1, length - index);
        }
        return outgoing;
    }

    public static boolean[] subset(boolean[] list, int start) {
        return PApplet.subset(list, start, list.length - start);
    }

    public static boolean[] subset(boolean[] list, int start, int count) {
        boolean[] output = new boolean[count];
        System.arraycopy(list, start, output, 0, count);
        return output;
    }

    public static byte[] subset(byte[] list, int start) {
        return PApplet.subset(list, start, list.length - start);
    }

    public static byte[] subset(byte[] list, int start, int count) {
        byte[] output = new byte[count];
        System.arraycopy(list, start, output, 0, count);
        return output;
    }

    public static char[] subset(char[] list, int start) {
        return PApplet.subset(list, start, list.length - start);
    }

    public static char[] subset(char[] list, int start, int count) {
        char[] output = new char[count];
        System.arraycopy(list, start, output, 0, count);
        return output;
    }

    public static int[] subset(int[] list, int start) {
        return PApplet.subset(list, start, list.length - start);
    }

    public static int[] subset(int[] list, int start, int count) {
        int[] output = new int[count];
        System.arraycopy(list, start, output, 0, count);
        return output;
    }

    public static float[] subset(float[] list, int start) {
        return PApplet.subset(list, start, list.length - start);
    }

    public static float[] subset(float[] list, int start, int count) {
        float[] output = new float[count];
        System.arraycopy(list, start, output, 0, count);
        return output;
    }

    public static String[] subset(String[] list, int start) {
        return PApplet.subset(list, start, list.length - start);
    }

    public static String[] subset(String[] list, int start, int count) {
        String[] output = new String[count];
        System.arraycopy(list, start, output, 0, count);
        return output;
    }

    public static Object subset(Object list, int start) {
        int length = Array.getLength(list);
        return PApplet.subset(list, start, length - start);
    }

    public static Object subset(Object list, int start, int count) {
        Class<?> type = list.getClass().getComponentType();
        Object outgoing = Array.newInstance(type, count);
        System.arraycopy(list, start, outgoing, 0, count);
        return outgoing;
    }

    public static boolean[] concat(boolean[] a, boolean[] b) {
        boolean[] c = new boolean[a.length + b.length];
        System.arraycopy(a, 0, c, 0, a.length);
        System.arraycopy(b, 0, c, a.length, b.length);
        return c;
    }

    public static byte[] concat(byte[] a, byte[] b) {
        byte[] c = new byte[a.length + b.length];
        System.arraycopy(a, 0, c, 0, a.length);
        System.arraycopy(b, 0, c, a.length, b.length);
        return c;
    }

    public static char[] concat(char[] a, char[] b) {
        char[] c = new char[a.length + b.length];
        System.arraycopy(a, 0, c, 0, a.length);
        System.arraycopy(b, 0, c, a.length, b.length);
        return c;
    }

    public static int[] concat(int[] a, int[] b) {
        int[] c = new int[a.length + b.length];
        System.arraycopy(a, 0, c, 0, a.length);
        System.arraycopy(b, 0, c, a.length, b.length);
        return c;
    }

    public static float[] concat(float[] a, float[] b) {
        float[] c = new float[a.length + b.length];
        System.arraycopy(a, 0, c, 0, a.length);
        System.arraycopy(b, 0, c, a.length, b.length);
        return c;
    }

    public static String[] concat(String[] a, String[] b) {
        String[] c = new String[a.length + b.length];
        System.arraycopy(a, 0, c, 0, a.length);
        System.arraycopy(b, 0, c, a.length, b.length);
        return c;
    }

    public static Object concat(Object a, Object b) {
        Class<?> type = a.getClass().getComponentType();
        int alength = Array.getLength(a);
        int blength = Array.getLength(b);
        Object outgoing = Array.newInstance(type, alength + blength);
        System.arraycopy(a, 0, outgoing, 0, alength);
        System.arraycopy(b, 0, outgoing, alength, blength);
        return outgoing;
    }

    public static boolean[] reverse(boolean[] list) {
        boolean[] outgoing = new boolean[list.length];
        int length1 = list.length - 1;
        for (int i = 0; i < list.length; ++i) {
            outgoing[i] = list[length1 - i];
        }
        return outgoing;
    }

    public static byte[] reverse(byte[] list) {
        byte[] outgoing = new byte[list.length];
        int length1 = list.length - 1;
        for (int i = 0; i < list.length; ++i) {
            outgoing[i] = list[length1 - i];
        }
        return outgoing;
    }

    public static char[] reverse(char[] list) {
        char[] outgoing = new char[list.length];
        int length1 = list.length - 1;
        for (int i = 0; i < list.length; ++i) {
            outgoing[i] = list[length1 - i];
        }
        return outgoing;
    }

    public static int[] reverse(int[] list) {
        int[] outgoing = new int[list.length];
        int length1 = list.length - 1;
        for (int i = 0; i < list.length; ++i) {
            outgoing[i] = list[length1 - i];
        }
        return outgoing;
    }

    public static float[] reverse(float[] list) {
        float[] outgoing = new float[list.length];
        int length1 = list.length - 1;
        for (int i = 0; i < list.length; ++i) {
            outgoing[i] = list[length1 - i];
        }
        return outgoing;
    }

    public static String[] reverse(String[] list) {
        String[] outgoing = new String[list.length];
        int length1 = list.length - 1;
        for (int i = 0; i < list.length; ++i) {
            outgoing[i] = list[length1 - i];
        }
        return outgoing;
    }

    public static Object reverse(Object list) {
        Class<?> type = list.getClass().getComponentType();
        int length = Array.getLength(list);
        Object outgoing = Array.newInstance(type, length);
        for (int i = 0; i < length; ++i) {
            Array.set(outgoing, i, Array.get(list, length - 1 - i));
        }
        return outgoing;
    }

    public static String trim(String str) {
        return str.replace('\u00a0', ' ').trim();
    }

    public static String[] trim(String[] array) {
        String[] outgoing = new String[array.length];
        for (int i = 0; i < array.length; ++i) {
            if (array[i] == null) continue;
            outgoing[i] = array[i].replace('\u00a0', ' ').trim();
        }
        return outgoing;
    }

    public static String join(String[] str, char separator) {
        return PApplet.join(str, String.valueOf(separator));
    }

    public static String join(String[] str, String separator) {
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < str.length; ++i) {
            if (i != 0) {
                buffer.append(separator);
            }
            buffer.append(str[i]);
        }
        return buffer.toString();
    }

    public static String[] splitTokens(String what) {
        return PApplet.splitTokens(what, " \t\n\r\f\u00a0");
    }

    public static String[] splitTokens(String what, String delim) {
        StringTokenizer toker = new StringTokenizer(what, delim);
        String[] pieces = new String[toker.countTokens()];
        int index = 0;
        while (toker.hasMoreTokens()) {
            pieces[index++] = toker.nextToken();
        }
        return pieces;
    }

    public static String[] split(String what, char delim) {
        if (what == null) {
            return null;
        }
        char[] chars = what.toCharArray();
        int splitCount = 0;
        for (int i = 0; i < chars.length; ++i) {
            if (chars[i] != delim) continue;
            ++splitCount;
        }
        if (splitCount == 0) {
            String[] splits = new String[]{new String(what)};
            return splits;
        }
        String[] splits = new String[splitCount + 1];
        int splitIndex = 0;
        int startIndex = 0;
        for (int i = 0; i < chars.length; ++i) {
            if (chars[i] != delim) continue;
            splits[splitIndex++] = new String(chars, startIndex, i - startIndex);
            startIndex = i + 1;
        }
        splits[splitIndex] = new String(chars, startIndex, chars.length - startIndex);
        return splits;
    }

    public static String[] split(String what, String delim) {
        int index;
        ArrayList<String> items = new ArrayList<String>();
        int offset = 0;
        while ((index = what.indexOf(delim, offset)) != -1) {
            items.add(what.substring(offset, index));
            offset = index + delim.length();
        }
        items.add(what.substring(offset));
        String[] outgoing = new String[items.size()];
        items.toArray(outgoing);
        return outgoing;
    }

    static Pattern matchPattern(String regexp) {
        Pattern p = null;
        if (matchPatterns == null) {
            matchPatterns = new HashMap();
        } else {
            p = matchPatterns.get(regexp);
        }
        if (p == null) {
            if (matchPatterns.size() == 10) {
                matchPatterns.clear();
            }
            p = Pattern.compile(regexp, 40);
            matchPatterns.put(regexp, p);
        }
        return p;
    }

    public static String[] match(String what, String regexp) {
        Pattern p = PApplet.matchPattern(regexp);
        Matcher m = p.matcher(what);
        if (m.find()) {
            int count = m.groupCount() + 1;
            String[] groups = new String[count];
            for (int i = 0; i < count; ++i) {
                groups[i] = m.group(i);
            }
            return groups;
        }
        return null;
    }

    public static String[][] matchAll(String what, String regexp) {
        int i;
        Pattern p = PApplet.matchPattern(regexp);
        Matcher m = p.matcher(what);
        ArrayList<String[]> results = new ArrayList<String[]>();
        int count = m.groupCount() + 1;
        while (m.find()) {
            String[] groups = new String[count];
            for (i = 0; i < count; ++i) {
                groups[i] = m.group(i);
            }
            results.add(groups);
        }
        if (results.isEmpty()) {
            return null;
        }
        String[][] matches = new String[results.size()][count];
        for (i = 0; i < matches.length; ++i) {
            matches[i] = (String[])results.get(i);
        }
        return matches;
    }

    public static final boolean parseBoolean(int what) {
        return what != 0;
    }

    public static final boolean parseBoolean(String what) {
        return new Boolean(what);
    }

    public static final boolean[] parseBoolean(byte[] what) {
        boolean[] outgoing = new boolean[what.length];
        for (int i = 0; i < what.length; ++i) {
            outgoing[i] = what[i] != 0;
        }
        return outgoing;
    }

    public static final boolean[] parseBoolean(int[] what) {
        boolean[] outgoing = new boolean[what.length];
        for (int i = 0; i < what.length; ++i) {
            outgoing[i] = what[i] != 0;
        }
        return outgoing;
    }

    public static final boolean[] parseBoolean(String[] what) {
        boolean[] outgoing = new boolean[what.length];
        for (int i = 0; i < what.length; ++i) {
            outgoing[i] = new Boolean(what[i]);
        }
        return outgoing;
    }

    public static final byte parseByte(boolean what) {
        return what ? (byte)1 : 0;
    }

    public static final byte parseByte(char what) {
        return (byte)what;
    }

    public static final byte parseByte(int what) {
        return (byte)what;
    }

    public static final byte parseByte(float what) {
        return (byte)what;
    }

    public static final byte[] parseByte(boolean[] what) {
        byte[] outgoing = new byte[what.length];
        for (int i = 0; i < what.length; ++i) {
            outgoing[i] = what[i] ? (byte)1 : 0;
        }
        return outgoing;
    }

    public static final byte[] parseByte(char[] what) {
        byte[] outgoing = new byte[what.length];
        for (int i = 0; i < what.length; ++i) {
            outgoing[i] = (byte)what[i];
        }
        return outgoing;
    }

    public static final byte[] parseByte(int[] what) {
        byte[] outgoing = new byte[what.length];
        for (int i = 0; i < what.length; ++i) {
            outgoing[i] = (byte)what[i];
        }
        return outgoing;
    }

    public static final byte[] parseByte(float[] what) {
        byte[] outgoing = new byte[what.length];
        for (int i = 0; i < what.length; ++i) {
            outgoing[i] = (byte)what[i];
        }
        return outgoing;
    }

    public static final char parseChar(byte what) {
        return (char)(what & 0xFF);
    }

    public static final char parseChar(int what) {
        return (char)what;
    }

    public static final char[] parseChar(byte[] what) {
        char[] outgoing = new char[what.length];
        for (int i = 0; i < what.length; ++i) {
            outgoing[i] = (char)(what[i] & 0xFF);
        }
        return outgoing;
    }

    public static final char[] parseChar(int[] what) {
        char[] outgoing = new char[what.length];
        for (int i = 0; i < what.length; ++i) {
            outgoing[i] = (char)what[i];
        }
        return outgoing;
    }

    public static final int parseInt(boolean what) {
        return what ? 1 : 0;
    }

    public static final int parseInt(byte what) {
        return what & 0xFF;
    }

    public static final int parseInt(char what) {
        return what;
    }

    public static final int parseInt(float what) {
        return (int)what;
    }

    public static final int parseInt(String what) {
        return PApplet.parseInt(what, 0);
    }

    public static final int parseInt(String what, int otherwise) {
        try {
            int offset = what.indexOf(46);
            if (offset == -1) {
                return Integer.parseInt(what);
            }
            return Integer.parseInt(what.substring(0, offset));
        }
        catch (NumberFormatException numberFormatException) {
            return otherwise;
        }
    }

    public static final int[] parseInt(boolean[] what) {
        int[] list = new int[what.length];
        for (int i = 0; i < what.length; ++i) {
            list[i] = what[i] ? 1 : 0;
        }
        return list;
    }

    public static final int[] parseInt(byte[] what) {
        int[] list = new int[what.length];
        for (int i = 0; i < what.length; ++i) {
            list[i] = what[i] & 0xFF;
        }
        return list;
    }

    public static final int[] parseInt(char[] what) {
        int[] list = new int[what.length];
        for (int i = 0; i < what.length; ++i) {
            list[i] = what[i];
        }
        return list;
    }

    public static int[] parseInt(float[] what) {
        int[] inties = new int[what.length];
        for (int i = 0; i < what.length; ++i) {
            inties[i] = (int)what[i];
        }
        return inties;
    }

    public static int[] parseInt(String[] what) {
        return PApplet.parseInt(what, 0);
    }

    public static int[] parseInt(String[] what, int missing) {
        int[] output = new int[what.length];
        for (int i = 0; i < what.length; ++i) {
            try {
                output[i] = Integer.parseInt(what[i]);
                continue;
            }
            catch (NumberFormatException e) {
                output[i] = missing;
            }
        }
        return output;
    }

    public static final float parseFloat(int what) {
        return what;
    }

    public static final float parseFloat(String what) {
        return PApplet.parseFloat(what, Float.NaN);
    }

    public static final float parseFloat(String what, float otherwise) {
        try {
            return new Float(what).floatValue();
        }
        catch (NumberFormatException numberFormatException) {
            return otherwise;
        }
    }

    public static final float[] parseByte(byte[] what) {
        float[] floaties = new float[what.length];
        for (int i = 0; i < what.length; ++i) {
            floaties[i] = what[i];
        }
        return floaties;
    }

    public static final float[] parseFloat(int[] what) {
        float[] floaties = new float[what.length];
        for (int i = 0; i < what.length; ++i) {
            floaties[i] = what[i];
        }
        return floaties;
    }

    public static final float[] parseFloat(String[] what) {
        return PApplet.parseFloat(what, Float.NaN);
    }

    public static final float[] parseFloat(String[] what, float missing) {
        float[] output = new float[what.length];
        for (int i = 0; i < what.length; ++i) {
            try {
                output[i] = new Float(what[i]).floatValue();
                continue;
            }
            catch (NumberFormatException e) {
                output[i] = missing;
            }
        }
        return output;
    }

    public static final String str(boolean x) {
        return String.valueOf(x);
    }

    public static final String str(byte x) {
        return String.valueOf(x);
    }

    public static final String str(char x) {
        return String.valueOf(x);
    }

    public static final String str(int x) {
        return String.valueOf(x);
    }

    public static final String str(float x) {
        return String.valueOf(x);
    }

    public static final String[] str(boolean[] x) {
        String[] s = new String[x.length];
        for (int i = 0; i < x.length; ++i) {
            s[i] = String.valueOf(x[i]);
        }
        return s;
    }

    public static final String[] str(byte[] x) {
        String[] s = new String[x.length];
        for (int i = 0; i < x.length; ++i) {
            s[i] = String.valueOf(x[i]);
        }
        return s;
    }

    public static final String[] str(char[] x) {
        String[] s = new String[x.length];
        for (int i = 0; i < x.length; ++i) {
            s[i] = String.valueOf(x[i]);
        }
        return s;
    }

    public static final String[] str(int[] x) {
        String[] s = new String[x.length];
        for (int i = 0; i < x.length; ++i) {
            s[i] = String.valueOf(x[i]);
        }
        return s;
    }

    public static final String[] str(float[] x) {
        String[] s = new String[x.length];
        for (int i = 0; i < x.length; ++i) {
            s[i] = String.valueOf(x[i]);
        }
        return s;
    }

    public static String[] nf(int[] num, int digits) {
        String[] formatted = new String[num.length];
        for (int i = 0; i < formatted.length; ++i) {
            formatted[i] = PApplet.nf(num[i], digits);
        }
        return formatted;
    }

    public static String nf(int num, int digits) {
        if (int_nf != null && int_nf_digits == digits && !int_nf_commas) {
            return int_nf.format(num);
        }
        int_nf = NumberFormat.getInstance();
        int_nf.setGroupingUsed(false);
        int_nf_commas = false;
        int_nf.setMinimumIntegerDigits(digits);
        int_nf_digits = digits;
        return int_nf.format(num);
    }

    public static String[] nfc(int[] num) {
        String[] formatted = new String[num.length];
        for (int i = 0; i < formatted.length; ++i) {
            formatted[i] = PApplet.nfc(num[i]);
        }
        return formatted;
    }

    public static String nfc(int num) {
        if (int_nf != null && int_nf_digits == 0 && int_nf_commas) {
            return int_nf.format(num);
        }
        int_nf = NumberFormat.getInstance();
        int_nf.setGroupingUsed(true);
        int_nf_commas = true;
        int_nf.setMinimumIntegerDigits(0);
        int_nf_digits = 0;
        return int_nf.format(num);
    }

    public static String nfs(int num, int digits) {
        return num < 0 ? PApplet.nf(num, digits) : ' ' + PApplet.nf(num, digits);
    }

    public static String[] nfs(int[] num, int digits) {
        String[] formatted = new String[num.length];
        for (int i = 0; i < formatted.length; ++i) {
            formatted[i] = PApplet.nfs(num[i], digits);
        }
        return formatted;
    }

    public static String nfp(int num, int digits) {
        return num < 0 ? PApplet.nf(num, digits) : '+' + PApplet.nf(num, digits);
    }

    public static String[] nfp(int[] num, int digits) {
        String[] formatted = new String[num.length];
        for (int i = 0; i < formatted.length; ++i) {
            formatted[i] = PApplet.nfp(num[i], digits);
        }
        return formatted;
    }

    public static String[] nf(float[] num, int left, int right) {
        String[] formatted = new String[num.length];
        for (int i = 0; i < formatted.length; ++i) {
            formatted[i] = PApplet.nf(num[i], left, right);
        }
        return formatted;
    }

    public static String nf(float num, int left, int right) {
        if (float_nf != null && float_nf_left == left && float_nf_right == right && !float_nf_commas) {
            return float_nf.format(num);
        }
        float_nf = NumberFormat.getInstance();
        float_nf.setGroupingUsed(false);
        float_nf_commas = false;
        if (left != 0) {
            float_nf.setMinimumIntegerDigits(left);
        }
        if (right != 0) {
            float_nf.setMinimumFractionDigits(right);
            float_nf.setMaximumFractionDigits(right);
        }
        float_nf_left = left;
        float_nf_right = right;
        return float_nf.format(num);
    }

    public static String[] nfc(float[] num, int right) {
        String[] formatted = new String[num.length];
        for (int i = 0; i < formatted.length; ++i) {
            formatted[i] = PApplet.nfc(num[i], right);
        }
        return formatted;
    }

    public static String nfc(float num, int right) {
        if (float_nf != null && float_nf_left == 0 && float_nf_right == right && float_nf_commas) {
            return float_nf.format(num);
        }
        float_nf = NumberFormat.getInstance();
        float_nf.setGroupingUsed(true);
        float_nf_commas = true;
        if (right != 0) {
            float_nf.setMinimumFractionDigits(right);
            float_nf.setMaximumFractionDigits(right);
        }
        float_nf_left = 0;
        float_nf_right = right;
        return float_nf.format(num);
    }

    public static String[] nfs(float[] num, int left, int right) {
        String[] formatted = new String[num.length];
        for (int i = 0; i < formatted.length; ++i) {
            formatted[i] = PApplet.nfs(num[i], left, right);
        }
        return formatted;
    }

    public static String nfs(float num, int left, int right) {
        return num < 0.0f ? PApplet.nf(num, left, right) : ' ' + PApplet.nf(num, left, right);
    }

    public static String[] nfp(float[] num, int left, int right) {
        String[] formatted = new String[num.length];
        for (int i = 0; i < formatted.length; ++i) {
            formatted[i] = PApplet.nfp(num[i], left, right);
        }
        return formatted;
    }

    public static String nfp(float num, int left, int right) {
        return num < 0.0f ? PApplet.nf(num, left, right) : '+' + PApplet.nf(num, left, right);
    }

    public static final String hex(byte what) {
        return PApplet.hex(what, 2);
    }

    public static final String hex(char what) {
        return PApplet.hex(what, 4);
    }

    public static final String hex(int what) {
        return PApplet.hex(what, 8);
    }

    public static final String hex(int what, int digits) {
        int length;
        String stuff = Integer.toHexString(what).toUpperCase();
        if (digits > 8) {
            digits = 8;
        }
        if ((length = stuff.length()) > digits) {
            return stuff.substring(length - digits);
        }
        if (length < digits) {
            return "00000000".substring(8 - (digits - length)) + stuff;
        }
        return stuff;
    }

    public static final int unhex(String what) {
        return (int)Long.parseLong(what, 16);
    }

    public static final String binary(byte what) {
        return PApplet.binary(what, 8);
    }

    public static final String binary(char what) {
        return PApplet.binary(what, 16);
    }

    public static final String binary(int what) {
        return PApplet.binary(what, 32);
    }

    public static final String binary(int what, int digits) {
        int length;
        String stuff = Integer.toBinaryString(what);
        if (digits > 32) {
            digits = 32;
        }
        if ((length = stuff.length()) > digits) {
            return stuff.substring(length - digits);
        }
        if (length < digits) {
            int offset = 32 - (digits - length);
            return "00000000000000000000000000000000".substring(offset) + stuff;
        }
        return stuff;
    }

    public static final int unbinary(String what) {
        return Integer.parseInt(what, 2);
    }

    public final int color(int gray) {
        if (this.g == null) {
            if (gray > 255) {
                gray = 255;
            } else if (gray < 0) {
                gray = 0;
            }
            return 0xFF000000 | gray << 16 | gray << 8 | gray;
        }
        return this.g.color(gray);
    }

    public final int color(float fgray) {
        if (this.g == null) {
            int gray = (int)fgray;
            if (gray > 255) {
                gray = 255;
            } else if (gray < 0) {
                gray = 0;
            }
            return 0xFF000000 | gray << 16 | gray << 8 | gray;
        }
        return this.g.color(fgray);
    }

    public final int color(int gray, int alpha) {
        if (this.g == null) {
            if (alpha > 255) {
                alpha = 255;
            } else if (alpha < 0) {
                alpha = 0;
            }
            if (gray > 255) {
                return alpha << 24 | gray & 0xFFFFFF;
            }
            return alpha << 24 | gray << 16 | gray << 8 | gray;
        }
        return this.g.color(gray, alpha);
    }

    public final int color(float fgray, float falpha) {
        if (this.g == null) {
            int gray = (int)fgray;
            int alpha = (int)falpha;
            if (gray > 255) {
                gray = 255;
            } else if (gray < 0) {
                gray = 0;
            }
            if (alpha > 255) {
                alpha = 255;
            } else if (alpha < 0) {
                alpha = 0;
            }
            return 0xFF000000 | gray << 16 | gray << 8 | gray;
        }
        return this.g.color(fgray, falpha);
    }

    public final int color(int x, int y, int z) {
        if (this.g == null) {
            if (x > 255) {
                x = 255;
            } else if (x < 0) {
                x = 0;
            }
            if (y > 255) {
                y = 255;
            } else if (y < 0) {
                y = 0;
            }
            if (z > 255) {
                z = 255;
            } else if (z < 0) {
                z = 0;
            }
            return 0xFF000000 | x << 16 | y << 8 | z;
        }
        return this.g.color(x, y, z);
    }

    public final int color(float x, float y, float z) {
        if (this.g == null) {
            if (x > 255.0f) {
                x = 255.0f;
            } else if (x < 0.0f) {
                x = 0.0f;
            }
            if (y > 255.0f) {
                y = 255.0f;
            } else if (y < 0.0f) {
                y = 0.0f;
            }
            if (z > 255.0f) {
                z = 255.0f;
            } else if (z < 0.0f) {
                z = 0.0f;
            }
            return 0xFF000000 | (int)x << 16 | (int)y << 8 | (int)z;
        }
        return this.g.color(x, y, z);
    }

    public final int color(int x, int y, int z, int a) {
        if (this.g == null) {
            if (a > 255) {
                a = 255;
            } else if (a < 0) {
                a = 0;
            }
            if (x > 255) {
                x = 255;
            } else if (x < 0) {
                x = 0;
            }
            if (y > 255) {
                y = 255;
            } else if (y < 0) {
                y = 0;
            }
            if (z > 255) {
                z = 255;
            } else if (z < 0) {
                z = 0;
            }
            return a << 24 | x << 16 | y << 8 | z;
        }
        return this.g.color(x, y, z, a);
    }

    public final int color(float x, float y, float z, float a) {
        if (this.g == null) {
            if (a > 255.0f) {
                a = 255.0f;
            } else if (a < 0.0f) {
                a = 0.0f;
            }
            if (x > 255.0f) {
                x = 255.0f;
            } else if (x < 0.0f) {
                x = 0.0f;
            }
            if (y > 255.0f) {
                y = 255.0f;
            } else if (y < 0.0f) {
                y = 0.0f;
            }
            if (z > 255.0f) {
                z = 255.0f;
            } else if (z < 0.0f) {
                z = 0.0f;
            }
            return (int)a << 24 | (int)x << 16 | (int)y << 8 | (int)z;
        }
        return this.g.color(x, y, z, a);
    }

    public static int blendColor(int c1, int c2, int mode) {
        return PImage.blendColor(c1, c2, mode);
    }

    public static void main(String[] args) {
    }

    public void loadPixels() {
        this.g.loadPixels();
        this.pixels = this.g.pixels;
    }

    public void updatePixels() {
        this.g.updatePixels();
    }

    public void updatePixels(int x1, int y1, int x2, int y2) {
        this.g.updatePixels(x1, y1, x2, y2);
    }

    public void setCache(PImage image, Object storage) {
        this.g.setCache(image, storage);
    }

    public Object getCache(PImage image) {
        return this.g.getCache(image);
    }

    public void removeCache(PImage image) {
        this.g.removeCache(image);
    }

    public void flush() {
        this.g.flush();
    }

    public PGL beginPGL() {
        return this.g.beginPGL();
    }

    public void endPGL() {
        this.g.endPGL();
    }

    public void hint(int which) {
        this.g.hint(which);
    }

    public void beginShape() {
        this.g.beginShape();
    }

    public void beginShape(int kind) {
        this.g.beginShape(kind);
    }

    public void edge(boolean edge) {
        this.g.edge(edge);
    }

    public void normal(float nx, float ny, float nz) {
        this.g.normal(nx, ny, nz);
    }

    public void attribPosition(String name, float x, float y, float z) {
        this.g.attribPosition(name, x, y, z);
    }

    public void attribNormal(String name, float nx, float ny, float nz) {
        this.g.attribNormal(name, nx, ny, nz);
    }

    public void attribColor(String name, int color) {
        this.g.attribColor(name, color);
    }

    public void attrib(String name, float ... values) {
        this.g.attrib(name, values);
    }

    public void attrib(String name, int ... values) {
        this.g.attrib(name, values);
    }

    public void attrib(String name, boolean ... values) {
        this.g.attrib(name, values);
    }

    public void textureMode(int mode) {
        this.g.textureMode(mode);
    }

    public void textureWrap(int wrap) {
        this.g.textureWrap(wrap);
    }

    public void texture(PImage image) {
        this.g.texture(image);
    }

    public void noTexture() {
        this.g.noTexture();
    }

    public void vertex(float x, float y) {
        this.g.vertex(x, y);
    }

    public void vertex(float x, float y, float z) {
        this.g.vertex(x, y, z);
    }

    public void vertex(float[] v) {
        this.g.vertex(v);
    }

    public void vertex(float x, float y, float u, float v) {
        this.g.vertex(x, y, u, v);
    }

    public void vertex(float x, float y, float z, float u, float v) {
        this.g.vertex(x, y, z, u, v);
    }

    public void breakShape() {
        this.g.breakShape();
    }

    public void beginContour() {
        this.g.beginContour();
    }

    public void endContour() {
        this.g.endContour();
    }

    public void endShape() {
        this.g.endShape();
    }

    public void endShape(int mode) {
        this.g.endShape(mode);
    }

    public void clip(float a, float b, float c, float d) {
        this.g.clip(a, b, c, d);
    }

    public void noClip() {
        this.g.noClip();
    }

    public void blendMode(int mode) {
        this.g.blendMode(mode);
    }

    public PShape loadShape(String filename) {
        return this.g.loadShape(filename);
    }

    public PShape createShape() {
        return this.g.createShape();
    }

    public PShape createShape(int type) {
        return this.g.createShape(type);
    }

    public PShape createShape(int kind, float ... p) {
        return this.g.createShape(kind, p);
    }

    public PShader loadShader(String fragFilename) {
        return this.g.loadShader(fragFilename);
    }

    public PShader loadShader(String fragFilename, String vertFilename) {
        return this.g.loadShader(fragFilename, vertFilename);
    }

    public void shader(PShader shader) {
        this.g.shader(shader);
    }

    public void shader(PShader shader, int kind) {
        this.g.shader(shader, kind);
    }

    public void resetShader() {
        this.g.resetShader();
    }

    public void resetShader(int kind) {
        this.g.resetShader(kind);
    }

    public PShader getShader(int kind) {
        return this.g.getShader(kind);
    }

    public void filter(PShader shader) {
        this.g.filter(shader);
    }

    public void bezierVertex(float x2, float y2, float x3, float y3, float x4, float y4) {
        this.g.bezierVertex(x2, y2, x3, y3, x4, y4);
    }

    public void bezierVertex(float x2, float y2, float z2, float x3, float y3, float z3, float x4, float y4, float z4) {
        this.g.bezierVertex(x2, y2, z2, x3, y3, z3, x4, y4, z4);
    }

    public void quadraticVertex(float cx, float cy, float x3, float y3) {
        this.g.quadraticVertex(cx, cy, x3, y3);
    }

    public void quadraticVertex(float cx, float cy, float cz, float x3, float y3, float z3) {
        this.g.quadraticVertex(cx, cy, cz, x3, y3, z3);
    }

    public void curveVertex(float x, float y) {
        this.g.curveVertex(x, y);
    }

    public void curveVertex(float x, float y, float z) {
        this.g.curveVertex(x, y, z);
    }

    public void point(float x, float y) {
        this.g.point(x, y);
    }

    public void point(float x, float y, float z) {
        this.g.point(x, y, z);
    }

    public void line(float x1, float y1, float x2, float y2) {
        this.g.line(x1, y1, x2, y2);
    }

    public void line(float x1, float y1, float z1, float x2, float y2, float z2) {
        this.g.line(x1, y1, z1, x2, y2, z2);
    }

    public void triangle(float x1, float y1, float x2, float y2, float x3, float y3) {
        this.g.triangle(x1, y1, x2, y2, x3, y3);
    }

    public void quad(float x1, float y1, float x2, float y2, float x3, float y3, float x4, float y4) {
        this.g.quad(x1, y1, x2, y2, x3, y3, x4, y4);
    }

    public void rectMode(int mode) {
        this.g.rectMode(mode);
    }

    public void rect(float a, float b, float c, float d) {
        this.g.rect(a, b, c, d);
    }

    public void rect(float a, float b, float c, float d, float r) {
        this.g.rect(a, b, c, d, r);
    }

    public void rect(float a, float b, float c, float d, float tl, float tr, float br, float bl) {
        this.g.rect(a, b, c, d, tl, tr, br, bl);
    }

    public void ellipseMode(int mode) {
        this.g.ellipseMode(mode);
    }

    public void ellipse(float a, float b, float c, float d) {
        this.g.ellipse(a, b, c, d);
    }

    public void arc(float a, float b, float c, float d, float start, float stop) {
        this.g.arc(a, b, c, d, start, stop);
    }

    public void arc(float a, float b, float c, float d, float start, float stop, int mode) {
        this.g.arc(a, b, c, d, start, stop, mode);
    }

    public void box(float size) {
        this.g.box(size);
    }

    public void box(float w, float h, float d) {
        this.g.box(w, h, d);
    }

    public void sphereDetail(int res) {
        this.g.sphereDetail(res);
    }

    public void sphereDetail(int ures, int vres) {
        this.g.sphereDetail(ures, vres);
    }

    public void sphere(float r) {
        this.g.sphere(r);
    }

    public float bezierPoint(float a, float b, float c, float d, float t) {
        return this.g.bezierPoint(a, b, c, d, t);
    }

    public float bezierTangent(float a, float b, float c, float d, float t) {
        return this.g.bezierTangent(a, b, c, d, t);
    }

    public void bezierDetail(int detail) {
        this.g.bezierDetail(detail);
    }

    public void bezier(float x1, float y1, float x2, float y2, float x3, float y3, float x4, float y4) {
        this.g.bezier(x1, y1, x2, y2, x3, y3, x4, y4);
    }

    public void bezier(float x1, float y1, float z1, float x2, float y2, float z2, float x3, float y3, float z3, float x4, float y4, float z4) {
        this.g.bezier(x1, y1, z1, x2, y2, z2, x3, y3, z3, x4, y4, z4);
    }

    public float curvePoint(float a, float b, float c, float d, float t) {
        return this.g.curvePoint(a, b, c, d, t);
    }

    public float curveTangent(float a, float b, float c, float d, float t) {
        return this.g.curveTangent(a, b, c, d, t);
    }

    public void curveDetail(int detail) {
        this.g.curveDetail(detail);
    }

    public void curveTightness(float tightness) {
        this.g.curveTightness(tightness);
    }

    public void curve(float x1, float y1, float x2, float y2, float x3, float y3, float x4, float y4) {
        this.g.curve(x1, y1, x2, y2, x3, y3, x4, y4);
    }

    public void curve(float x1, float y1, float z1, float x2, float y2, float z2, float x3, float y3, float z3, float x4, float y4, float z4) {
        this.g.curve(x1, y1, z1, x2, y2, z2, x3, y3, z3, x4, y4, z4);
    }

    public void imageMode(int mode) {
        this.g.imageMode(mode);
    }

    public void image(PImage image, float x, float y) {
        this.g.image(image, x, y);
    }

    public void image(PImage image, float x, float y, float c, float d) {
        this.g.image(image, x, y, c, d);
    }

    public void image(PImage image, float a, float b, float c, float d, int u1, int v1, int u2, int v2) {
        this.g.image(image, a, b, c, d, u1, v1, u2, v2);
    }

    public void shapeMode(int mode) {
        this.g.shapeMode(mode);
    }

    public void shape(PShape shape) {
        this.g.shape(shape);
    }

    public void shape(PShape shape, float x, float y) {
        this.g.shape(shape, x, y);
    }

    public void shape(PShape shape, float x, float y, float c, float d) {
        this.g.shape(shape, x, y, c, d);
    }

    public void textAlign(int align) {
        this.g.textAlign(align);
    }

    public void textAlign(int alignX, int alignY) {
        this.g.textAlign(alignX, alignY);
    }

    public float textAscent() {
        return this.g.textAscent();
    }

    public float textDescent() {
        return this.g.textDescent();
    }

    public void textFont(PFont which) {
        this.g.textFont(which);
    }

    public void textFont(PFont which, float size) {
        this.g.textFont(which, size);
    }

    public void textLeading(float leading) {
        this.g.textLeading(leading);
    }

    public void textMode(int mode) {
        this.g.textMode(mode);
    }

    public void textSize(float size) {
        this.g.textSize(size);
    }

    public float textWidth(char c) {
        return this.g.textWidth(c);
    }

    public float textWidth(String str) {
        return this.g.textWidth(str);
    }

    public void text(char c, float x, float y) {
        this.g.text(c, x, y);
    }

    public void text(char c, float x, float y, float z) {
        this.g.text(c, x, y, z);
    }

    public void text(String str, float x, float y) {
        this.g.text(str, x, y);
    }

    public void text(String str, float x, float y, float z) {
        this.g.text(str, x, y, z);
    }

    public void text(String str, float x1, float y1, float x2, float y2) {
        this.g.text(str, x1, y1, x2, y2);
    }

    public void text(int num, float x, float y) {
        this.g.text(num, x, y);
    }

    public void text(int num, float x, float y, float z) {
        this.g.text(num, x, y, z);
    }

    public void text(float num, float x, float y) {
        this.g.text(num, x, y);
    }

    public void text(float num, float x, float y, float z) {
        this.g.text(num, x, y, z);
    }

    public void pushMatrix() {
        this.g.pushMatrix();
    }

    public void popMatrix() {
        this.g.popMatrix();
    }

    public void translate(float tx, float ty) {
        this.g.translate(tx, ty);
    }

    public void translate(float tx, float ty, float tz) {
        this.g.translate(tx, ty, tz);
    }

    public void rotate(float angle) {
        this.g.rotate(angle);
    }

    public void rotateX(float angle) {
        this.g.rotateX(angle);
    }

    public void rotateY(float angle) {
        this.g.rotateY(angle);
    }

    public void rotateZ(float angle) {
        this.g.rotateZ(angle);
    }

    public void rotate(float angle, float vx, float vy, float vz) {
        this.g.rotate(angle, vx, vy, vz);
    }

    public void scale(float s) {
        this.g.scale(s);
    }

    public void scale(float sx, float sy) {
        this.g.scale(sx, sy);
    }

    public void scale(float x, float y, float z) {
        this.g.scale(x, y, z);
    }

    public void shearX(float angle) {
        this.g.shearX(angle);
    }

    public void shearY(float angle) {
        this.g.shearY(angle);
    }

    public void resetMatrix() {
        this.g.resetMatrix();
    }

    public void applyMatrix(PMatrix source) {
        this.g.applyMatrix(source);
    }

    public void applyMatrix(PMatrix2D source) {
        this.g.applyMatrix(source);
    }

    public void applyMatrix(float n00, float n01, float n02, float n10, float n11, float n12) {
        this.g.applyMatrix(n00, n01, n02, n10, n11, n12);
    }

    public void applyMatrix(PMatrix3D source) {
        this.g.applyMatrix(source);
    }

    public void applyMatrix(float n00, float n01, float n02, float n03, float n10, float n11, float n12, float n13, float n20, float n21, float n22, float n23, float n30, float n31, float n32, float n33) {
        this.g.applyMatrix(n00, n01, n02, n03, n10, n11, n12, n13, n20, n21, n22, n23, n30, n31, n32, n33);
    }

    public PMatrix getMatrix() {
        return this.g.getMatrix();
    }

    public PMatrix2D getMatrix(PMatrix2D target) {
        return this.g.getMatrix(target);
    }

    public PMatrix3D getMatrix(PMatrix3D target) {
        return this.g.getMatrix(target);
    }

    public PMatrix3D getObjectMatrix() {
        return this.g.getObjectMatrix();
    }

    public PMatrix3D getObjectMatrix(PMatrix3D target) {
        return this.g.getObjectMatrix(target);
    }

    public PMatrix3D getEyeMatrix() {
        return this.g.getEyeMatrix();
    }

    public PMatrix3D getEyeMatrix(PMatrix3D target) {
        return this.g.getEyeMatrix(target);
    }

    public void setMatrix(PMatrix source) {
        this.g.setMatrix(source);
    }

    public void setMatrix(PMatrix2D source) {
        this.g.setMatrix(source);
    }

    public void setMatrix(PMatrix3D source) {
        this.g.setMatrix(source);
    }

    public void printMatrix() {
        this.g.printMatrix();
    }

    public void cameraUp() {
        this.g.cameraUp();
    }

    public void beginCamera() {
        this.g.beginCamera();
    }

    public void endCamera() {
        this.g.endCamera();
    }

    public void camera() {
        this.g.camera();
    }

    public void camera(float eyeX, float eyeY, float eyeZ, float centerX, float centerY, float centerZ, float upX, float upY, float upZ) {
        this.g.camera(eyeX, eyeY, eyeZ, centerX, centerY, centerZ, upX, upY, upZ);
    }

    public void printCamera() {
        this.g.printCamera();
    }

    public void eye() {
        this.g.eye();
    }

    public void ortho() {
        this.g.ortho();
    }

    public void ortho(float left, float right, float bottom, float top) {
        this.g.ortho(left, right, bottom, top);
    }

    public void ortho(float left, float right, float bottom, float top, float near, float far) {
        this.g.ortho(left, right, bottom, top, near, far);
    }

    public void perspective() {
        this.g.perspective();
    }

    public void perspective(float fovy, float aspect, float zNear, float zFar) {
        this.g.perspective(fovy, aspect, zNear, zFar);
    }

    public void frustum(float left, float right, float bottom, float top, float near, float far) {
        this.g.frustum(left, right, bottom, top, near, far);
    }

    public void printProjection() {
        this.g.printProjection();
    }

    public float screenX(float x, float y) {
        return this.g.screenX(x, y);
    }

    public float screenY(float x, float y) {
        return this.g.screenY(x, y);
    }

    public float screenX(float x, float y, float z) {
        return this.g.screenX(x, y, z);
    }

    public float screenY(float x, float y, float z) {
        return this.g.screenY(x, y, z);
    }

    public float screenZ(float x, float y, float z) {
        return this.g.screenZ(x, y, z);
    }

    public float modelX(float x, float y, float z) {
        return this.g.modelX(x, y, z);
    }

    public float modelY(float x, float y, float z) {
        return this.g.modelY(x, y, z);
    }

    public float modelZ(float x, float y, float z) {
        return this.g.modelZ(x, y, z);
    }

    public void pushStyle() {
        this.g.pushStyle();
    }

    public void popStyle() {
        this.g.popStyle();
    }

    public void style(PStyle s) {
        this.g.style(s);
    }

    public void strokeWeight(float weight) {
        this.g.strokeWeight(weight);
    }

    public void strokeJoin(int join) {
        this.g.strokeJoin(join);
    }

    public void strokeCap(int cap) {
        this.g.strokeCap(cap);
    }

    public void noStroke() {
        this.g.noStroke();
    }

    public void stroke(int rgb) {
        this.g.stroke(rgb);
    }

    public void stroke(int rgb, float alpha) {
        this.g.stroke(rgb, alpha);
    }

    public void stroke(float gray) {
        this.g.stroke(gray);
    }

    public void stroke(float gray, float alpha) {
        this.g.stroke(gray, alpha);
    }

    public void stroke(float x, float y, float z) {
        this.g.stroke(x, y, z);
    }

    public void stroke(float x, float y, float z, float a) {
        this.g.stroke(x, y, z, a);
    }

    public void noTint() {
        this.g.noTint();
    }

    public void tint(int rgb) {
        this.g.tint(rgb);
    }

    public void tint(int rgb, float alpha) {
        this.g.tint(rgb, alpha);
    }

    public void tint(float gray) {
        this.g.tint(gray);
    }

    public void tint(float gray, float alpha) {
        this.g.tint(gray, alpha);
    }

    public void tint(float x, float y, float z) {
        this.g.tint(x, y, z);
    }

    public void tint(float x, float y, float z, float a) {
        this.g.tint(x, y, z, a);
    }

    public void noFill() {
        this.g.noFill();
    }

    public void fill(int rgb) {
        this.g.fill(rgb);
    }

    public void fill(int rgb, float alpha) {
        this.g.fill(rgb, alpha);
    }

    public void fill(float gray) {
        this.g.fill(gray);
    }

    public void fill(float gray, float alpha) {
        this.g.fill(gray, alpha);
    }

    public void fill(float x, float y, float z) {
        this.g.fill(x, y, z);
    }

    public void fill(float x, float y, float z, float a) {
        this.g.fill(x, y, z, a);
    }

    public void ambient(int rgb) {
        this.g.ambient(rgb);
    }

    public void ambient(float gray) {
        this.g.ambient(gray);
    }

    public void ambient(float x, float y, float z) {
        this.g.ambient(x, y, z);
    }

    public void specular(int rgb) {
        this.g.specular(rgb);
    }

    public void specular(float gray) {
        this.g.specular(gray);
    }

    public void specular(float x, float y, float z) {
        this.g.specular(x, y, z);
    }

    public void shininess(float shine) {
        this.g.shininess(shine);
    }

    public void emissive(int rgb) {
        this.g.emissive(rgb);
    }

    public void emissive(float gray) {
        this.g.emissive(gray);
    }

    public void emissive(float x, float y, float z) {
        this.g.emissive(x, y, z);
    }

    public void lights() {
        this.g.lights();
    }

    public void noLights() {
        this.g.noLights();
    }

    public void ambientLight(float red, float green, float blue) {
        this.g.ambientLight(red, green, blue);
    }

    public void ambientLight(float red, float green, float blue, float x, float y, float z) {
        this.g.ambientLight(red, green, blue, x, y, z);
    }

    public void directionalLight(float red, float green, float blue, float nx, float ny, float nz) {
        this.g.directionalLight(red, green, blue, nx, ny, nz);
    }

    public void pointLight(float red, float green, float blue, float x, float y, float z) {
        this.g.pointLight(red, green, blue, x, y, z);
    }

    public void spotLight(float red, float green, float blue, float x, float y, float z, float nx, float ny, float nz, float angle, float concentration) {
        this.g.spotLight(red, green, blue, x, y, z, nx, ny, nz, angle, concentration);
    }

    public void lightFalloff(float constant, float linear, float quadratic) {
        this.g.lightFalloff(constant, linear, quadratic);
    }

    public void lightSpecular(float x, float y, float z) {
        this.g.lightSpecular(x, y, z);
    }

    public void background(int rgb) {
        this.g.background(rgb);
    }

    public void background(int rgb, float alpha) {
        this.g.background(rgb, alpha);
    }

    public void background(float gray) {
        this.g.background(gray);
    }

    public void background(float gray, float alpha) {
        this.g.background(gray, alpha);
    }

    public void background(float x, float y, float z) {
        this.g.background(x, y, z);
    }

    public void background(float x, float y, float z, float a) {
        this.g.background(x, y, z, a);
    }

    public void clear() {
        this.g.clear();
    }

    public void background(PImage image) {
        this.g.background(image);
    }

    public void colorMode(int mode) {
        this.g.colorMode(mode);
    }

    public void colorMode(int mode, float max) {
        this.g.colorMode(mode, max);
    }

    public void colorMode(int mode, float maxX, float maxY, float maxZ) {
        this.g.colorMode(mode, maxX, maxY, maxZ);
    }

    public void colorMode(int mode, float maxX, float maxY, float maxZ, float maxA) {
        this.g.colorMode(mode, maxX, maxY, maxZ, maxA);
    }

    public final float alpha(int what) {
        return this.g.alpha(what);
    }

    public final float red(int what) {
        return this.g.red(what);
    }

    public final float green(int what) {
        return this.g.green(what);
    }

    public final float blue(int what) {
        return this.g.blue(what);
    }

    public final float hue(int what) {
        return this.g.hue(what);
    }

    public final float saturation(int what) {
        return this.g.saturation(what);
    }

    public final float brightness(int what) {
        return this.g.brightness(what);
    }

    public int lerpColor(int c1, int c2, float amt) {
        return this.g.lerpColor(c1, c2, amt);
    }

    public static int lerpColor(int c1, int c2, float amt, int mode) {
        return PGraphics.lerpColor(c1, c2, amt, mode);
    }

    public static void showDepthWarning(String method) {
        PGraphics.showDepthWarning(method);
    }

    public static void showDepthWarningXYZ(String method) {
        PGraphics.showDepthWarningXYZ(method);
    }

    public static void showMethodWarning(String method) {
        PGraphics.showMethodWarning(method);
    }

    public static void showVariationWarning(String str) {
        PGraphics.showVariationWarning(str);
    }

    public static void showMissingWarning(String method) {
        PGraphics.showMissingWarning(method);
    }

    public boolean displayable() {
        return this.g.displayable();
    }

    public boolean isGL() {
        return this.g.isGL();
    }

    public Object getNative() {
        return this.g.getNative();
    }

    public void setNative(Object nativeObject) {
        this.g.setNative(nativeObject);
    }

    public int get(int x, int y) {
        return this.g.get(x, y);
    }

    public PImage get(int x, int y, int w, int h) {
        return this.g.get(x, y, w, h);
    }

    public PImage get() {
        return this.g.get();
    }

    public void set(int x, int y, int c) {
        this.g.set(x, y, c);
    }

    public void set(int x, int y, PImage img) {
        this.g.set(x, y, img);
    }

    public void mask(int[] alpha) {
        this.g.mask(alpha);
    }

    public void mask(PImage alpha) {
        this.g.mask(alpha);
    }

    public void filter(int kind) {
        this.g.filter(kind);
    }

    public void filter(int kind, float param) {
        this.g.filter(kind, param);
    }

    public void copy(int sx, int sy, int sw, int sh, int dx, int dy, int dw, int dh) {
        this.g.copy(sx, sy, sw, sh, dx, dy, dw, dh);
    }

    public void copy(PImage src, int sx, int sy, int sw, int sh, int dx, int dy, int dw, int dh) {
        this.g.copy(src, sx, sy, sw, sh, dx, dy, dw, dh);
    }

    public void blend(int sx, int sy, int sw, int sh, int dx, int dy, int dw, int dh, int mode) {
        this.g.blend(sx, sy, sw, sh, dx, dy, dw, dh, mode);
    }

    public void blend(PImage src, int sx, int sy, int sw, int sh, int dx, int dy, int dw, int dh, int mode) {
        this.g.blend(src, sx, sy, sw, sh, dx, dy, dw, dh, mode);
    }

    static {
        ICON_IMAGE = new byte[]{71, 73, 70, 56, 57, 97, 16, 0, 16, 0, -77, 0, 0, 0, 0, 0, -1, -1, -1, 12, 12, 13, -15, -15, -14, 45, 57, 74, 54, 80, 111, 47, 71, 97, 62, 88, 117, 1, 14, 27, 7, 41, 73, 15, 52, 85, 2, 31, 55, 4, 54, 94, 18, 69, 109, 37, 87, 126, -1, -1, -1, 33, -7, 4, 1, 0, 0, 15, 0, 44, 0, 0, 0, 0, 16, 0, 16, 0, 0, 4, 122, -16, -107, 114, -86, -67, 83, 30, -42, 26, -17, -100, -45, 56, -57, -108, 48, 40, 122, -90, 104, 67, -91, -51, 32, -53, 77, -78, -100, 47, -86, 12, 76, -110, -20, -74, -101, 97, -93, 27, 40, 20, -65, 65, 48, -111, 99, -20, -112, -117, -123, -47, -105, 24, 114, -112, 74, 69, 84, 25, 93, 88, -75, 9, 46, 2, 49, 88, -116, -67, 7, -19, -83, 60, 38, 3, -34, 2, 66, -95, 27, -98, 13, 4, -17, 55, 33, 109, 11, 11, -2, -128, 121, 123, 62, 91, 120, -128, 127, 122, 115, 102, 2, 119, 0, -116, -113, -119, 6, 102, 121, -108, -126, 5, 18, 6, 4, -102, -101, -100, 114, 15, 17, 0, 59};
    }

    class AsyncImageLoader
    extends Thread {
        String filename;
        PImage vessel;

        public AsyncImageLoader(String filename, PImage vessel) {
            this.filename = filename;
            this.vessel = vessel;
        }

        @Override
        public void run() {
            while (PApplet.this.requestImageCount == PApplet.this.requestImageMax) {
                try {
                    Thread.sleep(10L);
                }
                catch (InterruptedException interruptedException) {}
            }
            ++PApplet.this.requestImageCount;
            PImage actual = PApplet.this.loadImage(this.filename);
            if (actual == null) {
                this.vessel.width = -1;
                this.vessel.height = -1;
            } else {
                this.vessel.width = actual.width;
                this.vessel.height = actual.height;
                this.vessel.format = actual.format;
                this.vessel.pixels = actual.pixels;
                this.vessel.bitmap = actual.bitmap;
                this.vessel.pixelWidth = actual.width;
                this.vessel.pixelHeight = actual.height;
                this.vessel.pixelDensity = 1;
            }
            --PApplet.this.requestImageCount;
        }
    }

    class InternalEventQueue {
        protected Event[] queue = new Event[10];
        protected int offset;
        protected int count;

        InternalEventQueue() {
        }

        synchronized void add(Event e) {
            if (this.count == this.queue.length) {
                this.queue = (Event[])PApplet.expand(this.queue);
            }
            this.queue[this.count++] = e;
        }

        synchronized Event remove() {
            if (this.offset == this.count) {
                throw new RuntimeException("Nothing left on the event queue.");
            }
            Event outgoing = this.queue[this.offset++];
            if (this.offset == this.count) {
                this.offset = 0;
                this.count = 0;
            }
            return outgoing;
        }

        synchronized boolean available() {
            return this.count != 0;
        }
    }

    class RegisteredMethods {
        int count;
        Object[] objects;
        Method[] methods;
        Object[] emptyArgs = new Object[0];

        RegisteredMethods() {
        }

        void handle() {
            this.handle(this.emptyArgs);
        }

        void handle(Object[] args) {
            for (int i = 0; i < this.count; ++i) {
                try {
                    this.methods[i].invoke(this.objects[i], args);
                    continue;
                }
                catch (Exception e) {
                    Throwable t;
                    if (e instanceof InvocationTargetException) {
                        InvocationTargetException ite = (InvocationTargetException)e;
                        t = ite.getCause();
                    } else {
                        t = e;
                    }
                    if (t instanceof RuntimeException) {
                        throw (RuntimeException)t;
                    }
                    t.printStackTrace();
                }
            }
        }

        void add(Object object, Method method) {
            if (this.findIndex(object) == -1) {
                if (this.objects == null) {
                    this.objects = new Object[5];
                    this.methods = new Method[5];
                } else if (this.count == this.objects.length) {
                    this.objects = (Object[])PApplet.expand(this.objects);
                    this.methods = (Method[])PApplet.expand(this.methods);
                }
                this.objects[this.count] = object;
                this.methods[this.count] = method;
                ++this.count;
            } else {
                PApplet.this.die(method.getName() + "() already added for this instance of " + object.getClass().getName());
            }
        }

        public void remove(Object object) {
            int index = this.findIndex(object);
            if (index != -1) {
                --this.count;
                for (int i = index; i < this.count; ++i) {
                    this.objects[i] = this.objects[i + 1];
                    this.methods[i] = this.methods[i + 1];
                }
                this.objects[this.count] = null;
                this.methods[this.count] = null;
            }
        }

        protected int findIndex(Object object) {
            for (int i = 0; i < this.count; ++i) {
                if (this.objects[i] != object) continue;
                return i;
            }
            return -1;
        }
    }
}

