/*
 * Decompiled with CFR 0.152.
 */
package processing.opengl;

import processing.opengl.PGL;
import processing.opengl.PGraphicsOpenGL;

public class VertexBuffer {
    protected static final int INIT_VERTEX_BUFFER_SIZE = 256;
    protected static final int INIT_INDEX_BUFFER_SIZE = 512;
    public int glId;
    int target;
    int elementSize;
    int ncoords;
    boolean index;
    protected PGL pgl;
    protected int context;
    private PGraphicsOpenGL.GLResourceVertexBuffer glres;

    VertexBuffer(PGraphicsOpenGL pGraphicsOpenGL, int n, int n2, int n3) {
        this(pGraphicsOpenGL, n, n2, n3, false);
    }

    VertexBuffer(PGraphicsOpenGL pGraphicsOpenGL, int n, int n2, int n3, boolean bl) {
        this.pgl = pGraphicsOpenGL.pgl;
        this.context = this.pgl.createEmptyContext();
        this.target = n;
        this.ncoords = n2;
        this.elementSize = n3;
        this.index = bl;
        this.create();
        this.init();
    }

    protected void create() {
        this.context = this.pgl.getCurrentContext();
        this.glres = new PGraphicsOpenGL.GLResourceVertexBuffer(this);
    }

    protected void init() {
        int n = this.index ? this.ncoords * 512 * this.elementSize : this.ncoords * 256 * this.elementSize;
        this.pgl.bindBuffer(this.target, this.glId);
        this.pgl.bufferData(this.target, n, null, PGL.STATIC_DRAW);
    }

    protected void dispose() {
        if (this.glres != null) {
            this.glres.dispose();
            this.glId = 0;
            this.glres = null;
        }
    }

    protected boolean contextIsOutdated() {
        boolean bl;
        boolean bl2 = bl = !this.pgl.contextIsCurrent(this.context);
        if (bl) {
            this.dispose();
        }
        return bl;
    }
}

