/*
 * Decompiled with CFR 0.152.
 */
package processing.opengl;

import android.app.ActivityManager;
import android.content.Context;
import android.content.pm.ConfigurationInfo;
import android.opengl.GLSurfaceView;
import android.service.wallpaper.WallpaperService;
import android.support.wearable.watchface.Gles2WatchFaceService;
import android.view.KeyEvent;
import android.view.MotionEvent;
import android.view.SurfaceHolder;
import javax.microedition.khronos.egl.EGL10;
import javax.microedition.khronos.egl.EGLConfig;
import javax.microedition.khronos.egl.EGLContext;
import javax.microedition.khronos.egl.EGLDisplay;
import javax.microedition.khronos.opengles.GL10;
import processing.android.AppComponent;
import processing.android.PFragment;
import processing.core.PApplet;
import processing.core.PGraphics;
import processing.core.PSurfaceNone;
import processing.opengl.PGLES;
import processing.opengl.PGraphicsOpenGL;

public class PSurfaceGLES
extends PSurfaceNone {
    public PGLES pgl;
    private SurfaceViewGLES glsurf;

    public PSurfaceGLES() {
    }

    public PSurfaceGLES(PGraphics pGraphics, AppComponent appComponent, SurfaceHolder surfaceHolder) {
        this.sketch = pGraphics.parent;
        this.graphics = pGraphics;
        this.component = appComponent;
        this.pgl = (PGLES)((PGraphicsOpenGL)pGraphics).pgl;
        if (appComponent.getKind() == 0) {
            PFragment pFragment = (PFragment)appComponent;
            this.activity = pFragment.getActivity();
            this.surfaceView = new SurfaceViewGLES((Context)this.activity, null);
        } else if (appComponent.getKind() == 1) {
            this.wallpaper = (WallpaperService)appComponent;
            this.surfaceView = new SurfaceViewGLES((Context)this.wallpaper, surfaceHolder);
        } else if (appComponent.getKind() == 2) {
            this.watchface = (Gles2WatchFaceService)appComponent;
            this.surfaceReady = true;
        }
        this.glsurf = (SurfaceViewGLES)this.surfaceView;
    }

    @Override
    public void dispose() {
        super.dispose();
        if (this.glsurf != null) {
            this.glsurf.dispose();
            this.glsurf = null;
        }
    }

    @Override
    protected void callDraw() {
        this.component.requestDraw();
        if (this.component.canDraw() && this.glsurf != null) {
            this.glsurf.requestRender();
        }
    }

    public RendererGLES getRenderer() {
        return new RendererGLES();
    }

    public ContextFactoryGLES getContextFactory() {
        return new ContextFactoryGLES();
    }

    public ConfigChooserGLES getConfigChooser(int n) {
        return new ConfigChooserGLES(5, 6, 5, 4, 16, 1, n);
    }

    public ConfigChooserGLES getConfigChooser(int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        return new ConfigChooserGLES(n, n2, n3, n4, n5, n6, n7);
    }

    protected class ConfigChooserGLES
    implements GLSurfaceView.EGLConfigChooser {
        public int redTarget;
        public int greenTarget;
        public int blueTarget;
        public int alphaTarget;
        public int depthTarget;
        public int stencilTarget;
        public int redBits;
        public int greenBits;
        public int blueBits;
        public int alphaBits;
        public int depthBits;
        public int stencilBits;
        public int[] tempValue = new int[1];
        public int numSamples;
        protected int[] attribsNoMSAA = new int[]{12352, 4, 12338, 0, 12344};

        public ConfigChooserGLES(int n, int n2, int n3, int n4, int n5, int n6, int n7) {
            this.redTarget = n;
            this.greenTarget = n2;
            this.blueTarget = n3;
            this.alphaTarget = n4;
            this.depthTarget = n5;
            this.stencilTarget = n6;
            this.numSamples = n7;
        }

        public EGLConfig chooseConfig(EGL10 eGL10, EGLDisplay eGLDisplay) {
            EGLConfig[] eGLConfigArray = null;
            if (1 < this.numSamples) {
                int[] nArray = new int[]{12352, 4, 12338, 1, 12337, this.numSamples, 12344};
                eGLConfigArray = this.chooseConfigWithAttribs(eGL10, eGLDisplay, nArray);
                if (eGLConfigArray == null) {
                    int[] nArray2 = new int[]{12352, 4, 12512, 1, 12513, this.numSamples, 12344};
                    eGLConfigArray = this.chooseConfigWithAttribs(eGL10, eGLDisplay, nArray2);
                    if (eGLConfigArray == null) {
                        eGLConfigArray = this.chooseConfigWithAttribs(eGL10, eGLDisplay, this.attribsNoMSAA);
                    } else {
                        PGLES.usingMultisampling = true;
                        PGLES.usingCoverageMultisampling = true;
                        PGLES.multisampleCount = this.numSamples;
                    }
                } else {
                    PGLES.usingMultisampling = true;
                    PGLES.usingCoverageMultisampling = false;
                    PGLES.multisampleCount = this.numSamples;
                }
            } else {
                eGLConfigArray = this.chooseConfigWithAttribs(eGL10, eGLDisplay, this.attribsNoMSAA);
            }
            if (eGLConfigArray == null) {
                throw new IllegalArgumentException("No EGL configs match configSpec");
            }
            return this.chooseBestConfig(eGL10, eGLDisplay, eGLConfigArray);
        }

        public EGLConfig chooseBestConfig(EGL10 eGL10, EGLDisplay eGLDisplay, EGLConfig[] eGLConfigArray) {
            EGLConfig eGLConfig = null;
            float f = Float.MAX_VALUE;
            for (EGLConfig eGLConfig2 : eGLConfigArray) {
                boolean bl;
                int n = this.findConfigAttrib(eGL10, eGLDisplay, eGLConfig2, 12352, 0);
                boolean bl2 = bl = (n & 4) != 0;
                if (!bl) continue;
                int n2 = this.findConfigAttrib(eGL10, eGLDisplay, eGLConfig2, 12325, 0);
                int n3 = this.findConfigAttrib(eGL10, eGLDisplay, eGLConfig2, 12326, 0);
                int n4 = this.findConfigAttrib(eGL10, eGLDisplay, eGLConfig2, 12324, 0);
                int n5 = this.findConfigAttrib(eGL10, eGLDisplay, eGLConfig2, 12323, 0);
                int n6 = this.findConfigAttrib(eGL10, eGLDisplay, eGLConfig2, 12322, 0);
                int n7 = this.findConfigAttrib(eGL10, eGLDisplay, eGLConfig2, 12321, 0);
                float f2 = 0.2f * (float)PApplet.abs(n4 - this.redTarget) + 0.2f * (float)PApplet.abs(n5 - this.greenTarget) + 0.2f * (float)PApplet.abs(n6 - this.blueTarget) + 0.15f * (float)PApplet.abs(n7 - this.alphaTarget) + 0.15f * (float)PApplet.abs(n2 - this.depthTarget) + 0.1f * (float)PApplet.abs(n3 - this.stencilTarget);
                if (!(f2 < f)) continue;
                eGLConfig = eGLConfig2;
                f = f2;
                this.redBits = n4;
                this.greenBits = n5;
                this.blueBits = n6;
                this.alphaBits = n7;
                this.depthBits = n2;
                this.stencilBits = n3;
            }
            return eGLConfig;
        }

        protected String printConfig(EGL10 eGL10, EGLDisplay eGLDisplay, EGLConfig eGLConfig) {
            int n = this.findConfigAttrib(eGL10, eGLDisplay, eGLConfig, 12324, 0);
            int n2 = this.findConfigAttrib(eGL10, eGLDisplay, eGLConfig, 12323, 0);
            int n3 = this.findConfigAttrib(eGL10, eGLDisplay, eGLConfig, 12322, 0);
            int n4 = this.findConfigAttrib(eGL10, eGLDisplay, eGLConfig, 12321, 0);
            int n5 = this.findConfigAttrib(eGL10, eGLDisplay, eGLConfig, 12325, 0);
            int n6 = this.findConfigAttrib(eGL10, eGLDisplay, eGLConfig, 12326, 0);
            int n7 = this.findConfigAttrib(eGL10, eGLDisplay, eGLConfig, 12352, 0);
            int n8 = this.findConfigAttrib(eGL10, eGLDisplay, eGLConfig, 12333, 0);
            int n9 = this.findConfigAttrib(eGL10, eGLDisplay, eGLConfig, 12320, 0);
            int n10 = this.findConfigAttrib(eGL10, eGLDisplay, eGLConfig, 12422, 0);
            return String.format("EGLConfig rgba=%d%d%d%d depth=%d stencil=%d", n, n2, n3, n4, n5, n6) + " type=" + n7 + " native=" + n8 + " buffer size=" + n9 + " buffer surface=" + n10 + String.format(" caveat=0x%04x", this.findConfigAttrib(eGL10, eGLDisplay, eGLConfig, 12327, 0));
        }

        protected int findConfigAttrib(EGL10 eGL10, EGLDisplay eGLDisplay, EGLConfig eGLConfig, int n, int n2) {
            if (eGL10.eglGetConfigAttrib(eGLDisplay, eGLConfig, n, this.tempValue)) {
                return this.tempValue[0];
            }
            return n2;
        }

        protected EGLConfig[] chooseConfigWithAttribs(EGL10 eGL10, EGLDisplay eGLDisplay, int[] nArray) {
            int[] nArray2 = new int[1];
            eGL10.eglChooseConfig(eGLDisplay, nArray, null, 0, nArray2);
            int n = nArray2[0];
            if (n <= 0) {
                return null;
            }
            EGLConfig[] eGLConfigArray = new EGLConfig[n];
            eGL10.eglChooseConfig(eGLDisplay, nArray, eGLConfigArray, n, nArray2);
            return eGLConfigArray;
        }
    }

    protected class ContextFactoryGLES
    implements GLSurfaceView.EGLContextFactory {
        protected ContextFactoryGLES() {
        }

        public EGLContext createContext(EGL10 eGL10, EGLDisplay eGLDisplay, EGLConfig eGLConfig) {
            int[] nArray = new int[]{12440, 2, 12344};
            EGLContext eGLContext = eGL10.eglCreateContext(eGLDisplay, eGLConfig, EGL10.EGL_NO_CONTEXT, nArray);
            return eGLContext;
        }

        public void destroyContext(EGL10 eGL10, EGLDisplay eGLDisplay, EGLContext eGLContext) {
            eGL10.eglDestroyContext(eGLDisplay, eGLContext);
        }
    }

    protected class RendererGLES
    implements GLSurfaceView.Renderer {
        public void onDrawFrame(GL10 gL10) {
            PSurfaceGLES.this.pgl.getGL(gL10);
            PSurfaceGLES.this.sketch.handleDraw();
        }

        public void onSurfaceChanged(GL10 gL10, int n, int n2) {
            PSurfaceGLES.this.pgl.getGL(gL10);
            PSurfaceGLES.this.sketch.surfaceChanged();
            PSurfaceGLES.this.graphics.surfaceChanged();
            PSurfaceGLES.this.sketch.setSize(n, n2);
            PSurfaceGLES.this.graphics.setSize(PSurfaceGLES.this.sketch.sketchWidth(), PSurfaceGLES.this.sketch.sketchHeight());
        }

        public void onSurfaceCreated(GL10 gL10, EGLConfig eGLConfig) {
            PSurfaceGLES.this.pgl.init(gL10);
        }
    }

    public class SurfaceViewGLES
    extends GLSurfaceView {
        SurfaceHolder holder;

        public SurfaceViewGLES(Context context, SurfaceHolder surfaceHolder) {
            boolean bl;
            super(context);
            this.holder = surfaceHolder;
            ActivityManager activityManager = (ActivityManager)context.getSystemService("activity");
            ConfigurationInfo configurationInfo = activityManager.getDeviceConfigurationInfo();
            boolean bl2 = bl = configurationInfo.reqGlEsVersion >= 131072;
            if (!bl) {
                throw new RuntimeException("OpenGL ES 2.0 is not supported by this device.");
            }
            SurfaceHolder surfaceHolder2 = this.getHolder();
            surfaceHolder2.addCallback((SurfaceHolder.Callback)this);
            this.setEGLContextClientVersion(2);
            this.setPreserveEGLContextOnPause(true);
            int n = PSurfaceGLES.this.sketch.sketchSmooth();
            if (1 < n) {
                this.setEGLConfigChooser(PSurfaceGLES.this.getConfigChooser(n));
            }
            this.setRenderer(PSurfaceGLES.this.getRenderer());
            this.setRenderMode(0);
            this.setFocusable(true);
            this.setFocusableInTouchMode(true);
            this.requestFocus();
            PSurfaceGLES.this.surfaceReady = false;
        }

        public SurfaceHolder getHolder() {
            if (this.holder == null) {
                return super.getHolder();
            }
            return this.holder;
        }

        public void dispose() {
            super.destroyDrawingCache();
            super.onDetachedFromWindow();
        }

        public void surfaceChanged(SurfaceHolder surfaceHolder, int n, int n2, int n3) {
            super.surfaceChanged(surfaceHolder, n, n2, n3);
        }

        public void surfaceCreated(SurfaceHolder surfaceHolder) {
            super.surfaceCreated(surfaceHolder);
            PSurfaceGLES.this.surfaceReady = true;
            if (PSurfaceGLES.this.requestedThreadStart) {
                PSurfaceGLES.this.startThread();
            }
        }

        public void surfaceDestroyed(SurfaceHolder surfaceHolder) {
            super.surfaceDestroyed(surfaceHolder);
        }

        public void onWindowFocusChanged(boolean bl) {
            super.onWindowFocusChanged(bl);
            PSurfaceGLES.this.sketch.surfaceWindowFocusChanged(bl);
        }

        public boolean onTouchEvent(MotionEvent motionEvent) {
            boolean bl;
            boolean bl2 = bl = ((PSurfaceGLES)PSurfaceGLES.this).sketch.width == ((PSurfaceGLES)PSurfaceGLES.this).sketch.displayWidth && ((PSurfaceGLES)PSurfaceGLES.this).sketch.height == ((PSurfaceGLES)PSurfaceGLES.this).sketch.displayHeight;
            if (bl && PApplet.SDK < 19) {
                this.setSystemUiVisibility(2);
            }
            return PSurfaceGLES.this.sketch.surfaceTouchEvent(motionEvent);
        }

        public boolean onKeyDown(int n, KeyEvent keyEvent) {
            PSurfaceGLES.this.sketch.surfaceKeyDown(n, keyEvent);
            return super.onKeyDown(n, keyEvent);
        }

        public boolean onKeyUp(int n, KeyEvent keyEvent) {
            PSurfaceGLES.this.sketch.surfaceKeyUp(n, keyEvent);
            return super.onKeyUp(n, keyEvent);
        }
    }
}

