/*
 * Decompiled with CFR 0.152.
 */
package processing.opengl;

import java.io.IOException;
import java.net.URL;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.ShortBuffer;
import java.util.Arrays;
import java.util.regex.Pattern;
import processing.core.PApplet;
import processing.core.PGraphics;
import processing.opengl.PGraphicsOpenGL;
import processing.opengl.Texture;

public abstract class PGL {
    protected PGraphicsOpenGL graphics;
    protected PApplet sketch;
    protected Thread glThread;
    protected int glContext;
    public boolean primaryPGL;
    public static int REQUESTED_DEPTH_BITS = 24;
    public static int REQUESTED_STENCIL_BITS = 8;
    public static int REQUESTED_ALPHA_BITS = 8;
    protected static boolean USE_DIRECT_BUFFERS = true;
    protected static int MIN_DIRECT_BUFFER_SIZE = 1;
    protected static boolean MIPMAPS_ENABLED = true;
    protected static int DEFAULT_IN_VERTICES = 64;
    protected static int DEFAULT_IN_EDGES = 128;
    protected static int DEFAULT_IN_TEXTURES = 64;
    protected static int DEFAULT_TESS_VERTICES = 64;
    protected static int DEFAULT_TESS_INDICES = 128;
    protected static int MAX_LIGHTS = 8;
    protected static int MAX_VERTEX_INDEX = Short.MAX_VALUE;
    protected static int MAX_VERTEX_INDEX1;
    protected static int FLUSH_VERTEX_COUNT;
    protected static int MIN_FONT_TEX_SIZE;
    protected static int MAX_FONT_TEX_SIZE;
    protected static float MIN_CAPS_JOINS_WEIGHT;
    protected static int MAX_CAPS_JOINS_LENGTH;
    protected static int MIN_ARRAYCOPY_SIZE;
    protected static float STROKE_DISPLACEMENT;
    protected IntBuffer firstFrame;
    protected static boolean SINGLE_BUFFERED;
    protected boolean fboLayerEnabled = false;
    protected boolean fboLayerCreated = false;
    protected boolean fboLayerEnabledReq = false;
    protected boolean fboLayerDisableReq = false;
    protected boolean fbolayerResetReq = false;
    public int reqNumSamples;
    protected int numSamples;
    protected IntBuffer glColorFbo;
    protected IntBuffer glColorTex;
    protected IntBuffer glDepthStencil;
    protected IntBuffer glDepth;
    protected IntBuffer glStencil;
    protected IntBuffer glMultiFbo;
    protected IntBuffer glMultiColor;
    protected IntBuffer glMultiDepthStencil;
    protected IntBuffer glMultiDepth;
    protected IntBuffer glMultiStencil;
    protected int fboWidth;
    protected int fboHeight;
    protected int backTex;
    protected int frontTex;
    protected boolean usingFrontTex = false;
    protected boolean needSepFrontTex = false;
    protected boolean loadedTex2DShader = false;
    protected int tex2DShaderProgram;
    protected int tex2DVertShader;
    protected int tex2DFragShader;
    protected int tex2DShaderContext;
    protected int tex2DVertLoc;
    protected int tex2DTCoordLoc;
    protected int tex2DSamplerLoc;
    protected int tex2DGeoVBO;
    protected boolean loadedTexRectShader = false;
    protected int texRectShaderProgram;
    protected int texRectVertShader;
    protected int texRectFragShader;
    protected int texRectShaderContext;
    protected int texRectVertLoc;
    protected int texRectTCoordLoc;
    protected int texRectSamplerLoc;
    protected int texRectGeoVBO;
    protected float[] texCoords = new float[]{-1.0f, -1.0f, 0.0f, 0.0f, 1.0f, -1.0f, 1.0f, 0.0f, -1.0f, 1.0f, 0.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f};
    protected FloatBuffer texData;
    protected static final String SHADER_PREPROCESSOR_DIRECTIVE = "#ifdef GL_ES\nprecision mediump float;\nprecision mediump int;\n#endif\n";
    protected static String[] texVertShaderSource;
    protected static String[] tex2DFragShaderSource;
    protected static String[] texRectFragShaderSource;
    protected boolean[] texturingTargets = new boolean[]{false, false};
    protected int maxTexUnits;
    protected int activeTexUnit = 0;
    protected int[][] boundTextures;
    protected float targetFps = 60.0f;
    protected float currentFps = 60.0f;
    protected boolean setFps = false;
    protected ByteBuffer byteBuffer;
    protected IntBuffer intBuffer;
    protected IntBuffer viewBuffer;
    protected IntBuffer colorBuffer;
    protected FloatBuffer depthBuffer;
    protected ByteBuffer stencilBuffer;
    protected int geomCount = 0;
    protected int pgeomCount;
    protected boolean clearColor = false;
    protected boolean pclearColor;
    protected boolean clearDepth = false;
    protected boolean pclearDepth;
    protected boolean clearStencil = false;
    protected boolean pclearStencil;
    public static final String WIKI = " Read http://wiki.processing.org/w/OpenGL_Issues for help.";
    public static final String FRAMEBUFFER_ERROR = "Framebuffer error (%1$s), rendering will probably not work as expected Read http://wiki.processing.org/w/OpenGL_Issues for help.";
    public static final String MISSING_FBO_ERROR = "Framebuffer objects are not supported by this hardware (or driver) Read http://wiki.processing.org/w/OpenGL_Issues for help.";
    public static final String MISSING_GLSL_ERROR = "GLSL shaders are not supported by this hardware (or driver) Read http://wiki.processing.org/w/OpenGL_Issues for help.";
    public static final String MISSING_GLFUNC_ERROR = "GL function %1$s is not available on this hardware (or driver) Read http://wiki.processing.org/w/OpenGL_Issues for help.";
    public static final String UNSUPPORTED_GLPROF_ERROR = "Unsupported OpenGL profile.";
    public static final String TEXUNIT_ERROR = "Number of texture units not supported by this hardware (or driver) Read http://wiki.processing.org/w/OpenGL_Issues for help.";
    public static final String NONPRIMARY_ERROR = "The renderer is trying to call a PGL function that can only be called on a primary PGL. This is most likely due to a bug in the renderer's code, please report it with an issue on Processing's github page https://github.com/processing/processing/issues?state=open if using any of the built-in OpenGL renderers. If you are using a contributed library, contact the library's developers.";
    protected static final String DEPTH_READING_NOT_ENABLED_ERROR = "Reading depth and stencil values from this multisampled buffer is not enabled. You can enable it by calling hint(ENABLE_DEPTH_READING) once. If your sketch becomes too slow, disable multisampling with noSmooth() instead.";
    protected static int SIZEOF_SHORT;
    protected static int SIZEOF_INT;
    protected static int SIZEOF_FLOAT;
    protected static int SIZEOF_BYTE;
    protected static int SIZEOF_INDEX;
    protected static int INDEX_TYPE;
    protected static float FLOAT_EPS;
    protected static boolean BIG_ENDIAN;
    protected boolean presentMode = false;
    protected boolean showStopButton = true;
    public float presentX;
    public float presentY;
    protected IntBuffer closeButtonTex;
    protected int stopButtonColor;
    protected int stopButtonWidth = 28;
    protected int stopButtonHeight = 12;
    protected int stopButtonX = 21;
    protected int closeButtonY = 21;
    protected static int[] closeButtonPix;
    protected static final String GLSL_ID_REGEX = "(?<![0-9A-Z_a-z])(%s)(?![0-9A-Z_a-z]|\\s*\\()";
    protected static final String GLSL_FN_REGEX = "(?<![0-9A-Z_a-z])(%s)(?=\\s*\\()";
    protected static boolean SHAPE_TEXT_SUPPORTED;
    protected static int SEG_MOVETO;
    protected static int SEG_LINETO;
    protected static int SEG_QUADTO;
    protected static int SEG_CUBICTO;
    protected static int SEG_CLOSE;
    public static int FALSE;
    public static int TRUE;
    public static int INT;
    public static int BYTE;
    public static int SHORT;
    public static int FLOAT;
    public static int BOOL;
    public static int UNSIGNED_INT;
    public static int UNSIGNED_BYTE;
    public static int UNSIGNED_SHORT;
    public static int RGB;
    public static int RGBA;
    public static int ALPHA;
    public static int LUMINANCE;
    public static int LUMINANCE_ALPHA;
    public static int UNSIGNED_SHORT_5_6_5;
    public static int UNSIGNED_SHORT_4_4_4_4;
    public static int UNSIGNED_SHORT_5_5_5_1;
    public static int RGBA4;
    public static int RGB5_A1;
    public static int RGB565;
    public static int RGB8;
    public static int RGBA8;
    public static int ALPHA8;
    public static int READ_ONLY;
    public static int WRITE_ONLY;
    public static int READ_WRITE;
    public static int TESS_WINDING_NONZERO;
    public static int TESS_WINDING_ODD;
    public static int TESS_EDGE_FLAG;
    public static int GENERATE_MIPMAP_HINT;
    public static int FASTEST;
    public static int NICEST;
    public static int DONT_CARE;
    public static int VENDOR;
    public static int RENDERER;
    public static int VERSION;
    public static int EXTENSIONS;
    public static int SHADING_LANGUAGE_VERSION;
    public static int MAX_SAMPLES;
    public static int SAMPLES;
    public static int ALIASED_LINE_WIDTH_RANGE;
    public static int ALIASED_POINT_SIZE_RANGE;
    public static int DEPTH_BITS;
    public static int STENCIL_BITS;
    public static int CCW;
    public static int CW;
    public static int VIEWPORT;
    public static int ARRAY_BUFFER;
    public static int ELEMENT_ARRAY_BUFFER;
    public static int PIXEL_PACK_BUFFER;
    public static int MAX_VERTEX_ATTRIBS;
    public static int STATIC_DRAW;
    public static int DYNAMIC_DRAW;
    public static int STREAM_DRAW;
    public static int STREAM_READ;
    public static int BUFFER_SIZE;
    public static int BUFFER_USAGE;
    public static int POINTS;
    public static int LINE_STRIP;
    public static int LINE_LOOP;
    public static int LINES;
    public static int TRIANGLE_FAN;
    public static int TRIANGLE_STRIP;
    public static int TRIANGLES;
    public static int CULL_FACE;
    public static int FRONT;
    public static int BACK;
    public static int FRONT_AND_BACK;
    public static int POLYGON_OFFSET_FILL;
    public static int UNPACK_ALIGNMENT;
    public static int PACK_ALIGNMENT;
    public static int TEXTURE_2D;
    public static int TEXTURE_RECTANGLE;
    public static int TEXTURE_BINDING_2D;
    public static int TEXTURE_BINDING_RECTANGLE;
    public static int MAX_TEXTURE_SIZE;
    public static int TEXTURE_MAX_ANISOTROPY;
    public static int MAX_TEXTURE_MAX_ANISOTROPY;
    public static int MAX_VERTEX_TEXTURE_IMAGE_UNITS;
    public static int MAX_TEXTURE_IMAGE_UNITS;
    public static int MAX_COMBINED_TEXTURE_IMAGE_UNITS;
    public static int NUM_COMPRESSED_TEXTURE_FORMATS;
    public static int COMPRESSED_TEXTURE_FORMATS;
    public static int NEAREST;
    public static int LINEAR;
    public static int LINEAR_MIPMAP_NEAREST;
    public static int LINEAR_MIPMAP_LINEAR;
    public static int CLAMP_TO_EDGE;
    public static int REPEAT;
    public static int TEXTURE0;
    public static int TEXTURE1;
    public static int TEXTURE2;
    public static int TEXTURE3;
    public static int TEXTURE_MIN_FILTER;
    public static int TEXTURE_MAG_FILTER;
    public static int TEXTURE_WRAP_S;
    public static int TEXTURE_WRAP_T;
    public static int TEXTURE_WRAP_R;
    public static int TEXTURE_CUBE_MAP;
    public static int TEXTURE_CUBE_MAP_POSITIVE_X;
    public static int TEXTURE_CUBE_MAP_POSITIVE_Y;
    public static int TEXTURE_CUBE_MAP_POSITIVE_Z;
    public static int TEXTURE_CUBE_MAP_NEGATIVE_X;
    public static int TEXTURE_CUBE_MAP_NEGATIVE_Y;
    public static int TEXTURE_CUBE_MAP_NEGATIVE_Z;
    public static int VERTEX_SHADER;
    public static int FRAGMENT_SHADER;
    public static int INFO_LOG_LENGTH;
    public static int SHADER_SOURCE_LENGTH;
    public static int COMPILE_STATUS;
    public static int LINK_STATUS;
    public static int VALIDATE_STATUS;
    public static int SHADER_TYPE;
    public static int DELETE_STATUS;
    public static int FLOAT_VEC2;
    public static int FLOAT_VEC3;
    public static int FLOAT_VEC4;
    public static int FLOAT_MAT2;
    public static int FLOAT_MAT3;
    public static int FLOAT_MAT4;
    public static int INT_VEC2;
    public static int INT_VEC3;
    public static int INT_VEC4;
    public static int BOOL_VEC2;
    public static int BOOL_VEC3;
    public static int BOOL_VEC4;
    public static int SAMPLER_2D;
    public static int SAMPLER_CUBE;
    public static int LOW_FLOAT;
    public static int MEDIUM_FLOAT;
    public static int HIGH_FLOAT;
    public static int LOW_INT;
    public static int MEDIUM_INT;
    public static int HIGH_INT;
    public static int CURRENT_VERTEX_ATTRIB;
    public static int VERTEX_ATTRIB_ARRAY_BUFFER_BINDING;
    public static int VERTEX_ATTRIB_ARRAY_ENABLED;
    public static int VERTEX_ATTRIB_ARRAY_SIZE;
    public static int VERTEX_ATTRIB_ARRAY_STRIDE;
    public static int VERTEX_ATTRIB_ARRAY_TYPE;
    public static int VERTEX_ATTRIB_ARRAY_NORMALIZED;
    public static int VERTEX_ATTRIB_ARRAY_POINTER;
    public static int BLEND;
    public static int ONE;
    public static int ZERO;
    public static int SRC_ALPHA;
    public static int DST_ALPHA;
    public static int ONE_MINUS_SRC_ALPHA;
    public static int ONE_MINUS_DST_COLOR;
    public static int ONE_MINUS_SRC_COLOR;
    public static int DST_COLOR;
    public static int SRC_COLOR;
    public static int SAMPLE_ALPHA_TO_COVERAGE;
    public static int SAMPLE_COVERAGE;
    public static int KEEP;
    public static int REPLACE;
    public static int INCR;
    public static int DECR;
    public static int INVERT;
    public static int INCR_WRAP;
    public static int DECR_WRAP;
    public static int NEVER;
    public static int ALWAYS;
    public static int EQUAL;
    public static int LESS;
    public static int LEQUAL;
    public static int GREATER;
    public static int GEQUAL;
    public static int NOTEQUAL;
    public static int FUNC_ADD;
    public static int FUNC_MIN;
    public static int FUNC_MAX;
    public static int FUNC_REVERSE_SUBTRACT;
    public static int FUNC_SUBTRACT;
    public static int DITHER;
    public static int CONSTANT_COLOR;
    public static int CONSTANT_ALPHA;
    public static int ONE_MINUS_CONSTANT_COLOR;
    public static int ONE_MINUS_CONSTANT_ALPHA;
    public static int SRC_ALPHA_SATURATE;
    public static int SCISSOR_TEST;
    public static int STENCIL_TEST;
    public static int DEPTH_TEST;
    public static int DEPTH_WRITEMASK;
    public static int COLOR_BUFFER_BIT;
    public static int DEPTH_BUFFER_BIT;
    public static int STENCIL_BUFFER_BIT;
    public static int FRAMEBUFFER;
    public static int COLOR_ATTACHMENT0;
    public static int COLOR_ATTACHMENT1;
    public static int COLOR_ATTACHMENT2;
    public static int COLOR_ATTACHMENT3;
    public static int RENDERBUFFER;
    public static int DEPTH_ATTACHMENT;
    public static int STENCIL_ATTACHMENT;
    public static int READ_FRAMEBUFFER;
    public static int DRAW_FRAMEBUFFER;
    public static int DEPTH24_STENCIL8;
    public static int DEPTH_COMPONENT;
    public static int DEPTH_COMPONENT16;
    public static int DEPTH_COMPONENT24;
    public static int DEPTH_COMPONENT32;
    public static int STENCIL_INDEX;
    public static int STENCIL_INDEX1;
    public static int STENCIL_INDEX4;
    public static int STENCIL_INDEX8;
    public static int DEPTH_STENCIL;
    public static int FRAMEBUFFER_COMPLETE;
    public static int FRAMEBUFFER_INCOMPLETE_ATTACHMENT;
    public static int FRAMEBUFFER_INCOMPLETE_MISSING_ATTACHMENT;
    public static int FRAMEBUFFER_INCOMPLETE_DIMENSIONS;
    public static int FRAMEBUFFER_INCOMPLETE_FORMATS;
    public static int FRAMEBUFFER_INCOMPLETE_DRAW_BUFFER;
    public static int FRAMEBUFFER_INCOMPLETE_READ_BUFFER;
    public static int FRAMEBUFFER_UNSUPPORTED;
    public static int FRAMEBUFFER_ATTACHMENT_OBJECT_TYPE;
    public static int FRAMEBUFFER_ATTACHMENT_OBJECT_NAME;
    public static int FRAMEBUFFER_ATTACHMENT_TEXTURE_LEVEL;
    public static int FRAMEBUFFER_ATTACHMENT_TEXTURE_CUBE_MAP_FACE;
    public static int RENDERBUFFER_WIDTH;
    public static int RENDERBUFFER_HEIGHT;
    public static int RENDERBUFFER_RED_SIZE;
    public static int RENDERBUFFER_GREEN_SIZE;
    public static int RENDERBUFFER_BLUE_SIZE;
    public static int RENDERBUFFER_ALPHA_SIZE;
    public static int RENDERBUFFER_DEPTH_SIZE;
    public static int RENDERBUFFER_STENCIL_SIZE;
    public static int RENDERBUFFER_INTERNAL_FORMAT;
    public static int MULTISAMPLE;
    public static int LINE_SMOOTH;
    public static int POLYGON_SMOOTH;
    public static int SYNC_GPU_COMMANDS_COMPLETE;
    public static int ALREADY_SIGNALED;
    public static int CONDITION_SATISFIED;

    public PGL() {
    }

    public PGL(PGraphicsOpenGL pGraphicsOpenGL) {
        this.graphics = pGraphicsOpenGL;
        if (this.glColorTex == null) {
            this.glColorFbo = PGL.allocateIntBuffer(1);
            this.glColorTex = PGL.allocateIntBuffer(2);
            this.glDepthStencil = PGL.allocateIntBuffer(1);
            this.glDepth = PGL.allocateIntBuffer(1);
            this.glStencil = PGL.allocateIntBuffer(1);
            this.glMultiFbo = PGL.allocateIntBuffer(1);
            this.glMultiColor = PGL.allocateIntBuffer(1);
            this.glMultiDepthStencil = PGL.allocateIntBuffer(1);
            this.glMultiDepth = PGL.allocateIntBuffer(1);
            this.glMultiStencil = PGL.allocateIntBuffer(1);
        }
        this.byteBuffer = PGL.allocateByteBuffer(1);
        this.intBuffer = PGL.allocateIntBuffer(1);
        this.viewBuffer = PGL.allocateIntBuffer(4);
    }

    public void dispose() {
        this.destroyFBOLayer();
        this.graphics = null;
        this.sketch = null;
    }

    public void setPrimary(boolean bl) {
        this.primaryPGL = bl;
    }

    public static int smoothToSamples(int n) {
        if (n == 0) {
            return 1;
        }
        if (n == 1) {
            return 2;
        }
        return n;
    }

    public abstract Object getNative();

    public void setFrameRate(float f) {
        this.targetFps = f;
        this.currentFps = f;
        this.setFps = true;
    }

    public float getFrameRate() {
        return this.currentFps;
    }

    protected abstract void initSurface(int var1);

    protected abstract void reinitSurface();

    protected abstract void registerListeners();

    protected int getReadFramebuffer() {
        return this.fboLayerEnabled ? this.glColorFbo.get(0) : 0;
    }

    protected int getDrawFramebuffer() {
        if (this.fboLayerEnabled) {
            return 1 < this.numSamples ? this.glMultiFbo.get(0) : this.glColorFbo.get(0);
        }
        return 0;
    }

    protected int getDefaultDrawBuffer() {
        return this.fboLayerEnabled ? COLOR_ATTACHMENT0 : BACK;
    }

    protected int getDefaultReadBuffer() {
        return this.fboLayerEnabled ? COLOR_ATTACHMENT0 : FRONT;
    }

    protected boolean isFBOBacked() {
        return this.fboLayerEnabled;
    }

    @Deprecated
    public void requestFBOLayer() {
        this.enableFBOLayer();
    }

    public void enableFBOLayer() {
        this.fboLayerEnabledReq = true;
    }

    public void disableFBOLayer() {
        this.fboLayerDisableReq = true;
    }

    public void resetFBOLayer() {
        this.fbolayerResetReq = true;
    }

    public abstract void queueEvent(Runnable var1);

    protected boolean isMultisampled() {
        return 1 < this.numSamples;
    }

    protected abstract int getDepthBits();

    protected abstract int getStencilBits();

    protected boolean getDepthTest() {
        this.intBuffer.rewind();
        this.getBooleanv(DEPTH_TEST, this.intBuffer);
        return this.intBuffer.get(0) != 0;
    }

    protected boolean getDepthWriteMask() {
        this.intBuffer.rewind();
        this.getBooleanv(DEPTH_WRITEMASK, this.intBuffer);
        return this.intBuffer.get(0) != 0;
    }

    protected Texture wrapBackTexture(Texture texture) {
        if (texture == null) {
            texture = new Texture(this.graphics);
            texture.init(this.graphics.width, this.graphics.height, this.glColorTex.get(this.backTex), TEXTURE_2D, RGBA, this.fboWidth, this.fboHeight, NEAREST, NEAREST, CLAMP_TO_EDGE, CLAMP_TO_EDGE);
            texture.invertedY(!this.graphics.cameraUp);
            texture.colorBuffer(true);
            this.graphics.setCache(this.graphics, texture);
        } else {
            texture.glName = this.glColorTex.get(this.backTex);
        }
        return texture;
    }

    protected Texture wrapFrontTexture(Texture texture) {
        if (texture == null) {
            texture = new Texture(this.graphics);
            texture.init(this.graphics.width, this.graphics.height, this.glColorTex.get(this.frontTex), TEXTURE_2D, RGBA, this.fboWidth, this.fboHeight, NEAREST, NEAREST, CLAMP_TO_EDGE, CLAMP_TO_EDGE);
            texture.invertedY(!this.graphics.cameraUp);
            texture.colorBuffer(true);
        } else {
            texture.glName = this.glColorTex.get(this.frontTex);
        }
        return texture;
    }

    protected void bindFrontTexture() {
        this.usingFrontTex = true;
        if (!this.texturingIsEnabled(TEXTURE_2D)) {
            this.enableTexturing(TEXTURE_2D);
        }
        this.bindTexture(TEXTURE_2D, this.glColorTex.get(this.frontTex));
    }

    protected void unbindFrontTexture() {
        if (this.textureIsBound(TEXTURE_2D, this.glColorTex.get(this.frontTex))) {
            if (!this.texturingIsEnabled(TEXTURE_2D)) {
                this.enableTexturing(TEXTURE_2D);
                this.bindTexture(TEXTURE_2D, 0);
                this.disableTexturing(TEXTURE_2D);
            } else {
                this.bindTexture(TEXTURE_2D, 0);
            }
        }
    }

    protected void syncBackTexture() {
        if (this.usingFrontTex) {
            this.needSepFrontTex = true;
        }
        if (1 < this.numSamples) {
            this.bindFramebufferImpl(READ_FRAMEBUFFER, this.glMultiFbo.get(0));
            this.bindFramebufferImpl(DRAW_FRAMEBUFFER, this.glColorFbo.get(0));
            int n = COLOR_BUFFER_BIT;
            if (this.graphics.getHint(10)) {
                n |= DEPTH_BUFFER_BIT | STENCIL_BUFFER_BIT;
            }
            this.blitFramebuffer(0, 0, this.fboWidth, this.fboHeight, 0, 0, this.fboWidth, this.fboHeight, n, NEAREST);
        }
    }

    protected abstract float getPixelScale();

    public void initPresentMode(float f, float f2, int n) {
        this.presentMode = true;
        this.showStopButton = n != 0;
        this.stopButtonColor = n;
        this.presentX = f;
        this.presentY = f2;
        this.enableFBOLayer();
    }

    public boolean presentMode() {
        return this.presentMode;
    }

    public float presentX() {
        return this.presentX;
    }

    public float presentY() {
        return this.presentY;
    }

    public boolean insideStopButton(float f, float f2) {
        if (!this.showStopButton) {
            return false;
        }
        return (float)this.stopButtonX < f && f < (float)(this.stopButtonX + this.stopButtonWidth) && (float)(-(this.closeButtonY + this.stopButtonHeight)) < f2 && f2 < (float)(-this.closeButtonY);
    }

    protected void clearDepthStencil() {
        if (!this.pclearDepth && !this.pclearStencil) {
            this.depthMask(true);
            this.clearDepth(1.0f);
            this.clearStencil(0);
            this.clear(DEPTH_BUFFER_BIT | STENCIL_BUFFER_BIT);
        } else if (!this.pclearDepth) {
            this.depthMask(true);
            this.clearDepth(1.0f);
            this.clear(DEPTH_BUFFER_BIT);
        } else if (!this.pclearStencil) {
            this.clearStencil(0);
            this.clear(STENCIL_BUFFER_BIT);
        }
    }

    protected void clearBackground(float f, float f2, float f3, float f4, boolean bl, boolean bl2) {
        this.clearColor(f, f2, f3, f4);
        if (bl && bl2) {
            this.clearDepth(1.0f);
            this.clearStencil(0);
            this.clear(DEPTH_BUFFER_BIT | STENCIL_BUFFER_BIT | COLOR_BUFFER_BIT);
            if (0 < this.sketch.frameCount) {
                this.clearColor = true;
                this.clearDepth = true;
                this.clearStencil = true;
            }
        } else if (bl) {
            this.clearDepth(1.0f);
            this.clear(DEPTH_BUFFER_BIT | COLOR_BUFFER_BIT);
            if (0 < this.sketch.frameCount) {
                this.clearColor = true;
                this.clearDepth = true;
            }
        } else if (bl2) {
            this.clearStencil(0);
            this.clear(STENCIL_BUFFER_BIT | COLOR_BUFFER_BIT);
            if (0 < this.sketch.frameCount) {
                this.clearColor = true;
                this.clearStencil = true;
            }
        } else {
            this.clear(COLOR_BUFFER_BIT);
            if (0 < this.sketch.frameCount) {
                this.clearColor = true;
            }
        }
        if (this.fboLayerEnabled) {
            this.clearFrontColorBuffer();
        }
    }

    protected void beginRender() {
        if (this.sketch == null) {
            this.sketch = this.graphics.parent;
        }
        this.pgeomCount = this.geomCount;
        this.geomCount = 0;
        this.pclearColor = this.clearColor;
        this.clearColor = false;
        this.pclearDepth = this.clearDepth;
        this.clearDepth = false;
        this.pclearStencil = this.clearStencil;
        this.clearStencil = false;
        if (SINGLE_BUFFERED && this.sketch.frameCount == 1) {
            this.restoreFirstFrame();
        }
        if (this.fboLayerEnabledReq) {
            this.fboLayerEnabled = true;
            this.fboLayerEnabledReq = false;
        }
        if (this.fboLayerEnabled) {
            if (this.fbolayerResetReq) {
                this.destroyFBOLayer();
                this.fbolayerResetReq = false;
            }
            if (!this.fboLayerCreated) {
                this.createFBOLayer();
            }
            this.bindFramebufferImpl(FRAMEBUFFER, this.glColorFbo.get(0));
            this.framebufferTexture2D(FRAMEBUFFER, COLOR_ATTACHMENT0, TEXTURE_2D, this.glColorTex.get(this.backTex), 0);
            if (1 < this.numSamples) {
                this.bindFramebufferImpl(FRAMEBUFFER, this.glMultiFbo.get(0));
            }
            if (this.sketch.frameCount == 0) {
                int n = this.graphics.backgroundColor;
                float f = (float)(n >> 24 & 0xFF) / 255.0f;
                float f2 = (float)(n >> 16 & 0xFF) / 255.0f;
                float f3 = (float)(n >> 8 & 0xFF) / 255.0f;
                float f4 = (float)(n & 0xFF) / 255.0f;
                this.clearColor(f2, f3, f4, f);
                this.clear(COLOR_BUFFER_BIT);
            } else if (!this.pclearColor || !this.sketch.isLooping()) {
                int n = 0;
                int n2 = 0;
                if (this.presentMode) {
                    n = (int)this.presentX;
                    n2 = (int)this.presentY;
                }
                float f = this.getPixelScale();
                this.drawTexture(TEXTURE_2D, this.glColorTex.get(this.frontTex), this.fboWidth, this.fboHeight, n, n2, this.graphics.width, this.graphics.height, 0, 0, (int)(f * (float)this.graphics.width), (int)(f * (float)this.graphics.height), 0, 0, this.graphics.width, this.graphics.height);
            }
        }
    }

    protected void endRender(int n) {
        if (this.fboLayerEnabled) {
            float f;
            this.syncBackTexture();
            this.bindFramebufferImpl(FRAMEBUFFER, 0);
            if (this.presentMode) {
                float f2 = (float)(n >> 24 & 0xFF) / 255.0f;
                float f3 = (float)(n >> 16 & 0xFF) / 255.0f;
                f = (float)(n >> 8 & 0xFF) / 255.0f;
                float f4 = (float)(n & 0xFF) / 255.0f;
                this.clearDepth(1.0f);
                this.clearColor(f3, f, f4, f2);
                this.clear(COLOR_BUFFER_BIT | DEPTH_BUFFER_BIT);
                if (this.showStopButton) {
                    if (this.closeButtonTex == null) {
                        this.closeButtonTex = PGL.allocateIntBuffer(1);
                        this.genTextures(1, this.closeButtonTex);
                        this.bindTexture(TEXTURE_2D, this.closeButtonTex.get(0));
                        this.texParameteri(TEXTURE_2D, TEXTURE_MIN_FILTER, NEAREST);
                        this.texParameteri(TEXTURE_2D, TEXTURE_MAG_FILTER, NEAREST);
                        this.texParameteri(TEXTURE_2D, TEXTURE_WRAP_S, CLAMP_TO_EDGE);
                        this.texParameteri(TEXTURE_2D, TEXTURE_WRAP_T, CLAMP_TO_EDGE);
                        this.texImage2D(TEXTURE_2D, 0, RGBA, this.stopButtonWidth, this.stopButtonHeight, 0, RGBA, UNSIGNED_BYTE, null);
                        int[] nArray = new int[closeButtonPix.length];
                        PApplet.arrayCopy(closeButtonPix, nArray);
                        float f5 = (float)(this.stopButtonColor >> 24 & 0xFF) / 255.0f;
                        float f6 = (float)(this.stopButtonColor >> 16 & 0xFF) / 255.0f;
                        float f7 = (float)(this.stopButtonColor >> 8 & 0xFF) / 255.0f;
                        float f8 = (float)(this.stopButtonColor >> 0 & 0xFF) / 255.0f;
                        for (int i = 0; i < nArray.length; ++i) {
                            int n2 = closeButtonPix[i];
                            int n3 = (int)(f5 * (float)(n2 >> 24 & 0xFF));
                            int n4 = (int)(f6 * (float)(n2 >> 16 & 0xFF));
                            int n5 = (int)(f7 * (float)(n2 >> 8 & 0xFF));
                            int n6 = (int)(f8 * (float)(n2 >> 0 & 0xFF));
                            nArray[i] = PGL.javaToNativeARGB(n3 << 24 | n4 << 16 | n5 << 8 | n6);
                        }
                        IntBuffer intBuffer = PGL.allocateIntBuffer(nArray);
                        this.copyToTexture(TEXTURE_2D, RGBA, this.closeButtonTex.get(0), 0, 0, this.stopButtonWidth, this.stopButtonHeight, intBuffer);
                        this.bindTexture(TEXTURE_2D, 0);
                    }
                    this.drawTexture(TEXTURE_2D, this.closeButtonTex.get(0), this.stopButtonWidth, this.stopButtonHeight, 0, 0, this.stopButtonX + this.stopButtonWidth, this.closeButtonY + this.stopButtonHeight, 0, this.stopButtonHeight, this.stopButtonWidth, 0, this.stopButtonX, this.closeButtonY, this.stopButtonX + this.stopButtonWidth, this.closeButtonY + this.stopButtonHeight);
                }
            } else {
                this.clearDepth(1.0f);
                this.clearColor(0.0f, 0.0f, 0.0f, 0.0f);
                this.clear(COLOR_BUFFER_BIT | DEPTH_BUFFER_BIT);
            }
            this.disable(BLEND);
            int n7 = 0;
            int n8 = 0;
            if (this.presentMode) {
                n7 = (int)this.presentX;
                n8 = (int)this.presentY;
            }
            f = this.getPixelScale();
            this.drawTexture(TEXTURE_2D, this.glColorTex.get(this.backTex), this.fboWidth, this.fboHeight, n7, n8, this.graphics.width, this.graphics.height, 0, 0, (int)(f * (float)this.graphics.width), (int)(f * (float)this.graphics.height), 0, 0, this.graphics.width, this.graphics.height);
            int n9 = this.frontTex;
            this.frontTex = this.backTex;
            this.backTex = n9;
            if (this.fboLayerDisableReq) {
                this.fboLayerEnabled = false;
                this.fboLayerDisableReq = false;
            }
        } else {
            if (SINGLE_BUFFERED && this.sketch.frameCount == 0) {
                this.saveFirstFrame();
            }
            if (!this.clearColor && 0 < this.sketch.frameCount || !this.sketch.isLooping()) {
                this.enableFBOLayer();
                if (SINGLE_BUFFERED) {
                    this.createFBOLayer();
                }
            }
        }
    }

    protected abstract void getGL(PGL var1);

    protected abstract boolean canDraw();

    protected abstract void requestFocus();

    protected abstract void requestDraw();

    protected abstract void swapBuffers();

    public boolean threadIsCurrent() {
        return Thread.currentThread() == this.glThread;
    }

    public void setThread(Thread thread) {
        this.glThread = thread;
    }

    protected void beginGL() {
    }

    protected void endGL() {
    }

    private void createFBOLayer() {
        int n;
        int n2;
        float f = this.getPixelScale();
        if (this.hasNpotTexSupport()) {
            this.fboWidth = (int)(f * (float)this.graphics.width);
            this.fboHeight = (int)(f * (float)this.graphics.height);
        } else {
            this.fboWidth = PGL.nextPowerOfTwo((int)(f * (float)this.graphics.width));
            this.fboHeight = PGL.nextPowerOfTwo((int)(f * (float)this.graphics.height));
        }
        if (this.hasFboMultisampleSupport()) {
            n2 = this.maxSamples();
            this.numSamples = PApplet.min(this.reqNumSamples, n2);
        } else {
            this.numSamples = 1;
        }
        n2 = 1 < this.numSamples ? 1 : 0;
        boolean bl = this.hasPackedDepthStencilSupport();
        int n3 = PApplet.min(REQUESTED_DEPTH_BITS, this.getDepthBits());
        int n4 = PApplet.min(REQUESTED_STENCIL_BITS, this.getStencilBits());
        this.genTextures(2, this.glColorTex);
        for (n = 0; n < 2; ++n) {
            this.bindTexture(TEXTURE_2D, this.glColorTex.get(n));
            this.texParameteri(TEXTURE_2D, TEXTURE_MIN_FILTER, NEAREST);
            this.texParameteri(TEXTURE_2D, TEXTURE_MAG_FILTER, NEAREST);
            this.texParameteri(TEXTURE_2D, TEXTURE_WRAP_S, CLAMP_TO_EDGE);
            this.texParameteri(TEXTURE_2D, TEXTURE_WRAP_T, CLAMP_TO_EDGE);
            this.texImage2D(TEXTURE_2D, 0, RGBA, this.fboWidth, this.fboHeight, 0, RGBA, UNSIGNED_BYTE, null);
            this.initTexture(TEXTURE_2D, RGBA, this.fboWidth, this.fboHeight, this.graphics.backgroundColor);
        }
        this.bindTexture(TEXTURE_2D, 0);
        this.backTex = 0;
        this.frontTex = 1;
        this.genFramebuffers(1, this.glColorFbo);
        this.bindFramebufferImpl(FRAMEBUFFER, this.glColorFbo.get(0));
        this.framebufferTexture2D(FRAMEBUFFER, COLOR_ATTACHMENT0, TEXTURE_2D, this.glColorTex.get(this.backTex), 0);
        if (n2 == 0 || this.graphics.getHint(10)) {
            this.createDepthAndStencilBuffer(false, n3, n4, bl);
        }
        if (n2 != 0) {
            this.genFramebuffers(1, this.glMultiFbo);
            this.bindFramebufferImpl(FRAMEBUFFER, this.glMultiFbo.get(0));
            this.genRenderbuffers(1, this.glMultiColor);
            this.bindRenderbuffer(RENDERBUFFER, this.glMultiColor.get(0));
            this.renderbufferStorageMultisample(RENDERBUFFER, this.numSamples, RGBA8, this.fboWidth, this.fboHeight);
            this.framebufferRenderbuffer(FRAMEBUFFER, COLOR_ATTACHMENT0, RENDERBUFFER, this.glMultiColor.get(0));
            this.createDepthAndStencilBuffer(true, n3, n4, bl);
        }
        this.validateFramebuffer();
        this.clearDepth(1.0f);
        this.clearStencil(0);
        n = this.graphics.backgroundColor;
        float f2 = (float)(n >> 24 & 0xFF) / 255.0f;
        float f3 = (float)(n >> 16 & 0xFF) / 255.0f;
        float f4 = (float)(n >> 8 & 0xFF) / 255.0f;
        float f5 = (float)(n & 0xFF) / 255.0f;
        this.clearColor(f3, f4, f5, f2);
        this.clear(DEPTH_BUFFER_BIT | STENCIL_BUFFER_BIT | COLOR_BUFFER_BIT);
        this.bindFramebufferImpl(FRAMEBUFFER, 0);
        this.initFBOLayer();
        this.fboLayerCreated = true;
    }

    protected abstract void initFBOLayer();

    protected void saveFirstFrame() {
        this.firstFrame = PGL.allocateDirectIntBuffer(this.graphics.width * this.graphics.height);
        if (this.hasReadBuffer()) {
            this.readBuffer(BACK);
        }
        this.readPixelsImpl(0, 0, this.graphics.width, this.graphics.height, RGBA, UNSIGNED_BYTE, this.firstFrame);
    }

    protected void restoreFirstFrame() {
        int n;
        int n2;
        if (this.firstFrame == null) {
            return;
        }
        IntBuffer intBuffer = PGL.allocateIntBuffer(1);
        this.genTextures(1, intBuffer);
        float f = this.getPixelScale();
        if (this.hasNpotTexSupport()) {
            n2 = (int)(f * (float)this.graphics.width);
            n = (int)(f * (float)this.graphics.height);
        } else {
            n2 = PGL.nextPowerOfTwo((int)(f * (float)this.graphics.width));
            n = PGL.nextPowerOfTwo((int)(f * (float)this.graphics.height));
        }
        this.bindTexture(TEXTURE_2D, intBuffer.get(0));
        this.texParameteri(TEXTURE_2D, TEXTURE_MIN_FILTER, NEAREST);
        this.texParameteri(TEXTURE_2D, TEXTURE_MAG_FILTER, NEAREST);
        this.texParameteri(TEXTURE_2D, TEXTURE_WRAP_S, CLAMP_TO_EDGE);
        this.texParameteri(TEXTURE_2D, TEXTURE_WRAP_T, CLAMP_TO_EDGE);
        this.texImage2D(TEXTURE_2D, 0, RGBA, n2, n, 0, RGBA, UNSIGNED_BYTE, null);
        this.texSubImage2D(TEXTURE_2D, 0, 0, 0, this.graphics.width, this.graphics.height, RGBA, UNSIGNED_BYTE, this.firstFrame);
        this.drawTexture(TEXTURE_2D, intBuffer.get(0), n2, n, 0, 0, this.graphics.width, this.graphics.height, 0, 0, (int)(f * (float)this.graphics.width), (int)(f * (float)this.graphics.height), 0, 0, this.graphics.width, this.graphics.height);
        this.deleteTextures(1, intBuffer);
        this.firstFrame.clear();
        this.firstFrame = null;
    }

    protected void destroyFBOLayer() {
        if (this.threadIsCurrent() && this.fboLayerCreated) {
            this.deleteFramebuffers(1, this.glColorFbo);
            this.deleteTextures(2, this.glColorTex);
            this.deleteRenderbuffers(1, this.glDepthStencil);
            this.deleteRenderbuffers(1, this.glDepth);
            this.deleteRenderbuffers(1, this.glStencil);
            this.deleteFramebuffers(1, this.glMultiFbo);
            this.deleteRenderbuffers(1, this.glMultiColor);
            this.deleteRenderbuffers(1, this.glMultiDepthStencil);
            this.deleteRenderbuffers(1, this.glMultiDepth);
            this.deleteRenderbuffers(1, this.glMultiStencil);
        }
        this.fboLayerCreated = false;
    }

    private void createDepthAndStencilBuffer(boolean bl, int n, int n2, boolean bl2) {
        if (bl2 && n == 24 && n2 == 8) {
            IntBuffer intBuffer = bl ? this.glMultiDepthStencil : this.glDepthStencil;
            this.genRenderbuffers(1, intBuffer);
            this.bindRenderbuffer(RENDERBUFFER, intBuffer.get(0));
            if (bl) {
                this.renderbufferStorageMultisample(RENDERBUFFER, this.numSamples, DEPTH24_STENCIL8, this.fboWidth, this.fboHeight);
            } else {
                this.renderbufferStorage(RENDERBUFFER, DEPTH24_STENCIL8, this.fboWidth, this.fboHeight);
            }
            this.framebufferRenderbuffer(FRAMEBUFFER, DEPTH_ATTACHMENT, RENDERBUFFER, intBuffer.get(0));
            this.framebufferRenderbuffer(FRAMEBUFFER, STENCIL_ATTACHMENT, RENDERBUFFER, intBuffer.get(0));
        } else {
            IntBuffer intBuffer;
            int n3;
            if (0 < n) {
                n3 = DEPTH_COMPONENT16;
                if (n == 32) {
                    n3 = DEPTH_COMPONENT32;
                } else if (n == 24) {
                    n3 = DEPTH_COMPONENT24;
                } else if (n == 16) {
                    n3 = DEPTH_COMPONENT16;
                }
                intBuffer = bl ? this.glMultiDepth : this.glDepth;
                this.genRenderbuffers(1, intBuffer);
                this.bindRenderbuffer(RENDERBUFFER, intBuffer.get(0));
                if (bl) {
                    this.renderbufferStorageMultisample(RENDERBUFFER, this.numSamples, n3, this.fboWidth, this.fboHeight);
                } else {
                    this.renderbufferStorage(RENDERBUFFER, n3, this.fboWidth, this.fboHeight);
                }
                this.framebufferRenderbuffer(FRAMEBUFFER, DEPTH_ATTACHMENT, RENDERBUFFER, intBuffer.get(0));
            }
            if (0 < n2) {
                n3 = STENCIL_INDEX1;
                if (n2 == 8) {
                    n3 = STENCIL_INDEX8;
                } else if (n2 == 4) {
                    n3 = STENCIL_INDEX4;
                } else if (n2 == 1) {
                    n3 = STENCIL_INDEX1;
                }
                intBuffer = bl ? this.glMultiStencil : this.glStencil;
                this.genRenderbuffers(1, intBuffer);
                this.bindRenderbuffer(RENDERBUFFER, intBuffer.get(0));
                if (bl) {
                    this.renderbufferStorageMultisample(RENDERBUFFER, this.numSamples, n3, this.fboWidth, this.fboHeight);
                } else {
                    this.renderbufferStorage(RENDERBUFFER, n3, this.fboWidth, this.fboHeight);
                }
                this.framebufferRenderbuffer(FRAMEBUFFER, STENCIL_ATTACHMENT, RENDERBUFFER, intBuffer.get(0));
            }
        }
    }

    protected void clearFrontColorBuffer() {
    }

    protected int createEmptyContext() {
        return -1;
    }

    protected int getCurrentContext() {
        return this.glContext;
    }

    protected boolean contextIsCurrent(int n) {
        return n == -1 || n == this.glContext;
    }

    protected void enableTexturing(int n) {
        if (n == TEXTURE_2D) {
            this.texturingTargets[0] = true;
        } else if (n == TEXTURE_RECTANGLE) {
            this.texturingTargets[1] = true;
        }
    }

    protected void disableTexturing(int n) {
        if (n == TEXTURE_2D) {
            this.texturingTargets[0] = false;
        } else if (n == TEXTURE_RECTANGLE) {
            this.texturingTargets[1] = false;
        }
    }

    protected boolean texturingIsEnabled(int n) {
        if (n == TEXTURE_2D) {
            return this.texturingTargets[0];
        }
        if (n == TEXTURE_RECTANGLE) {
            return this.texturingTargets[1];
        }
        return false;
    }

    protected boolean textureIsBound(int n, int n2) {
        if (this.boundTextures == null) {
            return false;
        }
        if (n == TEXTURE_2D) {
            return this.boundTextures[this.activeTexUnit][0] == n2;
        }
        if (n == TEXTURE_RECTANGLE) {
            return this.boundTextures[this.activeTexUnit][1] == n2;
        }
        return false;
    }

    protected void initTexture(int n, int n2, int n3, int n4) {
        this.initTexture(n, n2, n3, n4, 0);
    }

    protected void initTexture(int n, int n2, int n3, int n4, int n5) {
        int[] nArray = new int[256];
        Arrays.fill(nArray, PGL.javaToNativeARGB(n5));
        IntBuffer intBuffer = PGL.allocateDirectIntBuffer(256);
        intBuffer.put(nArray);
        intBuffer.rewind();
        for (int i = 0; i < n4; i += 16) {
            int n6 = PApplet.min(16, n4 - i);
            for (int j = 0; j < n3; j += 16) {
                int n7 = PApplet.min(16, n3 - j);
                this.texSubImage2D(n, 0, j, i, n7, n6, n2, UNSIGNED_BYTE, intBuffer);
            }
        }
    }

    protected void copyToTexture(int n, int n2, int n3, int n4, int n5, int n6, int n7, int[] nArray) {
        this.copyToTexture(n, n2, n3, n4, n5, n6, n7, IntBuffer.wrap(nArray));
    }

    protected void copyToTexture(int n, int n2, int n3, int n4, int n5, int n6, int n7, IntBuffer intBuffer) {
        this.activeTexture(TEXTURE0);
        boolean bl = false;
        if (!this.texturingIsEnabled(n)) {
            this.enableTexturing(n);
            bl = true;
        }
        this.bindTexture(n, n3);
        this.texSubImage2D(n, 0, n4, n5, n6, n7, n2, UNSIGNED_BYTE, intBuffer);
        this.bindTexture(n, 0);
        if (bl) {
            this.disableTexturing(n);
        }
    }

    public void drawTexture(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        this.drawTexture(n, n2, n3, n4, 0, 0, n3, n4, 1, n5, n6, n7, n8, n5, n6, n7, n8);
    }

    public void drawTexture(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10, int n11, int n12, int n13, int n14, int n15, int n16) {
        int n17 = (int)this.getPixelScale();
        this.drawTexture(n, n2, n3, n4, n5, n6, n7, n8, n17, n9, n10, n11, n12, n13, n14, n15, n16);
    }

    public void drawTexture(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10, int n11, int n12, int n13, int n14, int n15, int n16, int n17) {
        if (n == TEXTURE_2D) {
            this.drawTexture2D(n2, n3, n4, n5, n6, n7, n8, n9, n10, n11, n12, n13, n14, n15, n16, n17);
        } else if (n == TEXTURE_RECTANGLE) {
            this.drawTextureRect(n2, n3, n4, n5, n6, n7, n8, n9, n10, n11, n12, n13, n14, n15, n16, n17);
        }
    }

    protected PGL initTex2DShader() {
        PGL pGL;
        PGL pGL2 = pGL = this.primaryPGL ? this : this.graphics.getPrimaryPGL();
        if (!pGL.loadedTex2DShader || pGL.tex2DShaderContext != pGL.glContext) {
            String[] stringArray = PGL.preprocessVertexSource(texVertShaderSource, this.getGLSLVersion());
            String string = PApplet.join(stringArray, "\n");
            String[] stringArray2 = PGL.preprocessFragmentSource(tex2DFragShaderSource, this.getGLSLVersion());
            String string2 = PApplet.join(stringArray2, "\n");
            pGL.tex2DVertShader = this.createShader(VERTEX_SHADER, string);
            pGL.tex2DFragShader = this.createShader(FRAGMENT_SHADER, string2);
            if (0 < pGL.tex2DVertShader && 0 < pGL.tex2DFragShader) {
                pGL.tex2DShaderProgram = this.createProgram(pGL.tex2DVertShader, pGL.tex2DFragShader);
            }
            if (0 < pGL.tex2DShaderProgram) {
                pGL.tex2DVertLoc = this.getAttribLocation(pGL.tex2DShaderProgram, "position");
                pGL.tex2DTCoordLoc = this.getAttribLocation(pGL.tex2DShaderProgram, "texCoord");
                pGL.tex2DSamplerLoc = this.getUniformLocation(pGL.tex2DShaderProgram, "texMap");
            }
            pGL.loadedTex2DShader = true;
            pGL.tex2DShaderContext = pGL.glContext;
            this.genBuffers(1, this.intBuffer);
            pGL.tex2DGeoVBO = this.intBuffer.get(0);
            this.bindBuffer(ARRAY_BUFFER, pGL.tex2DGeoVBO);
            this.bufferData(ARRAY_BUFFER, 16 * SIZEOF_FLOAT, null, STATIC_DRAW);
        }
        if (this.texData == null) {
            this.texData = PGL.allocateDirectFloatBuffer(this.texCoords.length);
        }
        return pGL;
    }

    protected void drawTexture2D(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10, int n11, int n12, int n13, int n14, int n15, int n16) {
        PGL pGL = this.initTex2DShader();
        if (0 < pGL.tex2DShaderProgram) {
            boolean bl = this.getDepthTest();
            this.disable(DEPTH_TEST);
            boolean bl2 = this.getDepthWriteMask();
            this.depthMask(false);
            this.viewBuffer.rewind();
            this.getIntegerv(VIEWPORT, this.viewBuffer);
            this.viewportImpl(n8 * n4, n8 * n5, n8 * n6, n8 * n7);
            this.useProgram(pGL.tex2DShaderProgram);
            this.enableVertexAttribArray(pGL.tex2DVertLoc);
            this.enableVertexAttribArray(pGL.tex2DTCoordLoc);
            this.texCoords[0] = 2.0f * (float)n13 / (float)n6 - 1.0f;
            this.texCoords[1] = 2.0f * (float)n14 / (float)n7 - 1.0f;
            this.texCoords[2] = (float)n9 / (float)n2;
            this.texCoords[3] = (float)n10 / (float)n3;
            this.texCoords[4] = 2.0f * (float)n15 / (float)n6 - 1.0f;
            this.texCoords[5] = 2.0f * (float)n14 / (float)n7 - 1.0f;
            this.texCoords[6] = (float)n11 / (float)n2;
            this.texCoords[7] = (float)n10 / (float)n3;
            this.texCoords[8] = 2.0f * (float)n13 / (float)n6 - 1.0f;
            this.texCoords[9] = 2.0f * (float)n16 / (float)n7 - 1.0f;
            this.texCoords[10] = (float)n9 / (float)n2;
            this.texCoords[11] = (float)n12 / (float)n3;
            this.texCoords[12] = 2.0f * (float)n15 / (float)n6 - 1.0f;
            this.texCoords[13] = 2.0f * (float)n16 / (float)n7 - 1.0f;
            this.texCoords[14] = (float)n11 / (float)n2;
            this.texCoords[15] = (float)n12 / (float)n3;
            this.texData.rewind();
            this.texData.put(this.texCoords);
            this.activeTexture(TEXTURE0);
            boolean bl3 = false;
            if (!this.texturingIsEnabled(TEXTURE_2D)) {
                this.enableTexturing(TEXTURE_2D);
                bl3 = true;
            }
            this.bindTexture(TEXTURE_2D, n);
            this.uniform1i(pGL.tex2DSamplerLoc, 0);
            this.texData.position(0);
            this.bindBuffer(ARRAY_BUFFER, pGL.tex2DGeoVBO);
            this.bufferData(ARRAY_BUFFER, 16 * SIZEOF_FLOAT, this.texData, STATIC_DRAW);
            this.vertexAttribPointer(pGL.tex2DVertLoc, 2, FLOAT, false, 4 * SIZEOF_FLOAT, 0);
            this.vertexAttribPointer(pGL.tex2DTCoordLoc, 2, FLOAT, false, 4 * SIZEOF_FLOAT, 2 * SIZEOF_FLOAT);
            this.drawArrays(TRIANGLE_STRIP, 0, 4);
            this.bindBuffer(ARRAY_BUFFER, 0);
            this.bindTexture(TEXTURE_2D, 0);
            if (bl3) {
                this.disableTexturing(TEXTURE_2D);
            }
            this.disableVertexAttribArray(pGL.tex2DVertLoc);
            this.disableVertexAttribArray(pGL.tex2DTCoordLoc);
            this.useProgram(0);
            if (bl) {
                this.enable(DEPTH_TEST);
            } else {
                this.disable(DEPTH_TEST);
            }
            this.depthMask(bl2);
            this.viewportImpl(this.viewBuffer.get(0), this.viewBuffer.get(1), this.viewBuffer.get(2), this.viewBuffer.get(3));
        }
    }

    protected PGL initTexRectShader() {
        PGL pGL;
        PGL pGL2 = pGL = this.primaryPGL ? this : this.graphics.getPrimaryPGL();
        if (!pGL.loadedTexRectShader || pGL.texRectShaderContext != pGL.glContext) {
            String[] stringArray = PGL.preprocessVertexSource(texVertShaderSource, this.getGLSLVersion());
            String string = PApplet.join(stringArray, "\n");
            String[] stringArray2 = PGL.preprocessFragmentSource(texRectFragShaderSource, this.getGLSLVersion());
            String string2 = PApplet.join(stringArray2, "\n");
            pGL.texRectVertShader = this.createShader(VERTEX_SHADER, string);
            pGL.texRectFragShader = this.createShader(FRAGMENT_SHADER, string2);
            if (0 < pGL.texRectVertShader && 0 < pGL.texRectFragShader) {
                pGL.texRectShaderProgram = this.createProgram(pGL.texRectVertShader, pGL.texRectFragShader);
            }
            if (0 < pGL.texRectShaderProgram) {
                pGL.texRectVertLoc = this.getAttribLocation(pGL.texRectShaderProgram, "position");
                pGL.texRectTCoordLoc = this.getAttribLocation(pGL.texRectShaderProgram, "texCoord");
                pGL.texRectSamplerLoc = this.getUniformLocation(pGL.texRectShaderProgram, "texMap");
            }
            pGL.loadedTexRectShader = true;
            pGL.texRectShaderContext = pGL.glContext;
            this.genBuffers(1, this.intBuffer);
            pGL.texRectGeoVBO = this.intBuffer.get(0);
            this.bindBuffer(ARRAY_BUFFER, pGL.texRectGeoVBO);
            this.bufferData(ARRAY_BUFFER, 16 * SIZEOF_FLOAT, null, STATIC_DRAW);
        }
        return pGL;
    }

    protected void drawTextureRect(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10, int n11, int n12, int n13, int n14, int n15, int n16) {
        PGL pGL = this.initTexRectShader();
        if (this.texData == null) {
            this.texData = PGL.allocateDirectFloatBuffer(this.texCoords.length);
        }
        if (0 < pGL.texRectShaderProgram) {
            boolean bl = this.getDepthTest();
            this.disable(DEPTH_TEST);
            boolean bl2 = this.getDepthWriteMask();
            this.depthMask(false);
            this.viewBuffer.rewind();
            this.getIntegerv(VIEWPORT, this.viewBuffer);
            this.viewportImpl(n8 * n4, n8 * n5, n8 * n6, n8 * n7);
            this.useProgram(pGL.texRectShaderProgram);
            this.enableVertexAttribArray(pGL.texRectVertLoc);
            this.enableVertexAttribArray(pGL.texRectTCoordLoc);
            this.texCoords[0] = 2.0f * (float)n13 / (float)n6 - 1.0f;
            this.texCoords[1] = 2.0f * (float)n14 / (float)n7 - 1.0f;
            this.texCoords[2] = n9;
            this.texCoords[3] = n10;
            this.texCoords[4] = 2.0f * (float)n15 / (float)n6 - 1.0f;
            this.texCoords[5] = 2.0f * (float)n14 / (float)n7 - 1.0f;
            this.texCoords[6] = n11;
            this.texCoords[7] = n10;
            this.texCoords[8] = 2.0f * (float)n13 / (float)n6 - 1.0f;
            this.texCoords[9] = 2.0f * (float)n16 / (float)n7 - 1.0f;
            this.texCoords[10] = n9;
            this.texCoords[11] = n12;
            this.texCoords[12] = 2.0f * (float)n15 / (float)n6 - 1.0f;
            this.texCoords[13] = 2.0f * (float)n16 / (float)n7 - 1.0f;
            this.texCoords[14] = n11;
            this.texCoords[15] = n12;
            this.texData.rewind();
            this.texData.put(this.texCoords);
            this.activeTexture(TEXTURE0);
            boolean bl3 = false;
            if (!this.texturingIsEnabled(TEXTURE_RECTANGLE)) {
                this.enableTexturing(TEXTURE_RECTANGLE);
                bl3 = true;
            }
            this.bindTexture(TEXTURE_RECTANGLE, n);
            this.uniform1i(pGL.texRectSamplerLoc, 0);
            this.texData.position(0);
            this.bindBuffer(ARRAY_BUFFER, pGL.texRectGeoVBO);
            this.bufferData(ARRAY_BUFFER, 16 * SIZEOF_FLOAT, this.texData, STATIC_DRAW);
            this.vertexAttribPointer(pGL.texRectVertLoc, 2, FLOAT, false, 4 * SIZEOF_FLOAT, 0);
            this.vertexAttribPointer(pGL.texRectTCoordLoc, 2, FLOAT, false, 4 * SIZEOF_FLOAT, 2 * SIZEOF_FLOAT);
            this.drawArrays(TRIANGLE_STRIP, 0, 4);
            this.bindBuffer(ARRAY_BUFFER, 0);
            this.bindTexture(TEXTURE_RECTANGLE, 0);
            if (bl3) {
                this.disableTexturing(TEXTURE_RECTANGLE);
            }
            this.disableVertexAttribArray(pGL.texRectVertLoc);
            this.disableVertexAttribArray(pGL.texRectTCoordLoc);
            this.useProgram(0);
            if (bl) {
                this.enable(DEPTH_TEST);
            } else {
                this.disable(DEPTH_TEST);
            }
            this.depthMask(bl2);
            this.viewportImpl(this.viewBuffer.get(0), this.viewBuffer.get(1), this.viewBuffer.get(2), this.viewBuffer.get(3));
        }
    }

    protected int getColorValue(int n, int n2) {
        if (this.colorBuffer == null) {
            this.colorBuffer = IntBuffer.allocate(1);
        }
        this.colorBuffer.rewind();
        this.readPixels(n, this.graphics.height - n2 - 1, 1, 1, RGBA, UNSIGNED_BYTE, this.colorBuffer);
        return this.colorBuffer.get();
    }

    protected float getDepthValue(int n, int n2) {
        if (this.depthBuffer == null) {
            this.depthBuffer = FloatBuffer.allocate(1);
        }
        this.depthBuffer.rewind();
        this.readPixels(n, this.graphics.height - n2 - 1, 1, 1, DEPTH_COMPONENT, FLOAT, this.depthBuffer);
        return this.depthBuffer.get(0);
    }

    protected byte getStencilValue(int n, int n2) {
        if (this.stencilBuffer == null) {
            this.stencilBuffer = ByteBuffer.allocate(1);
        }
        this.stencilBuffer.rewind();
        this.readPixels(n, this.graphics.height - n2 - 1, 1, 1, STENCIL_INDEX, UNSIGNED_BYTE, this.stencilBuffer);
        return this.stencilBuffer.get(0);
    }

    protected static boolean isPowerOfTwo(int n) {
        return (n & n - 1) == 0;
    }

    protected static int nextPowerOfTwo(int n) {
        int n2;
        for (n2 = 1; n2 < n; n2 <<= 1) {
        }
        return n2;
    }

    protected static int nativeToJavaARGB(int n) {
        if (BIG_ENDIAN) {
            return n >>> 8 | n << 24;
        }
        int n2 = n & 0xFF00FF;
        return n & 0xFF00FF00 | n2 << 16 | n2 >> 16;
    }

    protected static void nativeToJavaARGB(int[] nArray, int n, int n2) {
        int n3;
        int n4;
        int n5;
        int n6 = 0;
        int n7 = (n2 - 1) * n;
        for (n5 = 0; n5 < n2 / 2; ++n5) {
            for (n4 = 0; n4 < n; ++n4) {
                n3 = nArray[n7];
                int n8 = nArray[n6];
                if (BIG_ENDIAN) {
                    nArray[n6] = n3 >>> 8 | n3 << 24;
                    nArray[n7] = n8 >>> 8 | n8 << 24;
                } else {
                    int n9 = n8 & 0xFF00FF;
                    int n10 = n3 & 0xFF00FF;
                    nArray[n6] = n3 & 0xFF00FF00 | n10 << 16 | n10 >> 16;
                    nArray[n7] = n8 & 0xFF00FF00 | n9 << 16 | n9 >> 16;
                }
                ++n6;
                ++n7;
            }
            n7 -= n * 2;
        }
        if (n2 % 2 == 1) {
            n6 = n2 / 2 * n;
            for (n5 = 0; n5 < n; ++n5) {
                n4 = nArray[n6];
                if (BIG_ENDIAN) {
                    nArray[n6] = n4 >>> 8 | n4 << 24;
                } else {
                    n3 = n4 & 0xFF00FF;
                    nArray[n6] = n4 & 0xFF00FF00 | n3 << 16 | n3 >> 16;
                }
                ++n6;
            }
        }
    }

    protected static int nativeToJavaRGB(int n) {
        if (BIG_ENDIAN) {
            return n >>> 8 | 0xFF000000;
        }
        int n2 = n & 0xFF00FF;
        return 0xFF000000 | n2 << 16 | n & 0xFF00 | n2 >> 16;
    }

    protected static void nativeToJavaRGB(int[] nArray, int n, int n2) {
        int n3;
        int n4;
        int n5;
        int n6 = 0;
        int n7 = (n2 - 1) * n;
        for (n5 = 0; n5 < n2 / 2; ++n5) {
            for (n4 = 0; n4 < n; ++n4) {
                n3 = nArray[n7];
                int n8 = nArray[n6];
                if (BIG_ENDIAN) {
                    nArray[n6] = n3 >>> 8 | 0xFF000000;
                    nArray[n7] = n8 >>> 8 | 0xFF000000;
                } else {
                    int n9 = n8 & 0xFF00FF;
                    int n10 = n3 & 0xFF00FF;
                    nArray[n6] = 0xFF000000 | n10 << 16 | n3 & 0xFF00 | n10 >> 16;
                    nArray[n7] = 0xFF000000 | n9 << 16 | n8 & 0xFF00 | n9 >> 16;
                }
                ++n6;
                ++n7;
            }
            n7 -= n * 2;
        }
        if (n2 % 2 == 1) {
            n6 = n2 / 2 * n;
            for (n5 = 0; n5 < n; ++n5) {
                n4 = nArray[n6];
                if (BIG_ENDIAN) {
                    nArray[n6] = n4 >>> 8 | 0xFF000000;
                } else {
                    n3 = n4 & 0xFF00FF;
                    nArray[n6] = 0xFF000000 | n3 << 16 | n4 & 0xFF00 | n3 >> 16;
                }
                ++n6;
            }
        }
    }

    protected static int javaToNativeARGB(int n) {
        if (BIG_ENDIAN) {
            return n >>> 24 | n << 8;
        }
        int n2 = n & 0xFF00FF;
        return n & 0xFF00FF00 | n2 << 16 | n2 >> 16;
    }

    protected static void javaToNativeARGB(int[] nArray, int n, int n2) {
        int n3;
        int n4;
        int n5;
        int n6 = 0;
        int n7 = (n2 - 1) * n;
        for (n5 = 0; n5 < n2 / 2; ++n5) {
            for (n4 = 0; n4 < n; ++n4) {
                n3 = nArray[n7];
                int n8 = nArray[n6];
                if (BIG_ENDIAN) {
                    nArray[n6] = n3 >>> 24 | n3 << 8;
                    nArray[n7] = n8 >>> 24 | n8 << 8;
                } else {
                    int n9 = n8 & 0xFF00FF;
                    int n10 = n3 & 0xFF00FF;
                    nArray[n6] = n3 & 0xFF00FF00 | n10 << 16 | n10 >> 16;
                    nArray[n7] = n8 & 0xFF00FF00 | n9 << 16 | n9 >> 16;
                }
                ++n6;
                ++n7;
            }
            n7 -= n * 2;
        }
        if (n2 % 2 == 1) {
            n6 = n2 / 2 * n;
            for (n5 = 0; n5 < n; ++n5) {
                n4 = nArray[n6];
                if (BIG_ENDIAN) {
                    nArray[n6] = n4 >>> 24 | n4 << 8;
                } else {
                    n3 = n4 & 0xFF00FF;
                    nArray[n6] = n4 & 0xFF00FF00 | n3 << 16 | n3 >> 16;
                }
                ++n6;
            }
        }
    }

    protected static int javaToNativeRGB(int n) {
        if (BIG_ENDIAN) {
            return 0xFF | n << 8;
        }
        int n2 = n & 0xFF00FF;
        return 0xFF000000 | n2 << 16 | n & 0xFF00 | n2 >> 16;
    }

    protected static void javaToNativeRGB(int[] nArray, int n, int n2) {
        int n3;
        int n4;
        int n5;
        int n6 = 0;
        int n7 = (n2 - 1) * n;
        for (n5 = 0; n5 < n2 / 2; ++n5) {
            for (n4 = 0; n4 < n; ++n4) {
                n3 = nArray[n7];
                int n8 = nArray[n6];
                if (BIG_ENDIAN) {
                    nArray[n6] = 0xFF | n3 << 8;
                    nArray[n7] = 0xFF | n8 << 8;
                } else {
                    int n9 = n8 & 0xFF00FF;
                    int n10 = n3 & 0xFF00FF;
                    nArray[n6] = 0xFF000000 | n10 << 16 | n3 & 0xFF00 | n10 >> 16;
                    nArray[n7] = 0xFF000000 | n9 << 16 | n8 & 0xFF00 | n9 >> 16;
                }
                ++n6;
                ++n7;
            }
            n7 -= n * 2;
        }
        if (n2 % 2 == 1) {
            n6 = n2 / 2 * n;
            for (n5 = 0; n5 < n; ++n5) {
                n4 = nArray[n6];
                if (BIG_ENDIAN) {
                    nArray[n6] = 0xFF | n4 << 8;
                } else {
                    n3 = n4 & 0xFF00FF;
                    nArray[n6] = 0xFF000000 | n3 << 16 | n4 & 0xFF00 | n3 >> 16;
                }
                ++n6;
            }
        }
    }

    protected static int qualityToSamples(int n) {
        if (n <= 1) {
            return 1;
        }
        int n2 = 2 * (n / 2);
        return n2;
    }

    protected abstract int getGLSLVersion();

    protected String[] loadVertexShader(String string) {
        return this.sketch.loadStrings(string);
    }

    protected String[] loadFragmentShader(String string) {
        return this.sketch.loadStrings(string);
    }

    protected String[] loadFragmentShader(URL uRL) {
        try {
            return PApplet.loadStrings(uRL.openStream());
        }
        catch (IOException iOException) {
            PGraphics.showException("Cannot load fragment shader " + uRL.getFile());
            return null;
        }
    }

    protected String[] loadVertexShader(URL uRL) {
        try {
            return PApplet.loadStrings(uRL.openStream());
        }
        catch (IOException iOException) {
            PGraphics.showException("Cannot load vertex shader " + uRL.getFile());
            return null;
        }
    }

    protected String[] loadVertexShader(String string, int n) {
        return this.loadVertexShader(string);
    }

    protected String[] loadFragmentShader(String string, int n) {
        return this.loadFragmentShader(string);
    }

    protected String[] loadFragmentShader(URL uRL, int n) {
        return this.loadFragmentShader(uRL);
    }

    protected String[] loadVertexShader(URL uRL, int n) {
        return this.loadVertexShader(uRL);
    }

    protected static String[] preprocessFragmentSource(String[] stringArray, int n) {
        String[] stringArray2;
        if (PGL.containsVersionDirective(stringArray)) {
            return stringArray;
        }
        if (n < 130) {
            Pattern[] patternArray = new Pattern[]{};
            String[] stringArray3 = new String[]{};
            int n2 = 1;
            stringArray2 = PGL.preprocessShaderSource(stringArray, patternArray, stringArray3, n2);
            stringArray2[0] = "#version " + n;
        } else {
            Pattern[] patternArray = new Pattern[]{Pattern.compile(String.format(GLSL_ID_REGEX, "varying|attribute")), Pattern.compile(String.format(GLSL_ID_REGEX, "texture")), Pattern.compile(String.format(GLSL_FN_REGEX, "textureRect|texture2D|texture3D|textureCube")), Pattern.compile(String.format(GLSL_ID_REGEX, "gl_FragColor"))};
            String[] stringArray4 = new String[]{"in", "texMap", "texture", "_fragColor"};
            int n3 = 2;
            stringArray2 = PGL.preprocessShaderSource(stringArray, patternArray, stringArray4, n3);
            stringArray2[0] = "#version " + n;
            stringArray2[1] = "out vec4 _fragColor;";
        }
        return stringArray2;
    }

    protected static String[] preprocessVertexSource(String[] stringArray, int n) {
        String[] stringArray2;
        if (PGL.containsVersionDirective(stringArray)) {
            return stringArray;
        }
        if (n < 130) {
            Pattern[] patternArray = new Pattern[]{};
            String[] stringArray3 = new String[]{};
            int n2 = 1;
            stringArray2 = PGL.preprocessShaderSource(stringArray, patternArray, stringArray3, n2);
            stringArray2[0] = "#version " + n;
        } else {
            Pattern[] patternArray = new Pattern[]{Pattern.compile(String.format(GLSL_ID_REGEX, "varying")), Pattern.compile(String.format(GLSL_ID_REGEX, "attribute")), Pattern.compile(String.format(GLSL_ID_REGEX, "texture")), Pattern.compile(String.format(GLSL_FN_REGEX, "textureRect|texture2D|texture3D|textureCube"))};
            String[] stringArray4 = new String[]{"out", "in", "texMap", "texture"};
            int n3 = 1;
            stringArray2 = PGL.preprocessShaderSource(stringArray, patternArray, stringArray4, n3);
            stringArray2[0] = "#version " + n;
        }
        return stringArray2;
    }

    protected static String[] preprocessShaderSource(String[] stringArray, Pattern[] patternArray, String[] stringArray2, int n) {
        String[] stringArray3 = new String[stringArray.length + n];
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            int n2 = string.indexOf("#version");
            if (n2 >= 0) {
                string = string.substring(0, n2);
            }
            for (int j = 0; j < patternArray.length; ++j) {
                string = patternArray[j].matcher(string).replaceAll(stringArray2[j]);
            }
            stringArray3[i + n] = string;
        }
        return stringArray3;
    }

    protected static boolean containsVersionDirective(String[] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            int n;
            String string = stringArray[i];
            int n2 = string.indexOf("#version");
            if (n2 < 0 || (n = string.indexOf("//")) >= 0 && n2 >= n) continue;
            return true;
        }
        return false;
    }

    protected int createShader(int n, String string) {
        int n2 = this.createShader(n);
        if (n2 != 0) {
            this.shaderSource(n2, string);
            this.compileShader(n2);
            if (!this.compiled(n2)) {
                System.err.println("Could not compile shader " + n + ":");
                System.err.println(this.getShaderInfoLog(n2));
                this.deleteShader(n2);
                n2 = 0;
            }
        }
        return n2;
    }

    protected int createProgram(int n, int n2) {
        int n3 = this.createProgram();
        if (n3 != 0) {
            this.attachShader(n3, n);
            this.attachShader(n3, n2);
            this.linkProgram(n3);
            if (!this.linked(n3)) {
                System.err.println("Could not link program: ");
                System.err.println(this.getProgramInfoLog(n3));
                this.deleteProgram(n3);
                n3 = 0;
            }
        }
        return n3;
    }

    protected boolean compiled(int n) {
        this.intBuffer.rewind();
        this.getShaderiv(n, COMPILE_STATUS, this.intBuffer);
        return this.intBuffer.get(0) != 0;
    }

    protected boolean linked(int n) {
        this.intBuffer.rewind();
        this.getProgramiv(n, LINK_STATUS, this.intBuffer);
        return this.intBuffer.get(0) != 0;
    }

    protected boolean validateFramebuffer() {
        int n = this.checkFramebufferStatus(FRAMEBUFFER);
        if (n == FRAMEBUFFER_COMPLETE) {
            return true;
        }
        if (n == FRAMEBUFFER_INCOMPLETE_ATTACHMENT) {
            System.err.println(String.format(FRAMEBUFFER_ERROR, "incomplete attachment"));
        } else if (n == FRAMEBUFFER_INCOMPLETE_MISSING_ATTACHMENT) {
            System.err.println(String.format(FRAMEBUFFER_ERROR, "incomplete missing attachment"));
        } else if (n == FRAMEBUFFER_INCOMPLETE_DIMENSIONS) {
            System.err.println(String.format(FRAMEBUFFER_ERROR, "incomplete dimensions"));
        } else if (n == FRAMEBUFFER_INCOMPLETE_FORMATS) {
            System.err.println(String.format(FRAMEBUFFER_ERROR, "incomplete formats"));
        } else if (n == FRAMEBUFFER_UNSUPPORTED) {
            System.err.println(String.format(FRAMEBUFFER_ERROR, "framebuffer unsupported"));
        } else {
            System.err.println(String.format(FRAMEBUFFER_ERROR, "unknown error"));
        }
        return false;
    }

    protected boolean isES() {
        return this.getString(VERSION).trim().toLowerCase().contains("opengl es");
    }

    protected int[] getGLVersion() {
        String string;
        String string2 = this.getString(VERSION).trim().toLowerCase();
        int n = string2.indexOf(string = "opengl es");
        if (n >= 0) {
            string2 = string2.substring(n + string.length()).trim();
        }
        int[] nArray = new int[]{0, 0, 0};
        String[] stringArray = string2.split(" ");
        for (int i = 0; i < stringArray.length; ++i) {
            if (0 >= stringArray[i].indexOf(".")) continue;
            String[] stringArray2 = stringArray[i].split("\\.");
            try {
                nArray[0] = Integer.parseInt(stringArray2[0]);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            if (1 < stringArray2.length) {
                try {
                    nArray[1] = Integer.parseInt(stringArray2[1]);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            if (2 >= stringArray2.length) break;
            try {
                nArray[2] = Integer.parseInt(stringArray2[2]);
            }
            catch (NumberFormatException numberFormatException) {}
            break;
        }
        return nArray;
    }

    protected boolean hasFBOs() {
        int n = this.getGLVersion()[0];
        if (n < 2) {
            String string = this.getString(EXTENSIONS);
            return string.indexOf("_framebuffer_object") != -1 && string.indexOf("_vertex_shader") != -1 && string.indexOf("_shader_objects") != -1 && string.indexOf("_shading_language") != -1;
        }
        return true;
    }

    protected boolean hasShaders() {
        int n = this.getGLVersion()[0];
        if (n < 2) {
            String string = this.getString(EXTENSIONS);
            return string.indexOf("_fragment_shader") != -1 && string.indexOf("_vertex_shader") != -1 && string.indexOf("_shader_objects") != -1 && string.indexOf("_shading_language") != -1;
        }
        return true;
    }

    protected boolean hasNpotTexSupport() {
        int n = this.getGLVersion()[0];
        if (n < 3) {
            String string = this.getString(EXTENSIONS);
            return -1 < string.indexOf("_texture_non_power_of_two");
        }
        return true;
    }

    protected boolean hasAutoMipmapGenSupport() {
        int n = this.getGLVersion()[0];
        if (n < 3) {
            String string = this.getString(EXTENSIONS);
            return -1 < string.indexOf("_generate_mipmap");
        }
        return true;
    }

    protected boolean hasFboMultisampleSupport() {
        int n = this.getGLVersion()[0];
        if (n < 3) {
            String string = this.getString(EXTENSIONS);
            return -1 < string.indexOf("_framebuffer_multisample");
        }
        return true;
    }

    protected boolean hasPackedDepthStencilSupport() {
        int n = this.getGLVersion()[0];
        if (n < 3) {
            String string = this.getString(EXTENSIONS);
            return -1 < string.indexOf("_packed_depth_stencil");
        }
        return true;
    }

    protected boolean hasAnisoSamplingSupport() {
        int n = this.getGLVersion()[0];
        if (n < 3) {
            String string = this.getString(EXTENSIONS);
            return -1 < string.indexOf("_texture_filter_anisotropic");
        }
        return true;
    }

    protected boolean hasSynchronization() {
        int[] nArray = this.getGLVersion();
        if (this.isES()) {
            return nArray[0] >= 3;
        }
        return nArray[0] > 3 || nArray[0] == 3 && nArray[1] >= 2;
    }

    protected boolean hasPBOs() {
        int[] nArray = this.getGLVersion();
        if (this.isES()) {
            return nArray[0] >= 3;
        }
        return nArray[0] > 2 || nArray[0] == 2 && nArray[1] >= 1;
    }

    protected boolean hasReadBuffer() {
        int[] nArray = this.getGLVersion();
        if (this.isES()) {
            return nArray[0] >= 3;
        }
        return nArray[0] >= 2;
    }

    protected boolean hasDrawBuffer() {
        int[] nArray = this.getGLVersion();
        if (this.isES()) {
            return nArray[0] >= 3;
        }
        return nArray[0] >= 2;
    }

    protected int maxSamples() {
        this.intBuffer.rewind();
        this.getIntegerv(MAX_SAMPLES, this.intBuffer);
        return this.intBuffer.get(0);
    }

    protected int getMaxTexUnits() {
        this.intBuffer.rewind();
        this.getIntegerv(MAX_TEXTURE_IMAGE_UNITS, this.intBuffer);
        return this.intBuffer.get(0);
    }

    protected static ByteBuffer allocateDirectByteBuffer(int n) {
        int n2 = PApplet.max(MIN_DIRECT_BUFFER_SIZE, n) * SIZEOF_BYTE;
        return ByteBuffer.allocateDirect(n2).order(ByteOrder.nativeOrder());
    }

    protected static ByteBuffer allocateByteBuffer(int n) {
        if (USE_DIRECT_BUFFERS) {
            return PGL.allocateDirectByteBuffer(n);
        }
        return ByteBuffer.allocate(n);
    }

    protected static ByteBuffer allocateByteBuffer(byte[] byArray) {
        if (USE_DIRECT_BUFFERS) {
            ByteBuffer byteBuffer = PGL.allocateDirectByteBuffer(byArray.length);
            byteBuffer.put(byArray);
            byteBuffer.position(0);
            return byteBuffer;
        }
        return ByteBuffer.wrap(byArray);
    }

    protected static ByteBuffer updateByteBuffer(ByteBuffer byteBuffer, byte[] byArray, boolean bl) {
        if (USE_DIRECT_BUFFERS) {
            if (byteBuffer == null || byteBuffer.capacity() < byArray.length) {
                byteBuffer = PGL.allocateDirectByteBuffer(byArray.length);
            }
            byteBuffer.position(0);
            byteBuffer.put(byArray);
            byteBuffer.rewind();
        } else if (bl) {
            byteBuffer = ByteBuffer.wrap(byArray);
        } else {
            if (byteBuffer == null || byteBuffer.capacity() < byArray.length) {
                byteBuffer = ByteBuffer.allocate(byArray.length);
            }
            byteBuffer.position(0);
            byteBuffer.put(byArray);
            byteBuffer.rewind();
        }
        return byteBuffer;
    }

    protected static void updateByteBuffer(ByteBuffer byteBuffer, byte[] byArray, int n, int n2) {
        if (USE_DIRECT_BUFFERS || byteBuffer.hasArray() && byteBuffer.array() != byArray) {
            byteBuffer.position(n);
            byteBuffer.put(byArray, n, n2);
            byteBuffer.rewind();
        }
    }

    protected static void getByteArray(ByteBuffer byteBuffer, byte[] byArray) {
        if (!byteBuffer.hasArray() || byteBuffer.array() != byArray) {
            byteBuffer.position(0);
            byteBuffer.get(byArray);
            byteBuffer.rewind();
        }
    }

    protected static void putByteArray(ByteBuffer byteBuffer, byte[] byArray) {
        if (!byteBuffer.hasArray() || byteBuffer.array() != byArray) {
            byteBuffer.position(0);
            byteBuffer.put(byArray);
            byteBuffer.rewind();
        }
    }

    protected static void fillByteBuffer(ByteBuffer byteBuffer, int n, int n2, byte by) {
        int n3 = n2 - n;
        byte[] byArray = new byte[n3];
        Arrays.fill(byArray, 0, n3, by);
        byteBuffer.position(n);
        byteBuffer.put(byArray, 0, n3);
        byteBuffer.rewind();
    }

    protected static ShortBuffer allocateDirectShortBuffer(int n) {
        int n2 = PApplet.max(MIN_DIRECT_BUFFER_SIZE, n) * SIZEOF_SHORT;
        return ByteBuffer.allocateDirect(n2).order(ByteOrder.nativeOrder()).asShortBuffer();
    }

    protected static ShortBuffer allocateShortBuffer(int n) {
        if (USE_DIRECT_BUFFERS) {
            return PGL.allocateDirectShortBuffer(n);
        }
        return ShortBuffer.allocate(n);
    }

    protected static ShortBuffer allocateShortBuffer(short[] sArray) {
        if (USE_DIRECT_BUFFERS) {
            ShortBuffer shortBuffer = PGL.allocateDirectShortBuffer(sArray.length);
            shortBuffer.put(sArray);
            shortBuffer.position(0);
            return shortBuffer;
        }
        return ShortBuffer.wrap(sArray);
    }

    protected static ShortBuffer updateShortBuffer(ShortBuffer shortBuffer, short[] sArray, boolean bl) {
        if (USE_DIRECT_BUFFERS) {
            if (shortBuffer == null || shortBuffer.capacity() < sArray.length) {
                shortBuffer = PGL.allocateDirectShortBuffer(sArray.length);
            }
            shortBuffer.position(0);
            shortBuffer.put(sArray);
            shortBuffer.rewind();
        } else if (bl) {
            shortBuffer = ShortBuffer.wrap(sArray);
        } else {
            if (shortBuffer == null || shortBuffer.capacity() < sArray.length) {
                shortBuffer = ShortBuffer.allocate(sArray.length);
            }
            shortBuffer.position(0);
            shortBuffer.put(sArray);
            shortBuffer.rewind();
        }
        return shortBuffer;
    }

    protected static void updateShortBuffer(ShortBuffer shortBuffer, short[] sArray, int n, int n2) {
        if (USE_DIRECT_BUFFERS || shortBuffer.hasArray() && shortBuffer.array() != sArray) {
            shortBuffer.position(n);
            shortBuffer.put(sArray, n, n2);
            shortBuffer.rewind();
        }
    }

    protected static void getShortArray(ShortBuffer shortBuffer, short[] sArray) {
        if (!shortBuffer.hasArray() || shortBuffer.array() != sArray) {
            shortBuffer.position(0);
            shortBuffer.get(sArray);
            shortBuffer.rewind();
        }
    }

    protected static void putShortArray(ShortBuffer shortBuffer, short[] sArray) {
        if (!shortBuffer.hasArray() || shortBuffer.array() != sArray) {
            shortBuffer.position(0);
            shortBuffer.put(sArray);
            shortBuffer.rewind();
        }
    }

    protected static void fillShortBuffer(ShortBuffer shortBuffer, int n, int n2, short s) {
        int n3 = n2 - n;
        short[] sArray = new short[n3];
        Arrays.fill(sArray, 0, n3, s);
        shortBuffer.position(n);
        shortBuffer.put(sArray, 0, n3);
        shortBuffer.rewind();
    }

    protected static IntBuffer allocateDirectIntBuffer(int n) {
        int n2 = PApplet.max(MIN_DIRECT_BUFFER_SIZE, n) * SIZEOF_INT;
        return ByteBuffer.allocateDirect(n2).order(ByteOrder.nativeOrder()).asIntBuffer();
    }

    protected static IntBuffer allocateIntBuffer(int n) {
        if (USE_DIRECT_BUFFERS) {
            return PGL.allocateDirectIntBuffer(n);
        }
        return IntBuffer.allocate(n);
    }

    protected static IntBuffer allocateIntBuffer(int[] nArray) {
        if (USE_DIRECT_BUFFERS) {
            IntBuffer intBuffer = PGL.allocateDirectIntBuffer(nArray.length);
            intBuffer.put(nArray);
            intBuffer.position(0);
            return intBuffer;
        }
        return IntBuffer.wrap(nArray);
    }

    protected static IntBuffer updateIntBuffer(IntBuffer intBuffer, int[] nArray, boolean bl) {
        if (USE_DIRECT_BUFFERS) {
            if (intBuffer == null || intBuffer.capacity() < nArray.length) {
                intBuffer = PGL.allocateDirectIntBuffer(nArray.length);
            }
            intBuffer.position(0);
            intBuffer.put(nArray);
            intBuffer.rewind();
        } else if (bl) {
            intBuffer = IntBuffer.wrap(nArray);
        } else {
            if (intBuffer == null || intBuffer.capacity() < nArray.length) {
                intBuffer = IntBuffer.allocate(nArray.length);
            }
            intBuffer.position(0);
            intBuffer.put(nArray);
            intBuffer.rewind();
        }
        return intBuffer;
    }

    protected static void updateIntBuffer(IntBuffer intBuffer, int[] nArray, int n, int n2) {
        if (USE_DIRECT_BUFFERS || intBuffer.hasArray() && intBuffer.array() != nArray) {
            intBuffer.position(n);
            intBuffer.put(nArray, n, n2);
            intBuffer.rewind();
        }
    }

    protected static void getIntArray(IntBuffer intBuffer, int[] nArray) {
        if (!intBuffer.hasArray() || intBuffer.array() != nArray) {
            intBuffer.position(0);
            intBuffer.get(nArray);
            intBuffer.rewind();
        }
    }

    protected static void putIntArray(IntBuffer intBuffer, int[] nArray) {
        if (!intBuffer.hasArray() || intBuffer.array() != nArray) {
            intBuffer.position(0);
            intBuffer.put(nArray);
            intBuffer.rewind();
        }
    }

    protected static void fillIntBuffer(IntBuffer intBuffer, int n, int n2, int n3) {
        int n4 = n2 - n;
        int[] nArray = new int[n4];
        Arrays.fill(nArray, 0, n4, n3);
        intBuffer.position(n);
        intBuffer.put(nArray, 0, n4);
        intBuffer.rewind();
    }

    protected static FloatBuffer allocateDirectFloatBuffer(int n) {
        int n2 = PApplet.max(MIN_DIRECT_BUFFER_SIZE, n) * SIZEOF_FLOAT;
        return ByteBuffer.allocateDirect(n2).order(ByteOrder.nativeOrder()).asFloatBuffer();
    }

    protected static FloatBuffer allocateFloatBuffer(int n) {
        if (USE_DIRECT_BUFFERS) {
            return PGL.allocateDirectFloatBuffer(n);
        }
        return FloatBuffer.allocate(n);
    }

    protected static FloatBuffer allocateFloatBuffer(float[] fArray) {
        if (USE_DIRECT_BUFFERS) {
            FloatBuffer floatBuffer = PGL.allocateDirectFloatBuffer(fArray.length);
            floatBuffer.put(fArray);
            floatBuffer.position(0);
            return floatBuffer;
        }
        return FloatBuffer.wrap(fArray);
    }

    protected static FloatBuffer updateFloatBuffer(FloatBuffer floatBuffer, float[] fArray, boolean bl) {
        if (USE_DIRECT_BUFFERS) {
            if (floatBuffer == null || floatBuffer.capacity() < fArray.length) {
                floatBuffer = PGL.allocateDirectFloatBuffer(fArray.length);
            }
            floatBuffer.position(0);
            floatBuffer.put(fArray);
            floatBuffer.rewind();
        } else if (bl) {
            floatBuffer = FloatBuffer.wrap(fArray);
        } else {
            if (floatBuffer == null || floatBuffer.capacity() < fArray.length) {
                floatBuffer = FloatBuffer.allocate(fArray.length);
            }
            floatBuffer.position(0);
            floatBuffer.put(fArray);
            floatBuffer.rewind();
        }
        return floatBuffer;
    }

    protected static void updateFloatBuffer(FloatBuffer floatBuffer, float[] fArray, int n, int n2) {
        if (USE_DIRECT_BUFFERS || floatBuffer.hasArray() && floatBuffer.array() != fArray) {
            floatBuffer.position(n);
            floatBuffer.put(fArray, n, n2);
            floatBuffer.rewind();
        }
    }

    protected static void getFloatArray(FloatBuffer floatBuffer, float[] fArray) {
        if (!floatBuffer.hasArray() || floatBuffer.array() != fArray) {
            floatBuffer.position(0);
            floatBuffer.get(fArray);
            floatBuffer.rewind();
        }
    }

    protected static void putFloatArray(FloatBuffer floatBuffer, float[] fArray) {
        if (!floatBuffer.hasArray() || floatBuffer.array() != fArray) {
            floatBuffer.position(0);
            floatBuffer.put(fArray);
            floatBuffer.rewind();
        }
    }

    protected static void fillFloatBuffer(FloatBuffer floatBuffer, int n, int n2, float f) {
        int n3 = n2 - n;
        float[] fArray = new float[n3];
        Arrays.fill(fArray, 0, n3, f);
        floatBuffer.position(n);
        floatBuffer.put(fArray, 0, n3);
        floatBuffer.rewind();
    }

    protected abstract int getFontAscent(Object var1);

    protected abstract int getFontDescent(Object var1);

    protected abstract int getTextWidth(Object var1, char[] var2, int var3, int var4);

    protected abstract Object getDerivedFont(Object var1, float var2);

    protected abstract Tessellator createTessellator(TessellatorCallback var1);

    protected String tessError(int n) {
        return "";
    }

    protected abstract FontOutline createFontOutline(char var1, Object var2);

    public abstract void flush();

    public abstract void finish();

    public abstract void hint(int var1, int var2);

    public abstract void enable(int var1);

    public abstract void disable(int var1);

    public abstract void getBooleanv(int var1, IntBuffer var2);

    public abstract void getIntegerv(int var1, IntBuffer var2);

    public abstract void getFloatv(int var1, FloatBuffer var2);

    public abstract boolean isEnabled(int var1);

    public abstract String getString(int var1);

    public abstract int getError();

    public abstract String errorString(int var1);

    public abstract void genBuffers(int var1, IntBuffer var2);

    public abstract void deleteBuffers(int var1, IntBuffer var2);

    public abstract void bindBuffer(int var1, int var2);

    public abstract void bufferData(int var1, int var2, Buffer var3, int var4);

    public abstract void bufferSubData(int var1, int var2, int var3, Buffer var4);

    public abstract void isBuffer(int var1);

    public abstract void getBufferParameteriv(int var1, int var2, IntBuffer var3);

    public abstract ByteBuffer mapBuffer(int var1, int var2);

    public abstract ByteBuffer mapBufferRange(int var1, int var2, int var3, int var4);

    public abstract void unmapBuffer(int var1);

    public abstract long fenceSync(int var1, int var2);

    public abstract void deleteSync(long var1);

    public abstract int clientWaitSync(long var1, int var3, long var4);

    public abstract void depthRangef(float var1, float var2);

    public abstract void viewport(int var1, int var2, int var3, int var4);

    protected abstract void viewportImpl(int var1, int var2, int var3, int var4);

    public void readPixels(int n, int n2, int n3, int n4, int n5, int n6, Buffer buffer) {
        boolean bl;
        boolean bl2 = this.isMultisampled() || this.graphics.offscreenMultisample;
        boolean bl3 = this.graphics.getHint(10);
        boolean bl4 = bl = n5 == STENCIL_INDEX || n5 == DEPTH_COMPONENT || n5 == DEPTH_STENCIL;
        if (bl2 && bl && !bl3) {
            PGraphics.showWarning(DEPTH_READING_NOT_ENABLED_ERROR);
            return;
        }
        this.graphics.beginReadPixels();
        this.readPixelsImpl(n, n2, n3, n4, n5, n6, buffer);
        this.graphics.endReadPixels();
    }

    public void readPixels(int n, int n2, int n3, int n4, int n5, int n6, long l) {
        boolean bl;
        boolean bl2 = this.isMultisampled() || this.graphics.offscreenMultisample;
        boolean bl3 = this.graphics.getHint(10);
        boolean bl4 = bl = n5 == STENCIL_INDEX || n5 == DEPTH_COMPONENT || n5 == DEPTH_STENCIL;
        if (bl2 && bl && !bl3) {
            PGraphics.showWarning(DEPTH_READING_NOT_ENABLED_ERROR);
            return;
        }
        this.graphics.beginReadPixels();
        this.readPixelsImpl(n, n2, n3, n4, n5, n6, l);
        this.graphics.endReadPixels();
    }

    protected abstract void readPixelsImpl(int var1, int var2, int var3, int var4, int var5, int var6, Buffer var7);

    protected abstract void readPixelsImpl(int var1, int var2, int var3, int var4, int var5, int var6, long var7);

    public abstract void vertexAttrib1f(int var1, float var2);

    public abstract void vertexAttrib2f(int var1, float var2, float var3);

    public abstract void vertexAttrib3f(int var1, float var2, float var3, float var4);

    public abstract void vertexAttrib4f(int var1, float var2, float var3, float var4, float var5);

    public abstract void vertexAttrib1fv(int var1, FloatBuffer var2);

    public abstract void vertexAttrib2fv(int var1, FloatBuffer var2);

    public abstract void vertexAttrib3fv(int var1, FloatBuffer var2);

    public abstract void vertexAttrib4fv(int var1, FloatBuffer var2);

    public abstract void vertexAttribPointer(int var1, int var2, int var3, boolean var4, int var5, int var6);

    public abstract void enableVertexAttribArray(int var1);

    public abstract void disableVertexAttribArray(int var1);

    public void drawArrays(int n, int n2, int n3) {
        this.geomCount += n3;
        this.drawArraysImpl(n, n2, n3);
    }

    public abstract void drawArraysImpl(int var1, int var2, int var3);

    public void drawElements(int n, int n2, int n3, int n4) {
        this.geomCount += n2;
        this.drawElementsImpl(n, n2, n3, n4);
    }

    public abstract void drawElementsImpl(int var1, int var2, int var3, int var4);

    public abstract void lineWidth(float var1);

    public abstract void frontFace(int var1);

    public abstract void cullFace(int var1);

    public abstract void polygonOffset(float var1, float var2);

    public abstract void pixelStorei(int var1, int var2);

    public abstract void texImage2D(int var1, int var2, int var3, int var4, int var5, int var6, int var7, int var8, Buffer var9);

    public abstract void copyTexImage2D(int var1, int var2, int var3, int var4, int var5, int var6, int var7, int var8);

    public abstract void texSubImage2D(int var1, int var2, int var3, int var4, int var5, int var6, int var7, int var8, Buffer var9);

    public abstract void copyTexSubImage2D(int var1, int var2, int var3, int var4, int var5, int var6, int var7, int var8);

    public abstract void compressedTexImage2D(int var1, int var2, int var3, int var4, int var5, int var6, int var7, Buffer var8);

    public abstract void compressedTexSubImage2D(int var1, int var2, int var3, int var4, int var5, int var6, int var7, int var8, Buffer var9);

    public abstract void texParameteri(int var1, int var2, int var3);

    public abstract void texParameterf(int var1, int var2, float var3);

    public abstract void texParameteriv(int var1, int var2, IntBuffer var3);

    public abstract void texParameterfv(int var1, int var2, FloatBuffer var3);

    public abstract void generateMipmap(int var1);

    public abstract void genTextures(int var1, IntBuffer var2);

    public abstract void deleteTextures(int var1, IntBuffer var2);

    public abstract void getTexParameteriv(int var1, int var2, IntBuffer var3);

    public abstract void getTexParameterfv(int var1, int var2, FloatBuffer var3);

    public abstract boolean isTexture(int var1);

    public void activeTexture(int n) {
        this.activeTexUnit = n - TEXTURE0;
        this.activeTextureImpl(n);
    }

    protected abstract void activeTextureImpl(int var1);

    public void bindTexture(int n, int n2) {
        this.bindTextureImpl(n, n2);
        if (this.boundTextures == null) {
            this.maxTexUnits = this.getMaxTexUnits();
            this.boundTextures = new int[this.maxTexUnits][2];
        }
        if (this.maxTexUnits <= this.activeTexUnit) {
            throw new RuntimeException(TEXUNIT_ERROR);
        }
        if (n == TEXTURE_2D) {
            this.boundTextures[this.activeTexUnit][0] = n2;
        } else if (n == TEXTURE_RECTANGLE) {
            this.boundTextures[this.activeTexUnit][1] = n2;
        }
    }

    protected abstract void bindTextureImpl(int var1, int var2);

    public abstract int createShader(int var1);

    public abstract void shaderSource(int var1, String var2);

    public abstract void compileShader(int var1);

    public abstract void releaseShaderCompiler();

    public abstract void deleteShader(int var1);

    public abstract void shaderBinary(int var1, IntBuffer var2, int var3, Buffer var4, int var5);

    public abstract int createProgram();

    public abstract void attachShader(int var1, int var2);

    public abstract void detachShader(int var1, int var2);

    public abstract void linkProgram(int var1);

    public abstract void useProgram(int var1);

    public abstract void deleteProgram(int var1);

    public abstract String getActiveAttrib(int var1, int var2, IntBuffer var3, IntBuffer var4);

    public abstract int getAttribLocation(int var1, String var2);

    public abstract void bindAttribLocation(int var1, int var2, String var3);

    public abstract int getUniformLocation(int var1, String var2);

    public abstract String getActiveUniform(int var1, int var2, IntBuffer var3, IntBuffer var4);

    public abstract void uniform1i(int var1, int var2);

    public abstract void uniform2i(int var1, int var2, int var3);

    public abstract void uniform3i(int var1, int var2, int var3, int var4);

    public abstract void uniform4i(int var1, int var2, int var3, int var4, int var5);

    public abstract void uniform1f(int var1, float var2);

    public abstract void uniform2f(int var1, float var2, float var3);

    public abstract void uniform3f(int var1, float var2, float var3, float var4);

    public abstract void uniform4f(int var1, float var2, float var3, float var4, float var5);

    public abstract void uniform1iv(int var1, int var2, IntBuffer var3);

    public abstract void uniform2iv(int var1, int var2, IntBuffer var3);

    public abstract void uniform3iv(int var1, int var2, IntBuffer var3);

    public abstract void uniform4iv(int var1, int var2, IntBuffer var3);

    public abstract void uniform1fv(int var1, int var2, FloatBuffer var3);

    public abstract void uniform2fv(int var1, int var2, FloatBuffer var3);

    public abstract void uniform3fv(int var1, int var2, FloatBuffer var3);

    public abstract void uniform4fv(int var1, int var2, FloatBuffer var3);

    public abstract void uniformMatrix2fv(int var1, int var2, boolean var3, FloatBuffer var4);

    public abstract void uniformMatrix3fv(int var1, int var2, boolean var3, FloatBuffer var4);

    public abstract void uniformMatrix4fv(int var1, int var2, boolean var3, FloatBuffer var4);

    public abstract void validateProgram(int var1);

    public abstract boolean isShader(int var1);

    public abstract void getShaderiv(int var1, int var2, IntBuffer var3);

    public abstract void getAttachedShaders(int var1, int var2, IntBuffer var3, IntBuffer var4);

    public abstract String getShaderInfoLog(int var1);

    public abstract String getShaderSource(int var1);

    public abstract void getShaderPrecisionFormat(int var1, int var2, IntBuffer var3, IntBuffer var4);

    public abstract void getVertexAttribfv(int var1, int var2, FloatBuffer var3);

    public abstract void getVertexAttribiv(int var1, int var2, IntBuffer var3);

    public abstract void getVertexAttribPointerv(int var1, int var2, ByteBuffer var3);

    public abstract void getUniformfv(int var1, int var2, FloatBuffer var3);

    public abstract void getUniformiv(int var1, int var2, IntBuffer var3);

    public abstract boolean isProgram(int var1);

    public abstract void getProgramiv(int var1, int var2, IntBuffer var3);

    public abstract String getProgramInfoLog(int var1);

    public abstract void scissor(int var1, int var2, int var3, int var4);

    public abstract void sampleCoverage(float var1, boolean var2);

    public abstract void stencilFunc(int var1, int var2, int var3);

    public abstract void stencilFuncSeparate(int var1, int var2, int var3, int var4);

    public abstract void stencilOp(int var1, int var2, int var3);

    public abstract void stencilOpSeparate(int var1, int var2, int var3, int var4);

    public abstract void depthFunc(int var1);

    public abstract void blendEquation(int var1);

    public abstract void blendEquationSeparate(int var1, int var2);

    public abstract void blendFunc(int var1, int var2);

    public abstract void blendFuncSeparate(int var1, int var2, int var3, int var4);

    public abstract void blendColor(float var1, float var2, float var3, float var4);

    public abstract void colorMask(boolean var1, boolean var2, boolean var3, boolean var4);

    public abstract void depthMask(boolean var1);

    public abstract void stencilMask(int var1);

    public abstract void stencilMaskSeparate(int var1, int var2);

    public abstract void clearColor(float var1, float var2, float var3, float var4);

    public abstract void clearDepth(float var1);

    public abstract void clearStencil(int var1);

    public abstract void clear(int var1);

    public void bindFramebuffer(int n, int n2) {
        this.graphics.beginBindFramebuffer(n, n2);
        this.bindFramebufferImpl(n, n2);
        this.graphics.endBindFramebuffer(n, n2);
    }

    protected abstract void bindFramebufferImpl(int var1, int var2);

    public abstract void deleteFramebuffers(int var1, IntBuffer var2);

    public abstract void genFramebuffers(int var1, IntBuffer var2);

    public abstract void bindRenderbuffer(int var1, int var2);

    public abstract void deleteRenderbuffers(int var1, IntBuffer var2);

    public abstract void genRenderbuffers(int var1, IntBuffer var2);

    public abstract void renderbufferStorage(int var1, int var2, int var3, int var4);

    public abstract void framebufferRenderbuffer(int var1, int var2, int var3, int var4);

    public abstract void framebufferTexture2D(int var1, int var2, int var3, int var4, int var5);

    public abstract int checkFramebufferStatus(int var1);

    public abstract boolean isFramebuffer(int var1);

    public abstract void getFramebufferAttachmentParameteriv(int var1, int var2, int var3, IntBuffer var4);

    public abstract boolean isRenderbuffer(int var1);

    public abstract void getRenderbufferParameteriv(int var1, int var2, IntBuffer var3);

    public abstract void blitFramebuffer(int var1, int var2, int var3, int var4, int var5, int var6, int var7, int var8, int var9, int var10);

    public abstract void renderbufferStorageMultisample(int var1, int var2, int var3, int var4, int var5);

    public abstract void readBuffer(int var1);

    public abstract void drawBuffer(int var1);

    static {
        FLUSH_VERTEX_COUNT = MAX_VERTEX_INDEX1 = MAX_VERTEX_INDEX + 1;
        MIN_FONT_TEX_SIZE = 256;
        MAX_FONT_TEX_SIZE = 1024;
        MIN_CAPS_JOINS_WEIGHT = 2.0f;
        MAX_CAPS_JOINS_LENGTH = 5000;
        MIN_ARRAYCOPY_SIZE = 2;
        STROKE_DISPLACEMENT = 0.999f;
        SINGLE_BUFFERED = false;
        texVertShaderSource = new String[]{"attribute vec2 position;", "attribute vec2 texCoord;", "varying vec2 vertTexCoord;", "void main() {", "  gl_Position = vec4(position, 0, 1);", "  vertTexCoord = texCoord;", "}"};
        tex2DFragShaderSource = new String[]{SHADER_PREPROCESSOR_DIRECTIVE, "uniform sampler2D texMap;", "varying vec2 vertTexCoord;", "void main() {", "  gl_FragColor = texture2D(texMap, vertTexCoord.st);", "}"};
        texRectFragShaderSource = new String[]{SHADER_PREPROCESSOR_DIRECTIVE, "uniform sampler2DRect texMap;", "varying vec2 vertTexCoord;", "void main() {", "  gl_FragColor = texture2DRect(texMap, vertTexCoord.st);", "}"};
        SIZEOF_SHORT = 2;
        SIZEOF_INT = 4;
        SIZEOF_FLOAT = 4;
        SIZEOF_BYTE = 1;
        SIZEOF_INDEX = SIZEOF_SHORT;
        INDEX_TYPE = 5123;
        FLOAT_EPS = Float.MIN_VALUE;
        float f = 1.0f;
        while ((double)((float)(1.0 + (double)(f /= 2.0f) / 2.0)) != 1.0) {
        }
        FLOAT_EPS = f;
        BIG_ENDIAN = ByteOrder.nativeOrder() == ByteOrder.BIG_ENDIAN;
        closeButtonPix = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -1, -1, -1, 0, 0, 0, -1, -1, -1, -1, -1, 0, 0, 0, -1, -1, -1, 0, 0, 0, -1, -1, -1, -1, 0, 0, 0, -1, 0, 0, 0, -1, 0, 0, 0, 0, -1, 0, 0, 0, 0, -1, -1, 0, -1, -1, 0, 0, -1, -1, 0, -1, -1, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, -1, 0, 0, 0, 0, -1, 0, 0, 0, -1, 0, 0, -1, 0, 0, 0, -1, 0, 0, 0, -1, -1, -1, 0, 0, 0, 0, 0, -1, 0, 0, 0, 0, -1, 0, 0, 0, -1, 0, 0, -1, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, -1, 0, 0, 0, 0, -1, 0, 0, 0, 0, -1, 0, 0, 0, -1, 0, 0, -1, 0, 0, 0, -1, 0, 0, -1, 0, 0, 0, -1, 0, 0, 0, 0, -1, 0, 0, 0, 0, -1, -1, 0, -1, -1, 0, 0, -1, -1, 0, -1, -1, 0, 0, 0, -1, -1, -1, 0, 0, 0, 0, 0, -1, -1, -1, 0, 0, 0, -1, -1, -1, 0, 0, 0, -1, -1, -1, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -1, 0, 0, 0, 0, 0};
    }

    protected static interface FontOutline {
        public boolean isDone();

        public int currentSegment(float[] var1);

        public void next();
    }

    protected static interface TessellatorCallback {
        public void begin(int var1);

        public void end();

        public void vertex(Object var1);

        public void combine(double[] var1, Object[] var2, float[] var3, Object[] var4);

        public void error(int var1);
    }

    protected static interface Tessellator {
        public void setCallback(int var1);

        public void setWindingRule(int var1);

        public void setProperty(int var1, int var2);

        public void beginPolygon();

        public void beginPolygon(Object var1);

        public void endPolygon();

        public void beginContour();

        public void endContour();

        public void addVertex(double[] var1);

        public void addVertex(double[] var1, int var2, Object var3);
    }
}

