/*
 * Decompiled with CFR 0.152.
 */
package processing.event;

import processing.event.Event;

public class TouchEvent
extends Event {
    public static final int START = 1;
    public static final int END = 2;
    public static final int CANCEL = 3;
    public static final int MOVE = 4;
    protected int action;
    protected int button;
    protected int numPointers;
    protected int[] pointerId;
    protected float[] pointerX;
    protected float[] pointerY;
    protected float[] pointerArea;
    protected float[] pointerPressure;

    public TouchEvent(Object object, long l, int n, int n2, int n3) {
        super(object, l, n, n2);
        this.flavor = 3;
        this.button = n3;
    }

    public void setNumPointers(int n) {
        this.numPointers = n;
        this.pointerId = new int[n];
        this.pointerX = new float[n];
        this.pointerY = new float[n];
        this.pointerArea = new float[n];
        this.pointerPressure = new float[n];
    }

    public void setPointer(int n, int n2, float f, float f2, float f3, float f4) {
        this.pointerId[n] = n2;
        this.pointerX[n] = f;
        this.pointerY[n] = f2;
        this.pointerArea[n] = f3;
        this.pointerPressure[n] = f4;
    }

    public int getNumPointers() {
        return this.numPointers;
    }

    public Pointer getPointer(int n) {
        Pointer pointer = new Pointer();
        pointer.id = this.pointerId[n];
        pointer.x = this.pointerX[n];
        pointer.y = this.pointerY[n];
        pointer.area = this.pointerArea[n];
        pointer.pressure = this.pointerPressure[n];
        return pointer;
    }

    public int getPointerId(int n) {
        return this.pointerId[n];
    }

    public float getPointerX(int n) {
        return this.pointerX[n];
    }

    public float getPointerY(int n) {
        return this.pointerY[n];
    }

    public float getPointerArea(int n) {
        return this.pointerArea[n];
    }

    public float getPointerPressure(int n) {
        return this.pointerPressure[n];
    }

    public int getButton() {
        return this.button;
    }

    public Pointer[] getTouches(Pointer[] pointerArray) {
        int n;
        if (pointerArray == null || pointerArray.length != this.numPointers) {
            pointerArray = new Pointer[this.numPointers];
            for (n = 0; n < this.numPointers; ++n) {
                pointerArray[n] = new Pointer();
            }
        }
        for (n = 0; n < this.numPointers; ++n) {
            pointerArray[n].id = this.pointerId[n];
            pointerArray[n].x = this.pointerX[n];
            pointerArray[n].y = this.pointerY[n];
            pointerArray[n].area = this.pointerArea[n];
            pointerArray[n].pressure = this.pointerPressure[n];
        }
        return pointerArray;
    }

    public class Pointer {
        public int id;
        public float x;
        public float y;
        public float area;
        public float pressure;
    }
}

