/*
 * Decompiled with CFR 0.152.
 */
package processing.data;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Array;
import java.util.ArrayList;
import processing.core.PApplet;
import processing.data.FloatList;
import processing.data.IntList;
import processing.data.JSONObject;
import processing.data.JSONTokener;
import processing.data.StringList;

public class JSONArray {
    private final ArrayList<Object> myArrayList = new ArrayList();

    public JSONArray() {
    }

    public JSONArray(Reader reader) {
        this(new JSONTokener(reader));
    }

    protected JSONArray(JSONTokener jSONTokener) {
        this();
        if (jSONTokener.nextClean() != '[') {
            throw new RuntimeException("A JSONArray text must start with '['");
        }
        if (jSONTokener.nextClean() != ']') {
            jSONTokener.back();
            block4: while (true) {
                if (jSONTokener.nextClean() == ',') {
                    jSONTokener.back();
                    this.myArrayList.add(JSONObject.NULL);
                } else {
                    jSONTokener.back();
                    this.myArrayList.add(jSONTokener.nextValue());
                }
                switch (jSONTokener.nextClean()) {
                    case ',': 
                    case ';': {
                        if (jSONTokener.nextClean() == ']') {
                            return;
                        }
                        jSONTokener.back();
                        continue block4;
                    }
                    case ']': {
                        return;
                    }
                }
                break;
            }
            throw new RuntimeException("Expected a ',' or ']'");
        }
    }

    public JSONArray(IntList intList) {
        for (int n : intList.values()) {
            this.myArrayList.add(n);
        }
    }

    public JSONArray(FloatList floatList) {
        for (float f : floatList.values()) {
            this.myArrayList.add(Float.valueOf(f));
        }
    }

    public JSONArray(StringList stringList) {
        for (String string : stringList.values()) {
            this.myArrayList.add(string);
        }
    }

    public static JSONArray parse(String string) {
        try {
            return new JSONArray(new JSONTokener(string));
        }
        catch (Exception exception) {
            return null;
        }
    }

    protected JSONArray(Object object) {
        this();
        if (object.getClass().isArray()) {
            int n = Array.getLength(object);
            for (int i = 0; i < n; ++i) {
                this.append(JSONObject.wrap(Array.get(object, i)));
            }
        } else {
            throw new RuntimeException("JSONArray initial value should be a string or collection or array.");
        }
    }

    private Object opt(int n) {
        if (n < 0 || n >= this.size()) {
            return null;
        }
        return this.myArrayList.get(n);
    }

    public Object get(int n) {
        Object object = this.opt(n);
        if (object == null) {
            throw new RuntimeException("JSONArray[" + n + "] not found.");
        }
        return object;
    }

    public String getString(int n) {
        Object object = this.get(n);
        if (object instanceof String) {
            return (String)object;
        }
        throw new RuntimeException("JSONArray[" + n + "] not a string.");
    }

    public String getString(int n, String string) {
        Object object = this.opt(n);
        return JSONObject.NULL.equals(object) ? string : object.toString();
    }

    public int getInt(int n) {
        Object object = this.get(n);
        try {
            return object instanceof Number ? ((Number)object).intValue() : Integer.parseInt((String)object);
        }
        catch (Exception exception) {
            throw new RuntimeException("JSONArray[" + n + "] is not a number.");
        }
    }

    public int getInt(int n, int n2) {
        try {
            return this.getInt(n);
        }
        catch (Exception exception) {
            return n2;
        }
    }

    public long getLong(int n) {
        Object object = this.get(n);
        try {
            return object instanceof Number ? ((Number)object).longValue() : Long.parseLong((String)object);
        }
        catch (Exception exception) {
            throw new RuntimeException("JSONArray[" + n + "] is not a number.");
        }
    }

    public long getLong(int n, long l) {
        try {
            return this.getLong(n);
        }
        catch (Exception exception) {
            return l;
        }
    }

    public float getFloat(int n) {
        return (float)this.getDouble(n);
    }

    public float getFloat(int n, float f) {
        try {
            return this.getFloat(n);
        }
        catch (Exception exception) {
            return f;
        }
    }

    public double getDouble(int n) {
        Object object = this.get(n);
        try {
            return object instanceof Number ? ((Number)object).doubleValue() : Double.parseDouble((String)object);
        }
        catch (Exception exception) {
            throw new RuntimeException("JSONArray[" + n + "] is not a number.");
        }
    }

    public double getDouble(int n, double d) {
        try {
            return this.getDouble(n);
        }
        catch (Exception exception) {
            return d;
        }
    }

    public boolean getBoolean(int n) {
        Object object = this.get(n);
        if (object.equals(Boolean.FALSE) || object instanceof String && ((String)object).equalsIgnoreCase("false")) {
            return false;
        }
        if (object.equals(Boolean.TRUE) || object instanceof String && ((String)object).equalsIgnoreCase("true")) {
            return true;
        }
        throw new RuntimeException("JSONArray[" + n + "] is not a boolean.");
    }

    public boolean getBoolean(int n, boolean bl) {
        try {
            return this.getBoolean(n);
        }
        catch (Exception exception) {
            return bl;
        }
    }

    public JSONArray getJSONArray(int n) {
        Object object = this.get(n);
        if (object instanceof JSONArray) {
            return (JSONArray)object;
        }
        throw new RuntimeException("JSONArray[" + n + "] is not a JSONArray.");
    }

    public JSONArray getJSONArray(int n, JSONArray jSONArray) {
        try {
            return this.getJSONArray(n);
        }
        catch (Exception exception) {
            return jSONArray;
        }
    }

    public JSONObject getJSONObject(int n) {
        Object object = this.get(n);
        if (object instanceof JSONObject) {
            return (JSONObject)object;
        }
        throw new RuntimeException("JSONArray[" + n + "] is not a JSONObject.");
    }

    public JSONObject getJSONObject(int n, JSONObject jSONObject) {
        try {
            return this.getJSONObject(n);
        }
        catch (Exception exception) {
            return jSONObject;
        }
    }

    public String[] getStringArray() {
        String[] stringArray = new String[this.size()];
        for (int i = 0; i < this.size(); ++i) {
            stringArray[i] = this.getString(i);
        }
        return stringArray;
    }

    public int[] getIntArray() {
        int[] nArray = new int[this.size()];
        for (int i = 0; i < this.size(); ++i) {
            nArray[i] = this.getInt(i);
        }
        return nArray;
    }

    public long[] getLongArray() {
        long[] lArray = new long[this.size()];
        for (int i = 0; i < this.size(); ++i) {
            lArray[i] = this.getLong(i);
        }
        return lArray;
    }

    public float[] getFloatArray() {
        float[] fArray = new float[this.size()];
        for (int i = 0; i < this.size(); ++i) {
            fArray[i] = this.getFloat(i);
        }
        return fArray;
    }

    public double[] getDoubleArray() {
        double[] dArray = new double[this.size()];
        for (int i = 0; i < this.size(); ++i) {
            dArray[i] = this.getDouble(i);
        }
        return dArray;
    }

    public boolean[] getBooleanArray() {
        boolean[] blArray = new boolean[this.size()];
        for (int i = 0; i < this.size(); ++i) {
            blArray[i] = this.getBoolean(i);
        }
        return blArray;
    }

    public JSONArray append(String string) {
        this.append((Object)string);
        return this;
    }

    public JSONArray append(int n) {
        this.append((Object)n);
        return this;
    }

    public JSONArray append(long l) {
        this.append((Object)l);
        return this;
    }

    public JSONArray append(float f) {
        return this.append((double)f);
    }

    public JSONArray append(double d) {
        Double d2 = d;
        JSONObject.testValidity(d2);
        this.append(d2);
        return this;
    }

    public JSONArray append(boolean bl) {
        this.append(bl ? Boolean.TRUE : Boolean.FALSE);
        return this;
    }

    public JSONArray append(JSONArray jSONArray) {
        this.myArrayList.add(jSONArray);
        return this;
    }

    public JSONArray append(JSONObject jSONObject) {
        this.myArrayList.add(jSONObject);
        return this;
    }

    protected JSONArray append(Object object) {
        this.myArrayList.add(object);
        return this;
    }

    public JSONArray setString(int n, String string) {
        this.set(n, string);
        return this;
    }

    public JSONArray setInt(int n, int n2) {
        this.set(n, n2);
        return this;
    }

    public JSONArray setLong(int n, long l) {
        return this.set(n, l);
    }

    public JSONArray setFloat(int n, float f) {
        return this.setDouble(n, f);
    }

    public JSONArray setDouble(int n, double d) {
        return this.set(n, d);
    }

    public JSONArray setBoolean(int n, boolean bl) {
        return this.set(n, bl ? Boolean.TRUE : Boolean.FALSE);
    }

    public JSONArray setJSONArray(int n, JSONArray jSONArray) {
        this.set(n, jSONArray);
        return this;
    }

    public JSONArray setJSONObject(int n, JSONObject jSONObject) {
        this.set(n, jSONObject);
        return this;
    }

    private JSONArray set(int n, Object object) {
        JSONObject.testValidity(object);
        if (n < 0) {
            throw new RuntimeException("JSONArray[" + n + "] not found.");
        }
        if (n < this.size()) {
            this.myArrayList.set(n, object);
        } else {
            while (n != this.size()) {
                this.append(JSONObject.NULL);
            }
            this.append(object);
        }
        return this;
    }

    public int size() {
        return this.myArrayList.size();
    }

    public boolean isNull(int n) {
        return JSONObject.NULL.equals(this.opt(n));
    }

    public Object remove(int n) {
        Object object = this.opt(n);
        this.myArrayList.remove(n);
        return object;
    }

    public boolean save(File file, String string) {
        PrintWriter printWriter = PApplet.createWriter(file);
        boolean bl = this.write(printWriter, string);
        printWriter.close();
        return bl;
    }

    public boolean write(PrintWriter printWriter) {
        return this.write(printWriter, null);
    }

    public boolean write(PrintWriter printWriter, String string) {
        int n = 2;
        if (string != null) {
            String[] stringArray;
            for (String string2 : stringArray = PApplet.split(string, ',')) {
                if (string2.equals("compact")) {
                    n = -1;
                    continue;
                }
                if (string2.startsWith("indent=")) {
                    n = PApplet.parseInt(string2.substring(7), -2);
                    if (n != -2) continue;
                    throw new IllegalArgumentException("Could not read a number from " + string2);
                }
                System.err.println("Ignoring " + string2);
            }
        }
        printWriter.print(this.format(n));
        printWriter.flush();
        return true;
    }

    public String toString() {
        try {
            return this.format(2);
        }
        catch (Exception exception) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String format(int n) {
        StringWriter stringWriter = new StringWriter();
        StringBuffer stringBuffer = stringWriter.getBuffer();
        synchronized (stringBuffer) {
            return this.writeInternal(stringWriter, n, 0).toString();
        }
    }

    protected Writer writeInternal(Writer writer, int n, int n2) {
        try {
            int n3;
            boolean bl = false;
            int n4 = this.size();
            writer.write(91);
            int n5 = n3 = n == -1 ? 0 : n;
            if (n4 == 1) {
                JSONObject.writeValue(writer, this.myArrayList.get(0), n, n2);
            } else if (n4 != 0) {
                int n6 = n2 + n3;
                for (int i = 0; i < n4; ++i) {
                    if (bl) {
                        writer.write(44);
                    }
                    if (n != -1) {
                        writer.write(10);
                    }
                    JSONObject.indent(writer, n6);
                    JSONObject.writeValue(writer, this.myArrayList.get(i), n, n6);
                    bl = true;
                }
                if (n != -1) {
                    writer.write(10);
                }
                JSONObject.indent(writer, n2);
            }
            writer.write(93);
            return writer;
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    public String join(String string) {
        int n = this.size();
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < n; ++i) {
            if (i > 0) {
                stringBuilder.append(string);
            }
            stringBuilder.append(JSONObject.valueToString(this.myArrayList.get(i)));
        }
        return stringBuilder.toString();
    }
}

