/*
 * Decompiled with CFR 0.152.
 */
package processing.data;

import java.io.BufferedReader;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Iterator;
import processing.core.PApplet;
import processing.data.JSONObject;
import processing.data.Sort;
import processing.data.StringList;

public class FloatDict {
    protected int count;
    protected String[] keys;
    protected float[] values;
    private HashMap<String, Integer> indices = new HashMap();

    public FloatDict() {
        this.count = 0;
        this.keys = new String[10];
        this.values = new float[10];
    }

    public FloatDict(int n) {
        this.count = 0;
        this.keys = new String[n];
        this.values = new float[n];
    }

    public FloatDict(BufferedReader bufferedReader) {
        String[] stringArray = PApplet.loadStrings(bufferedReader);
        this.keys = new String[stringArray.length];
        this.values = new float[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            String[] stringArray2 = PApplet.split(stringArray[i], '\t');
            if (stringArray2.length != 2) continue;
            this.keys[this.count] = stringArray2[0];
            this.values[this.count] = PApplet.parseFloat(stringArray2[1]);
            this.indices.put(stringArray2[0], this.count);
            ++this.count;
        }
    }

    public FloatDict(String[] stringArray, float[] fArray) {
        if (stringArray.length != fArray.length) {
            throw new IllegalArgumentException("key and value arrays must be the same length");
        }
        this.keys = stringArray;
        this.values = fArray;
        this.count = stringArray.length;
        for (int i = 0; i < this.count; ++i) {
            this.indices.put(stringArray[i], i);
        }
    }

    public FloatDict(Object[][] objectArray) {
        this.count = objectArray.length;
        this.keys = new String[this.count];
        this.values = new float[this.count];
        for (int i = 0; i < this.count; ++i) {
            this.keys[i] = (String)objectArray[i][0];
            this.values[i] = ((Float)objectArray[i][1]).floatValue();
            this.indices.put(this.keys[i], i);
        }
    }

    public int size() {
        return this.count;
    }

    public void resize(int n) {
        if (n == this.count) {
            return;
        }
        if (n > this.count) {
            throw new IllegalArgumentException("resize() can only be used to shrink the dictionary");
        }
        if (n < 1) {
            throw new IllegalArgumentException("resize(" + n + ") is too small, use 1 or higher");
        }
        String[] stringArray = new String[n];
        float[] fArray = new float[n];
        PApplet.arrayCopy(this.keys, stringArray, n);
        PApplet.arrayCopy(this.values, fArray, n);
        this.keys = stringArray;
        this.values = fArray;
        this.count = n;
        this.resetIndices();
    }

    public void clear() {
        this.count = 0;
        this.indices = new HashMap();
    }

    private void resetIndices() {
        this.indices = new HashMap(this.count);
        for (int i = 0; i < this.count; ++i) {
            this.indices.put(this.keys[i], i);
        }
    }

    public Iterable<Entry> entries() {
        return new Iterable<Entry>(){

            @Override
            public Iterator<Entry> iterator() {
                return FloatDict.this.entryIterator();
            }
        };
    }

    public Iterator<Entry> entryIterator() {
        return new Iterator<Entry>(){
            int index = -1;

            @Override
            public void remove() {
                FloatDict.this.removeIndex(this.index);
                --this.index;
            }

            @Override
            public Entry next() {
                ++this.index;
                Entry entry = new Entry(FloatDict.this.keys[this.index], FloatDict.this.values[this.index]);
                return entry;
            }

            @Override
            public boolean hasNext() {
                return this.index + 1 < FloatDict.this.size();
            }
        };
    }

    public String key(int n) {
        return this.keys[n];
    }

    protected void crop() {
        if (this.count != this.keys.length) {
            this.keys = PApplet.subset(this.keys, 0, this.count);
            this.values = PApplet.subset(this.values, 0, this.count);
        }
    }

    public Iterable<String> keys() {
        return new Iterable<String>(){

            @Override
            public Iterator<String> iterator() {
                return FloatDict.this.keyIterator();
            }
        };
    }

    public Iterator<String> keyIterator() {
        return new Iterator<String>(){
            int index = -1;

            @Override
            public void remove() {
                FloatDict.this.removeIndex(this.index);
                --this.index;
            }

            @Override
            public String next() {
                return FloatDict.this.key(++this.index);
            }

            @Override
            public boolean hasNext() {
                return this.index + 1 < FloatDict.this.size();
            }
        };
    }

    public String[] keyArray() {
        this.crop();
        return this.keyArray(null);
    }

    public String[] keyArray(String[] stringArray) {
        if (stringArray == null || stringArray.length != this.count) {
            stringArray = new String[this.count];
        }
        System.arraycopy(this.keys, 0, stringArray, 0, this.count);
        return stringArray;
    }

    public float value(int n) {
        return this.values[n];
    }

    public Iterable<Float> values() {
        return new Iterable<Float>(){

            @Override
            public Iterator<Float> iterator() {
                return FloatDict.this.valueIterator();
            }
        };
    }

    public Iterator<Float> valueIterator() {
        return new Iterator<Float>(){
            int index = -1;

            @Override
            public void remove() {
                FloatDict.this.removeIndex(this.index);
                --this.index;
            }

            @Override
            public Float next() {
                return Float.valueOf(FloatDict.this.value(++this.index));
            }

            @Override
            public boolean hasNext() {
                return this.index + 1 < FloatDict.this.size();
            }
        };
    }

    public float[] valueArray() {
        this.crop();
        return this.valueArray(null);
    }

    public float[] valueArray(float[] fArray) {
        if (fArray == null || fArray.length != this.size()) {
            fArray = new float[this.count];
        }
        System.arraycopy(this.values, 0, fArray, 0, this.count);
        return fArray;
    }

    public float get(String string) {
        int n = this.index(string);
        if (n == -1) {
            throw new IllegalArgumentException("No key named '" + string + "'");
        }
        return this.values[n];
    }

    public float get(String string, float f) {
        int n = this.index(string);
        if (n == -1) {
            return f;
        }
        return this.values[n];
    }

    public void set(String string, float f) {
        int n = this.index(string);
        if (n == -1) {
            this.create(string, f);
        } else {
            this.values[n] = f;
        }
    }

    public void setIndex(int n, String string, float f) {
        if (n < 0 || n >= this.count) {
            throw new ArrayIndexOutOfBoundsException(n);
        }
        this.keys[n] = string;
        this.values[n] = f;
    }

    public boolean hasKey(String string) {
        return this.index(string) != -1;
    }

    public void add(String string, float f) {
        int n = this.index(string);
        if (n == -1) {
            this.create(string, f);
        } else {
            int n2 = n;
            this.values[n2] = this.values[n2] + f;
        }
    }

    public void sub(String string, float f) {
        this.add(string, -f);
    }

    public void mult(String string, float f) {
        int n = this.index(string);
        if (n != -1) {
            int n2 = n;
            this.values[n2] = this.values[n2] * f;
        }
    }

    public void div(String string, float f) {
        int n = this.index(string);
        if (n != -1) {
            int n2 = n;
            this.values[n2] = this.values[n2] / f;
        }
    }

    private void checkMinMax(String string) {
        if (this.count == 0) {
            String string2 = String.format("Cannot use %s() on an empty %s.", string, this.getClass().getSimpleName());
            throw new RuntimeException(string2);
        }
    }

    public int minIndex() {
        if (this.count == 0) {
            return -1;
        }
        float f = Float.NaN;
        int n = -1;
        for (int i = 0; i < this.count; ++i) {
            if (this.values[i] != this.values[i]) continue;
            f = this.values[i];
            n = i;
            for (int j = i + 1; j < this.count; ++j) {
                float f2 = this.values[j];
                if (f2 != f2 || !(f2 < f)) continue;
                f = this.values[j];
                n = j;
            }
            break;
        }
        return n;
    }

    public String minKey() {
        this.checkMinMax("minKey");
        int n = this.minIndex();
        if (n == -1) {
            return null;
        }
        return this.keys[n];
    }

    public float minValue() {
        this.checkMinMax("minValue");
        int n = this.minIndex();
        if (n == -1) {
            return Float.NaN;
        }
        return this.values[n];
    }

    public int maxIndex() {
        if (this.count == 0) {
            return -1;
        }
        float f = Float.NaN;
        int n = -1;
        for (int i = 0; i < this.count; ++i) {
            if (this.values[i] != this.values[i]) continue;
            f = this.values[i];
            n = i;
            for (int j = i + 1; j < this.count; ++j) {
                float f2 = this.values[j];
                if (Float.isNaN(f2) || !(f2 > f)) continue;
                f = this.values[j];
                n = j;
            }
            break;
        }
        return n;
    }

    public String maxKey() {
        int n = this.maxIndex();
        if (n == -1) {
            return null;
        }
        return this.keys[n];
    }

    public float maxValue() {
        int n = this.maxIndex();
        if (n == -1) {
            return Float.NaN;
        }
        return this.values[n];
    }

    public float sum() {
        double d = this.sumDouble();
        if (d > 3.4028234663852886E38) {
            throw new RuntimeException("sum() exceeds 3.4028235E38, use sumDouble()");
        }
        if (d < -3.4028234663852886E38) {
            throw new RuntimeException("sum() lower than -3.4028235E38, use sumDouble()");
        }
        return (float)d;
    }

    public double sumDouble() {
        double d = 0.0;
        for (int i = 0; i < this.count; ++i) {
            d += (double)this.values[i];
        }
        return d;
    }

    public int index(String string) {
        Integer n = this.indices.get(string);
        return n == null ? -1 : n;
    }

    protected void create(String string, float f) {
        if (this.count == this.keys.length) {
            this.keys = PApplet.expand(this.keys);
            this.values = PApplet.expand(this.values);
        }
        this.indices.put(string, this.count);
        this.keys[this.count] = string;
        this.values[this.count] = f;
        ++this.count;
    }

    public int remove(String string) {
        int n = this.index(string);
        if (n != -1) {
            this.removeIndex(n);
        }
        return n;
    }

    public String removeIndex(int n) {
        if (n < 0 || n >= this.count) {
            throw new ArrayIndexOutOfBoundsException(n);
        }
        String string = this.keys[n];
        this.indices.remove(this.keys[n]);
        for (int i = n; i < this.count - 1; ++i) {
            this.keys[i] = this.keys[i + 1];
            this.values[i] = this.values[i + 1];
            this.indices.put(this.keys[i], i);
        }
        --this.count;
        this.keys[this.count] = null;
        this.values[this.count] = 0.0f;
        return string;
    }

    public void swap(int n, int n2) {
        String string = this.keys[n];
        float f = this.values[n];
        this.keys[n] = this.keys[n2];
        this.values[n] = this.values[n2];
        this.keys[n2] = string;
        this.values[n2] = f;
    }

    public void sortKeys() {
        this.sortImpl(true, false, true);
    }

    public void sortKeysReverse() {
        this.sortImpl(true, true, true);
    }

    public void sortValues() {
        this.sortValues(true);
    }

    public void sortValues(boolean bl) {
        this.sortImpl(false, false, bl);
    }

    public void sortValuesReverse() {
        this.sortValuesReverse(true);
    }

    public void sortValuesReverse(boolean bl) {
        this.sortImpl(false, true, bl);
    }

    protected void sortImpl(final boolean bl, final boolean bl2, final boolean bl3) {
        Sort sort = new Sort(){

            @Override
            public int size() {
                if (bl) {
                    return FloatDict.this.count;
                }
                if (FloatDict.this.count == 0) {
                    return 0;
                }
                int n = FloatDict.this.count - 1;
                while (FloatDict.this.values[n] != FloatDict.this.values[n]) {
                    if (--n != -1) continue;
                    return 0;
                }
                for (int i = n; i >= 0; --i) {
                    if (!Float.isNaN(FloatDict.this.values[i])) continue;
                    this.swap(i, n);
                    --n;
                }
                return n + 1;
            }

            @Override
            public float compare(int n, int n2) {
                float f = 0.0f;
                if (bl) {
                    f = FloatDict.this.keys[n].compareToIgnoreCase(FloatDict.this.keys[n2]);
                    if (f == 0.0f) {
                        f = FloatDict.this.values[n] - FloatDict.this.values[n2];
                    }
                } else {
                    f = FloatDict.this.values[n] - FloatDict.this.values[n2];
                    if (f == 0.0f && bl3) {
                        f = FloatDict.this.keys[n].compareToIgnoreCase(FloatDict.this.keys[n2]);
                    }
                }
                return bl2 ? -f : f;
            }

            @Override
            public void swap(int n, int n2) {
                FloatDict.this.swap(n, n2);
            }
        };
        sort.run();
        this.resetIndices();
    }

    public FloatDict getPercent() {
        double d = this.sum();
        FloatDict floatDict = new FloatDict();
        for (int i = 0; i < this.size(); ++i) {
            double d2 = (double)this.value(i) / d;
            floatDict.set(this.key(i), (float)d2);
        }
        return floatDict;
    }

    public FloatDict copy() {
        FloatDict floatDict = new FloatDict(this.count);
        System.arraycopy(this.keys, 0, floatDict.keys, 0, this.count);
        System.arraycopy(this.values, 0, floatDict.values, 0, this.count);
        for (int i = 0; i < this.count; ++i) {
            floatDict.indices.put(this.keys[i], i);
        }
        floatDict.count = this.count;
        return floatDict;
    }

    public void print() {
        for (int i = 0; i < this.size(); ++i) {
            System.out.println(this.keys[i] + " = " + this.values[i]);
        }
    }

    public void write(PrintWriter printWriter) {
        for (int i = 0; i < this.count; ++i) {
            printWriter.println(this.keys[i] + "\t" + this.values[i]);
        }
        printWriter.flush();
    }

    public String toJSON() {
        StringList stringList = new StringList();
        for (int i = 0; i < this.count; ++i) {
            stringList.append(JSONObject.quote(this.keys[i]) + ": " + this.values[i]);
        }
        return "{ " + stringList.join(", ") + " }";
    }

    public String toString() {
        return this.getClass().getSimpleName() + " size=" + this.size() + " " + this.toJSON();
    }

    public class Entry {
        public String key;
        public float value;

        Entry(String string, float f) {
            this.key = string;
            this.value = f;
        }
    }
}

