/*
 * Decompiled with CFR 0.152.
 */
package processing.core;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.content.res.AssetManager;
import android.graphics.Rect;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.os.Parcelable;
import android.service.wallpaper.WallpaperService;
import android.support.v4.app.ActivityCompat;
import android.support.v4.content.ContextCompat;
import android.support.v4.os.ResultReceiver;
import android.support.wearable.watchface.WatchFaceService;
import android.view.LayoutInflater;
import android.view.SurfaceHolder;
import android.view.SurfaceView;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.InputStream;
import processing.android.AppComponent;
import processing.android.PFragment;
import processing.android.PermissionRequestor;
import processing.android.ServiceEngine;
import processing.core.PApplet;
import processing.core.PConstants;
import processing.core.PGraphics;
import processing.core.PSurface;

public class PSurfaceNone
implements PSurface,
PConstants {
    protected PApplet sketch;
    protected PGraphics graphics;
    protected AppComponent component;
    protected Activity activity;
    protected boolean surfaceReady;
    protected SurfaceView surfaceView;
    protected View view;
    protected WallpaperService wallpaper;
    protected WatchFaceService watchface;
    protected boolean requestedThreadStart = false;
    protected Thread thread;
    protected boolean paused;
    protected Object pauseObject = new Object();
    protected float frameRateTarget = 60.0f;
    protected long frameRatePeriod = 16666666L;

    @Override
    public AppComponent getComponent() {
        return this.component;
    }

    @Override
    public Context getContext() {
        if (this.component.getKind() == 0) {
            return this.activity;
        }
        if (this.component.getKind() == 1) {
            return this.wallpaper;
        }
        if (this.component.getKind() == 2) {
            return this.watchface;
        }
        return null;
    }

    @Override
    public Activity getActivity() {
        return this.activity;
    }

    @Override
    public ServiceEngine getEngine() {
        return this.component.getEngine();
    }

    @Override
    public View getRootView() {
        return this.view;
    }

    @Override
    public String getName() {
        if (this.component.getKind() == 0) {
            return this.activity.getComponentName().getPackageName();
        }
        if (this.component.getKind() == 1) {
            return this.wallpaper.getPackageName();
        }
        if (this.component.getKind() == 2) {
            return this.watchface.getPackageName();
        }
        return "";
    }

    @Override
    public View getResource(int n) {
        return this.activity.findViewById(n);
    }

    @Override
    public Rect getVisibleFrame() {
        Rect rect = new Rect();
        if (this.view != null) {
            this.view.getWindowVisibleDisplayFrame(rect);
        }
        return rect;
    }

    @Override
    public void dispose() {
        this.sketch = null;
        this.graphics = null;
        if (this.activity != null) {
            // empty if block
        }
        if (this.view != null) {
            this.view.destroyDrawingCache();
        }
        if (this.component != null) {
            this.component.dispose();
        }
        if (this.surfaceView != null) {
            this.surfaceView.getHolder().getSurface().release();
        }
    }

    @Override
    public void setRootView(View view) {
        this.view = view;
    }

    @Override
    public SurfaceView getSurfaceView() {
        return this.surfaceView;
    }

    @Override
    public SurfaceHolder getSurfaceHolder() {
        SurfaceView surfaceView = this.getSurfaceView();
        if (surfaceView == null) {
            return null;
        }
        return surfaceView.getHolder();
    }

    @Override
    public void initView(int n, int n2) {
        if (this.component.getKind() == 0) {
            SurfaceView surfaceView;
            int n3 = this.component.getDisplayWidth();
            int n4 = this.component.getDisplayHeight();
            if (n == n3 && n2 == n4) {
                surfaceView = this.getSurfaceView();
            } else {
                RelativeLayout relativeLayout = new RelativeLayout((Context)this.activity);
                RelativeLayout.LayoutParams layoutParams = new RelativeLayout.LayoutParams(-2, -2);
                layoutParams.addRule(13);
                LinearLayout linearLayout = new LinearLayout((Context)this.activity);
                linearLayout.addView((View)this.getSurfaceView(), n, n2);
                relativeLayout.addView((View)linearLayout, (ViewGroup.LayoutParams)layoutParams);
                relativeLayout.setBackgroundColor(this.sketch.sketchWindowColor());
                surfaceView = relativeLayout;
            }
            this.setRootView((View)surfaceView);
        } else if (this.component.getKind() == 1) {
            this.setRootView((View)this.getSurfaceView());
        }
    }

    @Override
    public void initView(int n, int n2, boolean bl, LayoutInflater layoutInflater, ViewGroup viewGroup, Bundle bundle) {
        ViewGroup viewGroup2 = (ViewGroup)layoutInflater.inflate(this.sketch.parentLayout, viewGroup, false);
        SurfaceView surfaceView = this.getSurfaceView();
        if (bl) {
            LinearLayout.LayoutParams layoutParams = new LinearLayout.LayoutParams(-1, -1);
            layoutParams.weight = 1.0f;
            layoutParams.setMargins(0, 0, 0, 0);
            surfaceView.setPadding(0, 0, 0, 0);
            viewGroup2.addView((View)surfaceView, (ViewGroup.LayoutParams)layoutParams);
        } else {
            RelativeLayout relativeLayout = new RelativeLayout((Context)this.activity);
            RelativeLayout.LayoutParams layoutParams = new RelativeLayout.LayoutParams(-2, -2);
            layoutParams.addRule(13);
            relativeLayout.addView((View)surfaceView, n, n2);
            viewGroup2.addView((View)relativeLayout, (ViewGroup.LayoutParams)layoutParams);
        }
        viewGroup2.setBackgroundColor(this.sketch.sketchWindowColor());
        this.setRootView((View)viewGroup2);
    }

    @Override
    public void startActivity(Intent intent) {
        this.component.startActivity(intent);
    }

    @Override
    public void runOnUiThread(Runnable runnable) {
        if (this.component.getKind() == 0) {
            this.activity.runOnUiThread(runnable);
        }
    }

    @Override
    public void setOrientation(int n) {
        if (this.component.getKind() == 0) {
            if (n == 1) {
                this.activity.setRequestedOrientation(1);
            } else if (n == 2) {
                this.activity.setRequestedOrientation(0);
            }
        }
    }

    @Override
    public void setHasOptionsMenu(boolean bl) {
        if (this.component.getKind() == 0) {
            ((PFragment)this.component).setHasOptionsMenu(bl);
        }
    }

    @Override
    public File getFilesDir() {
        if (this.component.getKind() == 0) {
            return this.activity.getFilesDir();
        }
        if (this.component.getKind() == 1) {
            return this.wallpaper.getFilesDir();
        }
        if (this.component.getKind() == 2) {
            return this.watchface.getFilesDir();
        }
        return null;
    }

    @Override
    public File getFileStreamPath(String string) {
        if (this.component.getKind() == 0) {
            return this.activity.getFileStreamPath(string);
        }
        if (this.component.getKind() == 1) {
            return this.wallpaper.getFileStreamPath(string);
        }
        if (this.component.getKind() == 2) {
            return this.watchface.getFileStreamPath(string);
        }
        return null;
    }

    @Override
    public InputStream openFileInput(String string) {
        if (this.component.getKind() == 0) {
            try {
                return this.activity.openFileInput(string);
            }
            catch (FileNotFoundException fileNotFoundException) {
                fileNotFoundException.printStackTrace();
            }
        }
        return null;
    }

    @Override
    public AssetManager getAssets() {
        if (this.component.getKind() == 0) {
            return this.activity.getAssets();
        }
        if (this.component.getKind() == 1) {
            return this.wallpaper.getBaseContext().getAssets();
        }
        if (this.component.getKind() == 2) {
            return this.watchface.getBaseContext().getAssets();
        }
        return null;
    }

    @Override
    public void setSystemUiVisibility(int n) {
        int n2 = this.component.getKind();
        if (n2 == 0 || n2 == 1) {
            this.surfaceView.setSystemUiVisibility(n);
        }
    }

    @Override
    public void finish() {
    }

    public Thread createThread() {
        return new AnimationThread();
    }

    @Override
    public void startThread() {
        if (!this.surfaceReady) {
            this.requestedThreadStart = true;
            return;
        }
        if (this.thread != null) {
            throw new IllegalStateException("Thread already started in " + this.getClass().getSimpleName());
        }
        this.thread = this.createThread();
        this.thread.start();
        this.requestedThreadStart = false;
    }

    @Override
    public void pauseThread() {
        if (!this.surfaceReady) {
            return;
        }
        this.paused = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void resumeThread() {
        if (!this.surfaceReady) {
            return;
        }
        if (this.thread == null) {
            this.thread = this.createThread();
            this.thread.start();
        }
        this.paused = false;
        Object object = this.pauseObject;
        synchronized (object) {
            this.pauseObject.notifyAll();
        }
    }

    @Override
    public boolean stopThread() {
        if (!this.surfaceReady) {
            return true;
        }
        if (this.thread == null) {
            return false;
        }
        this.thread = null;
        return true;
    }

    @Override
    public boolean isStopped() {
        return this.thread == null;
    }

    @Override
    public void setFrameRate(float f) {
        this.frameRateTarget = f;
        this.frameRatePeriod = (long)(1.0E9 / (double)this.frameRateTarget);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void checkPause() {
        Object object = this.pauseObject;
        synchronized (object) {
            while (this.paused) {
                try {
                    this.pauseObject.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    protected void callDraw() {
        this.component.requestDraw();
        if (this.component.canDraw() && this.sketch != null) {
            this.sketch.handleDraw();
        }
    }

    @Override
    public boolean hasPermission(String string) {
        int n = ContextCompat.checkSelfPermission((Context)this.getContext(), (String)string);
        return n == 0;
    }

    @Override
    public void requestPermissions(String[] stringArray) {
        if (this.component.isService()) {
            final ServiceEngine serviceEngine = this.getEngine();
            if (serviceEngine != null) {
                ResultReceiver resultReceiver = new ResultReceiver(new Handler(Looper.getMainLooper())){

                    protected void onReceiveResult(int n, Bundle bundle) {
                        String[] stringArray = bundle.getStringArray("permissions");
                        int[] nArray = bundle.getIntArray("grantResults");
                        serviceEngine.onRequestPermissionsResult(n, stringArray, nArray);
                    }
                };
                Intent intent = new Intent(this.getContext(), PermissionRequestor.class);
                intent.putExtra("resultReceiver", (Parcelable)resultReceiver);
                intent.putExtra("permissions", stringArray);
                intent.putExtra("requestCode", 1);
                intent.addFlags(0x10000000);
                this.startActivity(intent);
            }
        } else if (this.activity != null) {
            ActivityCompat.requestPermissions((Activity)this.activity, (String[])stringArray, (int)1);
        }
    }

    public class AnimationThread
    extends Thread {
        public AnimationThread() {
            super("Animation Thread");
        }

        @Override
        public void run() {
            long l = System.nanoTime();
            long l2 = 0L;
            int n = 0;
            if (PSurfaceNone.this.sketch == null) {
                return;
            }
            PSurfaceNone.this.sketch.start();
            while (Thread.currentThread() == PSurfaceNone.this.thread && PSurfaceNone.this.sketch != null && !PSurfaceNone.this.sketch.finished) {
                PSurfaceNone.this.checkPause();
                PSurfaceNone.this.callDraw();
                long l3 = System.nanoTime();
                long l4 = l3 - l;
                long l5 = PSurfaceNone.this.frameRatePeriod - l4 - l2;
                if (l5 > 0L) {
                    try {
                        Thread.sleep(l5 / 1000000L, (int)(l5 % 1000000L));
                        n = 0;
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    l2 = System.nanoTime() - l3 - l5;
                } else {
                    l2 = 0L;
                    if (++n > 15) {
                        Thread.yield();
                        n = 0;
                    }
                }
                l = System.nanoTime();
            }
            PSurfaceNone.this.finish();
        }
    }
}

