/*
 * Decompiled with CFR 0.152.
 */
package processing.core;

import java.io.BufferedReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import processing.core.PApplet;
import processing.core.PImage;
import processing.core.PShape;
import processing.core.PVector;

public class PShapeOBJ
extends PShape {
    public PShapeOBJ(PApplet pApplet, String string) {
        this(pApplet, pApplet.createReader(string));
    }

    public PShapeOBJ(PApplet pApplet, BufferedReader bufferedReader) {
        ArrayList<OBJFace> arrayList = new ArrayList<OBJFace>();
        ArrayList<OBJMaterial> arrayList2 = new ArrayList<OBJMaterial>();
        ArrayList<PVector> arrayList3 = new ArrayList<PVector>();
        ArrayList<PVector> arrayList4 = new ArrayList<PVector>();
        ArrayList<PVector> arrayList5 = new ArrayList<PVector>();
        PShapeOBJ.parseOBJ(pApplet, bufferedReader, arrayList, arrayList2, arrayList3, arrayList4, arrayList5);
        pApplet = null;
        this.family = 0;
        this.addChildren(arrayList, arrayList2, arrayList3, arrayList4, arrayList5);
    }

    protected PShapeOBJ(OBJFace oBJFace, OBJMaterial oBJMaterial, ArrayList<PVector> arrayList, ArrayList<PVector> arrayList2, ArrayList<PVector> arrayList3) {
        this.family = 3;
        this.kind = oBJFace.vertIdx.size() == 3 ? 9 : (oBJFace.vertIdx.size() == 4 ? 17 : 20);
        this.stroke = false;
        this.fill = true;
        this.fillColor = PShapeOBJ.rgbaValue(oBJMaterial.kd);
        this.ambientColor = PShapeOBJ.rgbaValue(oBJMaterial.ka);
        this.specularColor = PShapeOBJ.rgbaValue(oBJMaterial.ks);
        this.shininess = oBJMaterial.ns;
        if (oBJMaterial.kdMap != null) {
            this.tintColor = PShapeOBJ.rgbaValue(oBJMaterial.kd, oBJMaterial.d);
        }
        this.vertexCount = oBJFace.vertIdx.size();
        this.vertices = new float[this.vertexCount][12];
        for (int i = 0; i < oBJFace.vertIdx.size(); ++i) {
            int n;
            int n2;
            PVector pVector = null;
            PVector pVector2 = null;
            PVector pVector3 = null;
            int n3 = oBJFace.vertIdx.get(i) - 1;
            pVector3 = arrayList.get(n3);
            if (i < oBJFace.normIdx.size() && -1 < (n2 = oBJFace.normIdx.get(i) - 1)) {
                pVector2 = arrayList2.get(n2);
            }
            if (i < oBJFace.texIdx.size() && -1 < (n = oBJFace.texIdx.get(i) - 1)) {
                pVector = arrayList3.get(n);
            }
            this.vertices[i][0] = pVector3.x;
            this.vertices[i][1] = pVector3.y;
            this.vertices[i][2] = pVector3.z;
            this.vertices[i][3] = oBJMaterial.kd.x;
            this.vertices[i][4] = oBJMaterial.kd.y;
            this.vertices[i][5] = oBJMaterial.kd.z;
            this.vertices[i][6] = 1.0f;
            if (pVector2 != null) {
                this.vertices[i][9] = pVector2.x;
                this.vertices[i][10] = pVector2.y;
                this.vertices[i][11] = pVector2.z;
            }
            if (pVector != null) {
                this.vertices[i][7] = pVector.x;
                this.vertices[i][8] = pVector.y;
            }
            if (oBJMaterial == null || oBJMaterial.kdMap == null) continue;
            this.image = oBJMaterial.kdMap;
        }
    }

    protected void addChildren(ArrayList<OBJFace> arrayList, ArrayList<OBJMaterial> arrayList2, ArrayList<PVector> arrayList3, ArrayList<PVector> arrayList4, ArrayList<PVector> arrayList5) {
        int n = -1;
        OBJMaterial oBJMaterial = null;
        for (int i = 0; i < arrayList.size(); ++i) {
            OBJFace oBJFace = arrayList.get(i);
            if (n != oBJFace.matIdx || oBJFace.matIdx == -1) {
                n = PApplet.max(0, oBJFace.matIdx);
                oBJMaterial = arrayList2.get(n);
            }
            PShapeOBJ pShapeOBJ = new PShapeOBJ(oBJFace, oBJMaterial, arrayList3, arrayList4, arrayList5);
            this.addChild(pShapeOBJ);
        }
    }

    protected static void parseOBJ(PApplet pApplet, BufferedReader bufferedReader, ArrayList<OBJFace> arrayList, ArrayList<OBJMaterial> arrayList2, ArrayList<PVector> arrayList3, ArrayList<PVector> arrayList4, ArrayList<PVector> arrayList5) {
        HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
        int n = -1;
        try {
            Object object;
            String string;
            boolean bl = false;
            boolean bl2 = false;
            boolean bl3 = false;
            String string2 = "object";
            while ((string = bufferedReader.readLine()) != null) {
                Object object2;
                if ((string = string.trim()).equals("") || string.indexOf(35) == 0) continue;
                while (string.contains("\\")) {
                    string = string.split("\\\\")[0];
                    object = bufferedReader.readLine();
                    if (object == null) continue;
                    string = string + (String)object;
                }
                object = string.split("\\s+");
                if (((String[])object).length <= 0) continue;
                if (object[0].equals("v")) {
                    object2 = new PVector(Float.valueOf(object[1]).floatValue(), Float.valueOf(object[2]).floatValue(), Float.valueOf(object[3]).floatValue());
                    arrayList3.add((PVector)object2);
                    bl3 = true;
                    continue;
                }
                if (object[0].equals("vn")) {
                    object2 = new PVector(Float.valueOf(object[1]).floatValue(), Float.valueOf(object[2]).floatValue(), Float.valueOf(object[3]).floatValue());
                    arrayList4.add((PVector)object2);
                    bl2 = true;
                    continue;
                }
                if (object[0].equals("vt")) {
                    object2 = new PVector(Float.valueOf(object[1]).floatValue(), 1.0f - Float.valueOf(object[2]).floatValue());
                    arrayList5.add((PVector)object2);
                    bl = true;
                    continue;
                }
                if (object[0].equals("o")) continue;
                if (object[0].equals("mtllib")) {
                    BufferedReader bufferedReader2;
                    if (object[1] == null || (bufferedReader2 = pApplet.createReader((String)(object2 = object[1]))) == null) continue;
                    PShapeOBJ.parseMTL(pApplet, (String)object2, bufferedReader2, arrayList2, hashMap);
                    bufferedReader2.close();
                    continue;
                }
                if (object[0].equals("g")) {
                    string2 = 1 < ((String[])object).length ? object[1] : "";
                    continue;
                }
                if (object[0].equals("usemtl")) {
                    if (object[1] == null) continue;
                    object2 = object[1];
                    if (hashMap.containsKey(object2)) {
                        Integer n2 = (Integer)hashMap.get(object2);
                        n = n2;
                        continue;
                    }
                    n = -1;
                    continue;
                }
                if (!object[0].equals("f")) continue;
                object2 = new OBJFace();
                ((OBJFace)object2).matIdx = n;
                ((OBJFace)object2).name = string2;
                for (int i = 1; i < ((String[])object).length; ++i) {
                    String string3 = object[i];
                    if (string3.indexOf("/") > 0) {
                        String[] stringArray = string3.split("/");
                        if (stringArray.length > 2) {
                            if (stringArray[0].length() > 0 && bl3) {
                                ((OBJFace)object2).vertIdx.add(Integer.valueOf(stringArray[0]));
                            }
                            if (stringArray[1].length() > 0 && bl) {
                                ((OBJFace)object2).texIdx.add(Integer.valueOf(stringArray[1]));
                            }
                            if (stringArray[2].length() <= 0 || !bl2) continue;
                            ((OBJFace)object2).normIdx.add(Integer.valueOf(stringArray[2]));
                            continue;
                        }
                        if (stringArray.length > 1) {
                            if (stringArray[0].length() > 0 && bl3) {
                                ((OBJFace)object2).vertIdx.add(Integer.valueOf(stringArray[0]));
                            }
                            if (stringArray[1].length() <= 0) continue;
                            if (bl) {
                                ((OBJFace)object2).texIdx.add(Integer.valueOf(stringArray[1]));
                                continue;
                            }
                            if (!bl2) continue;
                            ((OBJFace)object2).normIdx.add(Integer.valueOf(stringArray[1]));
                            continue;
                        }
                        if (stringArray.length <= 0 || stringArray[0].length() <= 0 || !bl3) continue;
                        ((OBJFace)object2).vertIdx.add(Integer.valueOf(stringArray[0]));
                        continue;
                    }
                    if (string3.length() <= 0 || !bl3) continue;
                    ((OBJFace)object2).vertIdx.add(Integer.valueOf(string3));
                }
                arrayList.add((OBJFace)object2);
            }
            if (arrayList2.size() == 0) {
                object = new OBJMaterial();
                arrayList2.add((OBJMaterial)object);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    protected static void parseMTL(PApplet pApplet, String string, BufferedReader bufferedReader, ArrayList<OBJMaterial> arrayList, Map<String, Integer> map) {
        try {
            String string2;
            OBJMaterial oBJMaterial = null;
            while ((string2 = bufferedReader.readLine()) != null) {
                String string3;
                String[] stringArray = (string2 = string2.trim()).split("\\s+");
                if (stringArray.length <= 0) continue;
                if (stringArray[0].equals("newmtl")) {
                    string3 = stringArray[1];
                    oBJMaterial = PShapeOBJ.addMaterial(string3, arrayList, map);
                    continue;
                }
                if (oBJMaterial == null) {
                    oBJMaterial = PShapeOBJ.addMaterial("material" + arrayList.size(), arrayList, map);
                }
                if (stringArray[0].equals("map_Kd") && stringArray.length > 1) {
                    string3 = stringArray[1];
                    oBJMaterial.kdMap = pApplet.loadImage(string3);
                    if (oBJMaterial.kdMap != null) continue;
                    System.err.println("The texture map \"" + string3 + "\" in the materials definition file \"" + string + "\" is missing or inaccessible, make sure the URL is valid or that the file has been added to your sketch and is readable.");
                    continue;
                }
                if (stringArray[0].equals("Ka") && stringArray.length > 3) {
                    oBJMaterial.ka.x = Float.valueOf(stringArray[1]).floatValue();
                    oBJMaterial.ka.y = Float.valueOf(stringArray[2]).floatValue();
                    oBJMaterial.ka.z = Float.valueOf(stringArray[3]).floatValue();
                    continue;
                }
                if (stringArray[0].equals("Kd") && stringArray.length > 3) {
                    oBJMaterial.kd.x = Float.valueOf(stringArray[1]).floatValue();
                    oBJMaterial.kd.y = Float.valueOf(stringArray[2]).floatValue();
                    oBJMaterial.kd.z = Float.valueOf(stringArray[3]).floatValue();
                    continue;
                }
                if (stringArray[0].equals("Ks") && stringArray.length > 3) {
                    oBJMaterial.ks.x = Float.valueOf(stringArray[1]).floatValue();
                    oBJMaterial.ks.y = Float.valueOf(stringArray[2]).floatValue();
                    oBJMaterial.ks.z = Float.valueOf(stringArray[3]).floatValue();
                    continue;
                }
                if ((stringArray[0].equals("d") || stringArray[0].equals("Tr")) && stringArray.length > 1) {
                    oBJMaterial.d = Float.valueOf(stringArray[1]).floatValue();
                    continue;
                }
                if (!stringArray[0].equals("Ns") || stringArray.length <= 1) continue;
                oBJMaterial.ns = Float.valueOf(stringArray[1]).floatValue();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    protected static OBJMaterial addMaterial(String string, ArrayList<OBJMaterial> arrayList, Map<String, Integer> map) {
        OBJMaterial oBJMaterial = new OBJMaterial(string);
        map.put(string, arrayList.size());
        arrayList.add(oBJMaterial);
        return oBJMaterial;
    }

    protected static int rgbaValue(PVector pVector) {
        return 0xFF000000 | (int)(pVector.x * 255.0f) << 16 | (int)(pVector.y * 255.0f) << 8 | (int)(pVector.z * 255.0f);
    }

    protected static int rgbaValue(PVector pVector, float f) {
        return (int)(f * 255.0f) << 24 | (int)(pVector.x * 255.0f) << 16 | (int)(pVector.y * 255.0f) << 8 | (int)(pVector.z * 255.0f);
    }

    protected static class OBJMaterial {
        String name;
        PVector ka;
        PVector kd;
        PVector ks;
        float d;
        float ns;
        PImage kdMap;

        OBJMaterial() {
            this("default");
        }

        OBJMaterial(String string) {
            this.name = string;
            this.ka = new PVector(0.5f, 0.5f, 0.5f);
            this.kd = new PVector(0.5f, 0.5f, 0.5f);
            this.ks = new PVector(0.5f, 0.5f, 0.5f);
            this.d = 1.0f;
            this.ns = 0.0f;
            this.kdMap = null;
        }
    }

    protected static class OBJFace {
        ArrayList<Integer> vertIdx = new ArrayList();
        ArrayList<Integer> texIdx = new ArrayList();
        ArrayList<Integer> normIdx = new ArrayList();
        int matIdx = -1;
        String name = "";

        OBJFace() {
        }
    }
}

