/*
 * Decompiled with CFR 0.152.
 */
package processing.android;

import android.annotation.TargetApi;
import android.app.Service;
import android.graphics.Point;
import android.graphics.Rect;
import android.opengl.EGL14;
import android.opengl.EGLConfig;
import android.opengl.EGLDisplay;
import android.os.Bundle;
import android.support.wearable.complications.ComplicationData;
import android.support.wearable.watchface.Gles2WatchFaceService;
import android.support.wearable.watchface.WatchFaceStyle;
import android.util.DisplayMetrics;
import android.view.Display;
import android.view.MotionEvent;
import android.view.SurfaceHolder;
import android.view.WindowInsets;
import android.view.WindowManager;
import java.lang.reflect.Method;
import processing.android.AppComponent;
import processing.android.CompatUtils;
import processing.android.ServiceEngine;
import processing.core.PApplet;

@TargetApi(value=21)
public class PWatchFaceGLES
extends Gles2WatchFaceService
implements AppComponent {
    private static final int[] CONFIG_ATTRIB_LIST = new int[]{12352, 4, 12324, 8, 12323, 8, 12322, 8, 12321, 8, 12325, 16, 12344};
    private Point size;
    private DisplayMetrics metrics;
    private GLES2Engine engine;

    @Override
    public void initDimensions() {
        this.metrics = new DisplayMetrics();
        this.size = new Point();
        WindowManager windowManager = (WindowManager)this.getSystemService("window");
        Display display = windowManager.getDefaultDisplay();
        CompatUtils.getDisplayParams(display, this.metrics, this.size);
    }

    @Override
    public int getDisplayWidth() {
        return this.size.x;
    }

    @Override
    public int getDisplayHeight() {
        return this.size.y;
    }

    @Override
    public float getDisplayDensity() {
        return this.metrics.density;
    }

    @Override
    public int getKind() {
        return 2;
    }

    public PApplet createSketch() {
        return new PApplet();
    }

    @Override
    public void setSketch(PApplet pApplet) {
        this.engine.sketch = pApplet;
    }

    @Override
    public PApplet getSketch() {
        return this.engine.sketch;
    }

    @Override
    public boolean isService() {
        return true;
    }

    @Override
    public ServiceEngine getEngine() {
        return this.engine;
    }

    @Override
    public void requestDraw() {
        if (this.engine != null) {
            this.engine.invalidateIfNecessary();
        }
    }

    @Override
    public boolean canDraw() {
        return false;
    }

    @Override
    public void dispose() {
    }

    public void requestPermissions() {
    }

    public Gles2WatchFaceService.Engine onCreateEngine() {
        this.engine = new GLES2Engine();
        return this.engine;
    }

    public void onDestroy() {
        super.onDestroy();
        if (this.engine != null) {
            this.engine.onDestroy();
        }
    }

    private class GLES2Engine
    extends Gles2WatchFaceService.Engine
    implements ServiceEngine {
        private PApplet sketch;
        private Method compUpdatedMethod;
        private Method tapCommandMethod;
        private boolean isRound;
        private Rect insets;
        private boolean lowBitAmbient;
        private boolean burnInProtection;

        private GLES2Engine() {
            super((Gles2WatchFaceService)PWatchFaceGLES.this);
            this.isRound = false;
            this.insets = new Rect();
            this.lowBitAmbient = false;
            this.burnInProtection = false;
        }

        public void onCreate(SurfaceHolder surfaceHolder) {
            super.onCreate(surfaceHolder);
            this.setWatchFaceStyle(new WatchFaceStyle.Builder((Service)PWatchFaceGLES.this).setAcceptsTapEvents(true).build());
            this.sketch = PWatchFaceGLES.this.createSketch();
            this.sketch.initSurface(PWatchFaceGLES.this, null);
            this.initTapEvents();
            this.initComplications();
            PWatchFaceGLES.this.requestPermissions();
        }

        public EGLConfig chooseEglConfig(EGLDisplay eGLDisplay) {
            int[] nArray = new int[1];
            EGLConfig[] eGLConfigArray = new EGLConfig[1];
            if (!EGL14.eglChooseConfig((EGLDisplay)eGLDisplay, (int[])CONFIG_ATTRIB_LIST, (int)0, (EGLConfig[])eGLConfigArray, (int)0, (int)eGLConfigArray.length, (int[])nArray, (int)0)) {
                throw new RuntimeException("eglChooseConfig failed");
            }
            if (nArray[0] == 0) {
                throw new RuntimeException("no matching EGL configs");
            }
            return eGLConfigArray[0];
        }

        public void onGlContextCreated() {
            super.onGlContextCreated();
        }

        public void onGlSurfaceCreated(int n, int n2) {
            super.onGlSurfaceCreated(n, n2);
            if (this.sketch != null) {
                this.sketch.displayWidth = n;
                this.sketch.displayHeight = n2;
                this.sketch.g.setSize(this.sketch.sketchWidth(), this.sketch.sketchHeight());
                this.sketch.surfaceChanged();
            }
        }

        private void initTapEvents() {
            try {
                this.tapCommandMethod = this.sketch.getClass().getMethod("onTapCommand", Integer.TYPE, Integer.TYPE, Integer.TYPE, Long.TYPE);
            }
            catch (Exception exception) {
                this.tapCommandMethod = null;
            }
        }

        private void initComplications() {
            try {
                this.compUpdatedMethod = this.sketch.getClass().getMethod("onComplicationDataUpdate", Integer.TYPE, ComplicationData.class);
            }
            catch (Exception exception) {
                this.compUpdatedMethod = null;
            }
        }

        private void invalidateIfNecessary() {
            if (this.isVisible() && !this.isInAmbientMode()) {
                this.invalidate();
            }
        }

        public void onAmbientModeChanged(boolean bl) {
            super.onAmbientModeChanged(bl);
            this.invalidateIfNecessary();
        }

        public void onPropertiesChanged(Bundle bundle) {
            super.onPropertiesChanged(bundle);
            this.lowBitAmbient = bundle.getBoolean("low_bit_ambient", false);
            this.burnInProtection = bundle.getBoolean("burn_in_protection", false);
        }

        public void onApplyWindowInsets(WindowInsets windowInsets) {
            super.onApplyWindowInsets(windowInsets);
            this.insets.set(windowInsets.getSystemWindowInsetLeft(), windowInsets.getSystemWindowInsetTop(), windowInsets.getSystemWindowInsetRight(), windowInsets.getSystemWindowInsetBottom());
        }

        public void onVisibilityChanged(boolean bl) {
            super.onVisibilityChanged(bl);
            if (this.sketch != null) {
                if (bl) {
                    this.sketch.onResume();
                } else {
                    this.sketch.onPause();
                }
            }
        }

        public void onPeekCardPositionUpdate(Rect rect) {
        }

        public void onTimeTick() {
            this.invalidate();
        }

        public void onDraw() {
            super.onDraw();
            if (this.sketch != null) {
                this.sketch.handleDraw();
            }
        }

        public void onTouchEvent(MotionEvent motionEvent) {
            super.onTouchEvent(motionEvent);
            if (this.sketch != null) {
                this.sketch.surfaceTouchEvent(motionEvent);
            }
        }

        public void onTapCommand(int n, int n2, int n3, long l) {
            if (this.tapCommandMethod != null) {
                try {
                    this.tapCommandMethod.invoke((Object)n, n2, n3, l);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.invalidate();
            }
        }

        public void onComplicationDataUpdate(int n, ComplicationData complicationData) {
            if (this.compUpdatedMethod != null) {
                try {
                    this.compUpdatedMethod.invoke((Object)n, complicationData);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.invalidate();
            }
        }

        public void onDestroy() {
            super.onDestroy();
            if (this.sketch != null) {
                this.sketch.onDestroy();
            }
        }

        @Override
        public float getXOffset() {
            return 0.0f;
        }

        @Override
        public float getYOffset() {
            return 0.0f;
        }

        @Override
        public float getXOffsetStep() {
            return 0.0f;
        }

        @Override
        public float getYOffsetStep() {
            return 0.0f;
        }

        @Override
        public int getXPixelOffset() {
            return 0;
        }

        @Override
        public int getYPixelOffset() {
            return 0;
        }

        @Override
        public boolean isRound() {
            return this.isRound;
        }

        @Override
        public Rect getInsets() {
            return this.insets;
        }

        @Override
        public boolean useLowBitAmbient() {
            return this.lowBitAmbient;
        }

        @Override
        public boolean requireBurnInProtection() {
            return this.burnInProtection;
        }

        @Override
        public void onRequestPermissionsResult(int n, String[] stringArray, int[] nArray) {
            if (this.sketch != null) {
                this.sketch.onRequestPermissionsResult(n, stringArray, nArray);
            }
        }
    }
}

