/*
 * Decompiled with CFR 0.152.
 */
package processing.android;

import android.graphics.Point;
import android.graphics.Rect;
import android.service.wallpaper.WallpaperService;
import android.util.DisplayMetrics;
import android.view.Display;
import android.view.MotionEvent;
import android.view.SurfaceHolder;
import android.view.WindowManager;
import processing.android.AppComponent;
import processing.android.CompatUtils;
import processing.android.ServiceEngine;
import processing.core.PApplet;

public class PWallpaper
extends WallpaperService
implements AppComponent {
    private Point size;
    private DisplayMetrics metrics;
    private WallpaperEngine engine;

    @Override
    public void initDimensions() {
        this.metrics = new DisplayMetrics();
        this.size = new Point();
        WindowManager windowManager = (WindowManager)this.getSystemService("window");
        Display display = windowManager.getDefaultDisplay();
        CompatUtils.getDisplayParams(display, this.metrics, this.size);
    }

    @Override
    public int getDisplayWidth() {
        return this.size.x;
    }

    @Override
    public int getDisplayHeight() {
        return this.size.y;
    }

    @Override
    public float getDisplayDensity() {
        return this.metrics.density;
    }

    @Override
    public int getKind() {
        return 1;
    }

    public PApplet createSketch() {
        return new PApplet();
    }

    @Override
    public void setSketch(PApplet pApplet) {
        this.engine.sketch = pApplet;
    }

    @Override
    public PApplet getSketch() {
        return this.engine.sketch;
    }

    @Override
    public boolean isService() {
        return true;
    }

    @Override
    public ServiceEngine getEngine() {
        return this.engine;
    }

    @Override
    public void requestDraw() {
    }

    @Override
    public boolean canDraw() {
        return true;
    }

    @Override
    public void dispose() {
    }

    public void requestPermissions() {
    }

    public WallpaperService.Engine onCreateEngine() {
        this.engine = new WallpaperEngine();
        return this.engine;
    }

    public void onDestroy() {
        super.onDestroy();
        if (this.engine != null) {
            this.engine.onDestroy();
        }
    }

    public class WallpaperEngine
    extends WallpaperService.Engine
    implements ServiceEngine {
        private PApplet sketch;
        private float xOffset;
        private float xOffsetStep;
        private float yOffset;
        private float yOffsetStep;
        private int xPixelOffset;
        private int yPixelOffset;

        public WallpaperEngine() {
            super((WallpaperService)PWallpaper.this);
        }

        public void onCreate(SurfaceHolder surfaceHolder) {
            super.onCreate(surfaceHolder);
            this.sketch = PWallpaper.this.createSketch();
            this.sketch.initSurface(PWallpaper.this, this.getSurfaceHolder());
            if (this.isPreview()) {
                PWallpaper.this.requestPermissions();
            }
            this.setTouchEventsEnabled(true);
        }

        public void onSurfaceCreated(SurfaceHolder surfaceHolder) {
            super.onSurfaceCreated(surfaceHolder);
        }

        public void onSurfaceChanged(SurfaceHolder surfaceHolder, int n, int n2, int n3) {
            if (this.sketch != null) {
                this.sketch.g.setSize(n2, n3);
            }
            super.onSurfaceChanged(surfaceHolder, n, n2, n3);
        }

        public void onVisibilityChanged(boolean bl) {
            if (this.sketch != null) {
                if (bl) {
                    this.sketch.onResume();
                } else {
                    this.sketch.onPause();
                }
            }
            super.onVisibilityChanged(bl);
        }

        public void onTouchEvent(MotionEvent motionEvent) {
            super.onTouchEvent(motionEvent);
            if (this.sketch != null) {
                this.sketch.surfaceTouchEvent(motionEvent);
            }
        }

        public void onOffsetsChanged(float f, float f2, float f3, float f4, int n, int n2) {
            if (this.sketch != null) {
                this.xOffset = f;
                this.yOffset = f2;
                this.xOffsetStep = f3;
                this.yOffsetStep = f4;
                this.xPixelOffset = n;
                this.yPixelOffset = n2;
            }
        }

        public void onSurfaceDestroyed(SurfaceHolder surfaceHolder) {
            super.onSurfaceDestroyed(surfaceHolder);
        }

        public void onDestroy() {
            super.onDestroy();
            if (this.sketch != null) {
                this.sketch.onDestroy();
            }
        }

        @Override
        public float getXOffset() {
            return this.xOffset;
        }

        @Override
        public float getYOffset() {
            return this.yOffset;
        }

        @Override
        public float getXOffsetStep() {
            return this.xOffsetStep;
        }

        @Override
        public float getYOffsetStep() {
            return this.yOffsetStep;
        }

        @Override
        public int getXPixelOffset() {
            return this.xPixelOffset;
        }

        @Override
        public int getYPixelOffset() {
            return this.yPixelOffset;
        }

        @Override
        public boolean isInAmbientMode() {
            return false;
        }

        @Override
        public boolean isRound() {
            return false;
        }

        @Override
        public Rect getInsets() {
            return null;
        }

        @Override
        public boolean useLowBitAmbient() {
            return false;
        }

        @Override
        public boolean requireBurnInProtection() {
            return false;
        }

        @Override
        public void onRequestPermissionsResult(int n, String[] stringArray, int[] nArray) {
            if (this.sketch != null) {
                this.sketch.onRequestPermissionsResult(n, stringArray, nArray);
            }
        }
    }
}

