/*
 * Decompiled with CFR 0.152.
 */
package processing.android;

import android.content.Intent;
import android.content.res.Configuration;
import android.graphics.Point;
import android.os.Bundle;
import android.support.annotation.IdRes;
import android.support.annotation.LayoutRes;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentActivity;
import android.support.v4.app.FragmentManager;
import android.support.v4.app.FragmentTransaction;
import android.util.DisplayMetrics;
import android.view.ContextMenu;
import android.view.Display;
import android.view.LayoutInflater;
import android.view.Menu;
import android.view.MenuInflater;
import android.view.MenuItem;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import processing.android.AppComponent;
import processing.android.CompatUtils;
import processing.android.ServiceEngine;
import processing.core.PApplet;

public class PFragment
extends Fragment
implements AppComponent {
    private DisplayMetrics metrics;
    private Point size;
    private PApplet sketch;
    @LayoutRes
    private int layout = -1;

    public PFragment() {
    }

    public PFragment(PApplet pApplet) {
        this.setSketch(pApplet);
    }

    @Override
    public void initDimensions() {
        this.metrics = new DisplayMetrics();
        this.size = new Point();
        WindowManager windowManager = this.getActivity().getWindowManager();
        Display display = windowManager.getDefaultDisplay();
        CompatUtils.getDisplayParams(display, this.metrics, this.size);
    }

    @Override
    public int getDisplayWidth() {
        return this.size.x;
    }

    @Override
    public int getDisplayHeight() {
        return this.size.y;
    }

    @Override
    public float getDisplayDensity() {
        return this.metrics.density;
    }

    @Override
    public int getKind() {
        return 0;
    }

    @Override
    public void setSketch(PApplet pApplet) {
        this.sketch = pApplet;
        if (this.layout != -1) {
            pApplet.parentLayout = this.layout;
        }
    }

    @Override
    public PApplet getSketch() {
        return this.sketch;
    }

    public void setLayout(@LayoutRes int n, @IdRes int n2, FragmentActivity fragmentActivity) {
        this.layout = n;
        if (this.sketch != null) {
            this.sketch.parentLayout = n;
        }
        FragmentManager fragmentManager = fragmentActivity.getSupportFragmentManager();
        FragmentTransaction fragmentTransaction = fragmentManager.beginTransaction();
        fragmentTransaction.add(n2, (Fragment)this);
        fragmentTransaction.commit();
    }

    public void setView(View view, FragmentActivity fragmentActivity) {
        FragmentManager fragmentManager = fragmentActivity.getSupportFragmentManager();
        FragmentTransaction fragmentTransaction = fragmentManager.beginTransaction();
        fragmentTransaction.add(view.getId(), (Fragment)this);
        fragmentTransaction.commit();
    }

    @Override
    public boolean isService() {
        return false;
    }

    @Override
    public ServiceEngine getEngine() {
        return null;
    }

    @Override
    public void dispose() {
    }

    public View onCreateView(LayoutInflater layoutInflater, ViewGroup viewGroup, Bundle bundle) {
        if (this.sketch != null) {
            this.sketch.initSurface(layoutInflater, viewGroup, bundle, this, null);
            this.sketch.onCreate(bundle);
            return this.sketch.getSurface().getRootView();
        }
        return null;
    }

    public void onStart() {
        super.onStart();
        if (this.sketch != null) {
            this.sketch.onStart();
        }
    }

    public void onResume() {
        super.onResume();
        if (this.sketch != null) {
            this.sketch.onResume();
        }
    }

    public void onPause() {
        super.onPause();
        if (this.sketch != null) {
            this.sketch.onPause();
        }
    }

    public void onStop() {
        super.onStop();
        if (this.sketch != null) {
            this.sketch.onStop();
        }
    }

    public void onDestroy() {
        super.onDestroy();
        if (this.sketch != null) {
            this.sketch.onDestroy();
        }
    }

    public void onActivityResult(int n, int n2, Intent intent) {
        if (this.sketch != null) {
            this.sketch.onActivityResult(n, n2, intent);
        }
    }

    public void onCreateOptionsMenu(Menu menu, MenuInflater menuInflater) {
        if (this.sketch != null) {
            this.sketch.onCreateOptionsMenu(menu, menuInflater);
        }
    }

    public boolean onOptionsItemSelected(MenuItem menuItem) {
        if (this.sketch != null) {
            return this.sketch.onOptionsItemSelected(menuItem);
        }
        return super.onOptionsItemSelected(menuItem);
    }

    public void onCreateContextMenu(ContextMenu contextMenu, View view, ContextMenu.ContextMenuInfo contextMenuInfo) {
        if (this.sketch != null) {
            this.sketch.onCreateContextMenu(contextMenu, view, contextMenuInfo);
        }
    }

    public boolean onContextItemSelected(MenuItem menuItem) {
        if (this.sketch != null) {
            return this.sketch.onContextItemSelected(menuItem);
        }
        return super.onContextItemSelected(menuItem);
    }

    public void onConfigurationChanged(Configuration configuration) {
        super.onConfigurationChanged(configuration);
    }

    public void setOrientation(int n) {
        if (n == 1) {
            this.getActivity().setRequestedOrientation(1);
        } else if (n == 2) {
            this.getActivity().setRequestedOrientation(0);
        }
    }

    @Override
    public void requestDraw() {
    }

    @Override
    public boolean canDraw() {
        if (this.sketch == null) {
            return false;
        }
        return this.sketch.isLooping();
    }
}

