/*
 * Decompiled with CFR 0.152.
 */
package processing.android;

import android.annotation.SuppressLint;
import android.graphics.Point;
import android.os.Build;
import android.util.DisplayMetrics;
import android.view.Display;
import android.view.View;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.atomic.AtomicInteger;

public class CompatUtils {
    private static final AtomicInteger nextId = new AtomicInteger(15000000);

    public static void getDisplayParams(Display display, DisplayMetrics displayMetrics, Point point) {
        if (17 <= Build.VERSION.SDK_INT) {
            display.getRealMetrics(displayMetrics);
            display.getRealSize(point);
        }
        if (14 <= Build.VERSION.SDK_INT) {
            display.getMetrics(displayMetrics);
            try {
                point.x = (Integer)Display.class.getMethod("getRawWidth", new Class[0]).invoke((Object)display, new Object[0]);
                point.y = (Integer)Display.class.getMethod("getRawHeight", new Class[0]).invoke((Object)display, new Object[0]);
            }
            catch (Exception exception) {
                display.getSize(point);
            }
        } else {
            display.getMetrics(displayMetrics);
            display.getSize(point);
        }
    }

    @SuppressLint(value={"NewApi"})
    public static int getUniqueViewId() {
        int n;
        int n2;
        if (17 <= Build.VERSION.SDK_INT) {
            return View.generateViewId();
        }
        do {
            if ((n = (n2 = nextId.get()) + 1) <= 0xFFFFFF) continue;
            n = 1;
        } while (!nextId.compareAndSet(n2, n));
        return n2;
    }

    @SuppressLint(value={"NewApi"})
    public static Charset getCharsetUTF8() {
        if (19 <= Build.VERSION.SDK_INT) {
            return StandardCharsets.UTF_8;
        }
        return Charset.forName("UTF-8");
    }
}

