/*
 * Decompiled with CFR 0.152.
 */
package processing.a2d;

import android.graphics.LinearGradient;
import android.graphics.RadialGradient;
import android.graphics.Shader;
import processing.a2d.PGraphicsAndroid2D;
import processing.core.PGraphics;
import processing.core.PShapeSVG;
import processing.data.XML;

public class PShapeAndroid2D
extends PShapeSVG {
    protected Shader strokeGradientPaint;
    protected Shader fillGradientPaint;

    public PShapeAndroid2D(XML xML) {
        super(xML);
    }

    public PShapeAndroid2D(PShapeSVG pShapeSVG, XML xML, boolean bl) {
        super(pShapeSVG, xML, bl);
    }

    @Override
    protected void setParent(PShapeSVG pShapeSVG) {
        super.setParent(pShapeSVG);
        if (pShapeSVG instanceof PShapeAndroid2D) {
            PShapeAndroid2D pShapeAndroid2D = (PShapeAndroid2D)pShapeSVG;
            this.fillGradientPaint = pShapeAndroid2D.fillGradientPaint;
            this.strokeGradientPaint = pShapeAndroid2D.strokeGradientPaint;
        } else {
            this.fillGradientPaint = null;
            this.strokeGradientPaint = null;
        }
    }

    @Override
    protected PShapeSVG createShape(PShapeSVG pShapeSVG, XML xML, boolean bl) {
        return new PShapeAndroid2D(pShapeSVG, xML, bl);
    }

    protected Shader calcGradientPaint(PShapeSVG.Gradient gradient) {
        int[] nArray = new int[gradient.count];
        int n = (int)(this.opacity * 255.0f) << 24;
        for (int i = 0; i < gradient.count; ++i) {
            nArray[i] = n | gradient.color[i] & 0xFFFFFF;
        }
        if (gradient instanceof PShapeSVG.LinearGradient) {
            PShapeSVG.LinearGradient linearGradient = (PShapeSVG.LinearGradient)gradient;
            return new LinearGradient(linearGradient.x1, linearGradient.y1, linearGradient.x2, linearGradient.y2, nArray, linearGradient.offset, Shader.TileMode.CLAMP);
        }
        if (gradient instanceof PShapeSVG.RadialGradient) {
            PShapeSVG.RadialGradient radialGradient = (PShapeSVG.RadialGradient)gradient;
            return new RadialGradient(radialGradient.cx, radialGradient.cy, radialGradient.r, nArray, radialGradient.offset, Shader.TileMode.CLAMP);
        }
        return null;
    }

    @Override
    protected void styles(PGraphics pGraphics) {
        super.styles(pGraphics);
        if (pGraphics instanceof PGraphicsAndroid2D) {
            PGraphicsAndroid2D pGraphicsAndroid2D = (PGraphicsAndroid2D)pGraphics;
            if (this.strokeGradient != null) {
                if (this.strokeGradientPaint == null) {
                    this.strokeGradientPaint = this.calcGradientPaint(this.strokeGradient);
                }
                pGraphicsAndroid2D.strokePaint.setShader(this.strokeGradientPaint);
            }
            if (this.fillGradient != null) {
                if (this.fillGradientPaint == null) {
                    this.fillGradientPaint = this.calcGradientPaint(this.fillGradient);
                }
                pGraphicsAndroid2D.fillPaint.setShader(this.fillGradientPaint);
            }
        }
    }
}

