/*
 * Decompiled with CFR 0.152.
 */
package processing.app.ui;

import java.awt.EventQueue;
import java.awt.Frame;
import java.io.File;
import java.io.IOException;
import processing.app.Base;
import processing.app.Language;
import processing.app.Platform;
import processing.app.Preferences;
import processing.app.ui.WebFrame;
import processing.core.PApplet;
import processing.data.StringDict;

public class Welcome
extends WebFrame {
    Base base;

    public Welcome(Base base, boolean sketchbook) throws IOException {
        super(Welcome.getIndexFile(sketchbook), 400);
        this.base = base;
        this.setVisible(true);
    }

    @Override
    public void handleSubmit(StringDict dict) {
        String sketchbookAction = dict.get("sketchbook", null);
        if ("create_new".equals(sketchbookAction)) {
            File folder = new File(Preferences.getSketchbookPath()).getParentFile();
            PApplet.selectFolder((String)Language.text("preferences.sketchbook_location.popup"), (String)"sketchbookCallback", (File)folder, (Object)this, (Frame)this);
        }
        boolean keepShowing = "on".equals(dict.get("show_each_time", null));
        Preferences.setBoolean("welcome.show", keepShowing);
        Preferences.save();
        this.handleClose();
    }

    public void sketchbookCallback(File folder) {
        if (folder != null) {
            if (this.base != null) {
                this.base.setSketchbookFolder(folder);
            } else {
                System.out.println("user selected " + folder);
            }
        }
    }

    @Override
    public void handleClose() {
        this.dispose();
    }

    private static File getIndexFile(boolean sketchbook) {
        String filename = "welcome/" + (sketchbook ? "sketchbook.html" : "generic.html");
        File htmlFile = new File("../build/shared/lib/" + filename);
        if (htmlFile.exists()) {
            return htmlFile;
        }
        htmlFile = Platform.getContentFile("../../../../../shared/lib/" + filename);
        if (htmlFile.exists()) {
            return htmlFile;
        }
        try {
            return Base.getLibFile(filename);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static void main(String[] args) {
        Platform.init();
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    new Welcome(null, true){

                        @Override
                        public void handleClose() {
                            System.exit(0);
                        }
                    };
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        });
    }
}

