/*
 * Decompiled with CFR 0.152.
 */
package processing.app.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.DisplayMode;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.ListCellRenderer;
import javax.swing.border.CompoundBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import processing.app.Base;
import processing.app.Language;
import processing.app.Messages;
import processing.app.Platform;
import processing.app.Preferences;
import processing.app.ui.ColorChooser;
import processing.app.ui.Editor;
import processing.app.ui.Toolkit;
import processing.core.PApplet;

public class PreferencesFrame {
    JFrame frame;
    GroupLayout layout;
    static final Integer[] FONT_SIZES = new Integer[]{10, 12, 14, 18, 24, 36, 48};
    JTextField sketchbookLocationField;
    JTextField presentColor;
    JTextField presentColorHex;
    JCheckBox editorAntialiasBox;
    JCheckBox deletePreviousBox;
    JCheckBox memoryOverrideBox;
    JTextField memoryField;
    JCheckBox checkUpdatesBox;
    JComboBox<Integer> fontSizeField;
    JComboBox<Integer> consoleFontSizeField;
    JCheckBox inputMethodBox;
    JCheckBox autoAssociateBox;
    ColorChooser selector;
    JCheckBox errorCheckerBox;
    JCheckBox warningsCheckerBox;
    JCheckBox codeCompletionBox;
    JCheckBox importSuggestionsBox;
    JComboBox<String> displaySelectionBox;
    JComboBox<String> languageSelectionBox;
    int displayCount;
    String[] monoFontFamilies;
    JComboBox<String> fontSelectionBox;
    JButton okButton;
    Base base;

    public PreferencesFrame(Base base) {
        JLabel preferencePathLabel;
        this.base = base;
        this.frame = new JFrame(Language.text("preferences"));
        Container pain = this.frame.getContentPane();
        this.layout = new GroupLayout(pain);
        this.layout.setAutoCreateGaps(true);
        this.layout.setAutoCreateContainerGaps(true);
        pain.setLayout(this.layout);
        int BORDER = Platform.isMacOS() ? 20 : 13;
        JLabel sketchbookLocationLabel = new JLabel(String.valueOf(Language.text("preferences.sketchbook_location")) + ":");
        this.sketchbookLocationField = new JTextField(40);
        JButton browseButton = new JButton(Language.getPrompt("browse"));
        browseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                File dflt = new File(PreferencesFrame.this.sketchbookLocationField.getText());
                PApplet.selectFolder((String)Language.text("preferences.sketchbook_location.popup"), (String)"sketchbookCallback", (File)dflt, (Object)PreferencesFrame.this, (Frame)PreferencesFrame.this.frame);
            }
        });
        JLabel languageLabel = new JLabel(String.valueOf(Language.text("preferences.language")) + ": ");
        this.languageSelectionBox = new JComboBox();
        Map<String, String> languages = Language.getLanguages();
        String[] languageSelection = new String[languages.size()];
        languageSelection[0] = languages.get(Language.getLanguage());
        int i = 1;
        for (Map.Entry<String, String> lang : languages.entrySet()) {
            if (lang.getKey().equals(Language.getLanguage())) continue;
            languageSelection[i++] = lang.getValue();
        }
        this.languageSelectionBox.setModel(new DefaultComboBoxModel<String>(languageSelection));
        JLabel restartProcessingLabel = new JLabel(" (" + Language.text("preferences.requires_restart") + ")");
        JLabel fontLabel = new JLabel(String.valueOf(Language.text("preferences.editor_and_console_font")) + ": ");
        String fontTip = "<html>" + Language.text("preferences.editor_and_console_font.tip");
        fontLabel.setToolTipText(fontTip);
        this.fontSelectionBox = new JComboBox<String>(new String[]{Toolkit.getMonoFontName()});
        this.fontSelectionBox.setToolTipText(fontTip);
        this.fontSelectionBox.setEnabled(false);
        JLabel fontSizelabel = new JLabel(String.valueOf(Language.text("preferences.editor_font_size")) + ": ");
        this.fontSizeField = new JComboBox<Integer>(FONT_SIZES);
        JLabel consoleFontSizeLabel = new JLabel(String.valueOf(Language.text("preferences.console_font_size")) + ": ");
        this.consoleFontSizeField = new JComboBox<Integer>(FONT_SIZES);
        this.fontSizeField.setSelectedItem(Preferences.getFont("editor.font.size"));
        JLabel backgroundColorLabel = new JLabel(String.valueOf(Language.text("preferences.background_color")) + ": ");
        String colorTip = "<html>" + Language.text("preferences.background_color.tip");
        backgroundColorLabel.setToolTipText(colorTip);
        this.presentColor = new JTextField("      ");
        this.presentColor.setOpaque(true);
        this.presentColor.setEnabled(true);
        this.presentColor.setEditable(false);
        CompoundBorder cb = new CompoundBorder(BorderFactory.createMatteBorder(1, 1, 0, 0, new Color(195, 195, 195)), BorderFactory.createMatteBorder(0, 0, 1, 1, new Color(54, 54, 54)));
        this.presentColor.setBorder(cb);
        this.presentColor.setBackground(Preferences.getColor("run.present.bgcolor"));
        this.presentColorHex = new JTextField(6);
        this.presentColorHex.setText(Preferences.get("run.present.bgcolor").substring(1));
        this.presentColorHex.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void removeUpdate(DocumentEvent e) {
                final String colorValue = PreferencesFrame.this.presentColorHex.getText().toUpperCase();
                if (colorValue.length() == 7 && colorValue.startsWith("#")) {
                    EventQueue.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            (this).PreferencesFrame.this.presentColorHex.setText(colorValue.substring(1));
                        }
                    });
                }
                if (colorValue.length() == 6 && colorValue.matches("[0123456789ABCDEF]*")) {
                    PreferencesFrame.this.presentColor.setBackground(new Color(PApplet.unhex((String)colorValue)));
                    if (!colorValue.equals(PreferencesFrame.this.presentColorHex.getText())) {
                        EventQueue.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                (this).PreferencesFrame.this.presentColorHex.setText(colorValue);
                            }
                        });
                    }
                }
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                final String colorValue = PreferencesFrame.this.presentColorHex.getText().toUpperCase();
                if (colorValue.length() == 7 && colorValue.startsWith("#")) {
                    EventQueue.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            (this).PreferencesFrame.this.presentColorHex.setText(colorValue.substring(1));
                        }
                    });
                }
                if (colorValue.length() == 6 && colorValue.matches("[0123456789ABCDEF]*")) {
                    PreferencesFrame.this.presentColor.setBackground(new Color(PApplet.unhex((String)colorValue)));
                    if (!colorValue.equals(PreferencesFrame.this.presentColorHex.getText())) {
                        EventQueue.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                (this).PreferencesFrame.this.presentColorHex.setText(colorValue);
                            }
                        });
                    }
                }
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
            }
        });
        this.selector = new ColorChooser(this.frame, false, Preferences.getColor("run.present.bgcolor"), Language.text("prompt.ok"), new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String colorValue = PreferencesFrame.this.selector.getHexColor();
                colorValue = colorValue.substring(1);
                PreferencesFrame.this.presentColorHex.setText(colorValue);
                PreferencesFrame.this.presentColor.setBackground(new Color(PApplet.unhex((String)colorValue)));
                PreferencesFrame.this.selector.hide();
            }
        });
        this.presentColor.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseExited(MouseEvent e) {
                PreferencesFrame.this.frame.setCursor(Cursor.getPredefinedCursor(0));
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                PreferencesFrame.this.frame.setCursor(Cursor.getPredefinedCursor(12));
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                PreferencesFrame.this.selector.show();
            }
        });
        JLabel hashLabel = new JLabel("#");
        this.editorAntialiasBox = new JCheckBox(Language.text("preferences.use_smooth_text"));
        this.inputMethodBox = new JCheckBox(String.valueOf(Language.text("preferences.enable_complex_text_input")) + " (" + Language.text("preferences.enable_complex_text_input_example") + ", " + Language.text("preferences.requires_restart") + ")");
        this.errorCheckerBox = new JCheckBox(Language.text("preferences.continuously_check"));
        this.warningsCheckerBox = new JCheckBox(Language.text("preferences.show_warnings"));
        this.codeCompletionBox = new JCheckBox(String.valueOf(Language.text("preferences.code_completion")) + " Ctrl-" + Language.text("preferences.cmd_space"));
        this.importSuggestionsBox = new JCheckBox(Language.text("preferences.suggest_imports"));
        this.memoryOverrideBox = new JCheckBox(String.valueOf(Language.text("preferences.increase_max_memory")) + ": ");
        this.memoryField = new JTextField(4);
        this.memoryOverrideBox.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                PreferencesFrame.this.memoryField.setEnabled(PreferencesFrame.this.memoryOverrideBox.isSelected());
            }
        });
        JLabel mbLabel = new JLabel("MB");
        this.deletePreviousBox = new JCheckBox(Language.text("preferences.delete_previous_folder_on_export"));
        this.checkUpdatesBox = new JCheckBox(Language.text("preferences.check_for_updates_on_startup"));
        JLabel displayLabel = new JLabel(String.valueOf(Language.text("preferences.run_sketches_on_display")) + ": ");
        String tip = "<html>" + Language.text("preferences.run_sketches_on_display.tip");
        displayLabel.setToolTipText(tip);
        this.displaySelectionBox = new JComboBox();
        this.updateDisplayList();
        this.autoAssociateBox = new JCheckBox(Language.text("preferences.automatically_associate_pde_files"));
        this.autoAssociateBox.setVisible(false);
        JLabel morePreferenceLabel = new JLabel(String.valueOf(Language.text("preferences.file")) + ":");
        morePreferenceLabel.setForeground(Color.gray);
        final JLabel clickable = preferencePathLabel = new JLabel(Preferences.getPreferencesPath());
        preferencePathLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                Platform.openFolder(Base.getSettingsFolder());
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                clickable.setForeground(new Color(0, 0, 140));
            }

            @Override
            public void mouseExited(MouseEvent e) {
                clickable.setForeground(Color.BLACK);
            }
        });
        JLabel preferenceHintLabel = new JLabel("(" + Language.text("preferences.file.hint") + ")");
        preferenceHintLabel.setForeground(Color.gray);
        this.okButton = new JButton(Language.getPrompt("ok"));
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PreferencesFrame.this.applyFrame();
                PreferencesFrame.this.disposeFrame();
            }
        });
        JButton cancelButton = new JButton(Language.getPrompt("cancel"));
        cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PreferencesFrame.this.disposeFrame();
            }
        });
        int buttonWidth = Toolkit.getButtonWidth();
        this.layout.setHorizontalGroup(this.layout.createSequentialGroup().addGap(BORDER).addGroup(this.layout.createParallelGroup().addComponent(sketchbookLocationLabel).addGroup(this.layout.createSequentialGroup().addComponent(this.sketchbookLocationField).addComponent(browseButton)).addGroup(this.layout.createSequentialGroup().addComponent(languageLabel).addComponent(this.languageSelectionBox, -2, -1, -2).addComponent(restartProcessingLabel)).addGroup(this.layout.createSequentialGroup().addComponent(fontLabel).addComponent(this.fontSelectionBox, -2, -1, -2)).addGroup(GroupLayout.Alignment.LEADING, this.layout.createSequentialGroup().addComponent(fontSizelabel).addComponent(this.fontSizeField, -2, -1, -2).addComponent(consoleFontSizeLabel).addComponent(this.consoleFontSizeField, -2, -1, -2)).addGroup(this.layout.createSequentialGroup().addComponent(backgroundColorLabel).addComponent(hashLabel, -2, -1, -2).addGap(0).addComponent(this.presentColorHex, -2, -1, -2).addComponent(this.presentColor, -2, -1, -2)).addComponent(this.editorAntialiasBox).addComponent(this.inputMethodBox).addGroup(this.layout.createSequentialGroup().addComponent(this.errorCheckerBox).addComponent(this.warningsCheckerBox)).addComponent(this.codeCompletionBox).addComponent(this.importSuggestionsBox).addGroup(this.layout.createSequentialGroup().addComponent(this.memoryOverrideBox).addComponent(this.memoryField, -2, -1, -2).addComponent(mbLabel)).addComponent(this.deletePreviousBox).addComponent(this.checkUpdatesBox).addGroup(this.layout.createSequentialGroup().addComponent(displayLabel).addComponent(this.displaySelectionBox, -2, -1, -2)).addComponent(this.autoAssociateBox).addComponent(morePreferenceLabel).addComponent(preferencePathLabel).addComponent(preferenceHintLabel).addGroup(GroupLayout.Alignment.TRAILING, this.layout.createSequentialGroup().addComponent(this.okButton, buttonWidth, -1, buttonWidth).addComponent(cancelButton, buttonWidth, -1, buttonWidth))).addGap(BORDER));
        this.layout.setVerticalGroup(this.layout.createSequentialGroup().addGap(BORDER).addComponent(sketchbookLocationLabel).addGroup(this.layout.createParallelGroup().addComponent(this.sketchbookLocationField).addComponent(browseButton)).addGroup(this.layout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(languageLabel).addComponent(this.languageSelectionBox).addComponent(restartProcessingLabel)).addGroup(this.layout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(fontLabel).addComponent(this.fontSelectionBox)).addGroup(this.layout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(fontSizelabel).addComponent(this.fontSizeField).addComponent(consoleFontSizeLabel).addComponent(this.consoleFontSizeField)).addGroup(this.layout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(backgroundColorLabel).addComponent(hashLabel).addComponent(this.presentColorHex).addComponent(this.presentColor)).addComponent(this.editorAntialiasBox).addComponent(this.inputMethodBox).addGroup(this.layout.createParallelGroup().addComponent(this.errorCheckerBox).addComponent(this.warningsCheckerBox)).addComponent(this.codeCompletionBox).addComponent(this.importSuggestionsBox).addGroup(this.layout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.memoryOverrideBox).addComponent(this.memoryField).addComponent(mbLabel)).addComponent(this.deletePreviousBox).addComponent(this.checkUpdatesBox).addGroup(this.layout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(displayLabel).addComponent(this.displaySelectionBox)).addComponent(this.autoAssociateBox).addComponent(morePreferenceLabel).addGap(0).addComponent(preferencePathLabel).addGap(0).addComponent(preferenceHintLabel).addGroup(this.layout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.okButton).addComponent(cancelButton)).addGap(BORDER));
        if (Platform.isWindows()) {
            this.autoAssociateBox.setVisible(true);
        }
        this.frame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                PreferencesFrame.this.disposeFrame();
            }
        });
        ActionListener disposer = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PreferencesFrame.this.disposeFrame();
            }
        };
        Toolkit.registerWindowCloseKeys(this.frame.getRootPane(), disposer);
        Toolkit.setIcon(this.frame);
        this.frame.setResizable(false);
        this.frame.pack();
        this.frame.setLocationRelativeTo(null);
        this.fontSizeField.setEditable(true);
        this.consoleFontSizeField.setEditable(true);
        pain.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                KeyStroke wc = Toolkit.WINDOW_CLOSE_KEYSTROKE;
                if (e.getKeyCode() == 27 || KeyStroke.getKeyStrokeForEvent(e).equals(wc)) {
                    PreferencesFrame.this.disposeFrame();
                }
            }
        });
    }

    public void sketchbookCallback(File file) {
        if (file != null) {
            this.sketchbookLocationField.setText(file.getAbsolutePath());
        }
    }

    protected void disposeFrame() {
        this.frame.dispose();
    }

    protected void applyFrame() {
        Preferences.setBoolean("editor.smooth", this.editorAntialiasBox.isSelected());
        Preferences.setBoolean("export.delete_target_folder", this.deletePreviousBox.isSelected());
        String oldPath = Preferences.getSketchbookPath();
        String newPath = this.sketchbookLocationField.getText();
        if (!newPath.equals(oldPath)) {
            this.base.setSketchbookFolder(new File(newPath));
        }
        Preferences.setBoolean("update.check", this.checkUpdatesBox.isSelected());
        Map<String, String> languages = Language.getLanguages();
        String language = "";
        for (Map.Entry<String, String> lang : languages.entrySet()) {
            if (!lang.getValue().equals(String.valueOf(this.languageSelectionBox.getSelectedItem()))) continue;
            language = lang.getKey().trim().toLowerCase();
            break;
        }
        if (!language.equals(Language.getLanguage()) && !language.equals("")) {
            Language.saveLanguage(language);
        }
        if (this.displaySelectionBox.isEnabled()) {
            int oldDisplayNum = Preferences.getInteger("run.display");
            int displayNum = -1;
            int d = 0;
            while (d < this.displaySelectionBox.getItemCount()) {
                if (this.displaySelectionBox.getSelectedIndex() == d) {
                    displayNum = d + 1;
                }
                ++d;
            }
            if (displayNum != -1 && displayNum != oldDisplayNum) {
                Preferences.setInteger("run.display", displayNum);
                for (Editor editor : this.base.getEditors()) {
                    editor.setSketchLocation(null);
                }
            }
        }
        Preferences.setBoolean("run.options.memory", this.memoryOverrideBox.isSelected());
        int memoryMin = Preferences.getInteger("run.options.memory.initial");
        int memoryMax = Preferences.getInteger("run.options.memory.maximum");
        try {
            memoryMax = Integer.parseInt(this.memoryField.getText().trim());
            if (memoryMax < memoryMin) {
                memoryMax = memoryMin;
            }
            Preferences.setInteger("run.options.memory.maximum", memoryMax);
        }
        catch (NumberFormatException numberFormatException) {
            System.err.println("Ignoring bad memory setting");
        }
        if (this.fontSelectionBox.isEnabled()) {
            String fontFamily = (String)this.fontSelectionBox.getSelectedItem();
            Preferences.set("editor.font.family", fontFamily);
        }
        try {
            Object selection = this.fontSizeField.getSelectedItem();
            if (selection instanceof String) {
                selection = Integer.parseInt((String)selection);
            }
            Preferences.set("editor.font.size", String.valueOf(selection));
        }
        catch (NumberFormatException numberFormatException) {
            Messages.log("Ignoring invalid font size " + this.fontSizeField);
            this.fontSizeField.setSelectedItem(Preferences.getInteger("editor.font.size"));
        }
        try {
            Object selection = this.consoleFontSizeField.getSelectedItem();
            if (selection instanceof String) {
                selection = Integer.parseInt((String)selection);
            }
            Preferences.set("console.font.size", String.valueOf(selection));
        }
        catch (NumberFormatException numberFormatException) {
            Messages.log("Ignoring invalid font size " + this.consoleFontSizeField);
            this.consoleFontSizeField.setSelectedItem(Preferences.getInteger("console.font.size"));
        }
        Preferences.setColor("run.present.bgcolor", this.presentColor.getBackground());
        Preferences.setBoolean("editor.input_method_support", this.inputMethodBox.isSelected());
        if (this.autoAssociateBox != null) {
            Preferences.setBoolean("platform.auto_file_type_associations", this.autoAssociateBox.isSelected());
        }
        Preferences.setBoolean("pdex.errorCheckEnabled", this.errorCheckerBox.isSelected());
        Preferences.setBoolean("pdex.warningsEnabled", this.warningsCheckerBox.isSelected());
        Preferences.setBoolean("pdex.completion", this.codeCompletionBox.isSelected());
        Preferences.setBoolean("pdex.suggest.imports", this.importSuggestionsBox.isSelected());
        for (Editor editor : this.base.getEditors()) {
            editor.applyPreferences();
        }
    }

    public void showFrame() {
        this.editorAntialiasBox.setSelected(Preferences.getBoolean("editor.smooth"));
        this.inputMethodBox.setSelected(Preferences.getBoolean("editor.input_method_support"));
        this.errorCheckerBox.setSelected(Preferences.getBoolean("pdex.errorCheckEnabled"));
        this.warningsCheckerBox.setSelected(Preferences.getBoolean("pdex.warningsEnabled"));
        this.codeCompletionBox.setSelected(Preferences.getBoolean("pdex.completion"));
        this.importSuggestionsBox.setSelected(Preferences.getBoolean("pdex.suggest.imports"));
        this.deletePreviousBox.setSelected(Preferences.getBoolean("export.delete_target_folder"));
        this.sketchbookLocationField.setText(Preferences.getSketchbookPath());
        this.checkUpdatesBox.setSelected(Preferences.getBoolean("update.check"));
        int defaultDisplayNum = this.updateDisplayList();
        int displayNum = Preferences.getInteger("run.display");
        if (displayNum < 1 || displayNum > this.displayCount) {
            displayNum = defaultDisplayNum;
            Preferences.setInteger("run.display", displayNum);
        }
        this.displaySelectionBox.setSelectedIndex(displayNum - 1);
        new Thread(new Runnable(){

            @Override
            public void run() {
                PreferencesFrame.this.initFontList();
            }
        }).start();
        this.fontSizeField.setSelectedItem(Preferences.getInteger("editor.font.size"));
        this.consoleFontSizeField.setSelectedItem(Preferences.getInteger("console.font.size"));
        this.presentColor.setBackground(Preferences.getColor("run.present.bgcolor"));
        this.presentColorHex.setText(Preferences.get("run.present.bgcolor").substring(1));
        this.memoryOverrideBox.setSelected(Preferences.getBoolean("run.options.memory"));
        this.memoryField.setText(Preferences.get("run.options.memory.maximum"));
        this.memoryField.setEnabled(this.memoryOverrideBox.isSelected());
        if (this.autoAssociateBox != null) {
            this.autoAssociateBox.setSelected(Preferences.getBoolean("platform.auto_file_type_associations"));
        }
        this.frame.getRootPane().setDefaultButton(this.okButton);
        this.frame.pack();
        this.frame.setVisible(true);
    }

    void initFontList() {
        if (this.monoFontFamilies == null) {
            this.monoFontFamilies = Toolkit.getMonoFontFamilies();
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    PreferencesFrame.this.fontSelectionBox.setModel(new DefaultComboBoxModel<String>(PreferencesFrame.this.monoFontFamilies));
                    String family = Preferences.get("editor.font.family");
                    PreferencesFrame.this.fontSelectionBox.setSelectedItem("Monospaced");
                    PreferencesFrame.this.fontSelectionBox.setSelectedItem(family);
                    PreferencesFrame.this.fontSelectionBox.setEnabled(true);
                }
            });
        }
    }

    int updateDisplayList() {
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice defaultDevice = ge.getDefaultScreenDevice();
        GraphicsDevice[] devices = ge.getScreenDevices();
        int defaultNum = -1;
        this.displayCount = devices.length;
        String[] items = new String[this.displayCount];
        int i = 0;
        while (i < this.displayCount) {
            DisplayMode mode = devices[i].getDisplayMode();
            String title = String.format("%d (%d \u2715 %d)", i + 1, mode.getWidth(), mode.getHeight());
            if (devices[i] == defaultDevice) {
                title = String.valueOf(title) + " default";
                defaultNum = i + 1;
            }
            items[i] = title;
            ++i;
        }
        this.displaySelectionBox.setModel(new DefaultComboBoxModel<String>(items));
        this.displaySelectionBox.setEnabled(this.displayCount != 1);
        return defaultNum;
    }

    static class FontNamer
    extends JLabel
    implements ListCellRenderer<Font> {
        FontNamer() {
        }

        @Override
        public Component getListCellRendererComponent(JList<? extends Font> list, Font value, int index, boolean isSelected, boolean cellHasFocus) {
            this.setText(String.valueOf(value.getFamily()) + " / " + value.getName() + " (" + value.getPSName() + ")");
            return this;
        }
    }
}

