/*
 * Decompiled with CFR 0.152.
 */
package processing.app.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.ToolTipManager;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import processing.app.Language;
import processing.app.Mode;
import processing.app.ui.Editor;

public class ErrorTable
extends JTable {
    Editor editor;
    static final String[] columnNames = new String[]{"", Language.text("editor.footer.errors.problem"), Language.text("editor.footer.errors.tab"), Language.text("editor.footer.errors.line")};
    static final int DATA_COLUMN = 0;
    static final int PROBLEM_COLUMN = 1;
    static final int TAB_COLUMN = 2;
    static final int LINE_COLUMN = 3;
    Font headerFont;
    Color headerColor;
    Color headerBgColor;
    Font rowFont;
    Color rowColor;
    Color rowBgColor;

    public ErrorTable(final Editor editor) {
        super(new DefaultTableModel(columnNames, 0));
        this.setSelectionMode(0);
        this.editor = editor;
        JTableHeader header = this.getTableHeader();
        Mode mode = editor.getMode();
        header.setDefaultRenderer(new GradyHeaderRenderer(mode));
        this.setDefaultRenderer(Object.class, new GradyRowRenderer(mode));
        this.setIntercellSpacing(new Dimension(0, 0));
        TableColumn emptyColumn = this.columnModel.getColumn(0);
        emptyColumn.setMaxWidth(44);
        emptyColumn.setMinWidth(44);
        this.columnModel.getColumn(1).setPreferredWidth(400);
        this.columnModel.getColumn(2).setPreferredWidth(100);
        this.columnModel.getColumn(3).setPreferredWidth(50);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public synchronized void mouseClicked(MouseEvent e) {
                try {
                    int row = ((ErrorTable)e.getSource()).getSelectedRow();
                    if (row >= 0 && row < ErrorTable.this.getRowCount()) {
                        Object data = ErrorTable.this.getModel().getValueAt(row, 0);
                        int clickCount = e.getClickCount();
                        if (clickCount == 1) {
                            editor.errorTableClick(data);
                        } else if (clickCount > 1) {
                            editor.errorTableDoubleClick(data);
                        }
                        editor.getTextArea().requestFocusInWindow();
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        });
        header.setReorderingAllowed(false);
        ToolTipManager.sharedInstance().registerComponent(this);
    }

    public void clearRows() {
        DefaultTableModel dtm = (DefaultTableModel)this.getModel();
        dtm.setRowCount(0);
    }

    public void addRow(Entry data, String message, String filename, String line) {
        DefaultTableModel dtm = (DefaultTableModel)this.getModel();
        dtm.addRow(new Object[]{data, message, filename, line});
    }

    @Override
    public boolean isCellEditable(int rowIndex, int colIndex) {
        return false;
    }

    public static interface Entry {
        public boolean isError();

        public boolean isWarning();
    }

    static class GradyHeaderRenderer
    extends JLabel
    implements TableCellRenderer {
        public GradyHeaderRenderer(Mode mode) {
            this.setFont(mode.getFont("errors.header.font"));
            this.setAlignmentX(0.0f);
            this.setForeground(mode.getColor("errors.header.fgcolor"));
            this.setBackground(mode.getColor("errors.header.bgcolor"));
            this.setOpaque(true);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean selected, boolean focused, int row, int column) {
            this.setText(value == null ? "" : value.toString());
            return this;
        }
    }

    static class GradyRowRenderer
    extends JLabel
    implements TableCellRenderer {
        Color textColor;
        Color bgColor;
        Color textColorSelected;
        Color bgColorSelected;
        Color bgColorError;
        Color bgColorWarning;
        Color errorIndicatorColor;
        Color warningIndicatorColor;

        public GradyRowRenderer(Mode mode) {
            this.setFont(mode.getFont("errors.row.font"));
            this.setAlignmentX(0.0f);
            this.textColor = mode.getColor("errors.row.fgcolor");
            this.bgColor = mode.getColor("errors.row.bgcolor");
            this.textColorSelected = mode.getColor("errors.selection.fgcolor");
            this.bgColorSelected = mode.getColor("errors.selection.bgcolor");
            this.bgColorError = mode.getColor("errors.selection.error.bgcolor");
            this.bgColorWarning = mode.getColor("errors.selection.warning.bgcolor");
            this.errorIndicatorColor = mode.getColor("errors.indicator.error.color");
            this.warningIndicatorColor = mode.getColor("errors.indicator.warning.color");
            this.setOpaque(true);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean selected, boolean focused, int row, int column) {
            Entry entry = (Entry)table.getValueAt(row, 0);
            if (selected) {
                this.setForeground(this.textColorSelected);
                if (entry.isError()) {
                    this.setBackground(this.bgColorError);
                } else if (entry.isWarning()) {
                    this.setBackground(this.bgColorWarning);
                } else {
                    this.setBackground(this.bgColorSelected);
                }
            } else {
                this.setForeground(this.textColor);
                this.setBackground(this.bgColor);
            }
            if (column == 0) {
                this.setText("\u2022");
                this.setHorizontalAlignment(0);
                if (entry.isError()) {
                    this.setForeground(this.errorIndicatorColor);
                } else if (entry.isWarning()) {
                    this.setForeground(this.warningIndicatorColor);
                } else {
                    this.setText("");
                }
            } else if (value == null) {
                this.setText("");
            } else {
                this.setHorizontalAlignment(2);
                this.setText(value.toString());
            }
            return this;
        }
    }
}

