/*
 * Decompiled with CFR 0.152.
 */
package processing.app.ui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.Box;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import processing.app.Base;
import processing.app.Language;
import processing.app.Mode;
import processing.app.ui.Editor;
import processing.app.ui.EditorButton;
import processing.app.ui.Toolkit;

public abstract class EditorToolbar
extends JPanel
implements KeyListener {
    static final int HIGH = 53;
    static final int GAP = 9;
    static final int RADIUS = 3;
    protected Editor editor;
    protected Base base;
    protected Mode mode;
    protected EditorButton runButton;
    protected EditorButton stopButton;
    protected EditorButton rolloverButton;
    protected JLabel rolloverLabel;
    protected Box box;
    protected Image gradient;

    public EditorToolbar(Editor editor) {
        this.editor = editor;
        this.base = editor.getBase();
        this.mode = editor.getMode();
        this.gradient = this.mode.makeGradient("toolbar", 400, 53);
        this.rebuild();
    }

    public void rebuild() {
        this.removeAll();
        List<EditorButton> buttons = this.createButtons();
        this.box = Box.createHorizontalBox();
        this.box.add(Box.createHorizontalStrut(44));
        this.rolloverLabel = new JLabel();
        this.rolloverLabel.setFont(this.mode.getFont("toolbar.rollover.font"));
        this.rolloverLabel.setForeground(this.mode.getColor("toolbar.rollover.color"));
        for (EditorButton button : buttons) {
            this.box.add(button);
            this.box.add(Box.createHorizontalStrut(9));
        }
        this.box.add(this.rolloverLabel);
        this.box.add(Box.createHorizontalGlue());
        this.addModeButtons(this.box, this.rolloverLabel);
        ModeSelector ms = new ModeSelector();
        this.box.add(ms);
        this.box.add(Box.createHorizontalStrut(12));
        this.setLayout(new BorderLayout());
        this.add((Component)this.box, "Center");
    }

    @Override
    public void paintComponent(Graphics g) {
        Dimension size = this.getSize();
        g.drawImage(this.gradient, 0, 0, size.width, size.height, this);
    }

    public List<EditorButton> createButtons() {
        this.runButton = new EditorButton(this, "/lib/toolbar/run", Language.text("toolbar.run"), Language.text("toolbar.present")){

            @Override
            public void actionPerformed(ActionEvent e) {
                EditorToolbar.this.handleRun(e.getModifiers());
            }
        };
        this.stopButton = new EditorButton(this, "/lib/toolbar/stop", Language.text("toolbar.stop")){

            @Override
            public void actionPerformed(ActionEvent e) {
                EditorToolbar.this.handleStop();
            }
        };
        return new ArrayList<EditorButton>(Arrays.asList(this.runButton, this.stopButton));
    }

    public void addModeButtons(Box box, JLabel label) {
    }

    public void addGap(Box box) {
        box.add(Box.createHorizontalStrut(9));
    }

    public void activateRun() {
        this.runButton.setSelected(true);
        this.repaint();
    }

    public void deactivateRun() {
        this.runButton.setSelected(false);
        this.repaint();
    }

    public void activateStop() {
        this.stopButton.setSelected(true);
        this.repaint();
    }

    public void deactivateStop() {
        this.stopButton.setSelected(false);
        this.repaint();
    }

    public abstract void handleRun(int var1);

    public abstract void handleStop();

    void setRollover(EditorButton button, InputEvent e) {
        this.rolloverButton = button;
        this.updateRollover(e);
    }

    void updateRollover(InputEvent e) {
        if (this.rolloverButton != null) {
            this.rolloverLabel.setText(this.rolloverButton.getRolloverText(e));
        } else {
            this.rolloverLabel.setText("");
        }
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    @Override
    public void keyReleased(KeyEvent e) {
        this.updateRollover(e);
    }

    @Override
    public void keyPressed(KeyEvent e) {
        this.updateRollover(e);
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(super.getPreferredSize().width, 53);
    }

    @Override
    public Dimension getMinimumSize() {
        return new Dimension(super.getMinimumSize().width, 53);
    }

    @Override
    public Dimension getMaximumSize() {
        return new Dimension(super.getMaximumSize().width, 53);
    }

    class ModeSelector
    extends JPanel {
        Image offscreen;
        int width;
        int height;
        String title;
        Font titleFont;
        Color titleColor;
        int titleAscent;
        int titleWidth;
        final int MODE_GAP_WIDTH = 13;
        final int ARROW_GAP_WIDTH = 6;
        final int ARROW_WIDTH = 6;
        final int ARROW_TOP = 12;
        final int ARROW_BOTTOM = 18;
        int[] triangleX = new int[3];
        int[] triangleY = new int[]{12, 12, 18};
        Color backgroundColor;
        Color outlineColor;

        public ModeSelector() {
            this.title = EditorToolbar.this.mode.getTitle();
            this.titleFont = EditorToolbar.this.mode.getFont("mode.title.font");
            this.titleColor = EditorToolbar.this.mode.getColor("mode.title.color");
            this.titleWidth = this.getToolkit().getFontMetrics(this.titleFont).stringWidth(this.title);
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent event) {
                    JPopupMenu popup = ((ModeSelector)ModeSelector.this).EditorToolbar.this.editor.getModePopup();
                    popup.show(ModeSelector.this, event.getX(), event.getY());
                }
            });
            this.backgroundColor = EditorToolbar.this.mode.getColor("mode.background.color");
            this.outlineColor = EditorToolbar.this.mode.getColor("mode.outline.color");
        }

        @Override
        public void paintComponent(Graphics screen) {
            int x;
            Dimension size = this.getSize();
            this.width = 0;
            if (this.width != size.width || this.height != size.height) {
                this.offscreen = Toolkit.highResDisplay() ? this.createImage(size.width * 2, size.height * 2) : this.createImage(size.width, size.height);
                this.width = size.width;
                this.height = size.height;
            }
            Graphics g = this.offscreen.getGraphics();
            Graphics2D g2 = Toolkit.prepareGraphics(g);
            g.setFont(this.titleFont);
            if (this.titleAscent == 0) {
                this.titleAscent = (int)Toolkit.getAscent(g);
            }
            FontMetrics metrics = g.getFontMetrics();
            this.titleWidth = metrics.stringWidth(this.title);
            g.setColor(this.backgroundColor);
            g.fillRect(0, 0, this.width, this.height);
            g.setColor(this.outlineColor);
            g2.draw(Toolkit.createRoundRect(1.0f, 1.0f, this.width - 1, this.height - 1, 3.0f, 3.0f, 3.0f, 3.0f));
            g.setColor(this.titleColor);
            g.drawString(this.title, 13, (this.height + this.titleAscent) / 2);
            this.triangleX[0] = x = 13 + this.titleWidth + 6;
            this.triangleX[1] = x + 6;
            this.triangleX[2] = x + 3;
            g.fillPolygon(this.triangleX, this.triangleY, 3);
            screen.drawImage(this.offscreen, 0, 0, this.width, this.height, this);
        }

        @Override
        public Dimension getPreferredSize() {
            return new Dimension(13 + this.titleWidth + 6 + 6 + 13, 30);
        }

        @Override
        public Dimension getMinimumSize() {
            return this.getPreferredSize();
        }

        @Override
        public Dimension getMaximumSize() {
            return this.getPreferredSize();
        }
    }
}

