/*
 * Decompiled with CFR 0.152.
 */
package processing.app.ui;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.plaf.basic.BasicSplitPaneDivider;
import javax.swing.plaf.basic.BasicSplitPaneUI;
import processing.app.Mode;
import processing.app.Platform;
import processing.app.ui.Editor;
import processing.app.ui.Toolkit;
import processing.core.PApplet;

public class EditorStatus
extends BasicSplitPaneDivider {
    static final int HIGH = 28;
    static final int LEFT_MARGIN = 44;
    static final int RIGHT_MARGIN = 20;
    Color[] fgColor;
    Color[] bgColor;
    Image[] bgImage;
    public static final int ERROR = 1;
    public static final int CURSOR_LINE_ERROR = 2;
    public static final int WARNING = 3;
    public static final int CURSOR_LINE_WARNING = 4;
    public static final int NOTICE = 0;
    static final int YES = 1;
    static final int NO = 2;
    static final int CANCEL = 3;
    static final int OK = 4;
    static final String NO_MESSAGE = "";
    Editor editor;
    int mode;
    String message;
    String url;
    Font font;
    FontMetrics metrics;
    int ascent;
    Image offscreen;
    int sizeW;
    int sizeH;
    int response;
    boolean indeterminate;
    Thread thread;

    public EditorStatus(BasicSplitPaneUI ui, Editor editor) {
        super(ui);
        this.editor = editor;
        this.empty();
        this.updateMode();
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                if (EditorStatus.this.url != null) {
                    EditorStatus.this.setCursor(Cursor.getPredefinedCursor(12));
                }
            }

            @Override
            public void mousePressed(MouseEvent e) {
                if (EditorStatus.this.url != null) {
                    Platform.openURL(EditorStatus.this.url);
                }
            }
        });
    }

    static String findURL(String message) {
        String[] m = PApplet.match((String)message, (String)"http\\S+");
        if (m != null) {
            return m[0];
        }
        return null;
    }

    public void updateMode() {
        Mode mode = this.editor.getMode();
        this.fgColor = new Color[]{mode.getColor("status.notice.fgcolor"), mode.getColor("status.error.fgcolor"), mode.getColor("status.error.fgcolor"), mode.getColor("status.warning.fgcolor"), mode.getColor("status.warning.fgcolor")};
        this.bgColor = new Color[]{mode.getColor("status.notice.bgcolor"), mode.getColor("status.error.bgcolor"), mode.getColor("status.error.bgcolor"), mode.getColor("status.warning.bgcolor"), mode.getColor("status.warning.bgcolor")};
        this.bgImage = new Image[]{mode.loadImage("/lib/status/notice.png"), mode.loadImage("/lib/status/error.png"), mode.loadImage("/lib/status/error.png"), mode.loadImage("/lib/status/warning.png"), mode.loadImage("/lib/status/warning.png")};
        this.font = mode.getFont("status.font");
        this.metrics = null;
    }

    public void empty() {
        this.mode = 0;
        this.message = NO_MESSAGE;
        this.url = null;
        this.repaint();
    }

    public void message(String message, int mode) {
        this.message = message;
        this.mode = mode;
        this.url = EditorStatus.findURL(message);
        this.repaint();
    }

    public void notice(String message) {
        this.message(message, 0);
    }

    public void warning(String message) {
        this.message(message, 3);
    }

    public void error(String message) {
        this.message(message, 1);
    }

    public void startIndeterminate() {
        this.indeterminate = true;
        this.thread = new Thread(){

            @Override
            public void run() {
                while (Thread.currentThread() == EditorStatus.this.thread) {
                    EditorStatus.this.repaint();
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
        };
        this.thread.setName("Editor Status");
        this.thread.start();
    }

    public void stopIndeterminate() {
        this.indeterminate = false;
        this.thread = null;
        this.repaint();
    }

    @Override
    public void paint(Graphics screen) {
        Dimension size = this.getSize();
        if (size.width != this.sizeW || size.height != this.sizeH) {
            this.offscreen = null;
        }
        if (this.offscreen == null) {
            this.sizeW = size.width;
            this.sizeH = size.height;
            this.offscreen = Toolkit.highResDisplay() ? this.createImage(this.sizeW * 2, this.sizeH * 2) : this.createImage(this.sizeW, this.sizeH);
        }
        Graphics g = this.offscreen.getGraphics();
        Toolkit.prepareGraphics(g);
        g.setFont(this.font);
        if (this.metrics == null) {
            this.metrics = g.getFontMetrics();
            this.ascent = this.metrics.getAscent();
        }
        g.drawImage(this.bgImage[this.mode], 0, 0, this.sizeW, this.sizeH, this);
        g.setColor(this.fgColor[this.mode]);
        if (this.message != null) {
            g.setFont(this.font);
            g.drawString(this.message, 44, (this.sizeH + this.ascent) / 2);
        }
        if (this.indeterminate) {
            int w = Toolkit.getButtonWidth();
            int x = this.getWidth() - 20 - w;
            int y = this.getHeight() / 3;
            int h = this.getHeight() / 3;
            g.setColor(new Color(Integer.MIN_VALUE, true));
            g.drawRect(x, y, w, h);
            int i = 0;
            while (i < 10) {
                int r = (int)((double)x + Math.random() * (double)w);
                g.drawLine(r, y, r, y + h);
                ++i;
            }
        }
        screen.drawImage(this.offscreen, 0, 0, this.sizeW, this.sizeH, null);
    }

    @Override
    public Dimension getPreferredSize() {
        return this.getMinimumSize();
    }

    @Override
    public Dimension getMinimumSize() {
        return new Dimension(300, 28);
    }

    @Override
    public Dimension getMaximumSize() {
        return new Dimension(super.getMaximumSize().width, 28);
    }
}

