/*
 * Decompiled with CFR 0.152.
 */
package processing.app.ui;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.InputEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import javax.swing.JComponent;
import processing.app.Mode;
import processing.app.ui.EditorToolbar;

public abstract class EditorButton
extends JComponent
implements MouseListener,
MouseMotionListener,
ActionListener {
    public static final int DIM = 30;
    protected String title;
    protected String titleShift;
    protected String titleAlt;
    protected boolean pressed;
    protected boolean selected;
    protected boolean rollover;
    protected boolean shift;
    protected Image enabledImage;
    protected Image disabledImage;
    protected Image selectedImage;
    protected Image rolloverImage;
    protected Image pressedImage;
    protected Image gradient;
    protected EditorToolbar toolbar;

    public EditorButton(EditorToolbar parent, String name, String title) {
        this(parent, name, title, title, title);
    }

    public EditorButton(EditorToolbar parent, String name, String title, String titleShift) {
        this(parent, name, title, titleShift, title);
    }

    public EditorButton(EditorToolbar parent, String name, String title, String titleShift, String titleAlt) {
        this.toolbar = parent;
        this.title = title;
        this.titleShift = titleShift;
        this.titleAlt = titleAlt;
        Mode mode = this.toolbar.mode;
        this.disabledImage = mode.loadImageX(String.valueOf(name) + "-disabled");
        this.enabledImage = mode.loadImageX(String.valueOf(name) + "-enabled");
        this.selectedImage = mode.loadImageX(String.valueOf(name) + "-selected");
        this.pressedImage = mode.loadImageX(String.valueOf(name) + "-pressed");
        this.rolloverImage = mode.loadImageX(String.valueOf(name) + "-rollover");
        if (this.disabledImage == null) {
            this.disabledImage = this.enabledImage;
        }
        if (this.selectedImage == null) {
            this.selectedImage = this.enabledImage;
        }
        if (this.pressedImage == null) {
            this.pressedImage = this.enabledImage;
        }
        if (this.rolloverImage == null) {
            this.rolloverImage = this.enabledImage;
        }
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
    }

    @Override
    public void paintComponent(Graphics g) {
        Image image = this.enabledImage;
        if (!this.isEnabled()) {
            image = this.disabledImage;
        } else if (this.selected) {
            image = this.selectedImage;
        } else if (this.pressed) {
            image = this.pressedImage;
        } else if (this.rollover) {
            image = this.rolloverImage;
        }
        if (this.gradient != null) {
            g.drawImage(this.gradient, 0, 0, 30, 30, this);
        }
        g.drawImage(image, 0, 0, 30, 30, this);
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    public boolean isShiftDown() {
        return this.shift;
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.setPressed(true);
        this.shift = e.isShiftDown();
        this.actionPerformed(new ActionEvent(this, 1001, null, e.getModifiers()));
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        this.setPressed(false);
    }

    public void setPressed(boolean pressed) {
        if (this.isEnabled()) {
            this.pressed = pressed;
            this.repaint();
        }
    }

    public void setSelected(boolean selected) {
        this.selected = selected;
    }

    public String getRolloverText(InputEvent e) {
        if (e.isShiftDown()) {
            return this.titleShift;
        }
        if (e.isAltDown()) {
            return this.titleAlt;
        }
        return this.title;
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        this.toolbar.setRollover(this, e);
    }

    @Override
    public void mouseExited(MouseEvent e) {
        this.toolbar.setRollover(null, e);
    }

    @Override
    public void mouseDragged(MouseEvent e) {
    }

    @Override
    public void mouseMoved(MouseEvent e) {
    }

    @Override
    public abstract void actionPerformed(ActionEvent var1);

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(30, 30);
    }

    @Override
    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    @Override
    public Dimension getMaximumSize() {
        return this.getPreferredSize();
    }
}

