/*
 * Decompiled with CFR 0.152.
 */
package processing.app.syntax.im;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.InputMethodEvent;
import java.awt.event.InputMethodListener;
import java.awt.font.FontRenderContext;
import java.awt.font.TextAttribute;
import java.awt.font.TextHitInfo;
import java.awt.font.TextLayout;
import java.awt.im.InputMethodRequests;
import java.text.AttributedCharacterIterator;
import java.text.AttributedString;
import java.util.Date;
import javax.swing.text.BadLocationException;
import processing.app.Base;
import processing.app.Messages;
import processing.app.Preferences;
import processing.app.syntax.JEditTextArea;
import processing.app.syntax.TextAreaPainter;
import processing.app.syntax.im.CompositionTextPainter;

public class InputMethodSupport
implements InputMethodRequests,
InputMethodListener {
    private static final AttributedCharacterIterator.Attribute[] CUSTOM_IM_ATTRIBUTES = new AttributedCharacterIterator.Attribute[]{TextAttribute.INPUT_METHOD_HIGHLIGHT};
    private int committed_count = 0;
    private TextHitInfo caret;
    private JEditTextArea textArea;
    private AttributedCharacterIterator composedText;
    private AttributedString composedTextString;

    public InputMethodSupport(JEditTextArea textArea) {
        this.textArea = textArea;
        this.textArea.enableInputMethods(true);
        this.textArea.addInputMethodListener(this);
    }

    @Override
    public Rectangle getTextLocation(TextHitInfo offset) {
        if (Base.DEBUG) {
            Messages.log("#Called getTextLocation:" + offset);
        }
        int line = this.textArea.getCaretLine();
        int offsetX = this.textArea.getCaretPosition() - this.textArea.getLineStartOffset(line);
        Rectangle rectangle = new Rectangle(this.textArea.offsetToX(line, offsetX), this.textArea.lineToY(line + 1), 0, 0);
        Point location = this.textArea.getPainter().getLocationOnScreen();
        rectangle.translate(location.x, location.y);
        return rectangle;
    }

    @Override
    public TextHitInfo getLocationOffset(int x, int y) {
        return null;
    }

    @Override
    public int getInsertPositionOffset() {
        return this.textArea.getCaretPosition() * -1;
    }

    @Override
    public AttributedCharacterIterator getCommittedText(int beginIndex, int endIndex, AttributedCharacterIterator.Attribute[] attributes) {
        int length = endIndex - beginIndex;
        String textAreaString = this.textArea.getText(beginIndex, length);
        return new AttributedString(textAreaString).getIterator();
    }

    @Override
    public int getCommittedTextLength() {
        return this.committed_count;
    }

    @Override
    public AttributedCharacterIterator cancelLatestCommittedText(AttributedCharacterIterator.Attribute[] attributes) {
        return null;
    }

    @Override
    public AttributedCharacterIterator getSelectedText(AttributedCharacterIterator.Attribute[] attributes) {
        return null;
    }

    @Override
    public void inputMethodTextChanged(InputMethodEvent event) {
        this.composedText = null;
        if (Base.DEBUG) {
            StringBuilder sb = new StringBuilder();
            sb.append("#Called inputMethodTextChanged");
            sb.append("\t ID: " + event.getID());
            sb.append("\t timestamp: " + new Date(event.getWhen()));
            sb.append("\t parmString: " + event.paramString());
            Messages.log(sb.toString());
        }
        AttributedCharacterIterator text = event.getText();
        this.committed_count = event.getCommittedCharacterCount();
        this.textArea.setCaretVisible(false);
        if (text != null && text.getEndIndex() - (text.getBeginIndex() + this.committed_count) <= 0) {
            this.textArea.setCaretVisible(true);
        }
        if (text == null) {
            this.textArea.setCaretVisible(true);
        }
        if (text != null) {
            int toCopy = this.committed_count;
            char c = text.first();
            while (toCopy-- > 0) {
                if (Base.DEBUG) {
                    Messages.log("INSERT:'" + c + "'");
                }
                this.insertCharacter(c);
                c = text.next();
            }
            CompositionTextPainter compositionPainter = this.textArea.getPainter().getCompositionTextpainter();
            if (Base.DEBUG) {
                Messages.log(" textArea.getCaretPosition() + committed_count: " + (this.textArea.getCaretPosition() + this.committed_count));
            }
            compositionPainter.setComposedTextLayout(this.getTextLayout(text, this.committed_count), this.textArea.getCaretPosition() + this.committed_count);
            compositionPainter.setCaret(event.getCaret());
        } else {
            CompositionTextPainter compositionPainter = this.textArea.getPainter().getCompositionTextpainter();
            compositionPainter.setComposedTextLayout(null, 0);
            compositionPainter.setCaret(null);
        }
        this.caret = event.getCaret();
        event.consume();
        this.textArea.repaint();
    }

    private TextLayout getTextLayout(AttributedCharacterIterator text, int committedCount) {
        boolean antialias = Preferences.getBoolean("editor.smooth");
        TextAreaPainter painter = this.textArea.getPainter();
        if (text.getEndIndex() - (text.getBeginIndex() + committedCount) <= 0) {
            this.composedTextString = new AttributedString("");
            return null;
        }
        this.composedTextString = new AttributedString(text, committedCount, text.getEndIndex(), CUSTOM_IM_ATTRIBUTES);
        Font font = painter.getFontMetrics().getFont();
        this.composedTextString.addAttribute(TextAttribute.FONT, font);
        this.composedTextString.addAttribute(TextAttribute.BACKGROUND, Color.WHITE);
        this.composedText = this.composedTextString.getIterator();
        Graphics2D g2d = (Graphics2D)painter.getGraphics();
        g2d.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, antialias ? RenderingHints.VALUE_TEXT_ANTIALIAS_ON : RenderingHints.VALUE_TEXT_ANTIALIAS_OFF);
        FontRenderContext frc = g2d.getFontRenderContext();
        if (Base.DEBUG) {
            Messages.log("debug: FontRenderContext is Antialiased = " + frc.getAntiAliasingHint());
        }
        return new TextLayout(this.composedTextString.getIterator(), frc);
    }

    @Override
    public void caretPositionChanged(InputMethodEvent event) {
        this.caret = event.getCaret();
        event.consume();
    }

    private void insertCharacter(char c) {
        if (Base.DEBUG) {
            Messages.log("debug: insertCharacter(char c) textArea.getCaretPosition()=" + this.textArea.getCaretPosition());
        }
        try {
            this.textArea.getDocument().insertString(this.textArea.getCaretPosition(), Character.toString(c), null);
            if (Base.DEBUG) {
                Messages.log("debug: \t after:insertCharacter(char c) textArea.getCaretPosition()=" + this.textArea.getCaretPosition());
            }
        }
        catch (BadLocationException e) {
            e.printStackTrace();
        }
    }
}

