/*
 * Decompiled with CFR 0.152.
 */
package processing.app.platform;

import com.sun.jna.Library;
import com.sun.jna.Native;
import com.sun.jna.platform.win32.Shell32Util;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import processing.app.Base;
import processing.app.Messages;
import processing.app.Preferences;
import processing.app.platform.DefaultPlatform;
import processing.app.platform.WindowsRegistry;
import processing.core.PApplet;

public class WindowsPlatform
extends DefaultPlatform {
    static final String APP_NAME = "Processing";
    static final String REG_OPEN_COMMAND = String.valueOf(System.getProperty("user.dir").replace('/', '\\')) + "\\" + "Processing".toLowerCase() + ".exe \"%1\"";
    static final String REG_DOC = "Processing.Document";
    static WinLibC clib;

    @Override
    public void initBase(Base base) {
        super.initBase(base);
        this.checkAssociations();
        this.checkPath();
    }

    protected void checkAssociations() {
        try {
            String knownCommand;
            if (Preferences.getBoolean("platform.auto_file_type_associations") && ((knownCommand = WindowsRegistry.getStringValue(WindowsRegistry.REGISTRY_ROOT_KEY.CURRENT_USER, "Software\\Classes\\Processing.Document\\shell\\open\\command", "")) == null || !knownCommand.equals(REG_OPEN_COMMAND))) {
                this.setAssociations();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void setAssociations() throws UnsupportedEncodingException {
        WindowsRegistry.REGISTRY_ROOT_KEY rootKey = WindowsRegistry.REGISTRY_ROOT_KEY.CURRENT_USER;
        if (!(WindowsRegistry.createKey(rootKey, "Software\\Classes", ".pde") && WindowsRegistry.setStringValue(rootKey, "Software\\Classes\\.pde", "", REG_DOC) && WindowsRegistry.createKey(rootKey, "Software\\Classes", REG_DOC) && WindowsRegistry.setStringValue(rootKey, "Software\\Classes\\Processing.Document", "", "Processing Source Code") && WindowsRegistry.createKey(rootKey, "Software\\Classes\\Processing.Document", "shell") && WindowsRegistry.createKey(rootKey, "Software\\Classes\\Processing.Document\\shell", "open") && WindowsRegistry.createKey(rootKey, "Software\\Classes\\Processing.Document\\shell\\open", "command") && WindowsRegistry.setStringValue(rootKey, "Software\\Classes\\Processing.Document\\shell\\open\\command", "", REG_OPEN_COMMAND))) {
            Messages.log("Could not associate files, turning off auto-associate pref.");
            Preferences.setBoolean("platform.auto_file_type_associations", false);
        }
    }

    protected void checkPath() {
        String path = System.getProperty("java.library.path");
        String[] pieces = PApplet.split((String)path, (char)File.pathSeparatorChar);
        String[] legit = new String[pieces.length];
        int legitCount = 0;
        String[] stringArray = pieces;
        int n = pieces.length;
        int n2 = 0;
        while (n2 < n) {
            File directory;
            String item = stringArray[n2];
            if (item.startsWith("\"")) {
                item = item.substring(1);
            }
            if (item.endsWith("\"")) {
                item = item.substring(0, item.length() - 1);
            }
            if (item.endsWith(File.separator)) {
                item = item.substring(0, item.length() - File.separator.length());
            }
            if ((directory = new File(item)).exists() && item.trim().length() != 0) {
                legit[legitCount++] = item;
            }
            ++n2;
        }
        String newPath = PApplet.join((String[])(legit = PApplet.subset((String[])legit, (int)0, (int)legitCount)), (String)File.pathSeparator);
        if (!newPath.equals(path)) {
            System.setProperty("java.library.path", newPath);
        }
    }

    @Override
    public File getSettingsFolder() throws Exception {
        File settingsFolder;
        File settingsFolder2;
        String appDataRoaming = WindowsPlatform.getAppDataPath();
        if (appDataRoaming != null && ((settingsFolder2 = new File(appDataRoaming, APP_NAME)).exists() || settingsFolder2.mkdirs())) {
            return settingsFolder2;
        }
        String appDataLocal = WindowsPlatform.getLocalAppDataPath();
        if (appDataLocal != null && ((settingsFolder = new File(appDataLocal, APP_NAME)).exists() || settingsFolder.mkdirs())) {
            return settingsFolder;
        }
        if (appDataRoaming == null && appDataLocal == null) {
            throw new IOException("Could not get the AppData folder");
        }
        throw new IOException("Please fix permissions for either " + appDataRoaming + " or " + appDataLocal);
    }

    private static String getAppDataPath() throws Exception {
        return Shell32Util.getSpecialFolderPath((int)26, (boolean)true);
    }

    private static String getLocalAppDataPath() throws Exception {
        return Shell32Util.getSpecialFolderPath((int)28, (boolean)true);
    }

    @Override
    public File getDefaultSketchbookFolder() throws Exception {
        String documentsPath = WindowsPlatform.getDocumentsPath();
        if (documentsPath != null) {
            return new File(documentsPath, APP_NAME);
        }
        return null;
    }

    private static String getDocumentsPath() throws Exception {
        return Shell32Util.getSpecialFolderPath((int)5, (boolean)true);
    }

    static WinLibC getLibC() {
        if (clib == null) {
            try {
                clib = (WinLibC)Native.loadLibrary((String)"msvcrt", WinLibC.class);
            }
            catch (UnsatisfiedLinkError ule) {
                Messages.showTrace("JNA Error", "JNA could not be loaded. Please report here:\nhttp://github.com/processing/processing/issues/new", ule, true);
            }
        }
        return clib;
    }

    @Override
    public void setenv(String variable, String value) {
        WindowsPlatform.getLibC()._putenv(String.valueOf(variable) + "=" + value);
    }

    @Override
    public String getenv(String variable) {
        return System.getenv(variable);
    }

    @Override
    public int unsetenv(String variable) {
        return WindowsPlatform.getLibC()._putenv(String.valueOf(variable) + "=");
    }

    public static interface WinLibC
    extends Library {
        public int _putenv(String var1);
    }
}

