/*
 * Decompiled with CFR 0.152.
 */
package processing.app.platform;

import java.awt.Toolkit;
import java.io.File;
import java.lang.reflect.Field;
import processing.app.Base;
import processing.app.Messages;
import processing.app.Preferences;
import processing.app.platform.DefaultPlatform;

public class LinuxPlatform
extends DefaultPlatform {
    @Override
    public void initBase(Base base) {
        super.initBase(base);
        String javaVendor = System.getProperty("java.vendor");
        String javaVM = System.getProperty("java.vm.name");
        if (javaVendor == null || !javaVendor.contains("Sun") && !javaVendor.contains("Oracle") || javaVM == null || !javaVM.contains("Java")) {
            Messages.showWarning("Not fond of this Java VM", "Processing requires Java 8 from Sun (i.e. the sun-java-jdk\npackage on Ubuntu). Other versions such as OpenJDK, IcedTea,\nand GCJ are strongly discouraged. Among other things, you're\nlikely to run into problems with sketch window size and\nplacement. For more background, please read the wiki:\nhttps://github.com/processing/processing/wiki/Supported-Platforms#Linux", null);
        }
        try {
            Toolkit xToolkit = Toolkit.getDefaultToolkit();
            Field awtAppClassNameField = xToolkit.getClass().getDeclaredField("awtAppClassName");
            awtAppClassNameField.setAccessible(true);
            awtAppClassNameField.set(xToolkit, "Processing");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void openURL(String url) throws Exception {
        String launcher;
        if (this.openFolderAvailable() && (launcher = Preferences.get("launcher")) != null) {
            Runtime.getRuntime().exec(new String[]{launcher, url});
        }
    }

    @Override
    public boolean openFolderAvailable() {
        if (Preferences.get("launcher") != null) {
            return true;
        }
        try {
            Process p = Runtime.getRuntime().exec(new String[]{"xdg-open"});
            p.waitFor();
            Preferences.set("launcher", "xdg-open");
            return true;
        }
        catch (Exception exception) {
            try {
                Process p = Runtime.getRuntime().exec(new String[]{"gnome-open"});
                p.waitFor();
                Preferences.set("launcher", "gnome-open");
                return true;
            }
            catch (Exception exception2) {
                try {
                    Process p = Runtime.getRuntime().exec(new String[]{"kde-open"});
                    p.waitFor();
                    Preferences.set("launcher", "kde-open");
                    return true;
                }
                catch (Exception exception3) {
                    return false;
                }
            }
        }
    }

    @Override
    public void openFolder(File file) throws Exception {
        if (this.openFolderAvailable()) {
            String lunch = Preferences.get("launcher");
            try {
                String[] params = new String[]{lunch, file.getAbsolutePath()};
                Runtime.getRuntime().exec(params);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            System.out.println("No launcher set, cannot open " + file.getAbsolutePath());
        }
    }
}

