/*
 * Decompiled with CFR 0.152.
 */
package processing.app.contrib;

import java.awt.Color;
import javax.swing.GroupLayout;
import javax.swing.JLabel;
import javax.swing.JProgressBar;
import processing.app.contrib.Contribution;
import processing.app.contrib.ContributionListing;
import processing.app.contrib.ContributionTab;
import processing.app.contrib.ContributionType;
import processing.app.contrib.LocalContribution;
import processing.app.contrib.ManagerFrame;
import processing.app.contrib.UpdateListPanel;
import processing.app.contrib.UpdateStatusPanel;
import processing.app.ui.Toolkit;

public class UpdateContributionTab
extends ContributionTab {
    public UpdateContributionTab(ManagerFrame dialog, ContributionType type) {
        this.contribDialog = dialog;
        this.contribType = type;
        this.filter = new Contribution.Filter(){

            @Override
            public boolean matches(Contribution contrib) {
                if (contrib instanceof LocalContribution) {
                    return ContributionListing.getInstance().hasUpdates(contrib);
                }
                return false;
            }
        };
        this.contributionListPanel = new UpdateListPanel(this, this.filter);
        this.statusPanel = new UpdateStatusPanel(this, 650);
        this.contribListing = ContributionListing.getInstance();
        this.contribListing.addListener(this.contributionListPanel);
    }

    @Override
    protected void setLayout(boolean error, boolean loading) {
        if (this.progressBar == null) {
            this.progressBar = new JProgressBar();
            this.progressBar.setVisible(false);
            this.buildErrorPanel();
            this.loaderLabel = new JLabel(Toolkit.getLibIcon("icons/loader.gif"));
            this.loaderLabel.setOpaque(false);
        }
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.loaderLabel).addComponent(this.contributionListPanel).addComponent(this.errorPanel).addComponent(this.statusPanel));
        layout.setVerticalGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.loaderLabel).addComponent(this.contributionListPanel)).addComponent(this.errorPanel).addComponent(this.statusPanel, -2, -1, -2));
        layout.setHonorsVisibility(this.contributionListPanel, false);
        this.setBackground(Color.WHITE);
    }
}

