/*
 * Decompiled with CFR 0.152.
 */
package processing.app.contrib;

import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import processing.app.Base;
import processing.app.Mode;
import processing.app.ui.Toolkit;

public class ManagerTabs
extends Box {
    static final int HIGH = 34;
    static final int BORDER = 8;
    static final int CURVE_RADIUS = 6;
    static final int TAB_TOP = 0;
    static final int TAB_BOTTOM = 32;
    static final int TAB_BETWEEN = 2;
    static final int MARGIN = 14;
    static final int ICON_WIDTH = 16;
    static final int ICON_HEIGHT = 16;
    static final int ICON_TOP = 7;
    static final int ICON_MARGIN = 7;
    static final int UNSELECTED = 0;
    static final int SELECTED = 1;
    Color[] textColor = new Color[2];
    Color[] tabColor = new Color[2];
    List<Tab> tabList = new ArrayList<Tab>();
    Mode mode;
    Font font;
    int fontAscent;
    Image offscreen;
    int sizeW;
    int sizeH;
    int imageW;
    int imageH;
    Image gradient;
    JPanel cardPanel;
    CardLayout cardLayout;
    Controller controller;
    Component currentPanel;

    public ManagerTabs(Base base) {
        super(1);
        this.mode = base.getDefaultMode();
        this.textColor[1] = this.mode.getColor("manager.tab.text.selected.color");
        this.textColor[0] = this.mode.getColor("manager.tab.text.unselected.color");
        this.font = this.mode.getFont("manager.tab.text.font");
        this.tabColor[1] = this.mode.getColor("manager.tab.selected.color");
        this.tabColor[0] = this.mode.getColor("manager.tab.unselected.color");
        this.gradient = this.mode.makeGradient("manager.tab", 400, 34);
        this.setBorder(new EmptyBorder(8, 8, 8, 8));
        this.controller = new Controller();
        this.add(this.controller);
        this.cardLayout = new CardLayout();
        this.cardPanel = new JPanel(this.cardLayout);
        this.add(this.cardPanel);
    }

    public void addPanel(Component comp, String name) {
        this.addPanel(comp, name, null);
    }

    public void addPanel(Component comp, String name, String icon) {
        if (this.tabList.isEmpty()) {
            this.currentPanel = comp;
        }
        this.tabList.add(new Tab(comp, name, icon));
        this.cardPanel.add(name, comp);
    }

    public void setPanel(Component comp) {
        for (Tab tab : this.tabList) {
            if (tab.comp != comp) continue;
            this.currentPanel = comp;
            this.cardLayout.show(this.cardPanel, tab.name);
            this.repaint();
        }
    }

    public Component getPanel() {
        return this.currentPanel;
    }

    public void setNotification(Component comp, boolean note) {
        for (Tab tab : this.tabList) {
            if (tab.comp != comp) continue;
            tab.notification = note;
            this.repaint();
        }
    }

    class Controller
    extends JComponent {
        Controller() {
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent e) {
                    int x = e.getX();
                    for (Tab tab : ((Controller)Controller.this).ManagerTabs.this.tabList) {
                        if (!tab.contains(x)) continue;
                        ManagerTabs.this.setPanel(tab.comp);
                        Controller.this.repaint();
                    }
                }
            });
        }

        @Override
        public void paintComponent(Graphics screen) {
            if (screen == null) {
                return;
            }
            Dimension size = this.getSize();
            if (size.width != ManagerTabs.this.sizeW || size.height != ManagerTabs.this.sizeH) {
                if (size.width > ManagerTabs.this.imageW || size.height > ManagerTabs.this.imageH) {
                    ManagerTabs.this.offscreen = null;
                } else {
                    ManagerTabs.this.sizeW = size.width;
                    ManagerTabs.this.sizeH = size.height;
                }
            }
            if (ManagerTabs.this.offscreen == null) {
                ManagerTabs.this.sizeW = size.width;
                ManagerTabs.this.sizeH = size.height;
                ManagerTabs.this.imageW = ManagerTabs.this.sizeW;
                ManagerTabs.this.imageH = ManagerTabs.this.sizeH;
                ManagerTabs.this.offscreen = Toolkit.highResDisplay() ? this.createImage(ManagerTabs.this.imageW * 2, ManagerTabs.this.imageH * 2) : this.createImage(ManagerTabs.this.imageW, ManagerTabs.this.imageH);
            }
            Graphics g = ManagerTabs.this.offscreen.getGraphics();
            g.setFont(ManagerTabs.this.font);
            if (ManagerTabs.this.fontAscent == 0) {
                ManagerTabs.this.fontAscent = (int)Toolkit.getAscent(g);
            }
            Graphics2D g2 = Toolkit.prepareGraphics(g);
            g.drawImage(ManagerTabs.this.gradient, 0, 0, ManagerTabs.this.imageW, ManagerTabs.this.imageH, this);
            g.setColor(ManagerTabs.this.tabColor[1]);
            g.fillRect(0, 32, ManagerTabs.this.imageW, 2);
            for (Tab tab : ManagerTabs.this.tabList) {
                tab.textWidth = (int)ManagerTabs.this.font.getStringBounds(tab.name, g2.getFontRenderContext()).getWidth();
            }
            this.placeTabs(0);
            this.drawTabs(g2);
            screen.drawImage(ManagerTabs.this.offscreen, 0, 0, ManagerTabs.this.imageW, ManagerTabs.this.imageH, null);
        }

        private void placeTabs(int left) {
            int x = left;
            for (Tab tab : ManagerTabs.this.tabList) {
                tab.left = x;
                x += 14;
                if (tab.hasIcon()) {
                    x += 30;
                }
                tab.right = x += tab.textWidth + 14;
                x += 2;
            }
            Tab lastTab = ManagerTabs.this.tabList.get(ManagerTabs.this.tabList.size() - 1);
            int offset = this.getWidth() - lastTab.right;
            lastTab.left += offset;
            lastTab.right += offset;
        }

        private void drawTabs(Graphics2D g) {
            for (Tab tab : ManagerTabs.this.tabList) {
                tab.draw(g);
            }
        }

        @Override
        public Dimension getPreferredSize() {
            return new Dimension(300, 34);
        }

        @Override
        public Dimension getMinimumSize() {
            return this.getPreferredSize();
        }

        @Override
        public Dimension getMaximumSize() {
            return new Dimension(super.getMaximumSize().width, 34);
        }
    }

    class Tab {
        String name;
        Component comp;
        boolean notification;
        Image enabledIcon;
        Image selectedIcon;
        int left;
        int right;
        int textWidth;

        Tab(Component comp, String name, String icon) {
            this.comp = comp;
            this.name = name;
            if (icon != null) {
                this.enabledIcon = ManagerTabs.this.mode.loadImageX(String.valueOf(icon) + "-enabled");
                this.selectedIcon = ManagerTabs.this.mode.loadImageX(String.valueOf(icon) + "-selected");
                if (this.selectedIcon == null) {
                    this.selectedIcon = this.enabledIcon;
                }
            }
        }

        boolean contains(int x) {
            return x >= this.left && x <= this.right;
        }

        boolean isCurrent() {
            return this.comp.isVisible();
        }

        boolean hasLeftNotch() {
            return ManagerTabs.this.tabList.get(0) == this || ManagerTabs.this.tabList.get(ManagerTabs.this.tabList.size() - 1) == this;
        }

        boolean hasRightNotch() {
            return ManagerTabs.this.tabList.get(ManagerTabs.this.tabList.size() - 1) == this || ManagerTabs.this.tabList.get(ManagerTabs.this.tabList.size() - 2) == this;
        }

        int getTextLeft() {
            int links = this.left;
            if (this.enabledIcon != null) {
                links += 23;
            }
            return links + (this.right - links - this.textWidth) / 2;
        }

        boolean hasIcon() {
            return this.enabledIcon != null;
        }

        void draw(Graphics g) {
            int state = this.isCurrent() ? 1 : 0;
            g.setColor(ManagerTabs.this.tabColor[state]);
            Graphics2D g2 = (Graphics2D)g;
            g2.fill(Toolkit.createRoundRect(this.left, 0.0f, this.right, 32.0f, this.hasLeftNotch() ? 6 : 0, this.hasRightNotch() ? 6 : 0, 0.0f, 0.0f));
            if (this.hasIcon()) {
                Image icon = this.isCurrent() || this.notification ? this.selectedIcon : this.enabledIcon;
                g.drawImage(icon, this.left + 14, 7, 16, 16, null);
            }
            int textLeft = this.getTextLeft();
            if (this.notification && state == 0) {
                g.setColor(ManagerTabs.this.textColor[1]);
            } else {
                g.setColor(ManagerTabs.this.textColor[state]);
            }
            int tabHeight = 32;
            int baseline = 0 + (tabHeight + ManagerTabs.this.fontAscent) / 2;
            g.drawString(this.name, textLeft, baseline);
        }
    }
}

