/*
 * Decompiled with CFR 0.152.
 */
package processing.app.contrib;

import java.awt.EventQueue;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.net.URLClassLoader;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import processing.app.Base;
import processing.app.Messages;
import processing.app.Preferences;
import processing.app.Util;
import processing.app.contrib.AvailableContribution;
import processing.app.contrib.ContribProgressMonitor;
import processing.app.contrib.Contribution;
import processing.app.contrib.ContributionListing;
import processing.app.contrib.ContributionManager;
import processing.app.contrib.ContributionType;
import processing.app.contrib.IgnorableException;
import processing.app.contrib.ModeContribution;
import processing.app.contrib.StatusPanel;
import processing.app.contrib.ToolContribution;
import processing.app.ui.Editor;
import processing.core.PApplet;
import processing.data.StringDict;
import processing.data.StringList;

public abstract class LocalContribution
extends Contribution {
    public static final String DELETION_FLAG = "marked_for_deletion";
    public static final String UPDATE_FLAGGED = "marked_for_update";
    public static final String RESTART_FLAG = "requires_restart";
    protected String id;
    protected int latestVersion;
    protected File folder;
    protected StringDict properties;
    protected ClassLoader loader;

    public LocalContribution(File folder) {
        this.folder = folder;
        File propertiesFile = new File(folder, String.valueOf(this.getTypeName()) + ".properties");
        if (propertiesFile.exists()) {
            String maxRev;
            this.properties = Util.readSettings(propertiesFile);
            this.name = this.properties.get("name");
            this.id = this.properties.get("id");
            this.categories = LocalContribution.parseCategories(this.properties);
            this.imports = LocalContribution.parseImports(this.properties);
            if (this.name == null) {
                this.name = folder.getName();
            }
            this.authors = this.properties.get("authors");
            if (this.authors == null) {
                this.authors = this.properties.get("authorList");
            }
            this.url = this.properties.get("url");
            this.sentence = this.properties.get("sentence");
            this.paragraph = this.properties.get("paragraph");
            try {
                this.version = Integer.parseInt(this.properties.get("version"));
            }
            catch (NumberFormatException numberFormatException) {
                System.err.println("The version number for the \u201c" + this.name + "\u201d library is not set properly.");
                System.err.println("Please contact the library author to fix it according to the guidelines.");
            }
            this.prettyVersion = this.properties.get("prettyVersion");
            try {
                this.lastUpdated = Long.parseLong(this.properties.get("lastUpdated"));
            }
            catch (NumberFormatException numberFormatException) {
                this.lastUpdated = 0L;
            }
            String minRev = this.properties.get("minRevision");
            if (minRev != null) {
                this.minRevision = PApplet.parseInt((String)minRev, (int)0);
            }
            if ((maxRev = this.properties.get("maxRevision")) != null) {
                this.maxRevision = PApplet.parseInt((String)maxRev, (int)0);
            }
        } else {
            Messages.log("No properties file at " + propertiesFile.getAbsolutePath());
            this.name = folder.getName();
            this.categories = LocalContribution.unknownCategoryList();
        }
        if (this.categories.hasValue("Starred")) {
            this.validateSpecial();
        }
    }

    private void validateSpecial() {
        AvailableContribution available;
        Iterator<AvailableContribution> iterator = ContributionListing.getInstance().advertisedContributions.iterator();
        if (iterator.hasNext() && (available = iterator.next()).getName().equals(this.name) && !available.isSpecial()) {
            this.categories.removeValue("Starred");
        }
    }

    public String initLoader(String className) throws Exception {
        File modeDirectory = new File(this.folder, this.getTypeName());
        if (modeDirectory.exists()) {
            File[] archives;
            Messages.log("checking mode folder regarding " + className);
            if (className == null) {
                String shortName = this.folder.getName();
                File mainJar = new File(modeDirectory, String.valueOf(shortName) + ".jar");
                if (!mainJar.exists()) {
                    throw new IgnorableException(String.valueOf(mainJar.getAbsolutePath()) + " does not exist.");
                }
                className = LocalContribution.findClassInZipFile(shortName, mainJar);
                if (className == null) {
                    throw new IgnorableException("Could not find " + shortName + " class inside " + mainJar.getAbsolutePath());
                }
            }
            if ((archives = Util.listJarFiles(modeDirectory)) != null && archives.length > 0) {
                URL[] urlList = new URL[archives.length];
                int j = 0;
                while (j < urlList.length) {
                    Messages.log("Found archive " + archives[j] + " for " + this.getName());
                    urlList[j] = archives[j].toURI().toURL();
                    ++j;
                }
                this.loader = new URLClassLoader(urlList);
                Messages.log("loading above JARs with loader " + this.loader);
            }
        }
        if (this.loader == null) {
            this.loader = Thread.currentThread().getContextClassLoader();
        }
        return className;
    }

    LocalContribution copyAndLoad(Base base, boolean confirmReplace, StatusPanel status) {
        String contribFolderName = this.getFolder().getName();
        File contribTypeFolder = this.getType().getSketchbookFolder();
        File contribFolder = new File(contribTypeFolder, contribFolderName);
        if (status != null) {
            Editor editor = base.getActiveEditor();
            ArrayList<LocalContribution> oldContribs = this.getType().listContributions(editor);
            if (contribFolder.exists() && !contribFolder.isDirectory()) {
                contribFolder.delete();
                contribFolder = new File(contribTypeFolder, contribFolderName);
            }
            for (LocalContribution oldContrib : oldContribs) {
                if ((!oldContrib.getFolder().exists() || !oldContrib.getFolder().equals(contribFolder)) && (oldContrib.getId() == null || !oldContrib.getId().equals(this.getId()))) continue;
                if (oldContrib.getType().requiresRestart()) {
                    if (oldContrib.backup(false, status)) continue;
                    return null;
                }
                int result = 0;
                boolean doBackup = Preferences.getBoolean("contribution.backup.on_install");
                if (!(confirmReplace ? (doBackup ? (result = Messages.showYesNoQuestion(editor, "Replace", "Replace pre-existing \"" + oldContrib.getName() + "\" library?", "A pre-existing copy of the \"" + oldContrib.getName() + "\" library<br>" + "has been found in your sketchbook. Clicking \u201cYes\u201d<br>" + "will move the existing library to a backup folder<br>" + "in <i>libraries/old</i> before replacing it.")) != 0 || !oldContrib.backup(true, status) : (result = Messages.showYesNoQuestion(editor, "Replace", "Replace pre-existing \"" + oldContrib.getName() + "\" library?", "A pre-existing copy of the \"" + oldContrib.getName() + "\" library<br>" + "has been found in your sketchbook. Clicking \u201cYes\u201d<br>" + "will permanently delete this library and all of its contents<br>" + "before replacing it.")) != 0 || !oldContrib.getFolder().delete()) : doBackup && !oldContrib.backup(true, status) || !doBackup && !oldContrib.getFolder().delete())) continue;
                return null;
            }
            if (contribFolder.exists()) {
                Util.removeDir(contribFolder);
            }
        } else if (contribFolder.exists() && contribFolder.isDirectory()) {
            Util.removeDir(contribFolder);
        } else if (contribFolder.exists()) {
            contribFolder.delete();
            contribFolder = new File(contribTypeFolder, contribFolderName);
        }
        File oldFolder = this.getFolder();
        try {
            Util.copyDir(oldFolder, contribFolder);
        }
        catch (IOException e) {
            status.setErrorMessage("Could not copy " + this.getTypeName() + " \"" + this.getName() + "\" to the sketchbook.");
            e.printStackTrace();
            return null;
        }
        return this.getType().load(base, contribFolder);
    }

    boolean backup(boolean deleteOriginal, StatusPanel status) {
        File backupFolder = this.getType().createBackupFolder(status);
        boolean success = false;
        if (backupFolder != null) {
            String libFolderName = this.getFolder().getName();
            String prefix = new SimpleDateFormat("yyyy-MM-dd").format(new Date());
            String backupName = String.valueOf(prefix) + " " + libFolderName;
            File backupSubFolder = ContributionManager.getUniqueName(backupFolder, backupName);
            if (deleteOriginal) {
                success = this.getFolder().renameTo(backupSubFolder);
            } else {
                try {
                    Util.copyDir(this.getFolder(), backupSubFolder);
                    success = true;
                }
                catch (IOException iOException) {}
            }
            if (!success) {
                status.setErrorMessage("Could not move contribution to backup folder.");
            }
        }
        return success;
    }

    void removeContribution(final Base base, final ContribProgressMonitor pm, final StatusPanel status) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                LocalContribution.this.remove(base, pm, status, ContributionListing.getInstance());
            }
        }, "Contribution Uninstaller").start();
    }

    void remove(final Base base, ContribProgressMonitor pm, StatusPanel status, final ContributionListing contribListing) {
        Throwable cause;
        pm.startTask("Removing", -1);
        boolean doBackup = Preferences.getBoolean("contribution.backup.on_remove");
        boolean success = false;
        if (this.getType() == ContributionType.MODE) {
            boolean isModeActive = false;
            ModeContribution m = (ModeContribution)this;
            for (Editor e : base.getEditors()) {
                if (!e.getMode().equals(m.getMode())) continue;
                isModeActive = true;
                break;
            }
            if (!isModeActive) {
                m.clearClassLoader(base);
            } else {
                pm.cancel();
                Messages.showMessage("Mode Manager", "Please save your Sketch and change the Mode of all Editor\nwindows that have " + this.name + " as the active Mode.");
                return;
            }
        }
        if (this.getType() == ContributionType.TOOL) {
            base.clearToolMenus();
            ((ToolContribution)this).clearClassLoader();
        }
        if (success = doBackup ? this.backup(true, status) : Util.removeDir(this.getFolder(), false)) {
            try {
                EventQueue.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        AvailableContribution advertisedVersion = contribListing.getAvailableContribution(LocalContribution.this);
                        if (advertisedVersion == null) {
                            contribListing.removeContribution(LocalContribution.this);
                        } else {
                            contribListing.replaceContribution(LocalContribution.this, advertisedVersion);
                        }
                        base.refreshContribs(LocalContribution.this.getType());
                        base.setUpdatesAvailable(contribListing.countUpdates(base));
                    }
                });
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                cause = e.getCause();
                if (cause instanceof RuntimeException) {
                    throw (RuntimeException)cause;
                }
                cause.printStackTrace();
            }
        } else if (!doBackup || doBackup && this.backup(false, status)) {
            if (this.setDeletionFlag(true)) {
                try {
                    EventQueue.invokeAndWait(new Runnable(){

                        @Override
                        public void run() {
                            contribListing.replaceContribution(LocalContribution.this, LocalContribution.this);
                            base.refreshContribs(LocalContribution.this.getType());
                            base.setUpdatesAvailable(contribListing.countUpdates(base));
                        }
                    });
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                catch (InvocationTargetException e) {
                    cause = e.getCause();
                    if (cause instanceof RuntimeException) {
                        throw (RuntimeException)cause;
                    }
                    cause.printStackTrace();
                }
            }
        } else {
            status.setErrorMessage("Could not delete the contribution's files");
        }
        if (success) {
            pm.finished();
        } else {
            pm.cancel();
        }
    }

    public File getFolder() {
        return this.folder;
    }

    @Override
    public boolean isInstalled() {
        return this.folder != null;
    }

    public String getId() {
        return this.id;
    }

    public int getLatestVersion() {
        return this.latestVersion;
    }

    @Override
    public StringList getImports() {
        return this.imports;
    }

    boolean setDeletionFlag(boolean flag) {
        return this.setFlag(DELETION_FLAG, flag);
    }

    @Override
    boolean isDeletionFlagged() {
        return LocalContribution.isDeletionFlagged(this.getFolder());
    }

    static boolean isDeletionFlagged(File folder) {
        return LocalContribution.isFlagged(folder, DELETION_FLAG);
    }

    boolean setUpdateFlag(boolean flag) {
        return this.setFlag(UPDATE_FLAGGED, flag);
    }

    @Override
    boolean isUpdateFlagged() {
        return LocalContribution.isUpdateFlagged(this.getFolder());
    }

    static boolean isUpdateFlagged(File folder) {
        return LocalContribution.isFlagged(folder, UPDATE_FLAGGED);
    }

    boolean setRestartFlag() {
        return this.setFlag(RESTART_FLAG, true);
    }

    @Override
    boolean isRestartFlagged() {
        return LocalContribution.isFlagged(this.getFolder(), RESTART_FLAG);
    }

    static void clearRestartFlags(File folder) {
        File restartFlag = new File(folder, RESTART_FLAG);
        if (restartFlag.exists()) {
            restartFlag.delete();
        }
    }

    private boolean setFlag(String flagFilename, boolean flag) {
        if (flag) {
            try {
                new File(this.getFolder(), flagFilename).createNewFile();
                return true;
            }
            catch (IOException iOException) {
                return false;
            }
        }
        return new File(this.getFolder(), flagFilename).delete();
    }

    private static boolean isFlagged(File folder, String flagFilename) {
        return new File(folder, flagFilename).exists();
    }

    protected static String findClassInZipFile(String base, File file) {
        String classFileName = "/" + base + ".class";
        try {
            ZipFile zipFile = new ZipFile(file);
            Enumeration<? extends ZipEntry> entries = zipFile.entries();
            while (entries.hasMoreElements()) {
                String name;
                ZipEntry entry = entries.nextElement();
                if (entry.isDirectory() || !(name = entry.getName()).endsWith(classFileName)) continue;
                zipFile.close();
                return name.substring(0, name.length() - 6).replace('/', '.');
            }
            zipFile.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }
}

