/*
 * Decompiled with CFR 0.152.
 */
package processing.app.contrib;

import java.io.File;
import java.util.HashMap;
import java.util.List;
import processing.app.Base;
import processing.app.contrib.ContributionType;
import processing.app.contrib.LocalContribution;
import processing.core.PApplet;
import processing.data.StringDict;
import processing.data.StringList;

public class ExamplesContribution
extends LocalContribution {
    private StringList modeList;

    public static ExamplesContribution load(File folder) {
        return new ExamplesContribution(folder);
    }

    private ExamplesContribution(File folder) {
        super(folder);
        if (this.properties != null) {
            this.modeList = ExamplesContribution.parseModeList(this.properties);
        }
    }

    private static StringList parseModeList(StringDict properties) {
        String unparsedModes = properties.get("modes");
        if ("null".equals(unparsedModes)) {
            properties.remove("modes");
            unparsedModes = null;
        }
        StringList outgoing = new StringList();
        if (unparsedModes != null) {
            outgoing.append(PApplet.trim((String[])PApplet.split((String)unparsedModes, (char)',')));
        }
        return outgoing;
    }

    public static boolean isCompatible(Base base, StringDict props) {
        String currentIdentifier = base.getActiveEditor().getMode().getIdentifier();
        StringList compatibleList = ExamplesContribution.parseModeList(props);
        if (compatibleList.size() == 0) {
            return true;
        }
        for (String c : compatibleList) {
            if (!c.equals(currentIdentifier)) continue;
            return true;
        }
        return false;
    }

    public static boolean isCompatible(Base base, File exampleFolder) {
        StringDict props = ExamplesContribution.loadProperties(exampleFolder, ContributionType.EXAMPLES);
        if (props != null) {
            return ExamplesContribution.isCompatible(base, props);
        }
        return false;
    }

    public static void loadMissing(Base base) {
        File examplesFolder = Base.getSketchbookExamplesFolder();
        List<ExamplesContribution> contribExamples = base.getExampleContribs();
        HashMap<File, ExamplesContribution> existing = new HashMap<File, ExamplesContribution>();
        for (ExamplesContribution contrib : contribExamples) {
            existing.put(contrib.getFolder(), contrib);
        }
        File[] potential = ContributionType.EXAMPLES.listCandidates(examplesFolder);
        if (potential != null) {
            File[] fileArray = potential;
            int n = potential.length;
            int n2 = 0;
            while (n2 < n) {
                File folder = fileArray[n2];
                if (!existing.containsKey(folder)) {
                    contribExamples.add(new ExamplesContribution(folder));
                }
                ++n2;
            }
        }
    }

    @Override
    public ContributionType getType() {
        return ContributionType.EXAMPLES;
    }

    public StringList getModeList() {
        return this.modeList;
    }
}

