/*
 * Decompiled with CFR 0.152.
 */
package processing.app.contrib;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.GroupLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.LayoutStyle;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;
import processing.app.Base;
import processing.app.Language;
import processing.app.Library;
import processing.app.contrib.Contribution;
import processing.app.contrib.ContributionListing;
import processing.app.contrib.ContributionType;
import processing.app.contrib.DetailPanel;
import processing.app.contrib.ExamplesContribution;
import processing.app.contrib.ListPanel;
import processing.app.contrib.ManagerFrame;
import processing.app.contrib.ModeContribution;
import processing.app.contrib.StatusPanel;
import processing.app.contrib.ToolContribution;
import processing.app.ui.Editor;
import processing.app.ui.Toolkit;

public class ContributionTab
extends JPanel {
    static final String ANY_CATEGORY = Language.text("contrib.all");
    static final int FILTER_WIDTH = 180;
    ContributionType contribType;
    ManagerFrame contribDialog;
    Contribution.Filter filter;
    JComboBox<String> categoryChooser;
    ListPanel contributionListPanel;
    StatusPanel statusPanel;
    FilterField filterField;
    JLabel categoryLabel;
    JLabel loaderLabel;
    JPanel errorPanel;
    JTextPane errorMessage;
    JButton tryAgainButton;
    JButton closeButton;
    Editor editor;
    String category;
    ContributionListing contribListing;
    JProgressBar progressBar;

    public ContributionTab() {
    }

    public ContributionTab(ManagerFrame dialog, ContributionType type) {
        this.contribDialog = dialog;
        this.contribType = type;
        this.filter = new Contribution.Filter(){

            @Override
            public boolean matches(Contribution contrib) {
                return contrib.getType() == ContributionTab.this.contribType;
            }
        };
        this.contribListing = ContributionListing.getInstance();
        this.statusPanel = new StatusPanel(this, 650);
        this.contributionListPanel = new ListPanel(this, this.filter);
        this.contribListing.addListener(this.contributionListPanel);
    }

    public void showFrame(Editor editor, boolean error, boolean loading) {
        this.editor = editor;
        this.setLayout(error, loading);
        this.contributionListPanel.setVisible(!loading);
        this.loaderLabel.setVisible(loading);
        this.errorPanel.setVisible(error);
        this.validate();
        this.repaint();
    }

    protected void setLayout(boolean activateErrorPanel, boolean isLoading) {
        if (this.progressBar == null) {
            this.progressBar = new JProgressBar();
            this.progressBar.setVisible(false);
            this.createComponents();
            this.buildErrorPanel();
            this.loaderLabel = new JLabel(Toolkit.getLibIcon("manager/loader.gif"));
            this.loaderLabel.setOpaque(false);
            this.loaderLabel.setBackground(Color.WHITE);
        }
        int scrollBarWidth = this.contributionListPanel.scrollPane.getVerticalScrollBar().getPreferredSize().width;
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.CENTER).addGroup(layout.createSequentialGroup().addGap(66).addComponent(this.filterField, 180, 180, 180).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -2, Short.MAX_VALUE).addComponent(this.categoryChooser, 240, 240, 240).addGap(scrollBarWidth)).addComponent(this.loaderLabel).addComponent(this.contributionListPanel).addComponent(this.errorPanel).addComponent(this.statusPanel));
        layout.setVerticalGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.categoryChooser).addComponent(this.filterField)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.loaderLabel).addComponent(this.contributionListPanel)).addComponent(this.errorPanel).addComponent(this.statusPanel, -2, -1, -2));
        layout.linkSize(1, this.categoryChooser, this.filterField);
        layout.setHonorsVisibility(this.contributionListPanel, false);
        layout.setHonorsVisibility(this.categoryChooser, false);
        this.setBackground(Color.WHITE);
        this.setBorder(null);
    }

    private void createComponents() {
        this.categoryLabel = new JLabel(Language.text("contrib.category"));
        this.categoryChooser = new JComboBox();
        this.categoryChooser.setMaximumRowCount(20);
        this.categoryChooser.setFont(Toolkit.getSansFont(14, 0));
        this.updateCategoryChooser();
        this.categoryChooser.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                ContributionTab.this.category = (String)ContributionTab.this.categoryChooser.getSelectedItem();
                if (ManagerFrame.ANY_CATEGORY.equals(ContributionTab.this.category)) {
                    ContributionTab.this.category = null;
                }
                ContributionTab.this.filterLibraries(ContributionTab.this.category, ContributionTab.this.filterField.filters);
                ContributionTab.this.contributionListPanel.updateColors();
            }
        });
        this.filterField = new FilterField();
    }

    protected void buildErrorPanel() {
        this.errorPanel = new JPanel();
        GroupLayout layout = new GroupLayout(this.errorPanel);
        layout.setAutoCreateGaps(true);
        layout.setAutoCreateContainerGaps(true);
        this.errorPanel.setLayout(layout);
        this.errorMessage = new JTextPane();
        this.errorMessage.setEditable(false);
        this.errorMessage.setContentType("text/html");
        this.errorMessage.setText("<html><body>Could not connect to the Processing server.<br>Contributions cannot be installed or updated without an Internet connection.<br>Please verify your network connection again, then try connecting again.</body></html>");
        this.errorMessage.setFont(Toolkit.getSansFont(14, 0));
        this.errorMessage.setMaximumSize(new Dimension(550, 50));
        this.errorMessage.setOpaque(false);
        StyledDocument doc = this.errorMessage.getStyledDocument();
        SimpleAttributeSet center = new SimpleAttributeSet();
        StyleConstants.setAlignment(center, 1);
        doc.setParagraphAttributes(0, doc.getLength(), center, false);
        this.closeButton = new JButton(Toolkit.getLibIconX("manager/close"));
        this.closeButton.setContentAreaFilled(false);
        this.closeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ContributionTab.this.contribDialog.makeAndShowTab(false, false);
            }
        });
        this.tryAgainButton = new JButton("Try Again");
        this.tryAgainButton.setFont(Toolkit.getSansFont(14, 0));
        this.tryAgainButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ContributionTab.this.contribDialog.makeAndShowTab(false, true);
                ContributionTab.this.contribDialog.downloadAndUpdateContributionListing(ContributionTab.this.editor.getBase());
            }
        });
        layout.setHorizontalGroup(layout.createSequentialGroup().addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -2, Short.MAX_VALUE).addGroup(layout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.errorMessage).addComponent(this.tryAgainButton, 150, 150, 150)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -2, Short.MAX_VALUE).addComponent(this.closeButton));
        layout.setVerticalGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup().addComponent(this.errorMessage).addComponent(this.closeButton)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.tryAgainButton));
        this.errorPanel.setBackground(Color.PINK);
        this.errorPanel.validate();
    }

    protected void updateCategoryChooser() {
        if (this.categoryChooser != null) {
            this.categoryChooser.removeAllItems();
            ArrayList<String> categories = new ArrayList<String>(this.contribListing.getCategories(this.filter));
            Collections.sort(categories);
            boolean categoriesFound = false;
            this.categoryChooser.addItem(ManagerFrame.ANY_CATEGORY);
            for (String s : categories) {
                this.categoryChooser.addItem(s);
                if (s.equals("Unknown")) continue;
                categoriesFound = true;
            }
            this.categoryChooser.setVisible(categoriesFound);
        }
    }

    protected void filterLibraries(String category, List<String> filters) {
        List<Contribution> filteredLibraries = this.contribListing.getFilteredLibraryList(category, filters);
        this.contributionListPanel.filterLibraries(filteredLibraries);
    }

    protected void updateContributionListing() {
        if (this.editor != null) {
            ArrayList<Contribution> contributions = new ArrayList<Contribution>();
            ArrayList<Library> libraries = new ArrayList<Library>(this.editor.getMode().contribLibraries);
            String sketchbookPath = Base.getSketchbookLibrariesFolder().getAbsolutePath();
            for (Library lib : this.editor.getMode().coreLibraries) {
                if (!lib.getLibraryPath().startsWith(sketchbookPath)) continue;
                libraries.add(lib);
            }
            contributions.addAll(libraries);
            Base base = this.editor.getBase();
            List<ToolContribution> tools = base.getToolContribs();
            contributions.addAll(tools);
            List<ModeContribution> modes = base.getModeContribs();
            contributions.addAll(modes);
            List<ExamplesContribution> examples = base.getExampleContribs();
            contributions.addAll(examples);
            this.contribListing.updateInstalledList(contributions);
        }
    }

    protected void setFilterText(String filter) {
        if (filter == null || filter.isEmpty()) {
            this.filterField.setText("");
        } else {
            this.filterField.setText(filter);
        }
        this.filterField.applyFilter();
    }

    public void updateStatusPanel(DetailPanel contributionPanel) {
        this.statusPanel.update(contributionPanel);
    }

    protected void updateAll() {
        Collection<DetailPanel> collection = this.contributionListPanel.panelByContribution.values();
        for (DetailPanel detailPanel : collection) {
            detailPanel.update();
            this.contributionListPanel.updatePanelOrdering(this.contributionListPanel.panelByContribution.keySet());
        }
    }

    protected boolean hasUpdates() {
        return this.contributionListPanel.getRowCount() > 0;
    }

    class FilterField
    extends JTextField {
        Icon searchIcon;
        List<String> filters;
        JLabel filterLabel;

        public FilterField() {
            super("");
            this.filterLabel = new JLabel("Filter");
            this.filterLabel.setFont(Toolkit.getSansFont(14, 0));
            this.filterLabel.setOpaque(false);
            this.setFont(Toolkit.getSansFont(14, 0));
            this.searchIcon = Toolkit.getLibIconX("manager/search");
            this.filterLabel.setIcon(this.searchIcon);
            this.setOpaque(false);
            GroupLayout fl = new GroupLayout(this);
            this.setLayout(fl);
            fl.setHorizontalGroup(fl.createSequentialGroup().addComponent(this.filterLabel));
            fl.setVerticalGroup(fl.createSequentialGroup().addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -2, Short.MAX_VALUE).addComponent(this.filterLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -2, Short.MAX_VALUE));
            this.filters = new ArrayList<String>();
            this.addFocusListener(new FocusListener(){

                @Override
                public void focusLost(FocusEvent focusEvent) {
                    if (FilterField.this.getText().isEmpty()) {
                        FilterField.this.filterLabel.setVisible(true);
                    }
                }

                @Override
                public void focusGained(FocusEvent focusEvent) {
                    FilterField.this.filterLabel.setVisible(false);
                }
            });
            this.getDocument().addDocumentListener(new DocumentListener(){

                @Override
                public void removeUpdate(DocumentEvent e) {
                    FilterField.this.applyFilter();
                }

                @Override
                public void insertUpdate(DocumentEvent e) {
                    FilterField.this.applyFilter();
                }

                @Override
                public void changedUpdate(DocumentEvent e) {
                    FilterField.this.applyFilter();
                }
            });
        }

        public void applyFilter() {
            String filter = this.getText();
            filter = filter.toLowerCase();
            filter = filter.replaceAll("[^\\x30-\\x39^\\x61-\\x7a^\\x3a]", " ");
            this.filters = Arrays.asList(filter.split(" "));
            ContributionTab.this.filterLibraries(ContributionTab.this.category, this.filters);
            ContributionTab.this.contributionListPanel.updateColors();
        }
    }
}

