/*
 * Decompiled with CFR 0.152.
 */
package processing.app;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.Random;
import javax.swing.JOptionPane;
import processing.app.Base;
import processing.app.Language;
import processing.app.Platform;
import processing.app.Preferences;
import processing.app.contrib.ContributionManager;
import processing.core.PApplet;

public class UpdateCheck {
    private final Base base;
    private static final String DOWNLOAD_URL = "http://processing.org/download/";
    private static final String LATEST_URL = "http://processing.org/download/latest.txt";
    private static final long ONE_DAY = 86400000L;
    static boolean allowed;

    public UpdateCheck(Base base) {
        this.base = base;
        if (UpdateCheck.isAllowed()) {
            new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        Thread.sleep(5000L);
                        UpdateCheck.this.updateCheck();
                    }
                    catch (Exception exception) {}
                }
            }, "Update Checker").start();
        }
    }

    public void updateCheck() throws IOException, InterruptedException {
        long when;
        Random r = new Random();
        long id = r.nextLong();
        String idString = Preferences.get("update.id");
        if (idString != null) {
            id = Long.parseLong(idString);
        } else {
            Preferences.set("update.id", String.valueOf(id));
        }
        String info = PApplet.urlEncode((String)(String.valueOf(id) + "\t" + PApplet.nf((int)Base.getRevision(), (int)4) + "\t" + System.getProperty("java.version") + "\t" + System.getProperty("java.vendor") + "\t" + System.getProperty("os.name") + "\t" + System.getProperty("os.version") + "\t" + System.getProperty("os.arch")));
        int latest = this.readInt("http://processing.org/download/latest.txt?" + info);
        String lastString = Preferences.get("update.last");
        long now = System.currentTimeMillis();
        if (lastString != null && now - (when = Long.parseLong(lastString)) < 86400000L) {
            return;
        }
        Preferences.set("update.last", String.valueOf(now));
        if (this.base.activeEditor != null && latest > Base.getRevision()) {
            System.out.println("You are running Processing revision 0" + Base.getRevision() + ", the latest build is 0" + latest + ".");
            this.promptToVisitDownloadPage();
        }
    }

    protected boolean promptToVisitDownloadPage() {
        String prompt = Language.text("update_check.updates_available.core");
        Object[] options = new Object[]{Language.text("prompt.yes"), Language.text("prompt.no")};
        int result = JOptionPane.showOptionDialog(this.base.activeEditor, prompt, Language.text("update_check"), 0, 3, null, options, options[0]);
        if (result == 0) {
            Platform.openURL(DOWNLOAD_URL);
            return true;
        }
        return false;
    }

    protected boolean promptToOpenContributionManager() {
        String contributionPrompt = Language.text("update_check.updates_available.contributions");
        Object[] options = new Object[]{Language.text("prompt.yes"), Language.text("prompt.no")};
        int result = JOptionPane.showOptionDialog(this.base.activeEditor, contributionPrompt, Language.text("update_check"), 0, 3, null, options, options[0]);
        if (result == 0) {
            ContributionManager.openUpdates();
            return true;
        }
        return false;
    }

    protected int readInt(String filename) throws IOException {
        URL url = new URL(filename);
        InputStream stream = url.openStream();
        InputStreamReader isr = new InputStreamReader(stream);
        BufferedReader reader = new BufferedReader(isr);
        return Integer.parseInt(reader.readLine());
    }

    public static boolean isAllowed() {
        return Preferences.getBoolean("update.check");
    }
}

