/*
 * Decompiled with CFR 0.152.
 */
package processing.app;

import java.awt.EventQueue;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import processing.app.Base;
import processing.app.Messages;
import processing.app.Preferences;
import processing.core.PApplet;

public class SingleInstance {
    static final String SERVER_PORT = "instance_server.port";
    static final String SERVER_KEY = "instance_server.key";

    static boolean alreadyRunning(String[] args) {
        return Preferences.get(SERVER_PORT) != null && SingleInstance.sendArguments(args);
    }

    static void startServer(final Base base) {
        try {
            final ServerSocket ss = new ServerSocket(0, 0, InetAddress.getByName(null));
            Preferences.set(SERVER_PORT, "" + ss.getLocalPort());
            final String key = "" + Math.random();
            Preferences.set(SERVER_KEY, key);
            Preferences.save();
            new Thread(new Runnable(){

                @Override
                public void run() {
                    while (true) {
                        try {
                            while (true) {
                                Socket s = ss.accept();
                                final BufferedReader reader = PApplet.createReader((InputStream)s.getInputStream());
                                String receivedKey = reader.readLine();
                                Messages.log(this, "key is " + key + ", received is " + receivedKey);
                                if (key.equals(receivedKey)) {
                                    EventQueue.invokeLater(new Runnable(){

                                        @Override
                                        public void run() {
                                            try {
                                                Messages.log(this, "about to read line");
                                                String path = reader.readLine();
                                                if (path == null) {
                                                    Messages.log(this, "opening new empty sketch");
                                                    base.handleNew();
                                                } else {
                                                    do {
                                                        Messages.log(this, "calling open with " + path);
                                                        base.handleOpen(path);
                                                    } while ((path = reader.readLine()) != null);
                                                }
                                            }
                                            catch (IOException e) {
                                                e.printStackTrace();
                                            }
                                        }
                                    });
                                    continue;
                                }
                                Messages.log(this, "keys do not match");
                            }
                        }
                        catch (IOException e) {
                            Messages.loge("SingleInstance error while listening", e);
                            continue;
                        }
                        break;
                    }
                }
            }, "SingleInstance Server").start();
        }
        catch (IOException e) {
            Messages.loge("Could not create single instance server.", e);
        }
    }

    static boolean sendArguments(String[] args) {
        try {
            int port = Preferences.getInteger(SERVER_PORT);
            String key = Preferences.get(SERVER_KEY);
            Socket socket = null;
            try {
                socket = new Socket(InetAddress.getByName(null), port);
            }
            catch (Exception exception) {}
            if (socket != null) {
                PrintWriter writer = PApplet.createWriter((OutputStream)socket.getOutputStream());
                writer.println(key);
                String[] stringArray = args;
                int n = args.length;
                int n2 = 0;
                while (n2 < n) {
                    String arg = stringArray[n2];
                    writer.println(arg);
                    ++n2;
                }
                writer.flush();
                writer.close();
                return true;
            }
        }
        catch (IOException e) {
            System.err.println("Error sending commands to other instance.");
            e.printStackTrace();
        }
        return false;
    }
}

