/*
 * Decompiled with CFR 0.152.
 */
package processing.app;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import processing.app.Base;
import processing.app.Platform;
import processing.app.Util;
import processing.core.PApplet;

public class Language {
    protected static final String PREF_FILE = "language.txt";
    protected static final File prefFile = Base.getSettingsFile("language.txt");
    private static volatile Language instance;
    private String language;
    private HashMap<String, String> languages;
    private LanguageBundle bundle;

    private Language() {
        String systemLanguage = Locale.getDefault().getLanguage();
        this.language = Language.loadLanguage();
        boolean writePrefs = false;
        if (this.language == null) {
            this.language = systemLanguage;
            writePrefs = true;
        }
        this.languages = new HashMap();
        String[] stringArray = Language.listSupported();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String code = stringArray[n2];
            Locale locale = Locale.forLanguageTag(code);
            this.languages.put(code, locale.getDisplayLanguage(locale));
            ++n2;
        }
        if (!this.languages.containsKey(this.language)) {
            this.language = "en";
            writePrefs = true;
        }
        if (writePrefs) {
            Language.saveLanguage(this.language);
        }
        try {
            this.bundle = new LanguageBundle(this.language);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static String[] listSupported() {
        String[] SUPPORTED = new String[]{"de", "en", "el", "es", "fr", "ja", "ko", "nl", "pt", "tr", "zh"};
        return SUPPORTED;
    }

    private static String loadLanguage() {
        try {
            if (prefFile.exists()) {
                String language = PApplet.loadStrings((File)prefFile)[0];
                if ((language = language.trim().toLowerCase()).trim().length() != 0) {
                    return language;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public static void saveLanguage(String language) {
        try {
            Util.saveFile(language, prefFile);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        Platform.saveLanguage(language);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Language init() {
        if (instance != null) return instance;
        Class<Language> clazz = Language.class;
        synchronized (Language.class) {
            if (instance != null) return instance;
            instance = new Language();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    private static String get(String key) {
        LanguageBundle bundle = Language.init().bundle;
        try {
            String value = bundle.getString(key);
            if (value != null) {
                return value;
            }
        }
        catch (MissingResourceException missingResourceException) {}
        return null;
    }

    public static String text(String key) {
        String value = Language.get(key);
        if (value == null) {
            return key;
        }
        return value;
    }

    public static String interpolate(String key, Object ... arguments) {
        String value = Language.get(key);
        if (value == null) {
            return key;
        }
        return String.format(value, arguments);
    }

    public static String pluralize(String key, int count) {
        String customKey = String.valueOf(key) + "." + count;
        String value = Language.get(customKey);
        if (value != null) {
            return String.format(value, count);
        }
        return Language.interpolate(String.valueOf(key) + ".n", count);
    }

    public static String getPrompt(String which) {
        return Language.text("prompt." + which);
    }

    public static Map<String, String> getLanguages() {
        return Language.init().languages;
    }

    public static String getLanguage() {
        return Language.init().language;
    }

    static class LanguageBundle {
        Map<String, String> table = new HashMap<String, String>();

        LanguageBundle(String language) throws IOException {
            String baseFilename = "languages/PDE.properties";
            String langFilename = "languages/PDE_" + language + ".properties";
            File baseFile = Base.getLibFile(baseFilename);
            File userBaseFile = new File(Base.getSketchbookFolder(), baseFilename);
            if (userBaseFile.exists()) {
                baseFile = userBaseFile;
            }
            File langFile = Base.getLibFile(langFilename);
            File userLangFile = new File(Base.getSketchbookFolder(), langFilename);
            if (userLangFile.exists()) {
                langFile = userLangFile;
            }
            this.read(baseFile);
            this.read(langFile);
        }

        void read(File additions) {
            String[] lines = PApplet.loadStrings((File)additions);
            int i = 0;
            while (i < lines.length) {
                int equals;
                String line = lines[i];
                if (line.length() != 0 && line.charAt(0) != '#' && (equals = line.indexOf(61)) != -1) {
                    String key = line.substring(0, equals).trim();
                    String value = line.substring(equals + 1).trim();
                    value = value.replaceAll("\\\\n", "\n");
                    value = value.replaceAll("\\\\'", "'");
                    this.table.put(key, value);
                }
                ++i;
            }
        }

        String getString(String key) {
            return this.table.get(key);
        }

        boolean containsKey(String key) {
            return this.table.containsKey(key);
        }
    }
}

