/*
 * Decompiled with CFR 0.152.
 */
package kellinwood.zipio;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import kellinwood.logging.LoggerInterface;
import kellinwood.logging.LoggerManager;
import kellinwood.zipio.CentralEnd;
import kellinwood.zipio.ZioEntry;
import kellinwood.zipio.ZipListingHelper;

public class ZipOutput {
    static LoggerInterface log;
    String outputFilename;
    OutputStream out = null;
    int filePointer = 0;
    List<ZioEntry> entriesWritten = new LinkedList<ZioEntry>();
    Set<String> namesWritten = new HashSet<String>();

    public ZipOutput(String filename) throws IOException {
        this.outputFilename = filename;
        File ofile = new File(this.outputFilename);
        this.init(ofile);
    }

    public ZipOutput(File outputFile) throws IOException {
        this.outputFilename = outputFile.getAbsolutePath();
        File ofile = outputFile;
        this.init(ofile);
    }

    private void init(File ofile) throws IOException {
        if (ofile.exists()) {
            ofile.delete();
        }
        this.out = new FileOutputStream(ofile);
        if (ZipOutput.getLogger().isDebugEnabled()) {
            ZipListingHelper.listHeader(ZipOutput.getLogger());
        }
    }

    public ZipOutput(OutputStream os) throws IOException {
        this.out = os;
    }

    private static LoggerInterface getLogger() {
        if (log == null) {
            log = LoggerManager.getLogger((String)ZipOutput.class.getName());
        }
        return log;
    }

    public void write(ZioEntry entry) throws IOException {
        String entryName = entry.getName();
        if (this.namesWritten.contains(entryName)) {
            ZipOutput.getLogger().warning("Skipping duplicate file in output: " + entryName);
            return;
        }
        entry.writeLocalEntry(this);
        this.entriesWritten.add(entry);
        this.namesWritten.add(entryName);
        if (ZipOutput.getLogger().isDebugEnabled()) {
            ZipListingHelper.listEntry(ZipOutput.getLogger(), entry);
        }
    }

    public void close() throws IOException {
        CentralEnd centralEnd = new CentralEnd();
        centralEnd.centralStartOffset = this.getFilePointer();
        centralEnd.numCentralEntries = centralEnd.totalCentralEntries = (short)this.entriesWritten.size();
        for (ZioEntry entry : this.entriesWritten) {
            entry.write(this);
        }
        centralEnd.centralDirectorySize = this.getFilePointer() - centralEnd.centralStartOffset;
        centralEnd.fileComment = "";
        centralEnd.write(this);
        if (this.out != null) {
            try {
                this.out.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public int getFilePointer() throws IOException {
        return this.filePointer;
    }

    public void writeInt(int value) throws IOException {
        byte[] data = new byte[4];
        for (int i = 0; i < 4; ++i) {
            data[i] = (byte)(value & 0xFF);
            value >>= 8;
        }
        this.out.write(data);
        this.filePointer += 4;
    }

    public void writeShort(short value) throws IOException {
        byte[] data = new byte[2];
        for (int i = 0; i < 2; ++i) {
            data[i] = (byte)(value & 0xFF);
            value = (short)(value >> 8);
        }
        this.out.write(data);
        this.filePointer += 2;
    }

    public void writeString(String value) throws IOException {
        byte[] data = value.getBytes();
        this.out.write(data);
        this.filePointer += data.length;
    }

    public void writeBytes(byte[] value) throws IOException {
        this.out.write(value);
        this.filePointer += value.length;
    }

    public void writeBytes(byte[] value, int offset, int length) throws IOException {
        this.out.write(value, offset, length);
        this.filePointer += length;
    }
}

