/*
 * Decompiled with CFR 0.152.
 */
package kellinwood.zipio;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import kellinwood.logging.LoggerInterface;
import kellinwood.logging.LoggerManager;
import kellinwood.zipio.ZioEntry;

public class ZioEntryInputStream
extends InputStream {
    RandomAccessFile raf;
    int size;
    int offset = 0;
    LoggerInterface log = LoggerManager.getLogger((String)this.getClass().getName());
    boolean debug = this.log.isDebugEnabled();
    boolean returnDummyByte = false;
    OutputStream monitor = null;

    public ZioEntryInputStream(ZioEntry entry) throws IOException {
        this.size = entry.getCompressedSize();
        this.raf = entry.getZipInput().in;
        long dpos = entry.getDataPosition();
        if (dpos >= 0L) {
            if (this.debug) {
                this.log.debug(String.format("Seeking to %d", entry.getDataPosition()));
            }
            this.raf.seek(entry.getDataPosition());
        } else {
            entry.readLocalHeader();
        }
    }

    public void setReturnDummyByte(boolean returnExtraByte) {
        this.returnDummyByte = returnExtraByte;
    }

    public void setMonitorStream(OutputStream monitorStream) {
        this.monitor = monitorStream;
    }

    @Override
    public void close() throws IOException {
    }

    @Override
    public boolean markSupported() {
        return false;
    }

    @Override
    public int available() throws IOException {
        int available = this.size - this.offset;
        if (this.debug) {
            this.log.debug(String.format("Available = %d", available));
        }
        if (available == 0 && this.returnDummyByte) {
            return 1;
        }
        return available;
    }

    @Override
    public int read() throws IOException {
        if (this.size - this.offset == 0) {
            if (this.returnDummyByte) {
                this.returnDummyByte = false;
                return 0;
            }
            return -1;
        }
        int b = this.raf.read();
        if (b >= 0) {
            if (this.monitor != null) {
                this.monitor.write(b);
            }
            if (this.debug) {
                this.log.debug("Read 1 byte");
            }
            ++this.offset;
        } else if (this.debug) {
            this.log.debug("Read 0 bytes");
        }
        return b;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        return this.readBytes(b, off, len);
    }

    private int readBytes(byte[] b, int off, int len) throws IOException {
        if (this.size - this.offset == 0) {
            if (this.returnDummyByte) {
                this.returnDummyByte = false;
                b[off] = 0;
                return 1;
            }
            return -1;
        }
        int numToRead = Math.min(len, this.available());
        int numRead = this.raf.read(b, off, numToRead);
        if (numRead > 0) {
            if (this.monitor != null) {
                this.monitor.write(b, off, numRead);
            }
            this.offset += numRead;
        }
        if (this.debug) {
            this.log.debug(String.format("Read %d bytes for read(b,%d,%d)", numRead, off, len));
        }
        return numRead;
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.readBytes(b, 0, b.length);
    }

    @Override
    public long skip(long n) throws IOException {
        long numToSkip = Math.min(n, (long)this.available());
        this.raf.seek(this.raf.getFilePointer() + numToSkip);
        if (this.debug) {
            this.log.debug(String.format("Skipped %d bytes", numToSkip));
        }
        return numToSkip;
    }
}

